<?php
/**
 * lang/.../modules/payment/yes_ppp.php
 * checkout_shipping.php ERWEITERT UM DIE AKTION update_ppp_payment
 * checkout_confirmation.php VERARBEITEN DER PAYPAL ZAHLUNG
 * es werden keine einzel summen und details mehr uebergeben, nur gesamtsumme
 */
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_create_password.inc.php');
if(!function_exists('xtc_draw_radio_field')){
    require_once(DIR_FS_INC.'xtc_draw_radio_field.inc.php');
}
class yes_ppp {
    var $code, $title, $description, $enabled, $mode, $clientID, $secret, $_check, $sort_order;
    
    function __construct() {
        $this->code = 'yes_ppp';
        $this->title = MODULE_PAYMENT_YES_PPP_TEXT_TITLE;
        $this->description = MODULE_PAYMENT_YES_PPP_TEXT_DESCRIPTION;
        $this->sort_order = (defined('MODULE_PAYMENT_YES_PPP_SORT_ORDER')) ? MODULE_PAYMENT_YES_PPP_SORT_ORDER : 0;
        $this->enabled = ((defined('MODULE_PAYMENT_YES_PPP_STATUS') and MODULE_PAYMENT_YES_PPP_STATUS == 'True') ? true : false);
        $this->mode = (defined('MODULE_PAYMENT_YES_PPP_MODE')) ? MODULE_PAYMENT_YES_PPP_MODE : '';
        if( $this->enabled === True){
            $this->clientID = MODULE_PAYMENT_YES_PPP_APICLIENTID;
            $this->secret = MODULE_PAYMENT_YES_PPP_APISECRET;
        }
    }
    
    private static function getPaypalAPIUrl($mode){
            return ($mode == 'Sandbox') ? "https://api-m.sandbox.paypal.com/v1/" : "https://api-m.paypal.com/v1/";
    }

	function javascript_validation() {
		return false;
	}
    public static function load_credentials(){
        return [];
    }

    public static function getPaymentValues(){
        return [];
    }

    public static function getPayment(){
        return [];
    }
    public static function get_payment_link_from_payment_object($payment, $mode){
        return '';
    }

	public function selection() {
            $desc = $this->description;
            return array (
                'id' => $this->code, 
                'module' => $this->title, 
                'description' => $desc
            );
	}
        
    function confirmation() {
            return false;
    }

    function process_button() {
            return false;
    }

    public function allocate_to_yes_order(int $orders_id, string $paypal_payer_id, string $paypal_txn_id, string $invoice_id){
        $insert_sql_array = [
            'xtc_order_id'=>$orders_id,
            'payer_id'=> $paypal_payer_id,
            'payment_date' => date('Y-m-d H:i:s'),
            'txn_id'=>$paypal_txn_id,
            'date_added'=>date('Y-m-d H:i:s'),
            'invoice'=>$invoice_id,
        ];
        yes_db_perform('paypal',$insert_sql_array);
    }

    public function before_process() {
        global $order, $order_totals;
        if(!defined('DEFAULT_CUSTOMERS_STATUS_ID_GUEST') or intval(constant('DEFAULT_CUSTOMERS_STATUS_ID_GUEST'))<1){
            throw new Exception('Es wurde kein oder fehlerhaftes DEFAULT_CUSTOMERS_STATUS_ID_GUEST definiert.');
        }
        $pp = new \YES4Trade\Model\paypal_api();
        if(isset($_SESSION['customer_id'])){
            if(isset($_GET['token'])){
                $pp->set_transaction_id($_GET['token']); /// in dem fall ist es die orderId
            }
            if($pp->get_transaction_id() === null){
                if($pp->get_access_token() === null){
                    $access_token = $pp->getAccess_token();
                    $pp->set_access_token($access_token);
                }
                return $pp->createOrder($order, $order_totals,false); // false = kein express
            }else{
                return $pp->capture( $pp->get_transaction_id() );
            }
            return true;
        }

        $current_po = $pp->get_paypal_order();
        $current_total = $current_po['purchase_units'][0]['amount']['value'];
        $po = $pp->getOrder($pp->getOrderToken());
        $new_total = $po['purchase_units'][0]['amount']['value'];
        $pp->set_paypal_order($po);
        $order->customer = \YES4Trade\Model\paypal_api::get_yes_orders_customer_array($po);
        $order->billing = $order->customer;
        $order->delivery = \YES4Trade\Model\paypal_api::get_yes_orders_delivery_array($po);
        if(floatval($current_total) <> floatval($new_total)){
            try{
                $pp->updateOrder($order, $order_totals);
            }catch(Exception $e){
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING,'error_message=Update%20Paypal%20'.urlencode($e->getMessage())));
            }
        }
        try{
            $paypal_order = $pp->get_paypal_order();
            if($paypal_order['status'] == 'PAYER_ACTION_REQUIRED'){
                foreach($paypal_order['links'] as $l){
                    if($l['rel'] == 'payer-action'){
                        xtc_redirect($l['href']);
                    }
                }
            }
            $pp->capture($pp->getOrderToken());
        }catch(Exception $e){
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING,'error_message=capture%20Paypal%20'.urlencode($e->getMessage())));
        }

        if(!isset($_SESSION['customer_id'])){
            $cs = intval(constant('DEFAULT_CUSTOMERS_STATUS_ID_GUEST'));
            $new = new \YES4Trade\Model\customers([
	            'customers_status'=> $cs,
                'customers_firstname'=>$order->customer['firstname'],
                'customers_lastname'=>$order->customer['lastname'],
                'customers_email_address'=>$order->customer['email_address'],
                'customers_password'=>xtc_create_password(8),
                'customers_date_added'=>date('Y-m-d H:i:s') 	
            ]);
            $customers_id = $new->create();

            $new = new \YES4Trade\Model\address_book([
	            'customers_id'=>intval($customers_id),
                'entry_company'=>$order->customer['company']??'',
                'entry_firstname'=>$order->customer['firstname'],
                'entry_lastname'=>$order->customer['lastname'],
                'entry_street_address'=>$order->customer['street_address']??'',
                'entry_suburb'=>$order->customer['suburb']??'',	
                'entry_postcode'=>$order->customer['postcode'],
                'entry_city'=>$order->customer['city'],
                'entry_state'=>$order->customer['state']??'',
                'entry_country_id'=>intval($order->customer['country']['id']),
                'entry_zone_id'=>intval($order->customer['zone_id']),
                'address_class'=>'',
                'address_date_added'=>date('Y-m-d H:i:s')
            ]);
            $abID = $new->create();
            $upd = new \YES4Trade\Model\customers([
                'customers_default_address_id'=>intval($abID),
                'customers_id'=>intval($customers_id)
            ]);
            $upd->update();
            $_SESSION['customer_id'] = $customers_id;
        }
        return true;
    }

    
    public function after_process(){
        global $insert_id;
        $pp = new \YES4Trade\Model\paypal_api();
        $paypal_order = $pp->get_paypal_order();
		$po = $pp->getOrder($paypal_order['id']);
		$pp->savePayerID($po['payer']['payer_id']);
        $this->allocate_to_yes_order(intval($insert_id), $po['payer']['payer_id'], $paypal_order['id'], $pp->get_invoice_id());
        unset($_SESSION['yes_ppp']);
        \YES4Trade\Model\paypal_api::clear_session();
        unset($_SESSION['YES_PPP']);
    }
    
    function check() {
        if (!isset ($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from ".TABLE_CONFIGURATION." where configuration_key = 'MODULE_PAYMENT_YES_PPP_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install() {
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_YES_PPP_STATUS', 'False',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_PPP_SORT_ORDER', '0',  '6', '3', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_YES_PPP_MODE', 'Sandbox',  '6', '4', 'xtc_cfg_select_option(array(\'Live\', \'Sandbox\'), ', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_PPP_APICLIENTID', '',  '6', '5', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_PPP_APISECRET', '',  '6', '6', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_PPP_PAYPALME', '',  '6', '7', now())");
    }

    function remove() {
        xtc_db_query("delete from ".TABLE_CONFIGURATION." where configuration_key in ('".implode("', '", $this->keys())."')");
    }

    function keys() {
        return array (
            'MODULE_PAYMENT_YES_PPP_STATUS', 
            'MODULE_PAYMENT_YES_PPP_SORT_ORDER', 
            'MODULE_PAYMENT_YES_PPP_MODE', 
            'MODULE_PAYMENT_YES_PPP_APICLIENTID',
            'MODULE_PAYMENT_YES_PPP_APISECRET',
            'MODULE_PAYMENT_YES_PPP_PAYPALME'
        );
    }
    
    
    
    private static function get_country_iso2_from_countries_id($countries_id){
        $record = main::get_country_values($countries_id);
        return $record['countries_iso_code_2'];
    }
    
    
}
