<?php

use \Secuconnect\Client\Configuration;
use \Secuconnect\Client\ApiClient;
use \Secuconnect\Client\Authentication\Authenticator;
use \Secuconnect\Client\Api\SmartTransactionsApi;
use \Secuconnect\Client\Api\PaymentTransactionsApi;
use \Secuconnect\Client\Model\SmartTransactionsDTO;
use \Secuconnect\Client\Model\SmartTransactionsBasketProduct;
use \Secuconnect\Client\Model\SmartTransactionsBasketInfo;
use \Secuconnect\Client\Model\SmartTransactionsApplicationContext;
use \Secuconnect\Client\Model\PaymentContext;
use \Secuconnect\Client\Model\SmartTransactionsApplicationContextReturnUrls;
use \Secuconnect\Client\Model\SmartTransactionsBasket;
use \Secuconnect\Client\Model\ProductInstanceID;
use \Secuconnect\Client\Api\GeneralContractsApi;
use \Secuconnect\Client\Api\GeneralStoresApi;
use \Secuconnect\Client\Api\GeneralMerchantsApi;
use Secuconnect\Client\Model\Contact;
use Secuconnect\Client\Model\SmartTransactionPaymentCustomerDTO;
use Secuconnect\Client\Model\SmartTransactionsPaymentLinks;
use Secuconnect\Client\Model\SmartTransactionsSetDeliveryModel;

require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_create_password.inc.php');
if(!function_exists('xtc_draw_radio_field')){
    require_once(DIR_FS_INC.'xtc_draw_radio_field.inc.php');
}
class yes_secupay {
    var $code, $title, $description, $enabled, $mode, $spaceid, $userid, $secret, 
        $logo, $_check, $sort_order, $contractID, $order_status;

    public const RESPONSE_LIST_SIZE = 20;
    public const API_URL_TEST = 'https://connect-testing.secupay-ag.de/api/v2';
    public const API_URL_LIVE = 'https://connect.secucard.com/api/v2';
    public const AUTH_URL_TEST = 'https://connect-testing.secupay-ag.de/';
    public const AUTH_URL_LIVE = 'https://connect.secucard.com/';
    function __construct() {
        $this->code = 'yes_secupay';
        $this->title = MODULE_PAYMENT_YES_SECUPAY_TEXT_TITLE;
        $this->description = MODULE_PAYMENT_YES_SECUPAY_TEXT_DESC;

        $this->sort_order = (defined('MODULE_PAYMENT_YES_SECUPAY_SORT_ORDER')) ? MODULE_PAYMENT_YES_SECUPAY_SORT_ORDER : 0;
        $this->enabled = ((defined('MODULE_PAYMENT_YES_SECUPAY_STATUS') and MODULE_PAYMENT_YES_SECUPAY_STATUS == 'True') ? true : false);
        $this->mode = (defined('MODULE_PAYMENT_YES_SECUPAY_MODE')) ? MODULE_PAYMENT_YES_SECUPAY_MODE : '';


        if( $this->enabled === True){
            $this->contractID = MODULE_PAYMENT_YES_SECUPAY_SPACEID;
            $this->spaceid = MODULE_PAYMENT_YES_SECUPAY_SPACEID;
            $this->userid = MODULE_PAYMENT_YES_SECUPAY_USERID;
            $this->secret = MODULE_PAYMENT_YES_SECUPAY_SECRET;
            $this->logo = MODULE_PAYMENT_YES_SECUPAY_LOGO;
            if(!empty($this->logo)){
                $desc .= sprintf('<br /><img src="%s" class="payment_logo secupay_logo" border="0" alt="Secupay Payment" />',
                    $this->logo
                );
            }
        }
        $this->order_status = ORDERS_STATUS_BEZAHLT;
    }
    
	function javascript_validation() {
		return false;
	}
    public static function load_credentials(){
        return [];
    }

    public static function getPaymentValues(){
        return [];
    }

    public static function getPayment(){
        return [];
    }
    public static function get_payment_link_from_payment_object($payment, $mode){
        return '';
    }

	public function selection() {
            $desc = $this->description;
            return array (
                'id' => $this->code, 
                'module' => $this->title, 
                'description' => $desc
            );
	}
        
    function confirmation() {
            return false;
    }

    function process_button() {
            return false;
    }

    public function allocate_to_yes_order(int $orders_id, string $paypal_payer_id, string $paypal_txn_id){
        $insert_sql_array = [
            'xtc_order_id'=>$orders_id,
            'payer_id'=> $paypal_payer_id,
            'payment_date' => date('Y-m-d H:i:s'),
            'txn_id'=>$paypal_txn_id,
            'date_added'=>date('Y-m-d H:i:s')
        ];
        yes_db_perform('paypal',$insert_sql_array);
    }

    public function before_process() {
        global $order, $order_totals;
        if(!defined('TEXT_PAYMENTINSTRUCTIONS_BANK_OWNER')){
            require_once(DIR_FS_CATALOG.'lang/'.($_SESSION['language']??'german').'/modules/payment/yes_secupay.php');
        }


        if(!is_countable($order_totals) or !sizeOf($order_totals)){
            // wir melden _is_ not available
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING,'error_msg=Secupay%20Payment%20is%20not%20available'));
        }
        $total = 0;
        foreach($order_totals as $ot){
            switch($ot['code']){
                case 'ot_total':
                    $total += $ot['value'];
                    break;
            }
        }
        $total = xtc_round($total*100, 0);
        $debug = false;
// === Konfiguration ===
        $host = $this->mode == 'Live' ? self::API_URL_LIVE : self::API_URL_TEST;
        $auth_host = $this->mode == 'Live' ? self::AUTH_URL_LIVE : self::AUTH_URL_TEST;
Configuration::getDefaultConfiguration()
        ->setDebug($debug)
    ->setHost($host)
    ->setAuthHost($auth_host);

// === Authentifizierung ===
Authenticator::authenticateByClientCredentials(
    constant('MODULE_PAYMENT_YES_SECUPAY_USERID'),
    constant('MODULE_PAYMENT_YES_SECUPAY_SECRET')
);
        if(isset($_SESSION['yes_secupay']) and isset($_SESSION['yes_secupay']['id'])){
            $response = $this->getSmartTransaction($_SESSION['yes_secupay']['id']);
            if($response->getStatus() == 'ok'){
                if( $response->getId() == $_SESSION['yes_secupay']['id'] ){
                    if(is_countable($response->getTransactions()) and sizeOf($response->getTransactions())){
                        $trans_values = [];
                        foreach($response->getTransactions() as $tr){
                            $trans_values[] = $tr->getId();
                        }
                        // die speichern wir als allocation zur _SESSION['yes_secupay']['id']
                        $_SESSION['secupay']['payment_transactions'] = $trans_values;

                        $firstTransaction = current($response->getTransactions());
                        $paymentTransactionResponse = $this->getPaymentTransaction($firstTransaction->getId());
                        $text = sprintf('IBAN: %s BIC: %s %s: %s Bank: %s %s: %s %s: %s',
                            $paymentTransactionResponse->getPaymentInstructions()->getIban(),
                            $paymentTransactionResponse->getPaymentInstructions()->getBic(),
                            TEXT_PAYMENTINSTRUCTIONS_BANK_OWNER,
                            $paymentTransactionResponse->getPaymentInstructions()->getOwner(),
                            $paymentTransactionResponse->getPaymentInstructions()->getBankname(),
                            TEXT_PAYMENTINSTRUCTIONS_VWZ,
                            $paymentTransactionResponse->getPaymentInstructions()->getPurpose(),
                            TEXT_PAYMENTINSTRUCTIONS_AMOUNT,
                            $paymentTransactionResponse->getAmount().' '.$paymentTransactionResponse->getCurrency()
                        );
                        $_SESSION['secupay']['paymentinstructions'] = $text;
                    }
                    $order->info['payment_method'] = $response->getPaymentMethod();
                    return true;
                }
            }
            unset($_SESSION['yes_secupay']);
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING,'error_msg=Secupay%20Payment%20Failed'));
        }


/*
$result = $this->getContracts();
$contracts = [];
foreach ($result->getData() as $contract) {
    $contracts[] = [
        'id'=>$contract->getId(),
        'text'=>$contract->getMerchant()->getId()
    ];
}
    // MRC_P3GUJ95S3PKS38NQUPZFP048GA8ZNN
yes_debug($result);
exit;
*/
/* ALLE STORES, KEINE AHNUNG WOFUER
$result = $this->getStores();
$stores = [];
foreach ($result->getData() as $store) {
    $stores[] = [
        'id'=>$store->getId(),
        'text'=>$store->getStoreName().' / '.$store->getName()
    ];
}
yes_debug($stores);
*/
/*
$result = $this->findSmartTransactions(0);
if($result->getCount() > self::RESPONSE_LIST_SIZE){
    $diff = $result->getCount() % self::RESPONSE_LIST_SIZE;
    $pages_total = 1+($result->getCount()-$diff)/self::RESPONSE_LIST_SIZE;
    echo $pages_total . ' pages';
}
for($i=0;$i<$pages_total;$i++){
    $result = $this->findSmartTransactions($i*self::RESPONSE_LIST_SIZE);
    $result_items = $result->getData();
    foreach($result_items as $trans){
        $pl = $trans->getPaymentLinks();
        printf('<li>%s vom %s im Status <b>%s</b>: %s %s (%s)</li>',
            $trans->getId(),
            $trans->getCreated(),
            $trans->getStatus(),
            $trans->getBasketInfo()->getSum()/100,
            $trans->getBasketInfo()->getCurrency(),
            ($pl !== Null) ? $pl->__toString() : ''
        );
    }
}
yes_debug($result);exit;
*/
/*$response = $this->getMerchant('MRC_P3GUJ95S3PKS38NQUPZFP048GA8ZNN');
yes_debug($response);exit;
*/
//$this->prepareTransaction('STX_32KAKNKD72Q2ZNUVCH787A3FG3A5A2');





// === 3. Basket definieren ===
/*$basketItems = [];
$basketItems[] = (new SmartTransactionsBasketProduct())
    ->setId(1)
    ->setItemType("article")
    ->setDesc("Your Order")
    ->setPriceOne($total)
    //->setTax(19)
    ->setQuantity(1);

$basket = (new SmartTransactionsBasket())
    ->setProducts($basketItems);
*/
$basketInfo = (new SmartTransactionsBasketInfo())
    ->setSum($total)
    ->setCurrency(DEFAULT_CURRENCY);

// === 4. Redirect-URLs ===
$returnUrls = (new SmartTransactionsApplicationContextReturnUrls())
    ->setUrlSuccess(HTTPS_SERVER.FILENAME_CHECKOUT_PROCESS)
    ->setUrlError(HTTPS_SERVER.FILENAME_CHECKOUT_SHIPPING)
    ->setUrlAbort(HTTPS_SERVER.FILENAME_CHECKOUT_SHIPPING)
    ->setUrlPush(HTTPS_SERVER.'callback/yes_secupay.php');

// === 5. Transaktion anlegen ===
$demo = ($this->mode == 'Live') ? false : true;
$transaction = (new SmartTransactionsDTO())
    ->setIntent("sale")
    ->setIsDemo($demo)
    //->setBasket($basket)
    ->setBasketInfo($basketInfo)
    ->setContract(
        (new ProductInstanceID())->setId($this->contractID)  // z. B. 'PCD_abc123...'
    )
    ->setCustomer(
        (new SmartTransactionPaymentCustomerDTO())
            ->setContact(
                (new Contact())
                ->setForename($order->billing['firstname'])
                ->setSurname($order->billing['lastname'])
                ->setEmail($order->customer['email_address'])
                ->setCompanyname($order->billing['company'])
                ->setAddress(
                    (new \Secuconnect\Client\Model\Address)
                        ->setStreet($order->billing['street_address'])
                        ->setAdditionalAddressData($order->billing['suburb'])
                        ->setCity($order->billing['city'])
                        ->setPostalCode($order->billing['postcode'])
                        ->setCountry($order->billing['country']['iso_code_2'])
                )
            )
    )
    ->setApplicationContext(
        (new SmartTransactionsApplicationContext())
            ->setReturnUrls($returnUrls)
            ->setCheckoutTemplate('COT_WD0DE66HN2XWJHW8JM88003YG0NEA2')
            ->setShopDetails((new \Secuconnect\Client\Model\SmartTransactionsApplicationContextShopDetails)
                ->setPluginVendor('YES Websolutions')
                ->setPluginVersion('1.0')
                ->setShopDomain(HTTPS_SERVER)
                ->setShopSystem(STORE_NAME)
            )
    )
    ->setPaymentContext(
        (new PaymentContext())
            ->setAutoCapture(true)
            ->setPaymentMethods(['creditcard'/*,'debit'*/,'invoice'])
);
/*->setPaymentMethods(['creditcard','debit','invoice'])*/
$api = new SmartTransactionsApi(new ApiClient());
$response = $api->addTransaction($transaction);
if($response->getStatus() == 'created'){
    $_SESSION['yes_secupay'] = [
        'id'=>$response->getID()
    ];
    // === 6. Weiterleitung zum Smart Checkout ===
    $paymentLinks = $response->getPaymentLinks();
    if (isset($paymentLinks['general'])) {
        header("Location: " . $paymentLinks['general']);
        exit;
    } else {
        throw new Exception("Kein 'general' Eintrag in PaymentLinks.\n\n".print_r($response,true));
    }
}
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING,'error_msg=Secupay%20Payment%20failed'));
        return false;
    }

    
    public function after_process(){
        global $insert_id;
        yes_db_perform(TABLE_ORDERS,[
            'payment_transaction_id'=>$_SESSION['yes_secupay']['id'],
            'orders_status'=>ORDERS_STATUS_BEZAHLT,
        ],'update',['orders_id'=>intval($insert_id)]);
        order::add_history_static($insert_id,ORDERS_STATUS_BEZAHLT,true, 'Secupay: Auftrag gilt als Bezahlt');
        yes_db_perform('orders_paymentinstructions',[
            'orders_id'=>intval($insert_id),
            'paymentinstructions'=>$_SESSION['secupay']['paymentinstructions'],
            'date_saved'=>date('Y-m-d H:i:s'),
        ]);
        if(is_countable($_SESSION['secupay']['payment_transactions'])){
            foreach($_SESSION['secupay']['payment_transactions'] as $ptid){
                yes_db_perform('secupay_payment_allocations',[
                    'orders_id'=>intval($insert_id),
                    'payment_transaction_id'=>$ptid,
                    'transaction_id'=>$_SESSION['yes_secupay']['id']
                ]);
            }
        }
        unset($_SESSION['yes_secupay']);
    }
    
    function check() {
        if (!isset ($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from ".TABLE_CONFIGURATION." where configuration_key = 'MODULE_PAYMENT_YES_SECUPAY_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install():void {
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_STATUS', 'False',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_SORT_ORDER', '0',  '6', '3', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_MODE', 'Sandbox',  '6', '4', 'xtc_cfg_select_option(array(\'Live\', \'Sandbox\'), ', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_SPACEID', '',  '6', '5', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_USERID', '',  '6', '6', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_SECRET', '',  '6', '7', now())");
        xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_SECUPAY_LOGO', '',  '6', '8', now())");
    }

    function remove() {
        xtc_db_query("delete from ".TABLE_CONFIGURATION." where configuration_key in ('".implode("', '", $this->keys())."')");
    }

    function keys():array {
        return array (
            'MODULE_PAYMENT_YES_SECUPAY_STATUS', 
            'MODULE_PAYMENT_YES_SECUPAY_SORT_ORDER', 
            'MODULE_PAYMENT_YES_SECUPAY_MODE', 
            'MODULE_PAYMENT_YES_SECUPAY_SPACEID',
            'MODULE_PAYMENT_YES_SECUPAY_USERID',
            'MODULE_PAYMENT_YES_SECUPAY_SECRET',
            'MODULE_PAYMENT_YES_SECUPAY_LOGO',
        );
    }
    
    
    
    private static function get_country_iso2_from_countries_id($countries_id):int{
        $record = main::get_country_values($countries_id);
        return $record['countries_iso_code_2'];
    }

    public function getContracts(){
        $client = new ApiClient();
        $GC = new GeneralContractsApi($client);
        return $GC->getAll();
    }

    public function getMerchant(string $merchantId ){
        $client = new ApiClient();
        $MA = new GeneralMerchantsApi($client);
        return $MA->getOne($merchantId);
        
    }

    public function getStores(){
        $client = new ApiClient();
        $GS = new GeneralStoresApi($client);
        return $GS->getAll();
    }

    public function findPaymentTransactions(int $start = 0, array $filter = []){
        $count = self::RESPONSE_LIST_SIZE;
        // 1. Konfiguration holen
        $config = Configuration::getDefaultConfiguration();

        // 2. Timeout setzen (in Sekunden)
        $config->setCurlTimeout(10);  // Abbruch nach 10 Sekunden bei Nicht-Antwort
        $client = new ApiClient($config);

        $PT = new PaymentTransactionsApi($client);
        return $PT->getAll($count, $start, $filter, null, 'created:desc');
    }

    public function findSmartTransactions(int $start = 0, array $filter = []){
        $count = self::RESPONSE_LIST_SIZE;
        $client = new ApiClient();
        $ST = new SmartTransactionsApi($client);
        return $ST->getAll($count,$start,$filter,null,'created:desc');
    }

    public function getSmartTransaction(string $transactionId){
        $client = new ApiClient();
        $ST = new SmartTransactionsApi($client);
        return $ST->getOne($transactionId);
    }

    public function prepareTransaction( string $transactionId ){
        $client = new ApiClient();
        $ST = new SmartTransactionsApi($client);
        $body = new \Secuconnect\Client\Model\SmartTransactionsPrepare();
        $returnUrls = (new SmartTransactionsApplicationContextReturnUrls())
            ->setUrlSuccess(HTTPS_SERVER.FILENAME_CHECKOUT_PROCESS)
            ->setUrlError(HTTPS_SERVER.FILENAME_CHECKOUT_SHIPPING)
            ->setUrlAbort(HTTPS_SERVER.FILENAME_CHECKOUT_SHIPPING);
        $body->setCallbackUrls($returnUrls);
        return $ST->prepare($transactionId,'invoice',$body);
    }

    public static function setSmartTransactionDelivery(string $transactionId, int $orders_id, string $shipper, string $transactions):Secuconnect\Client\Model\SmartTransactionsProductModel{
        $client = new ApiClient();
        $DT = new SmartTransactionsApi($client);
        $sm = new \Secuconnect\Client\Model\SmartTransactionsShippingModel();
        $sm->setInvoiceNumber("RE-NR $orders_id");
        $datetime = new DateTime('-2 Hours');
        $sm->setShippedAt($datetime->format(DateTime::ATOM));
        $sm->setShippedBy($shipper);
        $sm->setTrackingCode($transactions);
        $sm->setType('shipping');
        $body = new SmartTransactionsSetDeliveryModel();
        $body->setDeliveryOptions($sm);
        return $DT->setDelivery($transactionId,$body);
    }

    public static function getPaymentTransaction(string $paymentTransactionId){
        $client = new ApiClient();
        $PT = new PaymentTransactionsApi($client);
        return $PT->getPaymentInstructionsForPaymentTransaction($paymentTransactionId);
    }

    public static function getFullPaymentTransaction(string $paymentTransactionId){
        $client = new ApiClient();
        $PT = new PaymentTransactionsApi($client);
        return $PT->getOne($paymentTransactionId);
    }

    public static function getAllocationFromPaymentTransactionId( string $paymentTransactionId ):array{
        $query = yes_query(
            "SELECT transaction_id,orders_id FROM secupay_payment_allocations WHERE payment_transaction_id=:ptid",
            ['ptid'=>$paymentTransactionId],
            true
        );
        return [
            'orders_id'=>$query['orders_id']??0,
            'transaction_id'=>$query['transaction_id']??'',
        ];
    }
}
