<?php
/* -----------------------------------------------------------------------------------------
   $Id: flat.php,v 1.4 2012/03/29 09:55:48 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(flat.php,v 1.40 2003/02/05); www.oscommerce.com 
   (c) 2003	 nextcommerce (flat.php,v 1.7 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/


  class flat extends shipping_default_class {
    var $code, $title, $description, $icon, $enabled, $sort_order, $tax_class, $quotes;


    function __construct() {
      global $order;

      $this->code = 'flat';
      $this->title = MODULE_SHIPPING_FLAT_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_FLAT_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_SHIPPING_FLAT_SORT_ORDER'))?MODULE_SHIPPING_FLAT_SORT_ORDER:0;
      $this->icon = '';
      $this->tax_class = (defined('MODULE_SHIPPING_FLAT_TAX_CLASS'))?MODULE_SHIPPING_FLAT_TAX_CLASS:0;
      $this->enabled = ((defined('MODULE_SHIPPING_FLAT_STATUS') and MODULE_SHIPPING_FLAT_STATUS == 'True') ? true : false);

      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_FLAT_ZONE > 0) ) {
        $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
            intval(MODULE_SHIPPING_FLAT_ZONE),
            intval($order->delivery['country']['id']),
            intval($order->delivery['zone_id'])
        );
        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }


    function quote($method = '') {
		global $order;

		$this->quotes = array('id' => $this->code,
			'module' => MODULE_SHIPPING_FLAT_TEXT_TITLE,
			'methods' => array(array('id' => $this->code,
			'title' => MODULE_SHIPPING_FLAT_TEXT_WAY,
			'cost' => MODULE_SHIPPING_FLAT_COST))
		);
		$tax_class_id = $this->get_shipping_tax_class($order);
                $country_id = $order->delivery['country_id'];
                $zone_id = $order->delivery['zone_id'];
		if ($tax_class_id > 0) {
                    $this->quotes['tax'] = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);
		}

		if (xtc_not_null($this->icon)) $this->quotes['icon'] = xtc_image($this->icon, $this->title);
		return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_FLAT_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_SHIPPING_FLAT_STATUS', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_FLAT_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_FLAT_COST', '5.00', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_FLAT_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_FLAT_ZONE', '0', '6', '0', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_FLAT_SORT_ORDER', '0', '6', '0', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_SHIPPING_FLAT_STATUS', 'MODULE_SHIPPING_FLAT_COST','MODULE_SHIPPING_FLAT_ALLOWED', 'MODULE_SHIPPING_FLAT_TAX_CLASS', 'MODULE_SHIPPING_FLAT_ZONE', 'MODULE_SHIPPING_FLAT_SORT_ORDER');
    }
  }
