<?php
/* -----------------------------------------------------------------------------------------
   $Id: upcoming_products.php,v 1.8 2014/09/02 12:25:37 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(upcoming_products.php,v 1.23 2003/02/12); www.oscommerce.com 
   (c) 2003	 nextcommerce (upcoming_products.php,v 1.7 2003/08/22); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

$module_smarty= new yesSmarty;
$module_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
// include needed functions
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
require_once(DIR_WS_CLASSES . 'product.php');
$module_content=array();

//fsk18 lock
$fsk_lock='';
if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
	$fsk_lock=' and p.products_fsk18!=1';
}   
$group_check = '';
if (GROUP_CHECK=='true') {
	$group_check="and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
}
$expected_query = yes_db_query(
	sprintf(
		"select p.products_id, products_date_available as date_expected,pd.products_name,to_days(now()) - to_days(p.products_date_available) as dayspan
		from %s p LEFT JOIN %s pd USING(products_id)
                where to_days(p.products_date_available) >= to_days(now())
		 and pd.language_id='%d' and p.products_status=1 AND p.products_listing_status=1 
		 %s %s order by %s %s limit %s",
		TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,
		$_SESSION['languages_id'],
		$group_check,$fsk_lock,
		EXPECTED_PRODUCTS_FIELD,EXPECTED_PRODUCTS_SORT,
		MAX_DISPLAY_UPCOMING_PRODUCTS
	),true
);
if (yes_db_num_rows($expected_query)) {
	$row = 0;
	foreach($expected_query as $expected) {
		$row++;
		$product = new product($expected['products_id']);
		$info_array = $product->buildDataArray($product->data);
		$module_content[]=array(
		    'INFO'=>$info_array,
			'PRODUCTS_LINK'=>xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $expected['products_id']),
			'PRODUCTS_NAME'=>xtc_db_prepare_input($expected['products_name']),
			'PRODUCTS_DATE'=>xtc_date_short($expected['date_expected']),
		    'DAYSPAN'=>$expected['dayspan']
		);
	}
	$module_smarty->assign('language', $_SESSION['language']);
	$module_smarty->assign('module_content',$module_content);
	// set cache ID
	if (USE_CACHE=='false') {
		$module_smarty->caching = 0;
		$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/upcoming_products.html');
	} else {
		$module_smarty->caching = 1;
		$module_smarty->cache_lifetime=CACHE_LIFETIME;
		$module_smarty->cache_modified_check=CACHE_CHECK;
		$cache_id = $_SESSION['language'].$_SESSION['customers_status']['customers_status_name'].$_SESSION['currency'];
		$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/upcoming_products.html',$cache_id);
	}
	$default_smarty->assign('MODULE_upcoming_products',$module);
}

