<?php
/* YES SMARTY INCLUDES GLOBAL */
function smarty_function_marketing_box($params,&$smarty){
    global $InstanceCache;
    // include needed functions
    require_once (DIR_FS_INC . 'xtc_get_path.inc.php');
    if(!defined('BOX_MARKETING') or empty(BOX_MARKETING)){
	return '';
    }
    
    $parts = explode(':',BOX_MARKETING);
    if(sizeOf($parts) != 2){
	return '<p><b>Die Marketingbox wurde noch nicht konfiguriert.</b></p>';
    }
    $content = $parts[1];
    $boxes = explode(';',$content);
    if(!isset($params['box']) or $params['box'] > sizeOf($boxes) or $params['box'] < 1 or !isset($boxes[ $params['box']-1 ])){
	$params['box'] = 1;
    }
    $boxID = $params['box'] - 1;
    $products = array();
    $products_array = explode(',',$boxes[$boxID]);
    foreach($products_array as $pID){
	if($pID > 0){
	    $products[] = (int)xtc_db_input($pID);
	}
    }
    if(!sizeOf($products)){
	return 'Keine Artikel in der Marketingbox zum anzeigen.';
    }
    
    $language_id = intval($_SESSION['languages_id']??2);
    foreach($products as $pID){
	if((int)$pID < 1){
	    continue;
	}
	$product = new product($pID);
        $pc2_allocations = \YES4Trade\Model\products_to_categories::get_items_by_products_id(intval($pID));
        if(!is_countable($pc2_allocations) or !sizeOf($pc2_allocations)){
            continue;
        }
        $p2c = current($pc2_allocations);
        $cache_key = 'shop.categories-c'.$p2c->categories_id.'-l'.$language_id;
        $cache_group = 'categories';
        $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

        $CachedString = $InstanceCache->getItem($key); // cache group
        if (!$CachedString->isHit()) {
            $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                $p2c->categories_id, $language_id,['categories_name']
            );
            $categories_data = [
                'categories_id'=>$p2c->categories_id,
                'categories_name'=> $catd->categories_name??''
            ];
            $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $categories_data = $CachedString->get();
        }
        $fsk_ok = true;
        if (intval($_SESSION['customers_status']['customers_fsk18_display']) == 0) {
            if(intval($product->data['products_fsk18']) == 1){
                $fsk_ok = false;
            }
        }
	if ($fsk_ok === true and !empty($product->data['products_name']) and intval($product->data['products_status']) == 1 and $product->data['products_listing_status']) {
            $array[] = array(
                'box_content' => $product->buildDataArray($product->data),
                'CATEGORY_LINK' => xtc_href_link(FILENAME_DEFAULT, xtc_category_link($categories_data['categories_id'], $categories_data['categories_name'])),
                'CATEGORY_NAME' => $categories_data['categories_name']
            );
	}
    }
    $box_smarty = new yesSmarty;
    $box_smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');
    $box_smarty->assign('PRODUCTS', $array);
    $box_smarty->assign('MY_PAGE', 'TEXT_MY_PAGE');
    $box_smarty->assign('WATCH_CATGORY', 'TEXT_WATCH_CATEGORY');
    $box_smarty->assign('MY_PERSONAL_PAGE', xtc_href_link(FILENAME_ACCOUNT));
    $box_smarty->assign('language', $_SESSION['language']);
    $box_smarty->caching = 0;
    $box_marketing = $box_smarty->fetch(CURRENT_TEMPLATE . '/'.$params['template']);
    echo $box_marketing;
    //$smarty->assign($params['assign'],$vars);
}
