<?php
/* -----------------------------------------------------------------------------------------
   $Id: german.php,v 1.88 2019/02/08 09:26:44 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(german.php,v 1.119 2003/05/19); www.oscommerce.com
   (c) 2003  nextcommerce (german.php,v 1.25 2003/08/25); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

// look in your $PATH_LOCALE/locale directory for available locales..
// on RedHat try 'de_DE'
// on FreeBSD try 'de_DE.ISO_8859-15'
// on Windows try 'de' or 'German'
$eerp = error_reporting();
error_reporting(E_ERROR);
if(is_file(DIR_FS_CATALOG.'lang/german/own_german.php')){
	require_once(DIR_FS_CATALOG.'lang/german/own_german.php');
}
@setlocale(LC_TIME, 'de_DE.ISO_8859-15');
define('DATE_FORMAT_SHORT', '%d.%m.%Y');  // this is used for strftime()
define('DATE_FORMAT_LONG', '%A, %d.%m.%Y'); // this is used for strftime()
define('DATE_FORMAT', 'd.m.Y');  // this is used for strftime()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');
define('TEXT_DAY','Tag');
define('TEXT_DAYS','Tage');

// page title
define('TITLE', STORE_NAME);

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function xtc_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 0, 2) . substr($date, 3, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 3, 2) . substr($date, 0, 2);
  }
}

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
define('LANGUAGE_CURRENCY', 'EUR');

// needed in includes/modules/metatags.php
define('META_LANGUAGE_CODE','de,german,deutsch');

// Global entries for the <html> tag
define('HTML_PARAMS',' xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="de"');

define('HEADER_TITLE_TOP', 'Startseite');
define('HEADER_TITLE_CATALOG', 'Katalog');

 // text for gender
define('MALE', 'Herr');
define('FEMALE', 'Frau');
define('MALE_ADDRESS', 'Herr');
define('FEMALE_ADDRESS', 'Frau');

// text for date of birth example
define('DOB_FORMAT_STRING', 'tt.mm.jjjj');

// text for quick purchase
define('IMAGE_BUTTON_ADD_QUICK', 'Schnellkauf!');
define('BOX_ADD_PRODUCT_ID_TEXT', 'Bitte geben Sie die Artikelnummer aus unserem Katalog ein.');

// text for gift voucher redeeming
define('IMAGE_REDEEM_GIFT','Gutschein Einl&ouml;sen!');

define('BOX_TITLE_STATISTICS','Statistik:');
define('BOX_ENTRY_CUSTOMERS','Kunden');
define('BOX_ENTRY_PRODUCTS','Artikel');
define('BOX_ENTRY_REVIEWS','Bewertungen');

// quick_find box text in includes/boxes/quick_find.php
define('BOX_SEARCH_TEXT', 'Verwenden Sie Stichworte um einen speziellen Artikel zu finden.');
define('BOX_SEARCH_ADVANCED_SEARCH', 'Erweiterte Suche');

// reviews box text in includes/boxes/reviews.php
define('BOX_REVIEWS_WRITE_REVIEW', 'Bewerten Sie diesen Artikel!');
define('BOX_REVIEWS_NO_REVIEWS', 'Es liegen noch keine Bewertungen vor');
define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s von 5 Sternen!');

// shopping_cart box text in includes/boxes/shopping_cart.php
define('BOX_SHOPPING_CART_EMPTY', '0 Artikel');

// notifications box text in includes/boxes/products_notifications.php
define('BOX_NOTIFICATIONS_NOTIFY', 'Benachrichtigen Sie mich &uuml;ber Aktuelles zum Artikel <b>%s</b>');
define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'Benachrichtigen Sie mich nicht mehr zum Artikel <b>%s</b>');

// manufacturer box text
define('BOX_MANUFACTURER_INFO_HOMEPAGE', '%s Homepage');
define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', 'Mehr Artikel');

define('BOX_HEADING_ADD_PRODUCT_ID','In den Korb legen');
define('BOX_HEADING_SEARCH','Suchen!');

define('BOX_INFORMATION_CONTACT', 'Kontakt');

// tell a friend box text in includes/boxes/tell_a_friend.php
define('BOX_HEADING_TELL_A_FRIEND', 'An einen Freund weiterempfehlen');
define('BOX_TELL_A_FRIEND_TEXT', 'Empfehlen Sie diesen Artikel einfach per eMail weiter.');

// pull down default text
define('PULL_DOWN_DEFAULT', 'Bitte w&auml;hlen');
define('TYPE_BELOW', 'Bitte unten eingeben');

// javascript messages
define('JS_ERROR', 'Notwendige Angaben fehlen!\n Bitte richtig ausfüllen.\n\n');
define('JS_ERROR_NO_GENDER_SELECTED','Bitte wählen Sie Ihre Anrede.');

define('JS_REVIEW_TEXT', '* Der Text muss mindestens aus ' . REVIEW_TEXT_MIN_LENGTH . ' Buchstaben bestehen.\n');
define('JS_REVIEW_RATING', '* Geben Sie Ihre Bewertung ein.\n');
define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Bitte wählen Sie eine Zahlungsweise für Ihre Bestellung.\n');
define('JS_ERROR_SUBMITTED', 'Diese Seite wurde bereits best&auml;tigt. Betätigen Sie bitte OK und warten bis der Prozess durchgef&uuml;hrt wurde.');
define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Bitte wählen Sie eine Zahlungsweise für Ihre Bestellung.');
define('CATEGORY_COMPANY', 'Firmendaten');
define('CATEGORY_PERSONAL', 'Ihre pers&ouml;nlichen Daten');
define('CATEGORY_ADDRESS', 'Ihre Adresse');
define('CATEGORY_CONTACT', 'Ihre Kontaktinformationen');
define('CATEGORY_OPTIONS', 'Optionen');
define('CATEGORY_PASSWORD', 'Ihr Passwort');

define('ENTRY_COMPANY', 'Firmenname:');
define('ENTRY_COMPANY_ERROR', '');
define('ENTRY_COMPANY_TEXT', '');
define('ENTRY_GENDER', 'Anrede:');
define('ENTRY_GENDER_ERROR', 'Bitte wählen Sie Ihre Anrede aus.');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME', 'Vorname:');
define('ENTRY_FIRST_NAME_ERROR', 'Ihr Vorname muss aus mindestens ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME', 'Nachname:');
define('ENTRY_LAST_NAME_ERROR', 'Ihr Nachname muss aus mindestens ' . ENTRY_LAST_NAME_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH', 'Geburtsdatum:');
define('ENTRY_DATE_OF_BIRTH_ERROR', 'Ihr Geburtsdatum muss im Format TT.MM.JJJJ (zB. 21.05.1970) eingeben werden');
define('ENTRY_DATE_OF_BIRTH_TEXT', '* (zB. 21.05.1970)');
define('ENTRY_EMAIL_ADDRESS', 'eMail-Adresse:');
define('ENTRY_EMAIL_ADDRESS_ERROR', 'Ihre eMail Adresse muss aus mindestens ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Ihre eingegebene eMail Adresse ist fehlerhaft - bitte &uuml;berpr&uuml;fen Sie diese.');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Ihre eingegebene eMail Adresse existiert bereits in unserer Datenbank - bitte loggen Sie mit dieser ein, oder erstellen Sie ein neues Konto mit einer neuen eMail Adresse.');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_STREET_ADDRESS', 'Strasse/Nr.:');
define('ENTRY_STREET_ADDRESS_ERROR', 'Strasse/Nr muss aus mindestens ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB', 'Stadtteil:');
define('ENTRY_SUBURB_ERROR', '');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE', 'Postleitzahl:');
define('ENTRY_POST_CODE_ERROR', 'Ihre Postleitzahl muss aus mindestens ' . ENTRY_POSTCODE_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CITY', 'Ort:');
define('ENTRY_CITY_ERROR', 'Ort muss aus mindestens ' . ENTRY_CITY_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE', 'Bundesland:');
define('ENTRY_STATE_ERROR', 'Ihr Bundesland muss aus mindestens ' . ENTRY_STATE_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_STATE_ERROR_SELECT', 'Bitte wählen Sie ihr Bundesland aus der Liste aus.');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_COUNTRY', 'Land:');
define('ENTRY_COUNTRY_ERROR', 'Bitte wählen Sie ihr Land aus der Liste aus.');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER', 'Telefonnummer:');
define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Ihre Telefonnummer muss aus mindestens ' . ENTRY_TELEPHONE_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER', 'Telefaxnummer:');
define('ENTRY_FAX_NUMBER_ERROR', '');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER', 'Newsletter:');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_NEWSLETTER_YES', 'abonniert');
define('ENTRY_NEWSLETTER_NO', 'nicht abonniert');
define('ENTRY_NEWSLETTER_ERROR', '');
define('ENTRY_PASSWORD', 'Passwort:');
define('ENTRY_PASSWORD_ERROR', 'Ihr Passwort muss aus mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'Ihre Passwörter stimmen nicht überein.');
define('ENTRY_PASSWORD_TEXT', '*');
define('ENTRY_PASSWORD_CONFIRMATION', 'Best&auml;tigung:');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Aktuelles Passwort:');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'Ihr Passwort muss aus mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_PASSWORD_NEW', 'Neues Passwort:');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'Ihr neues Passwort muss aus mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen bestehen.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'Ihre Passwörter stimmen nicht überein.');
define('PASSWORD_HIDDEN', '--VERSTECKT--');


// constants for use in xtc_prev_next_display function
define('TEXT_RESULT_PAGE', 'Seiten:');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Artikeln)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bestellungen)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bewertungen)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> neuen Artikeln)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Angeboten)');

define('PREVNEXT_TITLE_FIRST_PAGE', 'erste Seite');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'vorherige Seite');
define('PREVNEXT_TITLE_NEXT_PAGE', 'n&auml;chste Seite');
define('PREVNEXT_TITLE_LAST_PAGE', 'letzte Seite');
define('PREVNEXT_TITLE_PAGE_NO', 'Seite %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Vorhergehende %d Seiten');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'N&auml;chste %d Seiten');
define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;ERSTE');
define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;vorherige]');
define('PREVNEXT_BUTTON_NEXT', '[n&auml;chste&nbsp;&gt;&gt;]');
define('PREVNEXT_BUTTON_LAST', 'LETZTE&gt;&gt;');
define('IMAGE_BUTTON_ADD_ADDRESS', 'Neue Adresse');
define('IMAGE_BUTTON_ADDRESS_BOOK', 'Adressbuch');
define('IMAGE_BUTTON_BACK', 'Zur&uuml;ck');
define('IMAGE_BUTTON_CHANGE_ADDRESS', 'Adresse &auml;ndern');
define('IMAGE_BUTTON_CHECKOUT', 'Kasse');
define('IMAGE_BUTTON_CONFIRM_ORDER', 'Bestellung best&auml;tigen');
define('IMAGE_BUTTON_CONTINUE', 'Weiter');
define('IMAGE_BUTTON_CONTINUE_SHOPPING', 'Einkauf fortsetzen');
define('IMAGE_BUTTON_DELETE', 'L&ouml;schen');
define('IMAGE_BUTTON_EDIT_ACCOUNT', 'Daten &auml;ndern');
define('IMAGE_BUTTON_HISTORY', 'Bestell&uuml;bersicht');
define('IMAGE_BUTTON_LOGIN', 'Anmelden');
define('IMAGE_BUTTON_IN_CART', 'In den Warenkorb');
define('IMAGE_BUTTON_NOTIFICATIONS', 'Benachrichtigungen');
define('IMAGE_BUTTON_QUICK_FIND', 'Schnellsuche');
define('IMAGE_BUTTON_REMOVE_NOTIFICATIONS', 'Benachrichtigungen l&ouml;schen');
define('IMAGE_BUTTON_REVIEWS', 'Bewertungen');
define('IMAGE_BUTTON_SEARCH', 'Suchen');
define('IMAGE_BUTTON_SHIPPING_OPTIONS', 'Versandoptionen');
define('IMAGE_BUTTON_TELL_A_FRIEND', 'Weiterempfehlen');
define('IMAGE_BUTTON_UPDATE', 'Aktualisieren');
define('IMAGE_BUTTON_UPDATE_CART', 'Warenkorb aktualisieren');
define('IMAGE_BUTTON_WRITE_REVIEW', 'Bewertung schreiben');
define('IMAGE_BUTTON_ADMIN', 'Admin');

define('SMALL_IMAGE_BUTTON_DELETE', 'L&ouml;schen');
define('SMALL_IMAGE_BUTTON_EDIT', '&Auml;ndern');
define('SMALL_IMAGE_BUTTON_VIEW', 'Anzeigen');

define('ICON_ARROW_RIGHT', 'Zeige mehr');
define('ICON_CART', 'In den Warenkorb');
define('ICON_SUCCESS', 'Erfolg');
define('ICON_WARNING', 'Warnung');
define('ICON_ERROR','Fehler');

define('TEXT_GREETING_PERSONAL', 'Sch&ouml;n da&szlig; Sie wieder da sind <span class="greetUser">%s!</span> M&ouml;chten Sie sich unsere <a href="%s">neuen Artikel</a> ansehen?');
define('TEXT_GREETING_PERSONAL_RELOGON', '<small>Wenn Sie nicht %s sind, melden Sie sich bitte <a href="%s">hier</a> mit Ihrem Kundenkonto an.</small>');
define('TEXT_GREETING_GUEST', 'Herzlich Willkommen <span class="greetUser">Gast!</span> M&ouml;chten Sie sich <a href="%s">anmelden</a>? Oder wollen Sie ein <a href="%s">Kundenkonto</a> er&ouml;ffnen?');

define('TEXT_SORT_PRODUCTS', 'Sortierung der Artikel ist ');
define('TEXT_DESCENDINGLY', 'absteigend');
define('TEXT_ASCENDINGLY', 'aufsteigend');
define('TEXT_BY', ' nach ');

define('TEXT_REVIEW_BY', 'von %s');
define('TEXT_REVIEW_WORD_COUNT', '%s Worte');
define('TEXT_REVIEW_RATING', 'Bewertung: %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Hinzugef&uuml;gt am: %s');
define('TEXT_NO_REVIEWS', 'Es liegen noch keine Bewertungen vor.');

define('TEXT_NO_NEW_PRODUCTS', 'Zur Zeit gibt es keine neuen Artikel.');

define('TEXT_UNKNOWN_TAX_RATE', 'Unbekannter Steuersatz');

define('TEXT_REQUIRED', 'erforderlich');

define('ERROR_TEP_MAIL', '<font face="Verdana, Arial" size="2" color="#ff0000"><b><small>Fehler:</small> Die eMail kann nicht &uuml;ber den angegebenen SMTP-Server verschickt werden. Bitte kontrollieren Sie die Einstellungen in der php.ini Datei und f&uuml;hren Sie notwendige Korrekturen durch!</b></font>');
define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Warnung: Das Installationverzeichnis ist noch vorhanden auf: ' . dirname($_SERVER['SCRIPT_FILENAME']) . '/xtc_installer. Bitte l&ouml;schen Sie das Verzeichnis aus Gr&uuml;nden der Sicherheit!');
define('WARNING_CONFIG_FILE_WRITEABLE', 'Warnung: XT-Commerce kann in die Konfigurationsdatei schreiben: ' . dirname($_SERVER['SCRIPT_FILENAME']) . '/includes/configure.php. Das stellt ein m&ouml;gliches Sicherheitsrisiko dar - bitte korrigieren Sie die Benutzerberechtigungen zu dieser Datei!');
define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Warnung: Das Verzeichnis f&uuml;r die Sessions existiert nicht: ' . xtc_session_save_path() . '. Die Sessions werden nicht funktionieren bis das Verzeichnis erstellt wurde!');
define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Warnung: XT-Commerce kann nicht in das Sessions Verzeichnis schreiben: ' . xtc_session_save_path() . '. Die Sessions werden nicht funktionieren bis die richtigen Benutzerberechtigungen gesetzt wurden!');
define('WARNING_SESSION_AUTO_START', 'Warnung: session.auto_start ist aktiviert (enabled) - Bitte deaktivieren (disabled) Sie dieses PHP Feature in der php.ini und starten Sie den WEB-Server neu!');
define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Warnung: Das Verzeichnis für den Artikel Download existiert nicht: ' . DIR_FS_DOWNLOAD . '. Diese Funktion wird nicht funktionieren bis das Verzeichnis erstellt wurde!');

define('TEXT_CCVAL_ERROR_INVALID_DATE', 'Das "G&uuml;ltig bis" Datum ist ung&uuml;ltig.<br>Bitte korrigieren Sie Ihre Angaben.');
define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'Die "KreditkarteNummer", die Sie angegeben haben, ist ung&uuml;ltig.<br>Bitte korrigieren Sie Ihre Angaben.');
define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'Die ersten 4 Ziffern Ihrer Kreditkarte sind: %s<br>Wenn diese Angaben stimmen, wird dieser Kartentyp leider nicht akzeptiert.<br>Bitte korrigieren Sie Ihre Angaben gegebenfalls.');

/*
  The following copyright announcement can only be
  appropriately modified or removed if the layout of
  the site theme has been modified to distinguish
  itself from the default osCommerce-copyrighted
  theme.

  Please leave this comment intact together with the
  following copyright announcement.

  Copyright announcement changed due to the permissions
  from LG Hamburg from 28th February 2003 / AZ 308 O 70/03
*/
define('FOOTER_TEXT_BODY', 'Copyright &copy; 2003 <a href="http://www.xt-commerce.com" target="_blank">XT-Commerce</a><br>Powered by <a href="http://www.xt-commerce.com" target="_blank">XT-Commerce</a>');

//  conditions check

define('ERROR_CONDITIONS_NOT_ACCEPTED', 'Sofern Sie unsere Allgemeinen Geschäftsbedingungen nicht akzeptieren, können wir Ihre Bestellung bedauerlicherweise nicht entgegennehmen!');
define('ERROR_WIDERRUF_NOT_ACCEPTED', 'Sofern Sie unsere Widerrufsbelehrung nicht akzeptieren, können wir Ihre Bestellung bedauerlicherweise nicht entgegennehmen!');

define('SUB_TITLE_OT_DISCOUNT','Rabatt:');
define('SUB_TITLE_SUB_NEW','Summe:');
define('TEXT_CART_OT_DISCOUNT','Rabatt:');

define('NOT_ALLOWED_TO_SEE_PRICES','<img src="images/icons/preis_info.gif" alt="Sie können als Gast (bzw mit Ihrem derzeitigen Status) keine Preise sehen" title="Sie können als Gast (bzw mit Ihrem derzeitigen Status) keine Preise sehen" border="0">');
define('NOT_ALLOWED_TO_ADD_TO_CART','Sie k&ouml;nnen als Gast (bzw mit Ihrem derzeitigen Status) keine Artikel in den Warenkorb legen');

define('BOX_LOGINBOX_HEADING', 'Willkommen zurück!');
define('BOX_LOGINBOX_EMAIL', 'eMail Adresse:');
define('BOX_LOGINBOX_PASSWORD', 'Passwort:');
define('BOX_ACCOUNTINFORMATION_HEADING','Information');
define('BOX_NEWSLETTER_EMAIL', 'eMail Adresse:');
define('BOX_LOGINBOX_STATUS','Kundengruppe:');
define('BOX_LOGINBOX_INCL','Alle Preise inkl. UST');
define('BOX_LOGINBOX_EXCL','Alle Preise exkl. UST');
define('TAX_ADD_TAX','inkl. ');
define('TAX_NO_TAX','zzgl. ');
define('BOX_LOGINBOX_DISCOUNT','Artikelrabatt');
define('BOX_LOGINBOX_DISCOUNT_TEXT','Rabatt');
define('BOX_LOGINBOX_DISCOUNT_OT','');

define('NOT_ALLOWED_TO_SEE_PRICES_TEXT','Sie haben keine Erlaubnis Preise zu sehen, erstellen Sie bitte ein Kundenkonto.');

define('TEXT_DOWNLOAD','Download');
define('TEXT_VIEW','Ansehen');

define('TEXT_BUY', '1 x \'');
define('TEXT_NOW', '\' bestellen');
define('TEXT_GUEST','Gast');
define('TEXT_NO_PURCHASES', 'Sie haben noch keine Bestellungen get&auml;tigt.');


// Warnings
define('SUCCESS_ACCOUNT_UPDATED', 'Ihr Konto wurde erfolgreich aktualisiert.');
define('SUCCESS_NEWSLETTER_UPDATED', 'Ihre Newsletter Abonnements wurden erfolgreich aktualisiert!');
define('SUCCESS_NOTIFICATIONS_UPDATED', 'Ihre Artikelbenachrichtigungen wurden erfolgreich aktualisiert!');
define('SUCCESS_PASSWORD_UPDATED', 'Ihr Passwort wurde erfolgreich ge&auml;ndert!');
define('ERROR_CURRENT_PASSWORD_NOT_MATCHING', 'Das eingegebene Passwort stimmt nicht mit dem gespeichertem Passwort &uuml;berein. Bitte versuchen Sie es noch einmal.');
define('TEXT_MAXIMUM_ENTRIES', '<font color="#ff0000"><b>Hinweis:</b></font> Ihnen stehen %s Adressbucheintr&auml;ge zur Verf&uuml;gung!');
define('SUCCESS_ADDRESS_BOOK_ENTRY_DELETED', 'Der ausgew&auml;hlte Eintrag wurde erflogreich gel&ouml;scht.');
define('SUCCESS_ADDRESS_BOOK_ENTRY_UPDATED', 'Ihr Adressbuch wurde erfolgreich aktualisiert!');
define('WARNING_PRIMARY_ADDRESS_DELETION', 'Die Standardadresse kann nicht gel&ouml;scht werden. Bitte erst eine andere Standardadresse w&auml;hlen. Danach kann der Eintrag gel&ouml;scht werden.');
define('ERROR_NONEXISTING_ADDRESS_BOOK_ENTRY', 'Dieser Adressbucheintrag ist nicht vorhanden.');
define('ERROR_ADDRESS_BOOK_FULL', 'Ihr Adressbuch kann keine weiteren Adressen aufnehmen. Bitte l&ouml;schen Sie eine nicht mehr ben&ouml;tigte Adresse. Danach k&ouml;nnen Sie einen neuen Eintrag speichern.');

//Advanced Search
define('ENTRY_CATEGORIES', 'Kategorien:');
define('ENTRY_INCLUDE_SUBCATEGORIES', 'Unterkategorien mit einbeziehen');
define('ENTRY_MANUFACTURERS', 'Hersteller:');
define('ENTRY_PRICE_FROM', 'Preis ab:');
define('ENTRY_PRICE_TO', 'Preis bis:');
define('TEXT_ALL_CATEGORIES', 'Alle Kategorien');
define('TEXT_ALL_MANUFACTURERS', 'Alle Hersteller');
define('JS_AT_LEAST_ONE_INPUT', '* Eines der folgenden Felder muss ausgefüllt werden:\n    Stichworte\n    Datum hinzugefügt von\n    Datum hinzugefügt bis\n    Preis ab\n    Preis bis\n');
define('JS_INVALID_FROM_DATE', '* Unzulässiges von Datum\n');
define('JS_INVALID_TO_DATE', '* Unzulässiges bis Datum\n');
define('JS_TO_DATE_LESS_THAN_FROM_DATE', '* Das von Datum muss grösser oder gleich bis jetzt sein\n');
define('JS_PRICE_FROM_MUST_BE_NUM', '* Preis ab, muss eine Zahl sein\n');
define('JS_PRICE_TO_MUST_BE_NUM', '* Preis bis, muss eine Zahl sein\n');
define('JS_PRICE_TO_LESS_THAN_PRICE_FROM', '* Preis bis muss größer oder gleich Preis ab sein.\n');
define('JS_INVALID_KEYWORDS', '* Suchbegriff unzulässig\n');
define('TEXT_NO_PRODUCTS', 'Es wurden keine Artikel gefunden, die den Suchkriterien entsprechen.');
define('TEXT_ORIGIN_LOGIN', '<font color="#FF0000"><small><b>ACHTUNG:</b></font></small> Wenn Sie bereits ein Konto besitzen, melden Sie sich bitte <a href="%s"><u><b>hier</b></u></a> an.');
define('TEXT_LOGIN_ERROR', '<font color="#ff0000"><b>FEHLER:</b></font> Keine &Uuml;bereinstimmung der eingebenen \'eMail-Adresse\' und/oder dem \'Passwort\'.');
define('TEXT_VISITORS_CART', '<font color="#ff0000"><b>ACHTUNG:</b></font> Ihre Eingaben werden automatisch mit Ihrem Kundenkonto verkn&uuml;pft. <a href="javascript:session_win();">[Mehr Information]</a>');
define('TEXT_NO_EMAIL_ADDRESS_FOUND', '<font color="#ff0000"><b>ACHTUNG:</b></font> Die eingegebene eMail-Adresse ist nicht registriert. Bitte versuchen Sie es noch einmal.');
define('TEXT_PASSWORD_SENT', 'Ein neues Passwort wurde per eMail verschickt.');
define('TEXT_PRODUCT_NOT_FOUND', 'Artikel wurde nicht gefunden!');
define('TEXT_MORE_INFORMATION', 'F&uuml;r weitere Informationen, besuchen Sie bitte die <a href="%s" target="_blank"><u>Homepage</u></a> zu diesem Artikel.');
define('TEXT_DATE_ADDED', 'Diesen Artikel haben wir am %s in unseren Katalog aufgenommen.');
define('TEXT_DATE_AVAILABLE', 'Wieder verfügbar ab %s');
define('TEXT_CART_EMPTY', 'Sie haben noch nichts in Ihrem Warenkorb.');
define('SUB_TITLE_SUB_TOTAL', 'Zwischensumme:');
define('SUB_TITLE_TOTAL', 'Summe:');

define('OUT_OF_STOCK_CANT_CHECKOUT', 'Die mit ' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . ' markierten Artikel sind leider nicht in der von Ihnen gew&uuml;nschten Menge auf Lager.<br>Bitte reduzieren Sie Ihre Bestellmenge f&uuml;r die gekennzeichneten Artikel. Vielen Dank');
define('OUT_OF_STOCK_CAN_CHECKOUT', 'Die mit ' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . ' markierten Artikel sind leider nicht in der von Ihnen gew&uuml;nschten Menge auf Lager.<br>Die bestellte Menge wird kurzfristig von uns geliefert, wenn Sie es w&uuml;nschen nehmen wir auch eine Teillieferung vor.');
define('STATUS_INVALID_CANT_CHECKOUT', 'Die mit ' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . ' markierten Artikel sind leider nicht mehr verf&uuml;gbar.');

define('HEADING_TITLE_TELL_A_FRIEND', 'Empfehlen Sie \'%s\' weiter');
define('HEADING_TITLE_ERROR_TELL_A_FRIEND', 'Artikel weiterempfehlen');
define('ERROR_INVALID_PRODUCT', 'Das von Ihnen gew&auml;hlte Artikel wurde nicht gefunden!');

define('NAVBAR_TITLE_ACCOUNT', 'Ihr Konto');
define('NAVBAR_TITLE_1_ACCOUNT_EDIT', 'Ihr Konto');
define('NAVBAR_TITLE_2_ACCOUNT_EDIT', 'Ihre pers&ouml;nliche Daten &auml;ndern');
define('NAVBAR_TITLE_1_ACCOUNT_HISTORY', 'Ihr Konto');
define('NAVBAR_TITLE_2_ACCOUNT_HISTORY', 'Ihre get&auml;tigten Bestellungen');
define('NAVBAR_TITLE_1_ACCOUNT_HISTORY_INFO', 'Ihr Konto');
define('NAVBAR_TITLE_2_ACCOUNT_HISTORY_INFO', 'Get&auml;tigte Bestellung');
define('NAVBAR_TITLE_3_ACCOUNT_HISTORY_INFO', 'Bestellnummer %s');
define('NAVBAR_TITLE_1_ACCOUNT_NEWSLETTERS', 'Ihr Konto');
define('NAVBAR_TITLE_2_ACCOUNT_NEWSLETTERS', 'Newsletter Abonnements');
define('NAVBAR_TITLE_1_ACCOUNT_NOTIFICATIONS', 'Ihr Konto');
define('NAVBAR_TITLE_2_ACCOUNT_NOTIFICATIONS', 'Artikelbenachrichtungen');
define('NAVBAR_TITLE_1_ACCOUNT_PASSWORD', 'Ihr Konto');
define('NAVBAR_TITLE_2_ACCOUNT_PASSWORD', 'Passwort &auml;ndern');
define('NAVBAR_TITLE_1_ADDRESS_BOOK', 'Ihr Konto');
define('NAVBAR_TITLE_2_ADDRESS_BOOK', 'Adressbuch');
define('NAVBAR_TITLE_1_ADDRESS_BOOK_PROCESS', 'Ihr Konto');
define('NAVBAR_TITLE_2_ADDRESS_BOOK_PROCESS', 'Adressbuch');
define('NAVBAR_TITLE_ADD_ENTRY_ADDRESS_BOOK_PROCESS', 'Neuer Eintrag');
define('NAVBAR_TITLE_MODIFY_ENTRY_ADDRESS_BOOK_PROCESS', 'Eintrag &auml;ndern');
define('NAVBAR_TITLE_DELETE_ENTRY_ADDRESS_BOOK_PROCESS', 'Eintrag l&ouml;schen');
define('NAVBAR_TITLE_ADVANCED_SEARCH', 'Erweiterte Suche');
define('NAVBAR_TITLE1_ADVANCED_SEARCH', 'Erweiterte Suche');
define('NAVBAR_TITLE2_ADVANCED_SEARCH', 'Suchergebnisse');
define('NAVBAR_TITLE_1_CHECKOUT_CONFIRMATION', 'Kasse');
define('NAVBAR_TITLE_2_CHECKOUT_CONFIRMATION', 'Best&auml;tigung');
define('NAVBAR_TITLE_1_CHECKOUT_PAYMENT', 'Kasse');
define('NAVBAR_TITLE_2_CHECKOUT_PAYMENT', 'Zahlungsweise');
define('NAVBAR_TITLE_1_PAYMENT_ADDRESS', 'Kasse');
define('NAVBAR_TITLE_2_PAYMENT_ADDRESS', 'Rechnungsadresse &auml;ndern');
define('NAVBAR_TITLE_1_CHECKOUT_SHIPPING', 'Kasse');
define('NAVBAR_TITLE_2_CHECKOUT_SHIPPING', 'Versandinformationen');
define('NAVBAR_TITLE_1_CHECKOUT_SHIPPING_ADDRESS', 'Kasse');
define('NAVBAR_TITLE_2_CHECKOUT_SHIPPING_ADDRESS', 'Versandadresse &auml;ndern');
define('NAVBAR_TITLE_1_CHECKOUT_SUCCESS', 'Kasse');
define('NAVBAR_TITLE_2_CHECKOUT_SUCCESS', 'Erfolg');
define('NAVBAR_TITLE_CONTACT_US', 'Kontakt');
define('NAVBAR_TITLE_CREATE_ACCOUNT', 'Konto erstellen');
define('NAVBAR_TITLE_1_CREATE_ACCOUNT_SUCCESS', 'Konto erstellen');
define('NAVBAR_TITLE_2_CREATE_ACCOUNT_SUCCESS', 'Erfolg');
if (isset($navigation) && $navigation->snapshot['page'] == FILENAME_CHECKOUT_SHIPPING) {
  define('NAVBAR_TITLE_LOGIN', 'Bestellen');
} else {
  define('NAVBAR_TITLE_LOGIN', 'Anmelden');
}
define('NAVBAR_TITLE_LOGOFF','Auf Wiedersehen');
define('NAVBAR_TITLE_1_PASSWORD_FORGOTTEN', 'Anmelden');
define('NAVBAR_TITLE_2_PASSWORD_FORGOTTEN', 'Passwort vergessen');
define('NAVBAR_TITLE_PRODUCTS_NEW', 'Neue Artikel');
define('NAVBAR_TITLE_SHOPPING_CART', 'Warenkorb');
define('NAVBAR_TITLE_SPECIALS', 'Angebote');
define('NAVBAR_TITLE_COOKIE_USAGE', 'Cookie-Nutzung');
define('NAVBAR_TITLE_PRODUCT_REVIEWS', 'Bewertungen');
define('NAVBAR_TITLE_TELL_A_FRIEND', 'Artikel weiterempfehlen');
define('NAVBAR_TITLE_REVIEWS_WRITE', 'Bewertungen');
define('NAVBAR_TITLE_REVIEWS','Bewertungen');
define('NAVBAR_TITLE_SSL_CHECK', 'Sicherheitshinweis');
define('NAVBAR_TITLE_CREATE_GUEST_ACCOUNT','Adresseingabe');
define('NAVBAR_TITLE_PASSWORD_DOUBLE_OPT','Passwort vergessen?');
// Newsletter
define('NAVBAR_TITLE_NEWSLETTER','Newsletter');
define('TEXT_INFO_START','Tragen Sie sich in unseren kostenlosen Newsletter ein!');
define('TEXT_NEWSLETTER','Sie möchten immer auf dem Laufenden bleiben?<br>Kein Problem, tragen Sie sich in unseren Newsletter ein und Sie sind immer auf dem neuesten Stand.');
define('TEXT_EMAIL_INPUT','Ihre E-Mailadresse wurde in unser System eingetragen.<br>Gleichzeitig wurde Ihnen vom System eine E-Mail mit einem Aktivierungslink geschickt. Bitte klicken Sie nach dem Erhalt der Mail auf den Link um Ihre Eintragung zu bestätigen. Ansonsten bekommen Sie keinen Newsletter von uns zugestellt!');

define('TEXT_WRONG_CODE','<font color="FF0000">Ihr eingegebener Sicherheitscode stimmte nicht mit dem angezeigten Code überein. Bitte versuchen Sie es erneut.</font>');
define('TEXT_EMAIL_EXIST_NO_NEWSLETTER','<font color="FF0000">Diese E-Mailadresse existiert bereits in unserer Datenbank ist aber noch nicht für den Empfang des Newsletters freigeschalten!</font>');
define('TEXT_EMAIL_EXIST_NEWSLETTER','<font color="FF0000">Diese E-Mailadresse existiert bereits in unserer Datenbank und ist für den Newsletterempfang bereits freigeschalten!</font>');
define('TEXT_EMAIL_NOT_EXIST','<font color="FF0000">Diese E-Mailadresse existiert nicht in unserer Datenbank!</font>');
define('TEXT_EMAIL_DEL','Ihre E-Mailadresse wurde aus unserer Newsletterdatenbank gelöscht.');
define('TEXT_EMAIL_DEL_ERROR','<font color="FF0000">Es ist ein Fehler aufgetreten, Ihre Mailadresse wurde nicht gelöscht!</font>');
define('TEXT_EMAIL_ACTIVE','<font color="FF0000">Ihre E-Mailadresse wurde erfolgreich für den Newsletterempfang freigeschalten!</font>');
define('TEXT_EMAIL_ACTIVE_ERROR','<font color="FF0000">Es ist ein Fehler aufgetreten, Ihre Mailadresse wurde nicht freigeschalten!</font>');
define('TEXT_EMAIL_SUBJECT','Ihre Newsletteranmeldung');
define('TEXT_CUSTOMER_GUEST','Gast');

define('TEXT_EMAIL_SUCCESSFUL_SENT','Ihre e-mail wurde erfolgreich versendet!');
define('TEXT_LINK_MAIL_SENDED','Ihre Anfrage nach einem neuen Passwort muß von Ihnen erst bestätigt werden.<br>Deshalb wurde Ihnen vom System eine E-Mail mit einem Bestätigungslink geschickt. Bitte klicken Sie nach dem Erhalt der Mail auf den Link und eine weitere Mail mit Ihrem neuen Login Passwort zu erhalten. Ansonsten wird Ihnen kein neues Passwort zugestellt oder eingerichtet!');
define('TEXT_PASSWORD_MAIL_SENDED','Eine E-Mail mit einem neuen Login Passwort wurde Ihnen soeben zugestellt.<br>Bitte ändern Sie nach Ihrem nächsten Login Ihr Passwort wie gewünscht.');
define('TEXT_CODE_ERROR','Bitte geben Sie Ihre E-mail Adresse und den Sicherheitscode erneut ein. <br>Achten Sie dabei auf Tippfehler!');
define('TEXT_EMAIL_ERROR','Bitte geben Sie Ihre E-mail Adresse und den Sicherheitscode erneut ein. <br>Achten Sie dabei auf Tippfehler!');
define('TEXT_NO_ACCOUNT','Leider müssen wir Ihnen mitteilen, daß Ihre Anfrage für ein neues Login Passwort entweder ungültig war oder abgelaufen ist.<br>Bitte versuchen Sie es erneut.');
define('HEADING_PASSWORD_FORGOTTEN','Passwort erneuern?');
define('TEXT_PASSWORD_FORGOTTEN','Ändern Sie Ihr Passwort in drei leichten Schritten.');
define('TEXT_EMAIL_PASSWORD_FORGOTTEN','Bestätigungsmail für Passwortänderung');
define('TEXT_EMAIL_PASSWORD_NEW_PASSWORD','Ihr neues Passwort');
define('ERROR_MAIL','Bitte Überprüfen Sie Ihre eingegebenen Daten im Formular');
define('CATEGORIE_NOT_FOUND','Kategorie wurde nicht gefunden');

define('BOX_INFORMATION_GV', 'Gutschein FAQ');
define('BOX_HEADING_GIFT_VOUCHER', 'Gutschein Konto');
define('GV_FAQ', 'Gutscheine - FAQ');
define('ERROR_REEDEEMED_AMOUNT', 'Gl&uuml;ckwunsch, Sie haben eingel&ouml;st ');
define('ERROR_NO_REDEEM_CODE', 'Sie haben leider keinen Code eingegeben.');
define('ERROR_NO_INVALID_REDEEM_GV', 'Ung&uuml;ltiger Gutscheincode');
define('TABLE_HEADING_CREDIT', 'Guthaben');
define('ENTRY_AMOUNT_CHECK_ERROR', 'Sie verf&uuml;gen nicht über ein entsprechendes Guthaben.');


define('EMAIL_SUBJECT', 'Nachricht von ' . STORE_NAME);
define('EMAIL_SEPARATOR', '----------------------------------------------------------------------------------------');

define('EMAIL_GV_TEXT_HEADER', 'Herzlichen Gl&uuml;ckwunsch, Sie haben einen Gutschein &uuml;ber %s erhalten !');
define('EMAIL_GV_TEXT_SUBJECT', 'Ein Geschenk von %s');
define('EMAIL_GV_FROM', 'Dieser Gutschein wurde Ihnen &uuml;bermittelt von %s');
define('EMAIL_GV_MESSAGE', 'Mit der Nachricht ');
define('EMAIL_GV_SEND_TO', 'Hallo, %s');
define('EMAIL_GV_REDEEMED', 'Um diesen Gutschein einzul&ouml;sen, klicken Sie bitte auf den unteren Link. Bitte notieren Sie sich zur Sicherheit Ihren Gutscheincode :  %s, so k&ouml;nnen wir Ihnen im Problemfall schneller helfen.');
define('EMAIL_GV_LINK', 'Um den Gutschein einzul&ouml;sen klichen Sie bitte auf ');
define('EMAIL_GV_VISIT', ' oder besuchen Sie ');
define('EMAIL_GV_ENTER', ' und geben den Code am Ende Ihrer Bestellung ein. ');
define('EMAIL_GV_FIXED_FOOTER', 'Falls es mit dem obigen Link Probleme beim Einl&ouml;sen kommen sollte, ' . "\n" .
                                'können Sie den Betrag während des Bestellvorganges verbuchen.' . "\n\n");
define('EMAIL_GV_SHOP_FOOTER', '');
define('MAIN_MESSAGE', 'Sie haben sich dazu entschieden, einen Gutschein im Wert von %s an %s versenden, dessen eMail Adresse %s lautet.<br><br>Folgender Text erscheint in Ihrer eMail :<br><br>Hallo %s<br><br>
                        Ihnen wurde ein Gutschein im Wert von %s durch %s geschickt.');

define('REDEEMED_AMOUNT','Ihr Gutschein wurde erfolgreich auf Ihr Konto verbucht. Gutscheinwert:');
define('REDEEMED_COUPON','Ihr Coupon wurde erfolgreich eingelöst und wird bei Ihrer nächsten Bestellung automatisch eingelöst.');

define('PERSONAL_MESSAGE', '%s schreibt: ');

define('NAVBAR_GV_FAQ', 'Gutschein FAQ');
define('NAVBAR_GV_REDEEM', 'Gutschein einl&ouml;sen');
define('NAVBAR_GV_SEND', 'Gutschein versenden');

//Popup Window
define('TEXT_CLOSE_WINDOW', 'Fenster schließen.');

// VAT ID
define('ENTRY_VAT_TEXT', 'Nur für Deutschland und EU!');
define('ENTRY_VAT_ERROR', 'Die eingegebene UstID ist ungültig. Bitte geben Sie eine gültige ID ein.');

// ****** XSELL
define('BOX_XSELL_PRODUCTS', 'Cross Marketing');


// SONDERANGEBOTE
define('XTPRICE_SPECIAL_DISCOUNT1','Statt');
define('XTPRICE_SPECIAL_DISCOUNT2','Nur');
define('XTPRICE_SPECIAL_DISCOUNT3','Sie sparen');
define('XTPRICE_SPECIAL_GRADUATED1','UVP');
define('XTPRICE_SPECIAL_GRADUATED2','Ihr Preis');

// VAT ID
define('MSRP','UVP');
define('YOUR_PRICE','Ihr Preis ');
define('ONLY',' Nur ');
define('FROM','Ab ');
define('YOU_SAVE','Sie Sparen ');
define('INSTEAD','Statt ');
define('TXT_PER',' pro ');
define('TAX_INFO_INCL','incl. %s UST');
define('TAX_INFO_EXCL','exkl. %s UST');
define('TAX_INFO_ADD','zzgl. %s UST');

define('SHIPPING_EXCL','exkl.');
define('SHIPPING_COSTS','Versandkosten');

// changes 3.0.4 SP2
define('SHIPPING_TIME','Lieferzeit: ');
define('MORE_INFO','[Mehr]');

// changes 3.0.4 SP2.2
define('ENTRY_PRIVACY','Datenschutzrichtlinien akzeptiert');
define('ENTRY_PRIVACY_ERROR','Bitte akzeptieren Sie unsere Datenschutzrichtlinien!');
define('TEXT_PAYMENT_FEE','Zahlungsgeb&uuml;hr');

define('FLOOD_WARNING_MESSAGE','<b>Zu viele Anfragen.</b><br />Bitte versuchen Sie es in ein paar Sekunden erneut.');

// KAUFABWICKLUNG
define('TEXT_SELECTED_SHIPPING_NOT_AVAILABLE','Der Versand mit der ausgew&auml;hlten Versandmethode in der Rechnung %s ist nicht m&ouml;glich.');
define('HEADING_TITLE_KAUFABWICKLUNG_STEP_2','Adressdaten + Produktauswahl');
define('HEADING_TITLE_KAUFABWICKLUNG_STEP_3','Versandart ausw&auml;hlen');
define('HEADING_TITLE_KAUFABWICKLUNG_STEP_4','Bezahlart ausw&auml;hlen');
define('HEADING_TITLE_KAUFABWICKLUNG_STEP_5','Bezahlen');

define('LIGHTBOX_STRING_IMAGE','Bild');
define('LIGHTBOX_STRING_FROM','von');

// CC_CREDIT fin@nzmodul
define('JS_CONFIRM_CC_CREDIT', 'Haben Sie den Antrag vollständig ausgefüllt?');
define('JS_CONFIRM_CC_CREDIT_REOPEN', 'Antragsfenster erneut öffnen?');
define('NAVBAR_TITLE_1_CHECKOUT_CC_CREDIT','Santander');
define('NAVBAR_TITLE_2_CHECKOUT_CC_CREDIT','Daten&uuml;bergabe');


define('TEXT_ORDERS_STATUS_OFFER','Angebot');
define('TEXT_ORDERS_STATUS_ALL','Auftrag');
define('TEXT_INVOICE','Rechnung');
define('TEXT_ORDER','Auftrag');
define('TEXT_OFFER','Angebot');


define('PAYPAL_ERROR','PayPal Abbruch');
define('PAYPAL_NOT_AVIABLE','PayPal Express steht zur Zeit leider nicht zur Verf&uuml;gung.<br />Bitte wählen Sie eine andere Zahlungsart<br />oder versuchen Sie es sp&auml;ter noch einmal.<br />Danke f&uuml;r Ihr Verst&auml;ndnis.<br />');
define('PAYPAL_FEHLER','PayPal hat einen Fehler bei der Abwicklung gemeldet.<br />Ihre Bestellung ist gespeichert, wird aber nicht ausgef&uuml;hrt.<br />Bitte geben Sie eine neue Bestellung ein.<br />Danke f&uuml;r Ihr Verst&auml;ndnis.<br />');
define('PAYPAL_WARTEN','PayPal hat einen Fehler bei der Abwicklung gemeldet.<br />Sie m&uuml;ssen noch einmal zu PayPal, um die Bestellung zu bezahlen.<br />Unten sehen Sie die gespeicherte Bestellung.<br />Danke f&uuml;r Ihr Verst&auml;ndnis.<br />Bitte dr&uuml;cken Sie erneut den Button PayPal Express.<br />');
define('PAYPAL_NEUBUTTON','Bitte erneut dr&uuml;cken, um die Bestellung zu bezahlen.<br />Jede andere Taste f&uuml;hrt zum Abbruch der Bestellung.');
define('ERROR_ADDRESS_NOT_ACCEPTED', '* Solange Sie Ihre Rechnungs- und Versandadresse nicht akzeptieren,\n k&ouml;nnen wir Ihre Bestellung bedauerlicherweise nicht entgegennehmen!\n\n');
define('PAYPAL_GS','Gutschein/Coupon');
define('PAYPAL_TAX','MwSt.');

define('NAVBAR_TITLE_PAYPAL_CHECKOUT','PayPal-Checkout');

define('PRE_SHIPPING_COUNTRIES_SELECT_FORM_LEGEND','Auswahl Versandland f&uuml;r Versandkostenberechnung');
define('PRE_SHIPPING_VALUES','Versandkosten f&uuml;r %s:');
define('PRE_SHIPPING_SUBMIT','Neu berechnen');
define('PRE_SHIPPING_NO_DELIVERY','Es wird kein Versand in das gew&auml;hlte Land angeboten');
define('PRE_PAYMENT_FEE_SELECT_FORM_LEGEND','Auswahl Bezahlart');
define('PRE_PAYMENT_FEE_VALUES','Bezahlartgeb&uuml;hren f&uuml;r %s:');
define('PRE_COUPON_SELECT_FORM_LEGEND','Geben Sie Ihren Gutscheincode ein');
define('PRE_COUPON_VALUES','Gutscheincode %s:');
define('PRE_COUPON_SUBMIT','Einlösen');
define('HISTORY_FIBUNUMBER_AUTOMATIC_ADD','Mit dem Statuswechsel wurde automatisch die FiBu Nummer %s für diesen Auftrag generiert.');

define('ERROR_INVALID_USES_USER_COUPON','Sie k&ouml;nnen den Kupon nur %s Mal einlösen.');
define('ERROR_INVALID_USES_COUPON','Diesen Kupon k&ouml;nnen Kunden nur %s Mal einlösen.');
define('ERROR_INVALID_STARTDATE_COUPON','Ihr Kupon ist noch nicht verf&uuml;gbar.');
define('ERROR_INVALID_FINISDATE_COUPON','Ihr Kupon ist bereits abgelaufen.');

@define('PAYMENT_CONFIRMATION_EMAIL_SUBJECT','Zahlungseingang bestätigt');

define('ERROR_CAPTCHA','Der Sicherheitscode stimmt nicht mit der angezeigten Grafik überein.');

define('TEXT_USERFILTER_NONE','Sortierung nach');
define('TEXT_USERFILTER_NAME','Artikelname');
define('TEXT_USERFILTER_PRICE','Preis');
define('TEXT_USERFILTER_DATE','Neuheiten');
define('TEXT_USERFILTER_BESTSELLER','Bestseller');
define('TEXT_USERFILTER_DESC','Absteigend');
define('TEXT_USERFILTER_ASC','Aufsteigend');

define('TEXT_ADMIN_USE_OWN_ADDRESS_IN_MAILMASTER','Beim versenden von E-Mails an Kunden im Mailmaster meine eigene E-Mailadresse verwenden');



define('TEXT_PROPERTIES','Properties');

define('TEXT_LOG_EXCEPTION','Es ist ein Fehler aufgetreten.');
define('TEXT_LOG_EXCEPTION_DESC','Beim Aufrufen der von Ihnen gew&uuml;nschten Seite, kam es zu einem Fehler. Das Team von <b>%s</b> wurde automatisch benachrichtigt. Wir werden versuchen den Fehler so schnell wie m&ouml;glich zu beheben.');
define('TEXT_LOG_EXCEPTION_REFRESH','Zum weitershoppen bitte %s klicken.');
define('TEXT_LOG_EXCEPTION_REFRESH_HERE','hier');

define('META_TITLE_SPECIALS','Sonderangebote');
define('META_TITLE_PRODUCTS_NEW','Neuheiten');


define('ERROR_PAYMENT_AND_SHIPPING_INCOMPATIBLE','Die Versandmöglichkeit ist leider nicht mit der Zahlungsvariante kombinierbar.');
if(is_file('lang/german/amazon.php')){
	include_once('lang/german/amazon.php');
}

define('IMAGE_BUTTON_WISHLIST', 'Merkzettel');      // wishlist
//wishlist
	define('TEXT_WISHLIST_INFO','Dies ist Ihr persönlicher Merkzettel von wo aus Sie z.B. regelmäßig benötigte Artikel direkt bestellen oder Artikel, die Ihnen besonders gefallen, speichern können, um diese evtl. zu einem späteren Zeitpunkt zu bestellen.<br /><br />Ihr Merkzettel unterstützt Sie auch beim Einkaufen und merkt sich Ihre meist bestellten Artikel, so dass Sie diese regelmäßig benötigten Produkte ohne langes suchen schnell wieder in den Warenkorb legen können. Bei Bedarf können Sie diese Liste auch ändern oder neue Artikel über die jeweilige Produktseite hinzufügen.');
	define('TEXT_WISHLIST', '\' auf den Merkzettel ');
	define('NAVBAR_TITLE_WISHLIST','Merkzettel ');
	define('WISHLIST_TEXT_SEND_SUBJECT','Mein Merkzettel ');
	define('IMAGE_BUTTON_IN_WISHLIST',   'Auf den Merkzettel');
	define('IMAGE_BUTTON_FROM_WISHLIST', 'Vom Merkzettel löschen');
  $month_names = array( 'Januar', 'Februar', 'M&auml;rz', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember' );
  $weekday_names = array( 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag', 'Sonntag' );

if(is_file(DIR_FS_CATALOG.'lang/german/amazon.php')){
	# BOM AMAZON PAYMENTS POWERED BY ALKIM MEDIA
	include_once(DIR_FS_CATALOG.'lang/german/amazon.php');
	# EOM AMAZON PAYMENTS POWERED BY ALKIM MEDIA
}

define('TEXT_NEW_SHOPORDER_COMMENT','Kommentar zu Auftrag %s');
define('PEM_ADD_ERROR_INVALID_PRODUCTS_ID','Zu diesem Artikel kann keine Emailbenachrichtigung hinterlegt werden.');
define('PEM_ADD_ERROR_INVALID_EMAIL_ADDRESS','Die angegebene Email Adresse entspricht nicht den Vorgaben.');
define('PEM_ADD_ERROR_WRONG_VVCODE','Der Sicherheitscode für den Spamschutz stimmt nicht mit Ihren Angaben überein.');
define('PEM_ADD_ERROR_ALLOCATION_EXISTS','Es wurde bereits eine Emailbenachrichtigung zu diesem Artikel gespeichert.');
define('PEM_EMAIL_CONFIRMATION_SUBJECT','Artikelbenachrichtigung bestätigen');
define('PEM_EMAIL_REMOVE_CONFIRMATION_SUBJECT','Artikelbenachrichtigung abmelden');
define('PEM_ADD_SUCCESS_MSG','Es wurde eine Email an %s gesendet. Bitte bestätigen Sie, dass Sie für den gewählten Artikel eine Benachrichtigung erhalten wollen, sobald dieser wieder verfügbar ist.');
define('PEM_REMOVE_SUCCESS_MSG','Es wurde eine Email an %s gesendet. Bitte bestätigen Sie, dass Sie für den gewählten Artikel keine Benachrichtigungen mehr erhalten wollen, sobald dieser wieder verfügbar ist.');
define('PEM_CODE_INVALID','Code ungültig, Vorgang abgebrochen.');
define('PEM_REMOVE_SUCCESSFUL','Die Artikelbenachrichtigung wurde entfernt.');
define('PEM_ADD_CONFIRMATION_SUCCESSFUL','Sie werden benachrichtigt, sobald der Artikel eintrifft.');
define('TEXT_NETTO_SUM','Nettosumme');
define('TEXT_PAYMENT_METHOD','Bezahlart');
define('TEXT_COUPON','Gutschein');
define('TEXT_COUPON_NOT_LOGGED_IN','Die Eingabe des Gutscheincodes ist erst m&ouml;glich, wenn Sie sich angemeldet haben.');
define('TEXT_ADMIN_EMAIL_SIGNATURE','Emailsignatur zur Verwendung im Mailmaster');
define('NAVBAR_TITLE_PRODUCTS_UPCOMING','Bald erscheinende Artikel');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_UPCOMING', 'Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> bald erscheinenden Artikeln)');
define('TEXT_NUMBER_OF_SPECIALS_IN_CATEGORY','Es befinden sich %s Artikel mit Sonderangeboten innerhalb dieser Kategorie');
/* BOF AGI PAYPAL-PPP CHECKOUT www.andreas-guder.de 1/1 */
define('NAVBAR_TITLE_CHECKOUT_PAYPAL_PPP', 'PayPal Checkout');
define('TEXT_PLEASE_WAIT', 'Bitte warten');
/* EOF AGI PAYPAL-PPP CHECKOUT www.andreas-guder.de 1/1 */
define('ENTRY_MOBILE','Mobilfunknummer');
define('TEXT_PRIMARY_ADDRESS','Standard Adresse');
define('TEXT_SEC_CODE','Hier eingeben - Sicherheitscode');
define('TEXT_NEWSLETTER_OPTIONS','Optionen');
define('TEXT_NEWSLETTER_OPTION_INP','Eintragen');
define('TEXT_NEWSLETTER_OPTION_DEL','Austragen');
define('MSG_ERROR_INVALID_DELIVERY_EMAIL_ADDRESS','Die Emailadresse "%s" zur Versandbenachrichtigung ist ungültig');
define('TEXT_EBAY_SOAP_AUCTIONCHECKOUTCOMPLETE_NOTICE_TITLE','eBay Zahlung Auftrag %s');
define('TEXT_EBAY_SOAP_AUCTIONCHECKOUTCOMPLETE_NOTICE_TEXT','Es gab zum Auftrag %s eine eBay Zahlung. Da der Auftragsstatus bereits geändert wurde, kontrollieren Sie diesen Vorgang manuell und aktualisieren Sie ggf, den Status des Auftrags');
define('MSG_ERROR_EVENT_MISSING_TIME','Sie haben keinen Zeitpunkt angegeben.');
define('MSG_ERROR_EVENT_MISSING_SLOTS','Bitte geben Sie die Anzahl der Personen an.');
define('MSG_ERROR_EVENT_NOT_ENOUGH_SLOTS','Es sind nur noch %s Plätze für den gewählten Zeitpunkt verfügbar.');
define('MSG_ERROR_EVENT_NOT_ENOUGH_SLOTS_WITHOUT_QUANTITY','Soviel Plätze sind für den gewählten Zeitpunkt nicht verfügbar. Bitte reduzieren Sie die Anzahl der Personen oder wählen einen anderen Zeitpunkt.');
define('MSG_ERROR_EVENT_DATE_TIMER_UNAVAILABLE_QUANTITY','Es sind nicht mehr genügend Plätze für das gewählte Event verfügbar.');
define('STOCK_MARK_PRODUCT_OUT_OF_STOCK_EVENT','Keine freien Plätze mehr');
define('MSG_ERROR_EVENT_NOT_ENOUGH_SLOTS_WITHOUT_QUANTITY_CART_TEXT','Es befinden sich bereits %s Stk dieses Artikels in Ihrem Warenkorb');
define('ACCOUNT_HISTORY_SUM_ORDERS_TOTAL','Gesamtwert offene Bestellungen');
define('ENTRY_VAT_ID','Ust-Nr');
define('NAVBAR_TITLE_PRODUCTS_BESTSELLER','Bestseller / Meist verkaufte Artikel');
define('BUTTON_CHANGE_PAYMENT','Bezahlart ändern');
define('TEXT_ORDERS_STATUS_COMMENT_UPDATE_REFUND_STATUS','Amazon Payment Refund #%s: Status geändert auf: %s');
define('MSG_ERROR_YES_AMAZON_PAY_INVALID_COUNTRY','Das gewählte Versandland konnte nicht verarbeitet werden.');
define('MSG_ERROR_YES_AMAZON_PAY_COUNTRY_NOT_ALLOWED','Das gewählte Versandland wird nicht durch uns beliefert.');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_BESTSELLER','Zeige <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Besteller Artikeln)');
define('YES_AMAZON_PAYMENT_SPERRBILDSCHIRM_INTRO','F&uuml;r den Login bei Amazon wurde ein neues Fenster ge&ouml;ffnet. Sollten Sie dieses Fenster nicht sehen, kontrollieren Sie ob sie bitte die Einstellungen Ihres Popup Blockers bzw schauen Sie ob es neue ge&ouml;ffnete Browsertabs gibt.');
define('TEXT_CHANGE_PAYMENT','Bezahlart Ãndern');
define('YES_AMAZON_PAY_CANCEL_LOGIN','Amazon Anmeldung abbrechen');
define('TEXT_WEEK', 'Woche');
define('TEXT_WEEKS', 'Wochen');
define('PUSH_NOTIFICATION_TAG_EMAIL_STAFF','Email Zuweisung');
define('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_ERROR_MESSAGE','Fehler bei der Captcha Überprüfung, versuchen Sie es noch einmal.');
define('TEXT_INVALID_DELIVERY_COUNTRY','In dieses Land findet kein Versand statt.');
define('INPUT_SPAN_USERVALUE_PREFIX', 'Ihre Angabe');
define('INPUT_SPAN_USERVALUE','Kunden Eingabe');
define('MODULE_OTHER_YESDSGVO_EDIT_CONSENTS_LINK','Datenschutzeinstellungen anpassen');
define('TEXT_ERROR_ALLOW_EMAIL_SHIPPER','Sie haben nicht zugestimmt, dass Ihre Email Adresse ggf. an Versanddienstleister weitergegeben werden darf.');

define('UNZER_BASKET_TOTAL','Ihre bestellten Artikel (%d versch. / %d Stk insgesamt)');
define('UNZER_BASKET_SUBTOTAL','Inkl. ');
define('CHECK_VATID_ERROR_INVALID_FORMAT','Die angegebene Umsatzsteuer ID ist nicht gültig. Die Umsatzsteuer-Identifikationsnummer beginnt mit zwei Großbuchstaben, meist bestehend aus dem zweistelligen Ländercode des Landes – in Deutschland startet die Nummer mit „DE“. Den beiden Großbuchstaben folgen neun Ziffern, also zum Beispiel „DE124356789“.');
define('CHECK_VATID_ERROR_SERVICE_UNAVAILABLE','Die Online Prüfung auf Gültigkeit der Umsatzsteuer ID ist fehlgeschlagen. Versuchen Sie es in ein paar Minuten erneut oder kontaktieren Sie uns direkt.');
define('MSG_ERROR_NO_ACCOUNT_TYPE_SELECTION','Fehler: Es wurde nicht ausgewählt ob Sie sich als privater oder gewerblicher Kunde registrieren wollen.');
define('IMAGE_SAVE','Speichern');

define('ERROR_ENTRY_AMOUNT_CHECK','Ungültiger Gutscheinwert.');
define('ERROR_ENTRY_EMAIL_ADDRESS_CHECK','Ungültige Email Adresse');
define('ERROR_ENTRY_AMOUNT_CHECK_GUTHABEN','Der Gutscheinwert übersteigt Ihr Guthaben');
define('ENTRY_COMPANY_PLACEHOLDER','Firma');

define('COMMISSION_NUMBER_TITLE','Kommissionsnummer');
define('DISTRIBUTION_WAREHOUSE_STORAGE_ID_TITLE','Auslieferungslager');

define('COUNTRY_OF_ORIGIN_TITLE','Herstellungsland');
define('COUNTRIES_OF_ORIGIN_TITLE','Herstellungsländer');


define('UN_CLASSIFICATION_ALLOCATED_PRODUCTS','Zugewiesene Artikel');
define('UN_CLASSIFACTIONS','Gefahrgut Kennzeichnungen');
define('UN_CLASSIFICATIONS_NO_ENTRYS','Es wurden noch keine Gefahrgut Kennzeichnungen angelegt.');
define('UN_CLASSIFACTIONS_TITLE','Gefahrgut Nummer');

define('TEXT_HEADER_MENU_TAX_RATES','Steuersätze');
define('ORDER_PALLETS','Paletten zum Auftrag');
define('ORDER_PALLETS_SIZES','Palette Grösse in cm');
define('ORDER_PALLETS_WEIGHT','Palette Gewicht in kg');
define('ORDER_PALLETS_POSITIONS','Positionen');
define('ORDER_PALLETS_ADD_POSITION','Position hinzufügen');
define('ORDER_PALLETS_NOTES','Bemerkungen');

define('ADR_Class_TITLE','Gefahrenklasse');
define('ADR_Class_1','Explosive Stoffe und Gegenstände');
define('ADR_Class_2', 'Gase');
define('ADR_Class_3', 'Entzündbare flüssige Stoffe');
define('ADR_Class_4_1', 'Entzündbare feste Stoffe, selbstzersetzliche Stoffe');
define('ADR_Class_4_2', 'Stoffe, die sich selbst entzünden können');
define('ADR_Class_4_3', 'Stoffe, die in Berührung mit Wasser entzündbare Gase entwickeln');
define('ADR_Class_5_1', 'Entzündend (oxidierend) wirkende Stoffe');
define('ADR_Class_5_2', 'Organische Peroxide');
define('ADR_Class_6_1', 'Giftige Stoffe');
define('ADR_Class_6_2', 'Ansteckungsgefährliche Stoffe');
define('ADR_Class_7', 'Radioaktive Stoffe');
define('ADR_Class_8', 'Ätzende Stoffe');
define('ADR_Class_9', 'Verschiedene gefährliche Stoffe und Gegenstände');

define('Packaging_Group_TITLE','Verpackungsgruppe');
define('Packaging_Group_I','Hohe Gefahr');
define('Packaging_Group_II','Mittlere Gefahr');
define('Packaging_Group_III','Geringe Gefahr');

define('Bk_TITLE','Transportkategorie');

define('Bk_1','Hochgefährlich');
define('Bk_2','Mittlere Gefahr');
define('Bk_3','Geringe Gefahr');
define('Bk_4','Befreit');

define('UN_SCORE_INFO_1','Alle Auftragspositionen werden addiert');
define('UN_SCORE_INFO_2','$GEWICHT = GESAMTGEWICHT POSITION');
define('UN_SCORE_INFO_3','$FAKTOR = Faktor der Transportkategorie');
define('UN_SCORE_INFO_4','POSITION SCORE = $GEWICHT  x $FAKTOR');
define('UN_SCORE_INFO_5','GESAMT SCORE = SUMME ALLER POSITION SCORES');
define('UN_SCORE_INFO_6','Es wird das zum Artikel hinterlegte Gewicht verwendet, es sei denn eine manuelle Gewichtsangabe zur Auftragsposition wurde hinterlegt.');

define('TUNNEL_CATEGORY','Tunnel Kategorie');
define('TUNNEL_CATEGORY_A','Keine Beschränkung');
define('TUNNEL_CATEGORY_A_TITLE','Keine');

define('TUNNEL_CATEGORY_B','Explosionsgefahr');
define('TUNNEL_CATEGORY_B_TITLE','Explosive Stoffe und Gegenstände (z. B. Klasse 1)');

define('TUNNEL_CATEGORY_C','Explosions- oder Vergiftungsgefahr');
define('TUNNEL_CATEGORY_C_TITLE','Explosive + giftige Gase/Flüssigkeiten');

define('TUNNEL_CATEGORY_D','Brandgefahr');
define('TUNNEL_CATEGORY_D_TITLE','Stoffe mit hoher Brandgefahr (z. B. Benzin, Aerosole)');

define('TUNNEL_CATEGORY_E','Sehr hohe Brand- oder Rauchgefahr');
define('TUNNEL_CATEGORY_E_TITLE','Fast alle Gefahrgüter außer wenigen Ausnahmen (z. B. in kleinen Mengen)');



error_reporting($eerp);
