<?php
/*------------------------------------------------------------------------------
   $Id: newsletter.php,v 1.0 

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce www.oscommerce.com 
   (c) 2003	 nextcommerce www.nextcommerce.org
   
   XTC-NEWSLETTER_RECIPIENTS RC1 - Contribution for XT-Commerce http://www.xt-commerce.com
   by Matthias Hinsche http://www.gamesempire.de
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'yes_input_field.php');
require_once(DIR_FS_INC.'xtc_validate_email.inc.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';

if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}
if(!$turnstile){
    require_once(DIR_WS_CLASSES.'yesCaptcha.php');
    $captcha = new yesTextCaptcha($captcha_lang);
}

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_render_vvcode.inc.php');
require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_password.inc.php');
require_once(DIR_FS_INC . 'yes_write_notice.inc.php');
if (isset($_GET['action']) && ($_GET['action'] == 'process')) {
    $email_valid = true;
    if(!xtc_validate_email($_POST['email'])){
        $info_message = 'Invalid Email';
    }else{
        $vlcode = xtc_random_charcode(32);
        $link = xtc_href_link(FILENAME_NEWSLETTER, 'action=activate&email='.$_POST['email'].'&key='.$vlcode, 'NONSSL');

        // assign language to template for caching
        $smarty->assign(array(
            'language'=>$_SESSION['language'],
            'tpl_path'=>'templates/'.CURRENT_TEMPLATE.'/',
            'logo_path'=>HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/',
            'EMAIL'=>$_POST['email'],
            'LINK'=>$link,
            'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS
        ));
        $smarty->caching = false;

        // create mails
        $html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/newsletter_mail.html');
        $txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/newsletter_mail.txt');

        if(!$turnstile){
            $msg = $captcha->check(false); // false = _POST
            if(isset($_POST['captcha_result'])){
                $captcha_success = ($msg == $captcha->lng['captcha_incorrect']) ? false : true;
            }else{
                if(!isset($_SESSION['vvcode']) or empty($_SESSION['vvcode'])){
                        $captcha_success = false;    		
                }else{
                        $captcha_success = $_POST['vvcode'] == $_SESSION['vvcode'];
                }
            }
        }else{
            $captcha_success = false;
            if($turnstile_class->verify()){
                $captcha_success = true;
            }
        }

        if($_POST['check'] == 'inp'){
            if($captcha_success){
                $reply_addresses = (xtc_not_null(constant('EMAIL_BILLING_FORWARDING_STRING'))) ? EMAIL_BILLING_FORWARDING_STRING : EMAIL_BILLING_REPLY_ADDRESS;
                $reply_addresses_array = explode(',',$reply_addresses);
                $reply_address = current($reply_addresses_array);
                $reply_forwards = '';
                if(sizeOf($reply_addresses_array)>1){
                    $reply_addresses_array = array_slice($reply_addresses_array,1);
                    $reply_forwards = implode(',',$reply_addresses_array);
                }
                $parameters = ['email'=>$_POST['email']];
                $check_mail_query_raw = sprintf("select customers_email_address, mail_status from %s where customers_email_address =:email",
                    TABLE_NEWSLETTER_RECIPIENTS
                );
                $check_mail_query = yes_query($check_mail_query_raw,$parameters);
                if (!sizeOf($check_mail_query)) {
                    if (isset($_SESSION['customer_id'])){
                        $customers_id = $_SESSION['customer_id'];
                        $customers_status = $_SESSION['customers_status']['customers_status_id'];
                        $customers_firstname = $_SESSION['customer_first_name'];
                        $customers_lastname = $_SESSION['customer_last_name'];
                    }else{
                        $cust_obj = \YES4Trade\Model\customers::get_by_email_address($_POST['email']);
                        if ($cust_obj === null) {
                            $customers_id = '0';
                            $customers_status = '1';
                            $customers_firstname = TEXT_CUSTOMER_GUEST;
                            $customers_lastname = '';
                        }else{
                            $check_customer = $cust_obj->toArray();
                            $customers_id = $check_customer['customers_id'];
                            $customers_status = $check_customer['customers_status'];
                            $customers_firstname = $check_customer['customers_firstname'];
                            $customers_lastname = $check_customer['customers_lastname'];
                        }
                    }
                    $sql_data_array = array(
                        'customers_email_address' => $_POST['email'],
                        'customers_id' => $customers_id,
                        'customers_status' => $customers_status,
                        'customers_firstname' => $customers_firstname,
                        'customers_lastname' => $customers_lastname,
                        'mail_status' => '0',
                        'mail_key' => $vlcode,
                        'date_added' => 'now()'
                    );
                    yes_db_perform(TABLE_NEWSLETTER_RECIPIENTS, $sql_data_array);
                    $info_message = TEXT_EMAIL_INPUT;
                    if(SEND_EMAILS == 'true' and !main::isDev(true)){
                        xtc_php_mail(EMAIL_SUPPORT_ADDRESS, 
                            EMAIL_SUPPORT_NAME, 
                            $_POST['email'], 
                            '', 
                            '', 
                            EMAIL_SUPPORT_REPLY_ADDRESS, 
                            EMAIL_SUPPORT_REPLY_ADDRESS_NAME, 
                            '', 
                            '', 
                            TEXT_EMAIL_SUBJECT, 
                            $html_mail, 
                            $txt_mail
                        );    
                    }
                }else{
                    $check_mail = current($check_mail_query);
                    if ($check_mail['mail_status']=='0'){
                        $info_message = TEXT_EMAIL_EXIST_NO_NEWSLETTER;
                        if(SEND_EMAILS == 'true' and !main::isDev(true)){
                            xtc_php_mail(EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, $_POST['email'], '', '', EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', TEXT_EMAIL_SUBJECT, $html_mail, $txt_mail);    
                        }
                    }else{
                        $info_message = TEXT_EMAIL_EXIST_NEWSLETTER;
                    }
                }
            }else{ // CAPTCHA NICHT BESTANDEN
                if(!$turnstile){
                    $info_message = TEXT_WRONG_CODE;
                }else{
                    $info_message = TEXT_CAPTCHA_FAILED;
                }
            }
        } // end check == inp

        // ALTES CAPTCHA HANDLING
        //if(($_POST['check'] == 'del')&&($_POST['vvcode'] == $_SESSION['vvcode'])){
        // NEUES CAPTCHA HANDLING
        if($_POST['check'] == 'del'){
            if($captcha_success){
                $parameters = [
                    'email'=>$_POST['email']
                ];
                $check_mail_query_raw = sprintf(
                    "select customers_email_address from %s where customers_email_address =:email",
                    TABLE_NEWSLETTER_RECIPIENTS
                );
                $check_mail_query = yes_query($check_mail_query_raw,$parameters);
                if (!sizeOf($check_mail_query)) {
                    $info_message = TEXT_EMAIL_NOT_EXIST;
                }else{
                    $del_query_raw = sprintf(
                        "delete from %s where customers_email_address =:email",
                        TABLE_NEWSLETTER_RECIPIENTS
                    );
                    yes_query($del_query_raw, $parameters);
                    $info_message = TEXT_EMAIL_DEL;
                }
            }else{
                $info_message = TEXT_WRONG_CODE;
            }
        } // end if check == del
    } // end if valid email
} // end if action == process


// Accountaktivierung per Emaillink
if (isset($_GET['action']) && ($_GET['action'] == 'activate')) {
    if(!isset($_GET['email']) or empty($_GET['email']) or !isset($_GET['key']) or empty($_GET['key'])){
        xtc_redirect(FILENAME_ACCOUNT);
    }
    $parameters = [
        'email'=>$_GET['email']
    ];
    $check_mail_query_raw = sprintf(
        "select mail_key from %s where customers_email_address =:email",
        TABLE_NEWSLETTER_RECIPIENTS
    );
    $check_mail_query = yes_query($check_mail_query_raw, $parameters);
    if (!sizeOf($check_mail_query)) {
        $info_message = TEXT_EMAIL_NOT_EXIST;
    }else{
        $check_mail = current($check_mail_query);
        if ($check_mail['mail_key'] != $_GET['key']) {
            $info_message = TEXT_EMAIL_ACTIVE_ERROR;
	}else{
            $update_sql_array = [
                'mail_status' => '1'
            ];
	        yes_db_perform(TABLE_NEWSLETTER_RECIPIENTS,$update_sql_array,'update',[
                'customers_email_address' => $_GET['email']
            ]);
	    $info_message = TEXT_EMAIL_ACTIVE;
	    if (NEWSLETTER_SUBSCRIPTION_COUPON != '') {
                $coupon_code = NEWSLETTER_SUBSCRIPTION_COUPON;
              
                $coupon_obj = \YES4Trade\Model\coupons::get_by_coupon_code($coupon_code);
                if($coupon_obj !== null){
                    $coupon = $coupon_obj->toArray();
                    $coupon_id = $coupon['coupon_id'];
                    $coupon_desc_obj = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                        (int)$coupon_id,
                        (int)$_SESSION['languages_id']
                    );
                    $coupon_desc = $coupon_desc_obj->toArray();
                    if (isset($_SESSION['customer_id'])){
                        $customers_id = $_SESSION['customer_id'];
                        $customers_firstname = $_SESSION['customer_first_name'];
                        $customers_lastname = $_SESSION['customer_last_name'];
                    }else{
                        $cust_obj = \YES4Trade\Model\customers::get_by_email_address($_GET['email']);
                        if ($cust_obj === null) {
                            $customers_id = 0;
                            $customers_firstname = TEXT_CUSTOMER_GUEST;
                            $customers_lastname = '';
                        }else{
                            $check_customer = $cust_obj->toArray();
                            $customers_id = $check_customer['customers_id'];
                            $customers_firstname = $check_customer['customers_firstname'];
                            $customers_lastname = $check_customer['customers_lastname'];
                        }
                    }


                    $new = new \YES4Trade\Model\coupon_email_track([
                        'coupon_id'=>(int)$coupon_id, 
                        'customer_id_sent'=>intval($customers_id), 
                        'sent_firstname'=>$customers_firstname, 
                        'sent_lastname'=>$customers_lastname,
                        'emailed_to'=>$_GET['email'], 
                        'date_sent'=>date('Y-m-d H:i:s')
                    ]);
                    $new->create();

                    $smarty->assign('COUPON_DESC',$coupon_desc['coupon_description']);
                    $smarty->assign('COUPON_CODE',$coupon['coupon_code']);
                    // assign language to template for caching
                    $smarty->assign('language', $_SESSION['language']);	
                    $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
                    $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
                    // assign vars
                    $smarty->assign('EMAIL',xtc_db_input($_GET['email']));
                    $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);

                    // dont allow cache
                    $smarty->caching = false;

                    // create mails
                    $html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/newsletter_coupon_mail.html');
                    $txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/newsletter_coupon_mail.txt');
                    if(SEND_EMAILS == true){
                        xtc_php_mail(EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, $_GET['email'], '', '', EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', TEXT_COUPON.': '.TEXT_EMAIL_SUBJECT, $html_mail, $txt_mail);
                    }
                }else{
		  $recipients_array = main::get_notice_recipients('coupon_admin');
		  yes_write_notice('Ungueltiger Newsletter Kupon', 'Der hinterlegte Newsletterkupon '.$coupon_code.' ist nicht verfuegbar.', 0, $recipients_array);
                }
	    }
	}
    }
}

// Accountdeaktivierung per Emaillink
if (isset($_GET['action']) && ($_GET['action'] == 'remove')) {
    $parameters = [
        'email'=>$_GET['email'],
        'mail_key'=>$_GET['key']
    ];
    $check_mail_query_raw = sprintf(
        "select customers_email_address, mail_key from %s where customers_email_address =:email and mail_key =:mail_key",
        TABLE_NEWSLETTER_RECIPIENTS
    );
    $check_mail_query = yes_query($check_mail_query_raw, $parameters);
    if (!sizeOf($check_mail_query)) {
        $info_message = TEXT_EMAIL_NOT_EXIST;
    }else{
        $check_mail = current($check_mail_query);
        if (!xtc_validate_password($check_mail['customers_email_address'], $_GET['key'])) {
            $info_message = TEXT_EMAIL_DEL_ERROR;
	}else{
            $del_query_raw = sprintf("delete from %s where  customers_email_address =:email and mail_key =:mail_key",
                TABLE_NEWSLETTER_RECIPIENTS
            );
            yes_query($del_query_raw, $parameters);
            $info_message = TEXT_EMAIL_DEL;
	}
    }
}

$breadcrumb->add(NAVBAR_TITLE_NEWSLETTER, xtc_href_link(FILENAME_NEWSLETTER, '', 'NONSSL'));

require(DIR_WS_INCLUDES . 'header.php');

$smarty->assign('VVIMG', '<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '"');
$smarty->assign(array(
    'text_newsletter'=> TEXT_NEWSLETTER,
    'info_message'=>$info_message,
    'FORM_ACTION'=>xtc_draw_form('sign', xtc_href_link(FILENAME_NEWSLETTER, 'action=process', 'NONSSL')),
    'FORM_END'=>'</form>',
    'INPUT_EMAIL'=>xtc_draw_input_field('email', $_POST['email']??''),
    'INPUT_EMAIL_ARRAY'=>yes_input_field::get_html(array(
        'name'=>'email',
        'label'=>ENTRY_EMAIL_ADDRESS,
        'type'=>'email',
        'required'=>true,
        'value'=>$_POST['email']??'',
        'maxlength'=>255,
        'minlength'=>ENTRY_EMAIL_ADDRESS_MIN_LENGTH,
        'placeholder'=>(defined('ENTRY_EMAIL_ADDRESS_PLACEHOLDER') and ENTRY_EMAIL_ADDRESS_PLACEHOLDER != '') ? ENTRY_EMAIL_ADDRESS_PLACEHOLDER : $_POST['email'],
        'required_text'=>ENTRY_EMAIL_ADDRESS_TEXT,
    )),
    'INPUT_CODE'=>(!$turnstile)?xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false):'',
    'INPUT_CODE_ARRAY'=>(!$turnstile)?yes_input_field::get_html(array(
        'name'=>'vvcode',
        'label'=>TEXT_SEC_CODE,
        'type'=>'text',
        'required'=>true,
        'maxlength'=>16,
        'minlength'=>1,
        'required_text'=>'*'
    )):[],
    'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create(),
    'CHECK_INP'=>xtc_draw_radio_field('check', 'inp',((isset($_POST['check']) and $_POST['check'] == 'inp') or !isset($_POST['check']))?true:false),
    'CHECK_DEL'=>xtc_draw_radio_field('check', 'del',(isset($_POST['check']) and $_POST['check'] == 'del')?true:false),
    'INPUT_CHECK_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'check',
	'label'=>TEXT_NEWSLETTER_OPTIONS,
	'type'=>'radio',
	'values'=>array(
	    array(
		'label'=>TEXT_NEWSLETTER_OPTION_INP,
		'value'=>'inp',
		'checked'=>((isset($_POST['check']) and $_POST['check'] == 'inp') or !isset($_POST['check']))?true:false
	    ),
	    array(
		'label'=>TEXT_NEWSLETTER_OPTION_DEL,
		'value'=>'del',
		'checked'=>(isset($_POST['check']) and $_POST['check'] == 'del')?true:false
	    )
	)
    )),
    'BUTTON_SEND'=>xtc_image_submit('button_send.gif', IMAGE_BUTTON_LOGIN),
    'language'=>$_SESSION['language']
));
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/newsletter.html');
$smarty->assign('main_content',$main_content);

$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');