<?php
/* -----------------------------------------------------------------------------------------
   $Id: product_info.php,v 1.25 2020/04/27 14:09:15 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(product_info.php,v 1.94 2003/05/04); www.oscommerce.com 
   (c) 2003      nextcommerce (product_info.php,v 1.46 2003/08/25); www.nextcommerce.org

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist
   New Attribute Manager v4b                            Autor: Mike G | mp3man@internetwork.net | http://downloads.ephing.com   
   Cross-Sell (X-Sell) Admin 1                          Autor: Joshua Dechant (dreamscape)
   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


include( 'includes/application_top.php');
require_once(DIR_FS_INC.'xtc_validate_email.inc.php');
require_once(DIR_WS_CLASSES.'yesCaptcha.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';
$captcha = new yesTextCaptcha($captcha_lang);

if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}


// create smarty elements
$smarty = new yesSmarty;

if (isset($_GET['products_id'])) {
    $pID = intval($_GET['products_id']);
    if(isset($_GET['action']) and $_GET['action'] == 'get_products_properties_values_id_from_value'){
        $ppID = (int)$_GET['ppID'];
        $value = $_GET['value'];
        $property = new product_properties( $ppID );
        $language_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $val = $property->getValues($language_id);
        foreach($val as $v){
            if(empty($v['input_span'])){
                if($v['description']->title == $value){
                    die(json_encode([
                        'ppvID'=>$v['description']->products_properties_values_id
                    ]));
                }
                continue;
            }
            $span = explode(':', $v['input_span']);
            if($value >= $span[0] and $value <= $span[1]){
                die(json_encode([
                    'ppvID'=>$v['description']->products_properties_values_id
                ]));
            }
        }
        die(json_encode(array(
            'ppvID'=>0,
        )));
    } // eof action = get_products_properties_values_id_from_value
    if(!isset($cPath)){
        $parts = explode('_',$pID);
        if(sizeOf($parts)>1){
            $pID = (int)$parts[0];
            $cID = $parts[1];
        }else{
            $pID = (int)$pID;
        }
    }else{
        $pID = (int) $pID;
    }
    $catData = yes_query(sprintf(
        "SELECT p2c.categories_id FROM %s p2c LEFT JOIN %s c USING(categories_id) WHERE products_id=:products_id AND c.categories_status=1 ",
        TABLE_PRODUCTS_TO_CATEGORIES,TABLE_CATEGORIES
    ),['products_id'=>$pID],true);
    if(!function_exists('xtc_get_path')){
        require_once(DIR_FS_INC . 'xtc_get_path.inc.php');
    }
    if(isset($catData['categories_id']) and $catData['categories_id'] > 0){
        $cPath=xtc_input_validation(xtc_get_path($catData['categories_id']),'cPath','');
        $smarty->assign('cPath',$cPath);
        $smarty->assign('cPath_parts',explode('_',$cPath));
    }
}

$YesBoxes->load( $smarty, basename(__FILE__) );
  
// include needed functions
require_once(DIR_FS_INC . 'xtc_get_download.inc.php');
require_once(DIR_FS_INC . 'xtc_delete_file.inc.php');
require_once(DIR_FS_INC . 'xtc_get_all_get_params.inc.php');
require_once(DIR_FS_INC . 'xtc_date_long.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_form.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_input_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_submit.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_input_field.inc.php');

require_once(DIR_FS_INC . 'xtc_render_vvcode.inc.php');
require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');

  
if (isset($_GET['action']) and $_GET['action']=='get_download') {
	xtc_get_download((int)xtc_db_input($_GET['cID'])); 
}
include(DIR_WS_MODULES . 'product_info.php');
  
//require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . FILENAME_PRODUCT_INFO);
require(DIR_WS_INCLUDES . 'header.php');
$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');

include ('includes/application_bottom.php');
