<?php
/* -----------------------------------------------------------------------------------------
   $Id: products_new.php,v 1.34 2016/08/10 05:59:26 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce 
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(products_new.php,v 1.25 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (products_new.php,v 1.16 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contributions:
   Enable_Disable_Categories 1.3        	Autor: Mikel Williams | mikel@ladykatcostumes.com

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
require_once(DIR_FS_INC.'xtc_get_manufacturers.inc.php');
require_once(DIR_FS_INC.'xtc_get_categories.inc.php');
require_once(DIR_FS_INC.'xtc_get_category_path.inc.php');
// create smarty elements
$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );
// include needed function
require_once(DIR_FS_INC . 'xtc_date_long.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once('admin/includes/classes/class.storagequantity.php');
require_once(DIR_WS_CLASSES.'product.php');

$userfilter_array = array(
	array('id'=>'','text'=>TEXT_USERFILTER_NONE),
	array('id'=>'products_date_added ASC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_ASC),
	array('id'=>'products_date_added DESC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_DESC),
	array('id'=>'products_ordered ASC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_ASC),
	array('id'=>'products_ordered DESC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_DESC),
	array('id'=>'products_price ASC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_ASC),
	array('id'=>'products_price DESC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_DESC),
	array('id'=>'pd.products_name ASC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_ASC),
	array('id'=>'pd.products_name DESC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_DESC),
);


$upcoming_mode = false;
if(isset($_REQUEST['upcoming']) and $_REQUEST['upcoming'] == 1){
    $breadcrumb->add(NAVBAR_TITLE_PRODUCTS_UPCOMING, xtc_href_link(FILENAME_PRODUCTS_NEW,'upcoming=1'));
    $upcoming_mode = true;
}else{
    $breadcrumb->add(NAVBAR_TITLE_PRODUCTS_NEW, xtc_href_link(FILENAME_PRODUCTS_NEW));
}

require(DIR_WS_INCLUDES . 'header.php');

$check_categories_id = filter_input(INPUT_GET, 'categories_id', FILTER_VALIDATE_INT);
if ($check_categories_id !== false && $check_categories_id !== null) {
    $categories_id = $check_categories_id;
}else{
    $categories_id = 0;
}

$check_manufacturers_id = filter_input(INPUT_GET, 'manufacturers_id', FILTER_VALIDATE_INT);
if ($check_manufacturers_id !== false && $check_manufacturers_id !== null) {
    $manufacturers_id = $check_manufacturers_id;
}else{
    $manufacturers_id = 0;
}

$check_default_category = filter_input(INPUT_GET, 'default_category', FILTER_VALIDATE_INT);
if ($check_default_category !== false && $check_default_category !== null) {
    $default_category = $check_default_category;
}else{
    $default_category = 0;
}

$filter = $_GET['usersort'] ?? '';
$exists = in_array($filter, array_column($userfilter_array, 'id'));
if(!$exists){
    $filter = '';
}
$products_new_array = array();
$parameters = [];
$fsk_lock='';
if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
      $fsk_lock=' and p.products_fsk18!=1';
}
if (GROUP_CHECK=='true') {
      $group_check="and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
}
if(!$upcoming_mode and MAX_DISPLAY_NEW_PRODUCTS_DAYS !='0') {
      $days = (defined('MAX_DISPLAY_NEW_PRODUCTS_DAYS'))?(int)MAX_DISPLAY_NEW_PRODUCTS_DAYS: 30;
      $dnp = new DateTime('-'.$days.' Days');
      $days = " and p.products_date_added > '".$dnp->format('Y-m-d H:i:s')."' ";
}else{
    if($upcoming_mode){
		$days = sprintf(" and p.products_date_available > '%s'",date('Y-m-d'));
		if($manufacturers_id > 0){
			$parameters['manufacturers_id'] = $manufacturers_id;
			$days .= " and p.manufacturers_id=:manufacturers_id";
		}
		if($categories_id > 0){
			$category_path = explode('_',xtc_get_category_path(intval($categories_id)));
			$parameters['categories'] = implode(',',$category_path);
			$days .= " and p2c.categories_id IN(:categories) ";
		}
    }
}

$order_by = (!empty($filter)) ? $filter : "p.products_date_added DESC,p.products_id ASC";

$products_new_query_raw = "select distinct p.products_id,pd.products_name,
    pd.products_extra_text,pd.products_short_description,p.products_fsk18,
    p.products_image,p.products_price,
    p.products_date_added,p.products_vpe,p.products_vpe_status,
    p.products_vpe_value ";
$products_new_query_raw_dc = "select distinct p.default_category as dc ";
$rest_sql = "from " . TABLE_PRODUCTS . " p LEFT JOIN products_description pd USING(products_id),
	" . TABLE_CATEGORIES . " c LEFT JOIN
	" . TABLE_PRODUCTS_TO_CATEGORIES . " p2c USING(categories_id)
	where c.categories_status=1
	".$fsk_lock."
	and p.products_id = p2c.products_id
	and products_status = '1'
	and pd.language_id='".intval($_SESSION['languages_id'])."'
	".$group_check."
	".$days;

if($default_category > 0){
    $parameters['default_category'] = $default_category;
    $rest_sql .= " and p.default_category=:default_category";
}
if($manufacturers_id > 0){
    $parameters['manufacturers_id'] = $manufacturers_id;
    $rest_sql .= " and p.manufacturers_id=:manufacturers_id";
}

$products_new_query_raw .= $rest_sql." order by ".$order_by;
$products_new_query_raw_dc .= $rest_sql;
if($default_category<1){
    $products_new_query_raw_dc .= ' and p.default_category>0 ';
}
$products_new_split = new splitPageResults($products_new_query_raw, intval($_GET['page']), MAX_DISPLAY_PRODUCTS_NEW,'p.products_id',false, $parameters);
if ($products_new_split->number_of_rows > 0) {
    $split_text = (!$upcoming_mode) ? TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW : TEXT_DISPLAY_NUMBER_OF_PRODUCTS_UPCOMING;
    $smarty->assign(array(
	'NAVIGATION_BAR'=>'
   <table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr>
            <td class="smallText">'.$products_new_split->display_count($split_text).'</td>
            <td align="right" class="smallText">'.TEXT_RESULT_PAGE . ' ' . $products_new_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y'))).'</td>
          </tr>
        </table>
	',
	'NAVIGATION_DATA'=>array(
	    'COUNT'=>$products_new_split->display_count($split_text),
	    'LINKS'=>TEXT_RESULT_PAGE . ' ' . $products_new_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y')))
	)
    ));
}
$module_content=array();
if ($products_new_split->number_of_rows > 0) {
    $products_new_query = yes_query($products_new_split->sql_query,$parameters);
    foreach($products_new_query as $products_new) {
	$product = new product($products_new['products_id']);
	$product_info = $product->data;
	
	$SQ = new products_quantity($product_info['products_id']);
	$product_info['qty_total'] = $SQ->get_products_total_qty();
	$info_array = $product->buildDataArray($product_info);
	
		$products_price=$xtPrice->xtcGetPrice($products_new['products_id'],
			$format=true,
			1,
			$info_array['PRODUCTS_TAX_CLASS_ID'],
			$products_new['products_price']
		);
		$products_price_clean=$xtPrice->xtcGetPrice($products_new['products_id'],
			$format=false,
			1,
			$info_array['PRODUCTS_TAX_CLASS_ID'],
			$products_new['products_price']
		);

		$products_new['products_name'] = $products_new['products_name'];
		$products_new['products_short_description'] = $products_new['products_short_description'];
		$products_new['products_extra_text'] = $products_new['products_extra_text'];
		$buy_now='';
		if ($_SESSION['customers_status']['customers_fsk18']=='1') {
			if ($products_new['products_fsk18']=='0')
				$buy_now='<a href="' . xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action','BUYproducts_id')) . 'action=buy_now&BUYproducts_id=' . $products_new['products_id'], 'NONSSL') . '">' . xtc_image_button('button_buy_now.gif', TEXT_BUY . $products_new['products_name'] . TEXT_NOW);
		} else {
			$buy_now='<a href="' . xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action','BUYproducts_id')) . 'action=buy_now&BUYproducts_id=' . $products_new['products_id'], 'NONSSL') . '">' . xtc_image_button('button_buy_now.gif', TEXT_BUY . $products_new['products_name'] . TEXT_NOW);
		}
		if ($products_new['products_image']!='') {
			$products_image=DIR_WS_THUMBNAIL_IMAGES . $products_new['products_image'];
		} else {
			$products_image='';
		}
		$PRODUCTS_VPE = '';
		if ($products_new['products_vpe_status'] == 1 && $products_new['products_vpe_value'] != 0.0){
			$PRODUCTS_VPE = $xtPrice->xtcFormat( ((float)str_replace(',','.',$products_price_clean)) * (1 / $products_new['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($products_new['products_vpe']);
		}
		$wishlist = $product->getWishlistButton($products_new['products_id'], $products_new['products_name']); // wishlist  
		$module_content[] = array(
			'PRODUCTS_ID'=>$products_new['products_id'],
			'PRODUCTS_NAME' => $products_new['products_name'],
			'PRODUCTS_DESCRIPTION' => $products_new['products_short_description'],
			'PRODUCTS_EXTRA_TEXT' => $products_new['products_extra_text'],
			'PRODUCTS_PRICE' => $products_price,
			'PRODUCTS_LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $products_new['products_id']),
			'PRODUCTS_IMAGE' => $products_image,
			'BUTTON_BUY_NOW'=>$buy_now,
			'WISHLIST_BUTTON' => $wishlist,       // wishlist 
			'VERFUEGBARER_BESTAND1'=>$SQ->get_available1_qty(),
			'PRODUCTS_VPE'=>$PRODUCTS_VPE,
			'INFO'=>$info_array,
		    'MANUFACTURER_INFO'=>$product->getManufacturersData()
		);
    }
  } else {
	$smarty->assign('ERROR',TEXT_NO_NEW_PRODUCTS);
  }

$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
if(sizeOf($module_content)>0){
    $smarty->assign('module_content',$module_content);
}
$manufacturers_array = xtc_get_manufacturers();
$manufacturers = array_merge(array(array('id'=>'','text'=>TEXT_ALL_MANUFACTURERS)), $manufacturers_array);
if($upcoming_mode){
    $categories_array = xtc_get_categories();
    $categories = array_merge(array(array('id'=>'','text'=>TEXT_ALL_CATEGORIES)), $categories_array);
    $smarty->assign(array(
	'FILTER_FORM'=>xtc_draw_form('filter_form',basename(__FILE__),'GET').
	    xtc_draw_hidden_field('upcoming',1),
	'INPUT_MANUFACTURERS'=>xtc_draw_pull_down_menu('manufacturers_id',$manufacturers,$manufacturers_id,'onchange="this.form.submit()"'),
	'INPUT_CATEGORIES'=>xtc_draw_pull_down_menu('categories_id',$categories,$categories_id,'onchange="this.form.submit()"')
    ));
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/products_upcoming.html');
}else{
    /**
     * BOF - DEFAULT CATEGORY PATH ARRAY
     */
    $default_category_array = array(array('id'=>'','text'=>PULL_DOWN_DEFAULT));
    $dc_query = yes_query($products_new_query_raw_dc, $parameters);
    foreach($dc_query as $dc_record){
	$categories_path_title = array();
	$category_path = xtc_get_category_path($dc_record['dc'], $_SESSION['languages_id']);
	$category_path_array = explode('_',$category_path);
	foreach($category_path_array as $cID){
            $languages_id = intval($_SESSION['languages_id'] ?? 2);
            $cache_key = 'shop.categories-c'.$cID.'-l'.$languages_id;
			$cache_group = 'categories';
			$key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);


            $CachedString = $InstanceCache->getItem($key); // cache group
            if (!$CachedString->isHit()) {
                $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                    intval($cID), $languages_id,
                    ['categories_name']
                );
                $categories_data = [
                    'categories_id'=>$cID,
                    'categories_name'=>$catd->categories_name??''
                ];
                $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG); // cat
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $categories_data = $CachedString->get();
            }
            $categories_path_title[] = xtc_db_prepare_input($categories_data['categories_name']);
	}
	$category_title_path = implode(' &raquo; ',$categories_path_title);
	$default_category_array[] = array(
	    'id'=>$dc_record['dc'],
	    'text'=>$category_title_path
	);
    }
    if(sizeOf($default_category_array)>1){
	$smarty->assign('INPUT_CATEGORIES',  xtc_draw_pull_down_menu('default_category', $default_category_array, ((isset($_REQUEST['default_category']))?(int)xtc_db_input($_REQUEST['default_category']):'' )));
    }
    /**
     * EOF - DEFAULT CATEGORY PATH ARRAY
     */
    $smarty->assign(array(
	'FILTER_FORM'=>xtc_draw_form('filter_form',basename(__FILE__),'GET'),
	'FORM_END'=>'</form>',
	'INPUT_MANUFACTURERS'=>xtc_draw_pull_down_menu('manufacturers_id',$manufacturers,$manufacturers_id),
	'FILTER_DROPDOWN'=>xtc_draw_pull_down_menu('usersort',$userfilter_array,$filter),
	
    ));
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/new_products_overview.html');
}
$smarty->assign('main_content',$main_content);

$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
