<?php
/* -----------------------------------------------------------------------------------------
   $Id: send_order.php,v 1.37 2020/07/30 05:36:22 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (send_order.php,v 1.1 2003/08/24); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
require_once(DIR_FS_INC . 'yes_get_products_shippingtime.inc.php');
require_once(DIR_FS_INC . 'yes_get_products_date_available.inc.php');
require_once(DIR_FS_INC . 'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'yes_get_shop_content.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_get_payment_method_title.inc.php');
// check if customer is allowed to send this order!
if(!isset($_SESSION['customer_id'])){
    die('Invalid call');
}
$order_check = yes_query(sprintf(
    "SELECT customers_id FROM %s WHERE orders_id=:orders_id",
        TABLE_ORDERS
    ),['orders_id'=>$insert_id],
    true
);
if (($_SESSION['customer_id'] == $order_check['customers_id']) or $send_by_amazon){
	$order = new order($insert_id,$xtPrice);
	$payi = $order->get_paymentinstructions();
	if(sizeOf($order->get_paymentinstructions())){
	    $smarty->assign('PAYMENTINSTRUCTIONS',current($payi));
	}

	$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
  	$smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br>'));
        if (!isset($_SESSION['credit_covers']) or $_SESSION['credit_covers']!='1') {
            $smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br>'));
        }
  	$smarty->assign('csID',$order->customer['csID']);
  	// get products data
	foreach($order->products as $order_data_values) {
            $slave_title_query = xtc_db_query(
                    "SELECT slave_title FROM products_description WHERE products_id='".$order_data_values['id']."' and language_id='".$_SESSION['languages_id']."'"
            );
            $slave_title = xtc_db_fetch_array($slave_title_query);
            $order_data[]=array(
                'PRODUCTS_MODEL' => $order_data_values['model'],
                'PRODUCTS_NAME' => $order_data_values['name'],
                'PRODUCTS_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price'],true),
                'PRODUCTS_SINGLE_PRICE' => $xtPrice->xtcFormat($order_data_values['price'],true),
                'PRODUCTS_QTY' => $order_data_values['qty'],
                'PRODUCTS_SHORT_DESCRIPTION'=>  xtc_get_short_description($order_data_values['id'], $_SESSION['languages_id']),
                'PROPERTIES'=>$order_data_values['properties'],
                'PRODUCTS_WEIGHT'=>  xtc_get_ext_products_weight($order_data_values['id'])*$order_data_values['qty'],
                'PRODUCTS_SHIPPINGTIME'=>yes_get_products_shippingtime($order_data_values['id'],$_SESSION['languages_id']),
                'PRODUCTS_DATE_AVAILABLE'=>yes_get_products_date_available($order_data_values['id']),
                'PRODUCTS_SLAVE_TITLE'=>  xtc_db_prepare_input($slave_title['slave_title'])
            );
	}
	foreach($order->totals as $ot) {
            $order_total[] = array(
                    'TITLE' => $ot['title'],
                    'TEXT' => $ot['text']
            );
	}
	// assign language to template for caching
	if(!isset($_SESSION['language'])){
            $_SESSION['language'] = 'german';
        }

	$smarty->assign('language', $_SESSION['language']);
	$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
	$smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
	$smarty->assign('oID',$insert_id);
	if ($order->info['payment_method']!='' && $order->info['payment_method']!='no_payment') {
        if(!defined('MODULE_PAYMENT_'.strtoupper($order->info['payment_method']).'_TEXT_TITLE')){
            include(DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/payment/'.$order->info['payment_method'].'.php');
        }
        if(!empty($order->info['payment_method']) and $order->info['payment_class'] == $order->info['payment_method']){
            $payment_method=constant(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'));
        }else{
            if(defined('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE')){
                $payment_class_title = constant(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'));
            }else{
                $payment_class_title = $order->info['payment_method'];
            }
            $payment_method = $payment_class_title.' '.xtc_get_payment_method_title($order->info['payment_method']);
        }
	}
	$smarty->assign('PAYMENT_METHOD',$payment_method);
	$smarty->assign('PAYMENT_CLASS',$order->info['payment_class']);
	$smarty->assign('PAYMENT_METHOD_RAW',$order->info['payment_method_db']);
	$smarty->assign('PAYMENT_CLASS_RAW',$order->info['payment_class_db']);
	$smarty->assign('order_data', $order_data);
	$smarty->assign('order_total', $order_total);
	$smarty->assign('NAME',$order->customer['name']);
	$smarty->assign('COMMENTS',$order->info['comments']);
	$smarty->assign(array(
	    'DATE'=>xtc_date_long($order->info['date_purchased']),
	    'YESORDER'=>$order->get_order_positions(),
	    'cID'=>$order->customer['id']
	));

	// NEUE VARIABLEN
	$smarty->assign('BANK_WRAP',BANK_WRAP);
	$smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);

	// PAYMENT MODUL TEXTS
	// EU Bank Transfer
	if ($order->info['payment_method']=='eustandardtransfer')  {
		$smarty->assign('PAYMENT_INFO_HTML',MODULE_PAYMENT_EUTRANSFER_TEXT_DESCRIPTION);
		$smarty->assign('PAYMENT_INFO_TXT',str_replace("<BR>","\n",MODULE_PAYMENT_EUTRANSFER_TEXT_DESCRIPTION));
	}
	// SOFORTUEBERWEISUNGVORKASSE
	if ($order->info['payment_method']=='sofortueberweisungvorkasse')  {
		$smarty->assign('PAYMENT_INFO_HTML',MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_EMAIL_FOOTER);
		$smarty->assign('PAYMENT_INFO_TXT',str_replace("<br />","\n",MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_EMAIL_FOOTER));
	}

	// SOFORTUEBERWEISUNG
	if ($order->info['payment_method']=='sofortueberweisung') {
		$smarty->assign('PAYMENT_INFO_HTML',MODULE_PAYMENT_SOFORTUEBERWEISUNG_TEXT_EMAIL_FOOTER);
		$smarty->assign('PAYMENT_INFO_TXT',str_replace("<br/>","\n",MODULE_PAYMENT_SOFORTUEBERWEISUNG_TEXT_EMAIL_FOOTER));
	}

	// SOFORTUEBERWEISUNGREDIRECT
	if ($order->info['payment_method']=='sofortueberweisungredirect') {
		$smarty->assign('PAYMENT_INFO_HTML',MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_EMAIL_FOOTER);
		$smarty->assign('PAYMENT_INFO_TXT',str_replace("<br/>","\n",MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_EMAIL_FOOTER));
	}

        
        if(!isset($order->Price->cStatus['customers_status_name'])){
            $cs = main::get_customers_status($order->info['status']);
            $customers_status_name = $cs['customers_status_name'];
        }else{
            $customers_status_name = $order->Price->cStatus['customers_status_name'];
        }

	$conditions = '';
	$conditions_txt = '';
	$shop_content_data = yes_get_shop_content(3, $_SESSION['languages_id'],false);
	if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
            $conditions = $shop_content_data['content_text'];
            $conditions_txt = yes_get_shop_content_html_stripped($conditions);
        }
	
	// WIDERRUF
	$widerruf = '';
	$widerruf_txt = '';
	$shop_content_data = yes_get_shop_content(9, $_SESSION['languages_id'],false);
	if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
            $widerruf = $shop_content_data['content_text'];
            $widerruf_txt = yes_get_shop_content_html_stripped($widerruf);
	}
        $payi = $order->get_paymentinstructions();
	if(sizeOf($payi)){
	    $smarty->assign('PAYMENTINSTRUCTIONS',current($payi)) ;
	}
	
	$smarty->assign(array(
            'cgroup'=>$customers_status_name,
            'conditions'=>$conditions,
            'widerruf'=>$widerruf,
            'conditions_txt'=>$conditions_txt,
            'widerruf_txt'=>$widerruf_txt,
	    'status_name'=>  $order->info['orders_status']
	));
  	// dont allow cache
  	$smarty->caching = false;
	$html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/order_mail.html');
	$txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/order_mail.txt');

	// create subject
	$order_subject=str_replace('{$nr}',$insert_id,EMAIL_BILLING_SUBJECT_ORDER);
	$order_subject=str_replace('{$date}',xtc_date_short(date('Y-m-d')),$order_subject);
	$order_subject=str_replace('{$lastname}',$order->customer['firstname'],$order_subject);
	$order_subject=str_replace('{$firstname}',$order->customer['firstname'],$order_subject);
        $forwarding_to = '';
	// send mail to admin
	if(defined('ADMINMAIL_AT_SHOPORDER') and ADMINMAIL_AT_SHOPORDER == '1'){
		$forwarding_to = (xtc_not_null(constant('EMAIL_BILLING_FORWARDING_STRING'))) ? EMAIL_BILLING_FORWARDING_STRING : EMAIL_BILLING_REPLY_ADDRESS;
	}
    $attachments_array = array();
    if(!defined('SEND_ORDER_MAIL_WITHOUT_CONTENT_FILES') or constant('SEND_ORDER_MAIL_WITHOUT_CONTENT_FILES') !== 'True'){
        foreach($order->get_products_content_files() as $pID => $files){
            foreach($files as $file_path=>$desc){
                $attachments_array[] = DIR_FS_CATALOG.$file_path;
            }
        }
    }
    \YES4Trade\Model\ebay_emails::create_ebay_emails([
        'subject'=>$order_subject,
        'mailto'=>$order->customer['email_address'],
        'from_name'=>EMAIL_BILLING_NAME,
        'from_email'=>EMAIL_BILLING_ADDRESS,
        'date'=>date('Y-m-d H:i:s'),
        'customers_id'=>intval($order->customer['id']),
        'orders_id'=>intval($insert_id),
        'read_status'=>\YES4Trade\Model\ebay_emails::READ_STATUS0,
        'reply_status'=>\YES4Trade\Model\ebay_emails::REPLY_STATUS0,
        'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
        'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1,
        'saved'=>\YES4Trade\Model\ebay_emails::SAVED0,
        'format'=>'text/html'
    ],$html_mail);
        
	// send mail to customer
	if(!main::isDev(true)){ // keine mail lokal
        xtc_php_mail(
            EMAIL_BILLING_ADDRESS,
            EMAIL_BILLING_NAME,
            $order->customer['email_address'] ,
            $order->customer['firstname'] . ' ' . $order->customer['lastname'] ,
            $forwarding_to,
            EMAIL_BILLING_REPLY_ADDRESS,
            EMAIL_BILLING_REPLY_ADDRESS_NAME,
            $attachments_array,
            '',
            $order_subject,
            $html_mail ,
            $txt_mail 
        );
	}
} else {
    $smarty->assign('ERROR','You are not allowed to view this order!');
    $smarty->display(CURRENT_TEMPLATE . '/module/error_message.html');	
}
