$(function(){
sticky.init()
mobNav.init();
slideMenu.init();
openDisclaimer.init();
dynModal.init();
imageSwap.init();
    $('.func-cart').hover(
        function() {
          $(this).find('.cart-popup').stop(true, true).fadeIn(200);
        },
        function() {
          $(this).find('.cart-popup').stop(true, true).fadeOut(200);
        }
      );

// Loop through each list item and check if it has a child ul (submenu)
$('.list-group-item').each(function() {
    if ($(this).find('ul').length > 0) {
      // If it has child <ul>, append a button for toggling the submenu
      $(this).prepend('<button class="menu-button">+</button>');
    }
  });

  // Toggle submenu visibility on button click
  $(document).on('click', '.menu-button', function() {
    var submenu = $(this).siblings('ul.submenu');
    submenu.slideToggle(0); // Slide down/up the submenu
    $(this).text($(this).text() == '+' ? '-' : '+'); // Change button text
  });

 //SLICK

$('.responsive').slick({
    dots: true,
    infinite: false,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    arrows:false,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          arrows:false,
          dots: true
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
    ]
  });

$('.single-item').slick({
    dots:true,
    arrows:false,
    autoplay: true,
    autoplaySpeed: 4000,
    fade:true
});

$('.center').slick({
    centerMode: true,
    centerPadding: '0px',
    slidesToShow: 4,
    autoplay: true,
    arrows:false,
    autoplaySpeed: 3000,
    responsive: [
        {
            breakpoint: 1024,
            settings: {
              arrows: false,
              centerMode: true,
              centerPadding: '40px',
              slidesToShow: 3
            }
          },
      {
        breakpoint: 768,
        settings: {
          arrows: false,
          centerMode: true,
          centerPadding: '40px',
          slidesToShow: 1
        }
      }
    
    ]
  });

})

let sticky ={
    init:function(){                
        if ($(window).scrollTop() > 50) {
            sticky.is_true();  
            } else {
            sticky.is_false();  
            }
        $(window).scroll(function() {
            if ($(window).scrollTop() > 50) {
                sticky.is_true();  
            } else {
                sticky.is_false();  
            }
          });
    },
    is_true:function(){
        $('.head-search').css({                
            'top': '0'
          });
    },
    is_false:function(){
        $('.head-search').css({                
            'top': '50px'
          });
    }
};

let mobNav = {
    init:function(){
    let $trigger = $('#mob-nav-switch');    
    let $target = $('.func-mobile-nav');
    // Hamburger Menu    
    $trigger.on('click',function(){
        if(!$trigger.hasClass('open')){
            $trigger.addClass('open')
            $trigger.find('i').removeClass('fa-bars');
            $trigger.find('i').addClass('fa-xmark');
            $target.stop(true,true).slideDown();
        }else{
            $trigger.removeClass('open')
            $trigger.find('i').addClass('fa-bars');
            $trigger.find('i').removeClass('fa-xmark');
            $target.stop(true,true).slideUp();
        }
    })
}
};

let slideMenu = {
    init:function(){        
        
    }
}

let openDisclaimer = {
    init:function(){
        let $tgt = $('.etc')
        $('.btn-show-etc').on('click',function(e){
            e.preventDefault();
            if(!$tgt.hasClass('open')){
                $tgt.addClass('open');
                $(this).find('i').removeClass('fa-chevron-down');
                $(this).find('i').addClass('fa-chevron-up');
            }else{
                $tgt.removeClass('open');
                $(this).find('i').removeClass('fa-chevron-up');
                $(this).find('i').addClass('fa-chevron-down');
            }
        })
    }
};
let imageSwap = {
    init:function(){
        $('.small-image').hover(function() {
            var newSrc = $(this).attr('data-src');
            $('#main-image').attr('src', newSrc);
            $('#main-image').parent('a').attr('href',newSrc);
        });
    }
};

var dynModal = {
    init:function(){
        $('.modal-call').each(function(){
            let $t = $(this);
            $t.on('click',function(e){
                e.preventDefault();

                let $tgt = $('#modal-cnt');
                let $t = $(this);
                let cnt = $t.attr('data-modalcnt');
                let size = $t.attr('data-modalsize');
                let title = $t.attr('data-modaltitle');
                $tgt.find('.modal-dialog').removeClass('modal-lg').addClass('modal-'+size);
                $tgt.find('.modal-title').html(title);
                $tgt.find('.modal-body').html(cnt);
                $tgt.modal('show');
            })       
        })
    }
}

$(function() {
  function PriceCard($card) {
    this.$card = $card;
    this.oldPrice = 0;
    this.newPrice = 0;
    this.discount = 0;
    this.$badge = null;
  }

  PriceCard.prototype = {
    init: function() {
      this._readPrices();
      if (this.oldPrice > 0 && this.newPrice > 0 && this.oldPrice > this.newPrice) {
        this._calcDiscount();
        this._createBadge();
        this._bindHover();
      }
    },

    _readPrices: function() {
      const clean = text => parseFloat(
        text.replace(/[€\s\.]/g, '').replace(',', '.')
      );

      this.oldPrice = clean(this.$card.find('.xtc_price_special_value1').text());
      this.newPrice = clean(this.$card.find('.xtc_price_special_value2').text());
    },

    _calcDiscount: function() {
      const raw = ((this.oldPrice - this.newPrice) / this.oldPrice) * 100;
      // Immer abrunden und auf ganze Prozentpunkte reduzieren
      this.discount = Math.floor(raw);
    },

    _createBadge: function() {
      this.$badge = $('<div>')
        .text('-' + this.discount + '%')
        .css({
          position: 'absolute',
          top: '8px',
          right: '8px',
          background: 'orange',
          color: 'white',
          'font-weight': 'bold',
          'border': '3px solid #fff',
          'font-size': '1em',
          width: '60px',
          height: '60px',
          'line-height': '50px',
          'border-radius': '50%',
          'text-align': 'center',
          'box-shadow': '0 2px 6px rgba(0,0,0,0.3)',
          'z-index': 10,
          transition: 'transform 0.3s ease'
        });

      // Card auf relative setzen, damit Badge korrekt positioniert wird
      this.$card.css('position', 'relative');
      this.$card.append(this.$badge);
    },

    _bindHover: function() {
      const self = this;
      this.$card.on('mouseenter', function() {
        self.$badge.css('transform', 'scale(1.15)');
      });
      this.$card.on('mouseleave', function() {
        self.$badge.css('transform', 'scale(1)');
      });
    }
  };

  $('.card:has(.xtc_price_special_value1):has(.xtc_price_special_value2)').each(function() {
    new PriceCard($(this)).init();
  });
});
