let sticky = {
  init: function () {
    if ($(window).scrollTop() > 50) {
      sticky.is_true();
    } else {
      sticky.is_false();
    }
    $(window).on('scroll', function () {
      if ($(window).scrollTop() > 50) {
        sticky.is_true();
      } else {
        sticky.is_false();
      }
    });
  },
  is_true: function () {
    $('.head-search').css({ top: '0' });
  },
  is_false: function () {
    $('.head-search').css({ top: '50px' });
  }
};

let mobNav = {
  init: function () {
    const $trigger = $('#mob-nav-switch');
    const $target = $('.func-mobile-nav');

    $trigger.on('click', function () {
      if (!$trigger.hasClass('open')) {
        $trigger.addClass('open');
        $trigger.find('i').removeClass('fa-bars').addClass('fa-xmark');
        $target.stop(true, true).slideDown();
      } else {
        $trigger.removeClass('open');
        $trigger.find('i').addClass('fa-bars').removeClass('fa-xmark');
        $target.stop(true, true).slideUp();
      }
    });
  }
};

let slideMenu = {
  init: function () {
    // derzeit leer
  }
};

let openDisclaimer = {
  init: function () {
    const $tgt = $('.etc');
    $('.btn-show-etc').on('click', function (e) {
      e.preventDefault();
      if (!$tgt.hasClass('open')) {
        $tgt.addClass('open');
        $(this).find('i').removeClass('fa-chevron-down').addClass('fa-chevron-up');
      } else {
        $tgt.removeClass('open');
        $(this).find('i').removeClass('fa-chevron-up').addClass('fa-chevron-down');
      }
    });
  }
};

let imageSwap = {
  init: function () {
    $('.small-image').hover(function () {
      const newSrc = $(this).attr('data-src');
      $('#main-image').attr('src', newSrc);
      $('#main-image').parent('a').attr('href', newSrc);
    });
  }
};

let dynModal = {
  init: function () {
    $('.modal-call').each(function () {
      const $trigger = $(this);
      $trigger.on('click', function (e) {
        e.preventDefault();
        const $tgt = $('#modal-cnt');
        const cnt = $trigger.attr('data-modalcnt');
        const size = $trigger.attr('data-modalsize');
        const title = $trigger.attr('data-modaltitle');
        $tgt.find('.modal-dialog').removeClass('modal-lg').addClass('modal-' + size);
        $tgt.find('.modal-title').html(title);
        $tgt.find('.modal-body').html(cnt);
        $tgt.modal('show');
      });
    });
  }
};

$(function () {
  // Initialisierungen
  sticky.init();
  mobNav.init();
  slideMenu.init();
  openDisclaimer.init();
  dynModal.init();
  imageSwap.init();

  // Cart Hover Popup
  $('.func-cart').hover(
    function () {
      $(this).find('.cart-popup').stop(true, true).fadeIn(200);
    },
    function () {
      $(this).find('.cart-popup').stop(true, true).fadeOut(200);
    }
  );

  // Menü Subtoggle
  $('.list-group-item').each(function () {
    if ($(this).find('ul').length > 0) {
      $(this).prepend('<button class="menu-button">+</button>');
    }
  });

  $(document).on('click', '.menu-button', function () {
    const submenu = $(this).siblings('ul.submenu');
    submenu.slideToggle(0);
    $(this).text($(this).text() === '+' ? '-' : '+');
  });

  // Slick-Slider: responsive
  $('.responsive').slick({
    dots: true,
    infinite: false,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    arrows: false,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          arrows: false,
          dots: true
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
    ]
  });

  $('.single-item').slick({
    dots: true,
    arrows: false,
    autoplay: true,
    autoplaySpeed: 4000,
    fade: true
  });

  $('.center').slick({
    centerMode: true,
    centerPadding: '0px',
    slidesToShow: 4,
    autoplay: true,
    arrows: false,
    autoplaySpeed: 3000,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          arrows: false,
          centerMode: true,
          centerPadding: '40px',
          slidesToShow: 3
        }
      },
      {
        breakpoint: 768,
        settings: {
          arrows: false,
          centerMode: true,
          centerPadding: '40px',
          slidesToShow: 1
        }
      }
    ]
  });

  // Price Badge Feature
  function PriceCard($card) {
    this.$card = $card;
    this.oldPrice = 0;
    this.newPrice = 0;
    this.discount = 0;
    this.$badge = null;
  }

  PriceCard.prototype = {
    init: function () {
      this._readPrices();
      if (this.oldPrice > 0 && this.newPrice > 0 && this.oldPrice > this.newPrice) {
        this._calcDiscount();
        this._createBadge();
        this._bindHover();
      }
    },

    _readPrices: function () {
      const clean = text =>
        parseFloat(text.replace(/[€\s\.]/g, '').replace(',', '.'));
      this.oldPrice = clean(this.$card.find('.xtc_price_special_value1').text());
      this.newPrice = clean(this.$card.find('.xtc_price_special_value2').text());
    },

    _calcDiscount: function () {
      const raw = ((this.oldPrice - this.newPrice) / this.oldPrice) * 100;
      this.discount = Math.floor(raw);
    },

    _createBadge: function () {
      this.$badge = $('<div>')
        .text('-' + this.discount + '%')
        .css({
          position: 'absolute',
          top: '8px',
          right: '8px',
          background: 'orange',
          color: 'white',
          'font-weight': 'bold',
          border: '3px solid #fff',
          'font-size': '1em',
          width: '60px',
          height: '60px',
          'line-height': '50px',
          'border-radius': '50%',
          'text-align': 'center',
          'box-shadow': '0 2px 6px rgba(0,0,0,0.3)',
          'z-index': 10,
          transition: 'transform 0.3s ease'
        });

      this.$card.css('position', 'relative');
      this.$card.append(this.$badge);
    },

    _bindHover: function () {
      const self = this;
      this.$card.on('mouseenter', function () {
        self.$badge.css('transform', 'scale(1.15)');
      });
      this.$card.on('mouseleave', function () {
        self.$badge.css('transform', 'scale(1)');
      });
    }
  };

  $('.card:has(.xtc_price_special_value1):has(.xtc_price_special_value2)').each(function () {
    new PriceCard($(this)).init();
  });
});
