<?php
ini_set('memory_limit','1200M');
include('includes/application_top.php');
if(!isset($_GET['admin']) and $_GET['admin'] != 'mArI011081759'){
	die('Unauthorized Call');
}
if(!isset($_SESSION['customer_id']) or $_SESSION['customer_id'] != 1){
	die('Unauthorized Call - only main admin');
}
date_default_timezone_set('Europe/Berlin');
error_reporting(E_ERROR);
function strip_cdata($string) {
    preg_match_all('/<!\[cdata\[(.*?)\]\]>/is', $string, $matches);
    return str_replace($matches[0], $matches[1], $string);
}
$from_cron = 1;
require('admin/includes/classes/class.storagequantity.php');
include('admin/includes/classes/class.SOAP.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.ebay.php');

require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.basics.php');
require_once ABS_PATH_TO_PHPAPI.'ebat/ReviseItemRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/ReviseFixedPriceItemRequestType.php';


require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
require (DIR_FS_INC.'yes_write_notice.inc.php');
require (DIR_FS_INC.'xtc_get_products_stock.inc.php');
require (DIR_FS_INC.'xtc_get_short_description.inc.php');
require (DIR_FS_INC.'yes_get_shop_content.inc.php');
if(!function_exists('xtc_get_products_name')){
	require (DIR_FS_INC.'xtc_get_products_name.inc.php');
}
require_once (DIR_FS_INC.'xtc_in_array.inc.php');
require_once (DIR_FS_INC.'xtc_collis.inc.php');
require_once (DIR_FS_INC.'xtc_get_serial_number.inc.php');

require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_ServiceProxy.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_Logger.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetSellerTransactionsRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GeteBayOfficialTimeRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetItemTransactionsRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_Environment.php';

require_once(DIR_WS_CLASSES.'class.phpmailer.php');

define("TABLE_EBAY_TRANSACTIONS",'ebay_transactions');
define("TABLE_EBAY_PRODUCTS",'ebay_products');
define("TABLE_EBAY_AUCTIONS",'ebay_auctions');
define('TABLE_EBAY_CALLS','ebay_calls');
define('TABLE_EBAY_EMAILS','ebay_emails');
define("EBAYAPI",true);

$language_id = '2';

// load all enabled shipping modules
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_calculate_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
require_once(DIR_FS_INC . 'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC . 'xtc_get_attributes_model.inc.php');
require_once(DIR_FS_INC . 'xtc_display_tax_value.inc.php');
require_once(DIR_FS_INC . 'xtc_quicklogin.inc.php');
require_once(DIR_FS_INC . 'xtc_count_shipping_modules.inc.php');
require_once(DIR_FS_INC . 'xtc_get_lang_path_from_ebay_site.inc.php');
require(DIR_WS_CLASSES . 'ebay_order.php');
require(DIR_WS_CLASSES . 'ebay_transaction.php');
require (DIR_WS_CLASSES.'shipping.php');
require_once(DIR_FS_INC . 'yes_customers_email_alias_functions.inc.php');
if(!function_exists('yes_add_products_history')){
	function yes_add_products_history($pID,$comments){
		$editor_id = 0;
		if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] > 0){
			$editor_id = $_SESSION['customer_id'];
		}
		$insert_sql_array = array(
			'products_id'=>$pID,
			'editor_id'=>$editor_id,
			'date_saved'=>'now()',
			'comments'=>$comments
		);
		xtc_db_perform('products_history',$insert_sql_array);
	}
}

$shipping_modules = new shipping;

function xtc_get_ebay_users(){
	$env = (EBAY_TESTMODE == 1) ? 'sandbox' : 'production';
	$user_array = array();
	$user_query = xtc_db_query("SELECT user FROM ebay_auth WHERE environment='".$env."'");
	while($user = xtc_db_fetch_array($user_query)){
		$user_array[] = array('id'=>$user['user'],'text'=>$user['user']);
	}
	return $user_array;
}

function format_price($price_string, $price_special, $currency, $allow_tax, $tax_rate) {
	// calculate currencies
	$currencies_query = xtc_db_query("SELECT
					symbol_left,
					symbol_right,
					decimal_places,
					value
				FROM
					" . TABLE_CURRENCIES . "
				WHERE
					code = '" . $currency . "'");
					
	$currencies_value = xtc_db_fetch_array($currencies_query);
	$currencies_data = array(
	'SYMBOL_LEFT' => $currencies_value['symbol_left'],
	'SYMBOL_RIGHT' => $currencies_value['symbol_right'],
	'DECIMAL_PLACES' => $currencies_value['decimal_places'],
	'VALUE' => $currencies_value['value']);

	// round price
	if ($allow_tax == 1) $price_string = $price_string/((100+$tax_rate)/100);
		$price_string = precision($price_string, $currencies_data['DECIMAL_PLACES']);
	if ($price_special == '1') {
		$price_string = $currencies_data['SYMBOL_LEFT'] . ' ' . $price_string . ' ' . $currencies_data['SYMBOL_RIGHT'];
	}
	return $price_string;
}

function precision($number, $places) {
	$number = number_format($number, $places, '.', '');
	return $number;
}

function split_string($value){
	// WIR BASTELN VOR- UND NACHNAMEN
	$reg_fullname = array();
	$reg_fullname_array = array();
	
	$reg_fullname_ebay = $value;
	$reg_fullname_array = split(" ",$reg_fullname_ebay);
	$reg_fullname[0] = $reg_fullname_array[0];
	if( count($reg_fullname_array) > 1 ) {
		for($i=1;$i<count($reg_fullname_array);$i++) {
			if(!isset($reg_fullname[1])) $reg_fullname[1] = '';
			$reg_fullname[1] .= ' '.$reg_fullname_array[$i];
		}
	}
	return $reg_fullname;
}

function _get_country_name_from_code($iso_code){
	$countryname_query = xtc_db_query("SELECT countries_name FROM countries WHERE countries_iso_code_2='".$iso_code."'");
	$countryname = xtc_db_fetch_array($countryname_query);
	return $countryname['countries_name'];
}

function _get_country_id_from_code($iso_code){
	$countryid_query = xtc_db_query("SELECT countries_id FROM countries WHERE countries_iso_code_2='".$iso_code."'");
	$countryid = xtc_db_fetch_array($countryid_query);
	return $countryid['countries_id'];
}

$rec_konv_array = array();
$admin_access_query = xtc_db_query("SELECT customers_id FROM admin_access WHERE ebayapi_cart=1");
while($admin_access = xtc_db_fetch_array($admin_access_query)){
	$rec_konv_array[] = $admin_access['customers_id'];
}

function _get_country_code($value,$ebayid,$write_notice = true){
	global $rec_konv_array,$EBAYAPI;
	$iso2 = $EBAYAPI->get_iso2_from_ebay_countryname($value);
    if( $iso2 != '' ){
    	return $iso2;
    }else{
	if($write_notice){
		$text = sprintf('In Auktion Nr. %s wurde das Land des Kaeufers als "%s" uebergeben. Diesem Wert konnte kein eindeutiges Land zugewiesen werden und in der Bestellung wurde als Default-Wert Germany hinterlegt.<p><i>Es kann oefter vorkommen das Ebay unvollstaendige oder fehlende Laenderkennungen uebergibt, damit es beim Versand nicht zu Problemen fuehrt, informiert Sie das YES System.</i></p>',$ebayid,$value);
		yes_write_notice('Fehlende Ebay-Land-Konvertierung',$text,0,$rec_konv_array);
	}
    	return 'DE';
    }
}

function _ebay_country_code($code){
	$country_id_query = xtc_db_query("SELECT countries_name,countries_id FROM countries WHERE countries_iso_code_2='".xtc_db_input(strtoupper( $code ))."'");
	$country_id_res = xtc_db_fetch_array($country_id_query);
	return (($country_id_res['countries_id'] > 0)?$country_id_res['countries_id']:'81');
}

function _ebay_zone_id($country_id){
	// bastel zone-id
	$zone_query = xtc_db_query("SELECT zone_id FROM ".TABLE_ZONES." WHERE zone_country_id='".$country_id."'");
	$zone = xtc_db_fetch_array($zone_query);
	return $zone["zone_id"];
}

function _get_payment_method($trans,$item,$shipping_class){
	$transStatus = $trans->getStatus();
	if($transStatus->getPaymentMethodUsed() != 'None'){
		if( $shipping_class != 'cod_cod' ){
			return $transStatus->getPaymentMethodUsed();
		}else{
			return 'COD';
		}
	}else{
		$paymentmethods = $item->getPaymentMethods();
		if( $shipping_class != 'cod_cod' ){
			if(EBAY_PREFERRED_PAYMENTMETHOD != ''){
				if(in_array(EBAY_PREFERRED_PAYMENTMETHOD,$paymentmethods))
					return EBAY_PREFERRED_PAYMENTMETHOD;
			}
			return $paymentmethods[0];
		}else{
			return 'COD';
		}
	}
}


class mytrans {
   var $transarray = array();
   var $Seller;
   var $SellerEmail = '';
   var $SellerUserID = '';
   var $SellingStatus = '';
   function _all_transactions( $pageNumber = '1' ){
	global $cs,$req,$from,$to;
//	$cs->attachLogger(new EbatNs_Logger(false),'stdout');
	$pag = new PaginationType();
	$pag->setEntriesPerPage(200);
	//$pag->setEntriesPerPage(2);
	$pag->setPageNumber($pageNumber);
	$req->setPagination($pag);
	$req->setModTimeFrom($from);
	$req->setModTimeTo($to);
	$req->setDetailLevel('ReturnAll');
	$req->setIncludeContainingOrder(true);
	$res = $cs->GetSellerTransactions($req);
	if(!$cs->isGood($res)){
		echo $cs->getErrorsToString($res)."\r\n";
	}else{
		$S = $res->getSeller();
		//$this->SellingStatus = $res->getSellingStatus();
		$this->Seller = $S;
		$this->SellerEmail = $S->getEmail();
		$this->SellerUserID = $S->getUserID();
		$pages = $res->PaginationResult->getTotalNumberOfPages();
		$entries = $res->PaginationResult->getTotalNumberOfEntries();
		for($i=0;$i<sizeOf($res->TransactionArray);$i++){
			$this->transarray[] = $res->TransactionArray[$i];
		}

		if($pageNumber < $pages){
			$this->_all_transactions( ($pageNumber+1) );
		}
	}
   }
   function getSeller(){
	return $this->Seller;
   }
}

$smarty = new yesSmarty;
$smarty->compile_dir=DIR_FS_CATALOG.'templates_c';
$smarty->secure_dir = array(DIR_FS_CATALOG.'templates/');
$EBAYAPI = new ebayAPI;

$ebay_users = xtc_get_ebay_users();

$ebay_now = $EBAYAPI->get_ebay_official_time();
if (($timestamp = strtotime($ebay_now)) === false) {
    die("ebay_now ($ebay_now) ist nicht parsebar.");
} else {
    $to = date('Y-m-d H:i:s',$timestamp);
}
if(!class_exists('ebayApi')) die('class ebayApi not exists');
if(!class_exists('products_quantity')) die('class products_quantity not exists');
if(!class_exists('yesSmarty')) die('class yesSmarty not exists');
if(!class_exists('order')) die('class order not exists');
$functions_array = array(
	'xtc_get_tax_rate',
	'xtc_get_product_collies',
	'xtc_get_product_collies_tax_value',
	'xtc_get_tax_class_id',
	'xtc_get_tax_rate',
	'_get_country_name_from_code',
	'xtc_get_products_name',
	'xtc_encrypt_password',
	'xtc_get_lang_path_from_ebay_site',
	'xtc_get_serial_number',
	'yes_add_products_history',
	'yes_update_products_in_auction_quantity',
	'yes_write_notice',
	'xtc_quicklogin_uuid',
	'xtc_quicklogin_save',
	'xtc_address_format',
	'xtc_get_attributes_model',
	'xtc_get_ext_products_weight',
	'xtc_get_short_description',
	'yes_get_shop_content',
	'yes_get_shop_content_html_stripped',
	'xtc_php_mail',
	'xtc_in_array'
);
foreach($functions_array as $func){
	if(!function_exists($func)) die("function $func not exists\r\n");
}

$smarty->assign(array(
	'EXAMPLE_START_DATE'=>date('d.m.Y', strtotime('-4 days')),
	'EXAMPLE_END_DATE'=>date('d.m.Y', strtotime('-2 days')),
));



$days = 1; // how many days
$span = 1; // how many days timespan


$from = strftime('%Y-%m-%dT00:00:00Z',strtotime(date('Y-m-d'))-(60*60*24*$days));
// wir ziehen 20 Minuten ab um nicht gleichzeitig mit SOAP ANfragen ins Gehege zu kommen
$to = gmdate('Y-m-d H:i:s', strtotime($to));
$transactions = array();
$output = [];
for($i=0;$i<sizeOf($ebay_users);$i++){
	$site_id = $EBAYAPI->get_site_id_from_name(EBAY_SITE);

	$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
	$session->setRequestToken( $EBAYAPI->getToken($ebay_users[$i]['id']) );
	$session->setSiteID($site_id);

	$cs = new EbatNs_ServiceProxy($session);
	//$cs->attachLogger(new EbatNs_Logger(false),'stdout');

	$req = new GetSellerTransactionsRequestType();
	$req->setModTimeFrom($from);
	$req->setModTimeTo($to);
	$mytrans = new mytrans();
	$mytrans->_all_transactions('1');
	$SELLER = $mytrans->getSeller();
	foreach($mytrans->transarray as $k=>$v){

		$sellingStatus = $v->getItem()->getSellingStatus();
		// bof wird nirgends verwendet? 2017/06
		if(method_exists($v, 'getShippingDetails')){
	                $shippingDetails = $v->getItem()->getShippingDetails();
		}
		// eof wird nirgends verwendet? 2017/06
		$differenz = strtotime($ebay_now)-strtotime($v->getCreatedDate());
		//echo $v->getCreatedDate().' hat Differenz in Sek: '.$differenz."\r\n";
		if( $differenz < 1800 ){ // halbe Stunde warten bei neuen Transaktionen
			echo $v->getItem()->getItemID().':'.$v->getTransactionID().' vom '.$v->getCreatedDate() . " muss noch warten\r\n";
			
			continue;
		}
                
                // EBAY PLUS ERMITTELN
                $ebay_plus = false;
		if(method_exists($v, 'getShippingServiceSelected')){
			$sss = $v->getShippingServiceSelected();
			if(method_exists($sss, 'getShippingService')){
				if($sss->getShippingService() == 'eBayPlus'){
					$ebay_plus = true;
				}
			}
//			print_r($v->getShippingDetails());
		}
		
		// BOF - UNBEKANNTE AUKTIONEN - DATUM PRUEFEN
		if(defined('EBAY_TRANSACTION_DEADLINE_DATE') and EBAY_TRANSACTION_DEADLINE_DATE != ''){
		    if(strtotime($v->getCreatedDate()) < strtotime(EBAY_TRANSACTION_DEADLINE_DATE)){
			if(!is_file(DIR_FS_CATALOG.'cache/deadline_transaction_'.$v->getItem()->getItemID().$v->getTransactionID().'.DAT')){
			    $dead_comment = sprintf('Es wurde zur Auktion %s eine veraltete Transaktion (%s) vom %s gemeldet. Diese Transaktion wird ignoriert und NICHT eingelesen. F&uuml;r Details zur Transaktion verwenden Sie bitte Ihr eBay Sellerkonto.',
				    $v->getItem()->getItemID(),$v->getTransactionID(),$v->getCreatedDate()
			    );
			    yes_write_notice('Veraltete Transaktion ('.$v->getItem()->getItemID().')', $dead_comment, 0, $rec_konv_array);
			    file_put_contents(DIR_FS_CATALOG.'cache/deadline_transaction_'.$v->getItem()->getItemID().$v->getTransactionID().'.DAT',date('Y-m-d H:i:s'));
			    echo $dead_comment . "\r\n";
			}   
			continue;
		    }
		}
		// EOF - UNBEKANNTE AUKTIONEN - DATUM PRUEFEN
		
		
		$et = new ebay_transaction($SELLER->getUserID(),$v->getItem()->getItemID(),$v->getTransactionID(),$v->getItem()->getTitle(),$sellingStatus->getQuantitySold(),$v->getItem()->getQuantity(),$sellingStatus->getCurrentPrice()->value, $v->getItem()->getListingType(),$ebay_plus);
		$et->source = 'CRON';
		
		
		$et->addresses = $et->get_addresses_from_object( $v->getBuyer() );
		
		
		if(method_exists($v, 'getContainingOrder')){
			$et->combined_order = $et->get_combined_order_from_object($v->getContainingOrder());
		}else{
			$et->combined_order = array();
		}
		$et->transaction_data = $et->get_transactiondata_from_object($v);
		$oID = 0;
		$query = xtc_db_query(sprintf(
			"SELECT orders_id FROM ebay_transactions WHERE ebayid='%s' AND transactionid='%s'",
			$v->getItem()->getItemID(),$v->getTransactionID()
		));
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			$oID = $record['orders_id'];
		}

		$output[ $ebay_users[$i]['id'] ][] = array('ORDERS_ID'=>$oID,'obj'=>$et,'html'=>json_encode(print_r($et,true)));
/*
if($et->ebay_user != 'nawo1321986'){
	continue;
}
		$et->process($language_id);
		
		// BOF - REAL SHIPPING COSTS
		if(isset($et->orders_id) and $et->orders_id > 0){
		    $order = new order($et->orders_id);
		    $order->save_real_shipping_cost();
		}
		// EOF - REAL SHIPPING COSTS
		
		if($et->send_mail == 1){
			$insert_id = $et->orders_id;
			$transaction = array_merge($et->addresses, $et->transaction_data_copy);
			$auction_data = $et->auction_data_copy;
			$is_registered = $et->is_registered;
			include('ebay_send_order.php');
		}
		continue;
*/
	}
}
$smarty->assign(array(
	'FROM_DATE'=>$from,
	'TO_DATE'=>$to,
	'DATA'=>$output
));
$smarty->display('admin/templates/ebay_trans_search.tpl');



