<?php
class yes_system_client extends yes_xmlrpc{
	public function getconfig($m){
		$params = parent::getCallParams($m->getParam(0),$m->methodname);
		$relations = array();
		$id = '';
		$id_name = '';
		switch($params['detail']){
			case 'lang':
				$table = 'languages';
				break;
			case 'shipping_status':
				$table = 'shipping_status';
				break;
			case 'manufacturer':
				$table = 'manufacturers';
				$relations[] = array(
					'table'=>'manufacturers_info',
					'field_src'=>'manufacturers_id',
					'field_rel'=>'manufacturers_id'
				);
				break;
			default:
				parent::sendError('Unknown detail Option',812);
				break;
		}
		$data = array();
		$data[$table] = new xmlrpcval(
			self::getDBEntryAsArray($table,$id,$id_name,$relations),
			'struct'
		);
		return new xmlrpcresp(new xmlrpcval($data,'struct'));
	}

	public function getproduct($m){
		$params = parent::getCallParams($m->getParam(0),$m->methodname);
		$q = sprintf(
			"SELECT products_id FROM products WHERE products_id='%s'",
			(int)$params['id']
		);
		$query = yes_db_query($q);
		if(!yes_db_num_rows($query)){
			parent::sendError('Unknown ID',810);
		}

		$data['products'] = new xmlrpcval(
			self::getDBEntryAsArray('products',(int)$params['id'],'products_id'),
			'struct'
		);
		$data['products_description'] = new xmlrpcval(
			self::getDBEntryAsArray('products_description',(int)$params['id'],'products_id'),
			'struct'
		);
		$data['products_images'] = new xmlrpcval(
			self::getDBEntryAsArray('products_images',(int)$params['id'],'products_id'),
			'struct'
		);
		$data['products_collies'] = new xmlrpcval(
			self::getDBEntryAsArray('products_collies',(int)$params['id'],'products_id'),
			'struct'
		);
		return new xmlrpcresp(new xmlrpcval($data,"struct"));
	}

	public function getproductquantity($m){
		global $yes_path;
		$params = parent::getCallParams($m->getParam(0),$m->methodname);
		$q = sprintf(
			"SELECT products_id FROM products WHERE products_id='%s'",
			(int)$params['id']
		);
		$query = yes_db_query($q);
		if(!yes_db_num_rows($query)){
			parent::sendError('Unknown ID',811);
		}
		require($yes_path.'admin/includes/classes/class.storagequantity.php');
		require($yes_path.'inc/xtc_collis.inc.php');
		$SQ = new products_quantity((int)$params['id']);
		$data_array = array(
				'PHYSICAL'=>$SQ->get_products_total_qty(),
				'AV1'=>$SQ->get_available1_qty(),
				'AV2'=>$SQ->get_available2_qty()
		);
		$order_array = array(php_xmlrpc_encode($data_array));
		$data['QUANTITY'] = new xmlrpcval($order_array,'struct');
		return new xmlrpcresp(new xmlrpcval($data,"struct"));
	}
	public function getcategories($m){
		$params = parent::getCallParams($m->getParam(0),$m->methodname);
		$id_name = 'categories_id';
		$id = 0;
		$table = 'categories';
		$relations[] = array(
			'table'=>'categories_description',
			'field_src'=>'categories_id',
			'field_rel'=>'categories_id'
		);
		$data = array();
		$data[$table] = new xmlrpcval(
			self::getDBEntryAsArray($table,$id,$id_name,$relations),
			'struct'
		);
		return new xmlrpcresp(new xmlrpcval($data,'struct'));
	}

	public function getproductsincategory($m){
		$limit = 100;
		$lang_id = 2; // irgendwann mal beim call verlangen
		$params = parent::getCallParams($m->getParam(0),$m->methodname);
		$page = (isset($params['page'])) ? (int)$params['page'] : 0;
		$data = array();
		$products = array();
		$query = xtc_db_query(sprintf(
			"SELECT COUNT(p2c.products_id) as anz FROM products p LEFT JOIN products_to_categories p2c USING(products_id) LEFT JOIN products_description pd USING(products_id) WHERE p2c.categories_id='%s' AND pd.language_id='%s'",
			(int)xtc_db_input($params['id']),$lang_id
		));
		$record = xtc_db_fetch_array($query);
		$data['total'] = php_xmlrpc_encode($record['anz']);
		$query = xtc_db_query(sprintf(
			"SELECT p2c.products_id,pd.products_name,p.products_ean,p.products_model,p.products_image FROM products p LEFT JOIN products_to_categories p2c USING(products_id) LEFT JOIN products_description pd USING(products_id) WHERE p2c.categories_id='%s' AND pd.language_id='%s' LIMIT %s, %s",
			(int)xtc_db_input($params['id']),$lang_id,$page*$limit,$limit
		));
		while($record = xtc_db_fetch_array($query)){
			$products[] = $record;
		}
		$data['products'] = php_xmlrpc_encode($products);
		$query = xtc_db_query(sprintf(
			"SELECT categories_name FROM categories_description WHERE categories_id='%s' AND language_id='%s'",
			$params['id'],$lang_id
		));
		$category = xtc_db_fetch_array($query);
		$data['category_info'] = php_xmlrpc_encode($category);

		return new xmlrpcresp(new xmlrpcval($data,'struct'));
	}

	function getorders($m){
		parent::sendError('not implemented yet',888);
		$err="";
		$params = self::getCallParams($m->getParam(0),$m->methodname);
		$sdv = $params['start_date'];
		$edv = $params['end_date'];
		$pageNr = (isset($params['pageNr'])) ? $params['pageNr'] : 1;

		// look it up in our array (zero-based)
		$_err = array();
		if (!yesCheckDate($sdv)) {
			$_err[] = 'startdate '.$sdv.' not valid';
		}
		if (!yesCheckDate($edv)) {
			$_err[] = 'enddate '.$edv.' not valid';
		}
		if(strtotime($edv) < strtotime($sdv)){
			$_err[] = 'enddate must greater then startdate';
		}
		if($edv > date('Y-m-d')){
			$_err[] = 'endate must lower then today';
		}
		if(sizeOf($_err)){
			return new xmlrpcresp(0, $xmlrpcerruser, implode("\r\n",$_err));
		}



		$query = yes_db_query(sprintf(
			"SELECT COUNT(orders_id) AS anz FROM orders WHERE date_purchased > '%s' AND date_purchased < '%s'",
			$sdv,$edv
		));
		$record = current($query);
		$total = $record['anz'];

		if (!sizeOf($record)){
			// not, there so complain
			$err="No Results for '" . $snv . "'";
		}

		// if we generated an error, create an error return response
		if ($err){
			return new xmlrpcresp(0, $xmlrpcerruser, $err);
		}else{
			$query = yes_db_query(sprintf(
				"SELECT * FROM orders WHERE date_purchased > '%s' AND date_purchased < '%s' ORDER BY date_purchased LIMIT %s,%s",
				$sdv,$edv, ($pageNr-1)*MAX_DB_NUM_ROWS, ($pageNr-1)+MAX_DB_NUM_ROWS
			));
			$records = yes_db_num_rows($query);
			$data = array(
				'TOTAL' => new xmlrpcval($total,'int'),
				'CURRENT' => new xmlrpcval($records,'int'),
				'PAGE' => new xmlrpcval($pageNr,'int'),
				'MAX_ITEMS' => new xmlrpcval(MAX_DB_NUM_ROWS,'int')
			);
			$order_array = array();
			foreach($query as $order_data){
				$current_order_data = array();
				foreach($order_data as $key=>$value){
					$current_order_data[ $key ] = $value;
				}

				// FIBU
				$fibu_query = yes_db_query(sprintf(
					"SELECT fibunumber,date_added FROM orders_fibunumbers WHERE orders_id='%s'",
					$order_data['orders_id']
				));
				$current_order_data['FIBUNUMBER'] = array();
				if(yes_db_num_rows($fibu_query)){
					$current_order_data['FIBUNUMBER'] = current($fibu_query);
				}

				// PRODUCTS
				$op_query = yes_db_query(sprintf(
					"SELECT * FROM orders_products WHERE orders_id='%s'",
					$order_data['orders_id']
				));
				$current_order_data['PRODUCTS'] = array();
				if(yes_db_num_rows($op_query)){
					foreach($op_query as $op){
						unset($op['orders_id']); // BRAUCHEN WIR JA NICHT DOPPELT

						// PRICE FIXING
						$pf_query = yes_db_query(sprintf(
							"SELECT * FROM orders_products_price_fixing WHERE orders_products_id='%s'",
							$op['orders_products_id']
						));
						$op['PRICE_FIXING'] = array();
						if(yes_db_num_rows($pf_query)){
							foreach($pf_query as $pf){
								unset($pf['orders_products_id']); // BRAUCHEN WIR JA NICHT DOPPELT
								$op['PRICE_FIXING'][] = $pf;
							}
						}

						// PROPERTIES
						$pt_query = yes_db_query(sprintf(
							"SELECT * FROM orders_products_properties WHERE orders_products_id='%s'",
							$op['orders_products_id']
						));
						$op['PROPERTIES'] = array();
						if(yes_db_num_rows($pt_query)){
							foreach($pt_query as $pt){
								unset($pt['orders_products_id']); // BRAUCHEN WIR JA NICHT DOPPELT
								$op['PROPERTIES'][] = $pt;
							}
						}

						// SERIALS
						$sn_query = yes_db_query(sprintf(
							"SELECT * FROM orders_products_serials WHERE orders_products_id='%s'",
							$op['orders_products_id']
						));
						$op['SERIAL_NUMBERS'] = array();
						if(yes_db_num_rows($sn_query)){
							foreach($sn_query as $sn){
								unset($sn['orders_products_id']); // BRAUCHEN WIR JA NICHT DOPPELT
								$op['SERIAL_NUMBERS'][] = $sn;
							}
						}

						$current_order_data['PRODUCTS'][] = $op;
					}
				}
				// TOTALS
				$ot_query = yes_db_query(sprintf(
					"SELECT * FROM orders_total WHERE orders_id='%s'",
					$order_data['orders_id']
				));
				$current_order_data['TOTALS'] = array();
				if(yes_db_num_rows($ot_query)){
					foreach($ot_query as $ot){
						unset($ot['orders_id']); // BRAUCHEN WIR JA NICHT DOPPELT
						$current_order_data['TOTALS'][] = $ot;
					}
				}
				$order_array[] = php_xmlrpc_encode($current_order_data);

			}
			$data['ORDERS'] = new xmlrpcval($order_array,'struct');
			return new xmlrpcresp(new xmlrpcval($data,"struct"));
		}
	}

	private function getDBEntryAsArray($table,$id=0,$id_name='',$relations=array()){
		$data_array = array();
		$q = sprintf(
			"SELECT * FROM %s",
			$table
		);
		if($id > 0){
			$q .= sprintf(" WHERE %s='%s'",
				$id_name,$id
			);
		}
		$query = yes_db_query($q);
		foreach($query as $row){
			$row['relation_data'] = array();
			if(sizeOf($relations)){
				foreach($relations as $rel){
					$_relation_data = array();
					$qr = sprintf(
						"SELECT * FROM %s WHERE %s='%s'",
						$rel['table'],$rel['field_rel'],$row[$rel['field_src']]
					);
					$rel_query = yes_db_query($qr);
					foreach($rel_query as $rel_row){
						$_relation_data[] = $rel_row;
					}
					$row['relation_data'][ $rel['table'] ] = $_relation_data;
				}
			}
			$data_array[] = php_xmlrpc_encode($row);
		}
		return $data_array;
	}

}

