<?php
define('GZIP_COMPRESSION','false');
define('MAX_DB_NUM_ROWS','100');
define('USE_YES_ERROR_HANDLER',false);
$current_path = dirname(__FILE__);
$yes_path = current(explode('/yes/',dirname(__FILE__))).'/yes/';
chdir($yes_path);
require('includes/application_top.php');
chdir($current_path);
//$yes_db_class_instance = new db(0);

class xmlrpc_server_methods_container{
	/**
	* Method used to test logging of php warnings generated by user functions.
	*/
	function phpwarninggenerator($m){
		$a = $b; // this triggers a warning in E_ALL mode, since $b is undefined
		return new xmlrpcresp(new xmlrpcval(1, 'boolean'));
	}

	/**
	* Method used to testcatching of exceptions in the server.
	*/
	function exceptiongenerator($m){
	throw new Exception("it's just a test", 1);
	}

	/**
	* a PHP version of the state-number server. Send me an integer and i'll sell you a state
	* @param integer $s
	* @return string
	*/
	static function findstate($s){
		return inner_findstate($s);
	}

	/**
	* @param start_date $sd
	* @return array
	*/
	static function getorders($sd){
		return inner_getorders($sd);
	}

	static function getproduct(){
		return inner_getproduct();
	}
	static function getproductquantity(){
		return inner_getproductquantity();
	}
	static function searchproduct(){
		return inner_searchproduct();
	}
}
require('yes_xmlrpc.php');

function yesCheckDate($date){
	if ($date != '0000-00-00' and strlen($date) == 10 and @date('Y-m-d', strtotime($date)) == $date) {
		return true;
	}
	return false;
}

/**
 * Demo server for xmlrpc library.
 *
 * Implements a lot of webservices, including a suite of services used for
 * interoperability testing (validator1 methods), and some whose only purpose
 * is to be used for unit-testing the library.
 *
 * Please do not copy this file verbatim into your production server.
 *
 * @version $Id: server.php,v 1.4 2014/09/05 15:36:06 cvs Exp $
 **/

// give user a chance to see the source for this server instead of running the services
if (isset($_SERVER['REQUEST_METHOD']) and $_SERVER['REQUEST_METHOD'] != 'POST' && isset($_GET['showSource']))
{
	highlight_file(__FILE__);
	die();
}


// a PHP version
// of the state-number server
// send me an integer and i'll sell you a state

$yx = new yes_xmlrpc;
$yx->init();


