<?php
require_once('yes_system_client.php');
class yes_xmlrpc
{
	var $token;
	var $method;
	var $xmlrpcerruser;
	var $xmlrpcStruct;
	var $getproduct_sig,$getproduct_doc,$getorders_sig,$getorders_doc,$getproductquantity_sig,$getproductquantity_doc,$getallheaders_sig,$getallheaders_doc;
	var $getconfig_doc,$getconfig_sig,$getcategories_sig,$getcategories_doc,$getproductsincategory_sig,$getproductsincategory_doc,$searchproducts_sig,$searchproducts_doc;
	function __construct(){
		include("../../lib/xmlrpc.inc");
		include("../../lib/xmlrpcs.inc");
		include("../../lib/xmlrpc_wrappers.inc");
		$this->xmlrpcStruct = $GLOBALS['xmlrpcStruct'];
		$this->xmlrpcerruser = $GLOBALS['xmlrpcerruser'];
		$this->xmlrpcArray = $GLOBALS['xmlrpcArray'];
	}
	function init(){

		$this->getallheaders_sig=array(array($this->xmlrpcStruct));
		$this->getallheaders_doc='Returns a struct containing all the HTTP headers received with the request. Provides limited functionality with IIS';
		$this->getproduct_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->getproduct_doc = 'Get product data for a specified id.';
		$this->getproductquantity_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->getproductquantity_doc = 'Get product quantity info for a specified id.';
		$this->getorders_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->getorders_doc = 'Get orders data for a specified Daterange.';
		$this->getconfig_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->getconfig_doc = 'Get config data for a specified detailtype.';
		$this->getcategories_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->getcategories_doc = 'Get all categories data or for a specified parent_id.';
		$this->getproductsincategory_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->getproductsincategory_doc = 'Get products for a specified category_id.';
		$this->searchproducts_sig=array(array($this->xmlrpcArray, $this->xmlrpcStruct));
		$this->searchproducts_doc = 'Search products.';


		$o=new xmlrpc_server_methods_container;
		$a=array(
			'yes.getConfig' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->getconfig_sig,
				'docstring'=>$this->getconfig_doc
			),
			'yes.getOrders' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->getorders_sig,
				'docstring'=>$this->getorders_doc
			),
			'yes.getProduct' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->getproduct_sig,
				'docstring'=>$this->getproduct_doc
			),
			'yes.getProductQuantity' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->getproductquantity_sig,
				'docstring'=>$this->getproductquantity_doc
			),
			'yes.getCategories' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->getcategories_sig,
				'docstring'=>$this->getcategories_doc
			),
			'yes.getProductsInCategory' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->getproductsincategory_sig,
				'docstring'=>$this->getproductsincategory_doc
			),
			'yes.searchProducts' => array(
				'function'=>'yes_xmlrpc::yes_call',
				'signature'=>$this->searchproducts_sig,
				'docstring'=>$this->searchproducts_doc
			),
		);
		$s=new xmlrpc_server($a, false);
		$s->setdebug(0);
		$s->compress_response = true;
		// out-of-band information: let the client manipulate the server operations.
		// we do this to help the testsuite script: do not reproduce in production!
		$s->response_charset_encoding = 'UTF-8';
/*
		if (isset($_GET['RESPONSE_ENCODING']))
			$s->response_charset_encoding = $_GET['RESPONSE_ENCODING'];
		if (isset($_GET['EXCEPTION_HANDLING']))
			$s->exception_handling = $_GET['EXCEPTION_HANDLING'];
		if(!$this->check_status()){
			$this->sendError('Der XMLRPC Server ist nicht freigegeben.',800);
		}
*/
		$s->service();
	}

	public function check_calllimit($method,$token){
		$call_timelimit_seconds = 60;
		switch($method){
			case 'yes.getProduct':
				$call_limit = 100;
				break;
			default:
				$call_limit = 0;
				break;
		}
		$dir = md5($token);
		$file = $dir.'/'.$method;
		if(!is_dir($dir))
			mkdir($dir);
		if(!is_file($file)){
			touch($file);
		}
		$creationtime = filemtime($file);

		$filetimeexp = $creationtime+$call_timelimit_seconds;
		if($filetimeexp < time()){
			unlink($dir.'/'.$method);
			touch($file);
		}
		$content = (int)file_get_contents($file);
		if($call_limit > 0 and $content >= $call_limit){
			self::sendError('Call limit of '.$call_limit.' for method '.$method.' reached, wait '.($filetimeexp-time()).'/'.$call_timelimit_seconds.' seconds.',805);
		}
		$content++;
		file_put_contents($file, $content);
		return true;
	}
	public function check_status(){
		if(!defined('MODULE_YES_XMLRPC_STATUS') or MODULE_YES_XMLRPC_STATUS != 'True'){
			return false;
		}
		return true;
	}

	public function yes_call($m){
		$params = self::getCallParams($m->getParam(0),$m->methodname);
		$tkn = substr(str_replace(array('%','"',"'"),'',$params['token']),0,32);
		$query = yes_db_query(sprintf(
			"SELECT * FROM yes_xmlrpc_token WHERE token='%s'",
			$tkn
		));
		$record = current($query);
		if(!isset($record['id'])){
			self::sendError('Autorisierung fehlgeschlagen',801);
		}
		if(substr($m->methodname,0,4) == 'yes.'){
			$af = explode(';',$record['allowed_functions']);
			$mn = substr($m->methodname,4,strlen($m->methodname));
			if(!in_array($mn,$af)){
				self::sendError('Methode nicht erlaubt.',802);
			}
		}else{
			self::sendError('Methode wird nicht unterstuetzt.',803);
		}
		if(!yes_xmlrpc::check_calllimit($m->methodname,$params['token'])){
			self::sendError('Call Volumen ueberschritten.',803);
		}
		switch($m->methodname){
			case 'yes.getConfig':
				return yes_system_client::getconfig($m);
				break;
			case 'yes.getProduct':
				return yes_system_client::getproduct($m);
				break;
			case 'yes.getOrders':
				return yes_system_client::getorders($m);
				break;
			case 'yes.getProductQuantity':
				return yes_system_client::getproductquantity($m);
				break;
			case 'yes.getCategories':
				return yes_system_client::getcategories($m);
				break;
			case 'yes.getProductsInCategory':
				return yes_system_client::getproductsincategory($m);
				break;
			case 'yes.searchProducts':
				return yes_system_client::searchproducts($m);
				break;
		}
	}
	public function sendError($error_str,$error_id){
		$r = new xmlrpcresp(0, $error_id, $error_str);
		echo $r->serialize();
		exit;
	}

	public function getCallParams($param,$method_name){
		$xml = new SimpleXMLElement($param->serialize());
		$return_values = array('auth'=>false);
		foreach ($xml->children() as $second_gen) {
			foreach ($second_gen->children() as $third_gen) {
				$value_element = $third_gen->value;
				$type = key($value_element);
				$value = current($value_element->$type);
				$return_values[ ''.$third_gen->name ] = $value;
			}
		}
		return $return_values;
	}

}

