<?php
class getConfig extends yes_callType{
	public function compare_with_local($detail){
	    if(!sizeOf($this->data_array)){
		$this->errors[] = sprintf('Es liegen keine Vergleichsdaten vor.');
		return false;
	    }
	    switch($detail){
		case 'lang':
		    $table = 'languages';
		    break;
		case 'manufacturer':
		    $table = 'manufacturers';
		    break;
		default:
		    $table = $detail;
		    break;
	    }
	    $diff_array = array();
	    $local_data = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM %s",
		    $table
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$local_data[] = $record;
	    }
	    switch($table){
		case 'languages':
		    foreach($this->data_array[$table] as $lang){
			$diff_array[ $lang['languages_id'] ] = array(
			    'code'=>$lang['code'],
			    'directory'=>$lang['directory']
			);
		    }
		    foreach($diff_array as $language_id => $lang ){
			$exists = false;
			foreach($local_data as $loclang){
			    if($loclang['languages_id'] == $language_id){
				if($loclang['directory'] == $lang['directory'] and $loclang['code'] == $lang['code']){
				    $exists = true;
				}
			    }
			}
			if(!$exists){
			    $this->errors[] = sprintf('Lokal fehlt das Sprachpaket ID %s (Code: %s, Verzeichnis: %s)',$language_id,$lang['code'],$lang['directory']);
			}
		    }
		    break;
		case 'shipping_status':
		    foreach($this->data_array[$table] as $ss){
			$diff_array[ $ss['shipping_status_id'] ] = array(
			    'language_id'=>$ss['language_id'],
			    'shipping_status_name'=>$ss['shipping_status_name']
			);
		    }
		    foreach($diff_array as $ssid => $ss ){
			$exists = false;
			foreach($local_data as $locss){
			    if($locss['shipping_status_id'] == $ssid){
				if($locss['shipping_status_name'] == $ss['shipping_status_name'] and $locss['language_id'] == $ss['language_id']){
				    $exists = true;
				}
			    }
			}
			if(!$exists){
			    $this->errors[] = sprintf('Lokal fehlt (oder weicht ab) die Versanddauer ID %s (Sprache: %s, Name: %s)',$ssid,$ss['language_id'], $ss['shipping_status_name']);
			}
		    }
		    break;
		case 'manufacturers':
		    foreach($this->data_array[$table] as $m){
			$diff_array[ $m['manufacturers_id'] ] = array(
			    'manufacturers_name'=>$m['manufacturers_name'],
			    'short_name'=>$m['short_name']
			);
		    }
		    foreach($diff_array as $mid => $m ){
			$exists = false;
			foreach($local_data as $locm){
			    if($locm['manufacturers_id'] == $mid){
				if($locm['manufacturers_name'] == $m['manufacturers_name'] and $locm['short_name'] == $m['short_name']){
				    $exists = true;
				}
			    }
			}
			if(!$exists){
			    $this->errors[] = sprintf('Lokal fehlt (oder weicht ab) der Hersteller ID %s (Name: %s, Kurzname: %s)',$mid,$m['manufacturers_name'], $m['short_name']);
			}
		    }
		    break;
	    }
	    if(sizeOf($this->errors))
		return false;
	    return true;
	}
}
