<?php
class getProduct extends yes_callType{
    var $remote_unsets = array(
		'products'=>array(
			'products_id',
			'products_image',
			'products_image1',
			'products_image2',
			'products_image3',
			'products_discount_allowed',
			'products_date_added',
			'products_last_modified',
			'products_status',
			'product_template',
			'options_template',
			'lagerort_id',
			'products_ordered',
			'template_link',
			'ebay_template',
			'default_storage',
			'colli_id',
			'products_master',
			'products_master_status',
			'products_listing_status',
			'products_startpage',
			'products_startpage_sort',
			'ext_additionalcosts',
			'characteristics_template',
			'shipping_extra_charge',
			'in_auction',
			'default_category',
			'allow_amazon',
			'shopgate_block',
			'shopgate_quantity',
			'shopgate_status',
			'packaging_costs',
		    'relation_data'
		),
		'products_description'=>array(
			'products_id',
			'last_modified',
			'amazon_flatfile',
			'amazon_browse_node_id',
		    'products_keywords',
		    'relation_data'
		),
	);
	var $import_config;
	public function import($xmlrpc_server_image_path){
		$remote_products_id = 0;
		$remote_images = array();
		foreach($this->data_array as $table=>$sql_array){
			if(!sizeOf($sql_array)){
				unset($this->data_array[$table]);
				continue;
			}
			switch($table){
				case 'products_description':
				    /**
				     * UEBERSCHREIBE DIE LANGUAGE EINSTELLUNGEN
				     */
				    if(isset($this->import_config['languages'])){
					foreach($sql_array as $k=>$row){
					    $this->data_array[$table][$k]['language_id'] = $this->import_config['languages'][$row['language_id']];
					}
				    }
				    $this->unsetFields($table);
				    break;
				case 'products':
					$remote_products_id = $sql_array[0]['products_id'];
					if($sql_array[0]['products_image'] != ''){
						$remote_images[] = $sql_array[0]['products_image'];
					}
					/**
					 * UEBERSCHREIBE DIE MANUFACTURER EINSTELLUNGEN
					 */
					if(isset($this->import_config['manufacturers'])){
					    foreach($sql_array as $k=>$row){
						if($row['manufacturers_id'] > 0){
						    $this->data_array[$table][$k]['manufacturers_id'] = $this->import_config['manufacturers'][$row['manufacturers_id']];
						}
					    }
					}
					/**
					 * UEBERSCHREIBE DIE SHIPPINGTIME EINSTELLUNGEN
					 */
					if(isset($this->import_config['shipping_statuses'])){
					    foreach($sql_array as $k=>$row){
						if($row['products_shippingtime'] > 0){
						    $this->data_array[$table][$k]['products_shippingtime'] = $this->import_config['shipping_statuses'][$row['products_shippingtime']];
						}
					    }
					}
					/**
					 * UEBERSCHREIBE DIE UNITS EINSTELLUNGEN
					 */
					if(isset($this->import_config['units'])){
					    foreach($sql_array as $k=>$row){
						if($row['units_id'] > 0){
						    $this->data_array[$table][$k]['units_id'] = $this->import_config['units'][$row['units_id']];
						}
					    }
					}
					/**
					 * UEBERSCHREIBE DIE PRODUCTS_VPE EINSTELLUNGEN
					 */
					if(isset($this->import_config['products_vpe'])){
					    foreach($sql_array as $k=>$row){
						if($row['products_vpe'] > 0){
						    $this->data_array[$table][$k]['products_vpe'] = $this->import_config['products_vpe'][$row['products_vpe']];
						}
					    }
					}
					$this->unsetFields($table);
					break;
				case 'products_images':
					foreach($sql_array as $row){
						if($row['image_name'] != ''){
							$remote_images[] = $row['image_name'];
						}
					}
					$this->unsetFields($table);
					break;
				default:
				    $this->unsetFields($table);
				    break;
			}
		}
		
		// products
		$this->data_array['products'][0]['products_date_added'] = 'now()';
		xtc_db_perform('products',$this->data_array['products'][0]);
		// products_description
		$new_products_id = xtc_db_insert_id();
		$local_languages_processed = array();
		$local_languages = xtc_get_languages();
		foreach($this->data_array['products_description'] as $insert_sql_array){
		    $insert_sql_array['products_id'] = $new_products_id;
		    xtc_db_perform('products_description',$insert_sql_array);
		    $local_languages_processed[] = $insert_sql_array['language_id'];
		}
		foreach($local_languages as $loclang){
		    if(!in_array($loclang['id'],$local_languages_processed)){
			// DIESE LOKALE SPRACHE IST UNBEKANNT UND MUSS GEFUELLT WERDEN
			// WIR NEHMEN DIE ERSTE DIE WIR VOM REMOTE KRIEGEN
			$insert_sql_array = $this->data_array['products_description'][0];
			$insert_sql_array['products_id'] = $new_products_id;
			$insert_sql_array['language_id'] = $loclang['id'];
			xtc_db_perform('products_description',$insert_sql_array);
		    }
		}
		// images
		foreach($remote_images as $k=>$img){
		    $ext = substr($img,strlen($img)-3,strlen($img));
		    $local_name = DIR_FS_CATALOG.'images/product_images/original_images/'.$new_products_id.'_'.$k.'.'.$ext;
		    if($this->saveImage($xmlrpc_server_image_path.$img,$local_name)){
			$products_image_name = $new_products_id.'_'.$k.'.'.$ext;
			$link_check = DIR_FS_CATALOG_THUMBNAIL_IMAGES;
			if(substr($link_check,strlen($link_check)-1,strlen($link_check)) == '/'){
			    $link_check = substr($link_check,0,strlen($link_check)-1);
			}
			if(is_dir($link_check) and !is_link($link_check)){
			    require('includes/product_thumbnail_images.php');
			    //@chmod(DIR_FS_CATALOG_THUMBNAIL_IMAGES.'/'.$products_image_name,0777);
			}

			require('includes/product_info_images.php');
			require('includes/product_ebaycategory_images.php');
			require('includes/product_popup_images.php');

			//@chmod(DIR_FS_CATALOG_INFO_IMAGES.'/'.$products_image_name,0777);
			//@chmod(DIR_FS_CATALOG_POPUP_IMAGES.'/'.$products_image_name,0777);
			//@chmod(DIR_FS_CATALOG_EBAYCATEGORY_IMAGES.'/'.$products_image_name,0777);
		    }
		    if($k < 1){
			$update_sql_array = array(
			    'products_image'=>$new_products_id.'_'.$k.'.'.$ext
			);
			xtc_db_perform('products',$update_sql_array,'update',"products_id='".$new_products_id."'");
		    }else{
			$insert_sql_array = array(
			    'products_id'=>$new_products_id,
			    'image_nr'=>$k,
			    'image_name'=>$new_products_id.'_'.$k.'.'.$ext
			);
			xtc_db_perform('products_images',$insert_sql_array);
		    }
		}
		// categories
		$categories_id = (isset($this->import_config['import_categories_id'])) ? $this->import_config['import_categories_id'] : 0;
		$insert_sql_array = array(
		    'products_id'=>$new_products_id,
		    'categories_id'=>$categories_id
		);
		xtc_db_perform('products_to_categories',$insert_sql_array);
		return $new_products_id;
	}

	private static function image_exists($url){
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL,$url);
	    // don't download content
	    curl_setopt($ch, CURLOPT_NOBODY, 1);
	    curl_setopt($ch, CURLOPT_FAILONERROR, 1);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	    if(curl_exec($ch)!==FALSE){
		return true;
	    }else{
		return false;
	    }
	}
	private function saveImage($image,$local_name){
	    if(!self::image_exists($image)){
		$this->throwError('remote image '.$image.' dont exists');
		return false;
	    }
	    $fp = fopen($local_name, 'wb');
	    if(!$fp){
		$this->throwError('local image '.$local_name.' not writable');
		return false;
	    }
	    $ch = curl_init($image);
	    curl_setopt($ch, CURLOPT_FILE, $fp);
	    curl_setopt($ch, CURLOPT_HEADER, 0);
	    curl_exec($ch);
	    curl_close($ch);
	    fclose($fp);
	    return true;
	}
	
}
