<?php
require_once('yes.callType.php');
class yesParser
{
    var $debug_mode;
	var $function;
	var $data_array;
	var $config;
	var $errors = array();

	protected function getClassName(){
		return substr($this->getFunction(),4,strlen($this->getFunction()));
	}
	protected function setFunction($function){
		$this->function = $function;
	}
	protected function setData_array($data_array){
		$this->data_array = $data_array;
	}
	protected function getFunction(){
		return $this->function;
	}
	protected function getData_array(){
		return $this->data_array;
	}

	function __construct($function,$data_array){
		$this->setFunction($function);
		$this->setData_array($data_array);
		return $this->autoload();
	}

	public function getCallInstance(){
		$class_name = $this->getClassName();
		return new $class_name($this->getdata_array());
	}

	protected function autoload(){
		if(!is_file(DIR_FS_CATALOG.'xmlrpc/yes_client/'.$this->getFunction().'.php' ) ){
		    $this->throwError('Autoload for '.$this->getFunction().' failed');
		    return false;
		}
		include(DIR_FS_CATALOG.'xmlrpc/yes_client/'.$this->getFunction().'.php');
		return true;
	}
	
	protected function throwError($msg){
	    $this->errors[] = $msg;
	}
	public function getErrorsToString(){
	    return implode('<br />',$this->errors);
	}
}

