#!/usr/bin/perl

use strict;
use warnings;

use XML::SAX::ParserFactory;
use XML::Validator::Schema;

my ($xml) = @ARGV;
if (@ARGV != 1) {
    die "Usage: $0 xml\n";
}

my $validator = XML::Validator::Schema-> new(file => 'amos.xsd');

my $parser = XML::SAX::ParserFactory-> parser(Handler => $validator);

eval { $parser-> parse_uri($xml) };
die "$@" if $@;
print "OK";

