<?php
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'amazon_export.php');
require_once(DIR_WS_CLASSES.'class.storagequantity.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'yes_export_modules.php');
require_once(DIR_WS_CLASSES.'class.products_export.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_WS_CLASSES.'amz_Helper.php');

$tpl_config_dir = 'amazon_export_templates/';
if(!is_dir(\main::get_importdata_path().$tpl_config_dir)){
	mkdir(\main::get_importdata_path().$tpl_config_dir);
}

$amazon_export_data_dir = \main::get_exportdata_path().'amazon/';
if(!is_dir($amazon_export_data_dir)){
	echo mkdir($amazon_export_data_dir);
}
$ae_template_extension = '.conf';
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
$language = (isset($_REQUEST['language'])) ? $_REQUEST['language'] : $_SESSION['language'];
$flatfile = (isset($_REQUEST['flatfile'])) ? xtc_db_input($_REQUEST['flatfile']) : '';
$template = (isset($_REQUEST['template'])) ? xtc_db_input($_REQUEST['template']) : '';
$template = str_replace(array(' ','.php','/','\\','%','.sh','..'),'',$template);

$basics = new basics;
$pe = new products_export;
$ae = new amazon_export($language);
$A = new amazon_helper;

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$auth_user_input_array = array();
foreach($A->get_auth_user_array() as $_authuseramz){
	$auth_user_input_array[] = array('id'=>$_authuseramz,'text'=>$_authuseramz);
}
$smarty->assign(array(
    'FORM_END'=>'</form>',
    'TEXT_SELECT_AMAZON_TEMPLATE'=>TEXT_SELECT_AMAZON_TEMPLATE,
    'TEXT_SHOW_NON_MANDATORY'=>TEXT_SHOW_NON_MANDATORY,
    'TEXT_HIDE_NON_MANDATORY'=>TEXT_HIDE_NON_MANDATORY,
    'TEXT_SELECT_SOURCE'=>TEXT_SELECT_SOURCE,
    'TEXT_SELECT_SOURCE_TITLE'=>TEXT_SELECT_SOURCE_TITLE,
    'TEXT_SELECT_TYPE'=>TEXT_SELECT_TYPE,
    'TEXT_SELECT_TYPE_TITLE'=>TEXT_SELECT_TYPE_TITLE,
    'AE_BASELINK'=>xtc_href_link('amazon_export.php','template='.$template),
    'TEXT_SAVE_TEMPLATE_SOURCE_CONFIG'=>TEXT_SAVE_TEMPLATE_SOURCE_CONFIG,
    'BUTTON_AMAZON_EXPORT'=>BUTTON_AMAZON_EXPORT,
    'TEXT_MANDATORY'=>TEXT_MANDATORY,
    'TEXT_PRODUCTS_FOR_AMAZON_EXPORT'=>TEXT_PRODUCTS_FOR_AMAZON_EXPORT,
    'INPUT_MERCHANT_ID' => xtc_draw_pull_down_menu('merchant_id',$auth_user_input_array)
));

$yep = new yes_export_modules($language);
switch($action){
    case 'delete_template':
	$flatfile = basename(xtc_db_input($_REQUEST['flatfile']));
	$filename = basename(xtc_db_input($_REQUEST['template']));
	
	if(is_file(\main::get_importdata_path().'amazon_export_templates/'.$flatfile.'/'.$filename)){
		unlink(\main::get_importdata_path().'amazon_export_templates/'.$flatfile.'/'.$filename);
	}
	$messageStack->add_session(sprintf(MSG_SUCCESS_REMOVED,$filename),'success');
	xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF'])));
	break;
    case 'delete_template_confirm':
	header('Content-Type: text/html; charset='.CHARSET);
	printf('<b>%s</b><br /><i>%s</i><br /><br />',JS_CONFIRM_REALLY_DELETE_TEMPLATE,xtc_db_input($_REQUEST['template']));
	printf('<input type="button" onclick="window.location.href=\'%s\'" value="%s" class="ui-state-highlight" />',
		xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')).'action=delete_template'),
		IMAGE_DELETE
	);
	//print_r($_REQUEST);
	exit;
	break;
    case 'validate_template_name':
	$message = '';
	$filename = $basics->get_valid_filename_from_string($_REQUEST['input_string']);
	if(strlen($filename) < 5){
	    $message = sprintf(ERROR_TEMPLATE_FILENAME_TOO_SHORT,$filename);
	}
	$filename = substr($filename,0,25);
	if(is_file(\main::get_importdata_path().'amazon_export_templates/'.$flatfile.'/'.$filename.$ae_template_extension)){
	    $message = sprintf(ERROR_TEMPLATE_FILENAME_EXISTS,$filename);
	}
	die(json_encode(array(
	    'filename'=>$filename.$ae_template_extension,
	    'message'=>$message
	)));
	break;
    case 'get_flatfile_templates':
	$templates = array();
	$tpl_path = \main::get_importdata_path().'amazon_export_templates/'.$flatfile.'/';
	if(!is_dir($tpl_path)) {
		mkdir($tpl_path);
	}
	if ($handle = opendir($tpl_path)) {
	    while (false !== ($file = readdir($handle))) {
			if(strcmp( substr($file,strlen($file)-strlen($ae_template_extension),strlen($ae_template_extension)),$ae_template_extension ) == 0){
				$templates[] = $file;
			}
	    }
	}
	sort($templates);
	
	$values = array(array('id'=>'','text'=>TEXT_SELECT));
	foreach($templates as $tpl){
	    $values[] = array('id'=>$tpl,'text'=>$tpl);
	}
	$values[] = array('id'=>'add','text'=>TEXT_NEW_AMAZON_EXPORT_TEMPLATE);
	header('Content-Type: text/html; charset='.CHARSET);
	echo TEXT_AMAZON_EXPORT_TEMPLATE.': '.xtc_draw_pull_down_menu('template',$values,'','onchange="template_select(this)"');
	exit;
	break;
    case 'product_groups_characteristic_select':
        $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
	if(!isset($gh->groups) or !is_countable($gh->groups) or !sizeOf($gh->groups)){
	    die('Keine Produktgruppen hinterlegt');
	}
	$groups = array();
	$chars = array();
        $gID = (int)xtc_db_input($_REQUEST['groups_id']);
	foreach($gh->groups as $g){
	    if(is_countable($g['characteristics']) and sizeOf($g['characteristics'])>0){
		if($g['groups_id'] == $gID){
                    foreach($g['characteristics'] as $char){
			$chars[] = array(
			    'id'=>$char['products_characteristic_id'],
			    'text'=>$char['description']['title']
			);
                    }
		}
		$groups[] = array(
		    'id'=>$g['groups_id'],
		    'text'=>$g['groups_title'],
		);
	    }
	}
	$show_groups = ($gID > 0) ? true : false;
	$input_char = ($gID > 0) ? TEXT_PRODUCT_GROUP_SET.'<br />'.xtc_draw_pull_down_menu('characteristics',$chars,'','size="10" class="char_select"') : '';
	$smarty->assign(array(
	    'action'=>$action,
	    'INPUT_GROUPS'=>TEXT_PRODUCT_GROUP.'<br />'.xtc_draw_pull_down_menu('group',$groups,'','size="10" class="group_select"'),
	    'SHOW_GROUPS'=>$show_groups,
	    'INPUT_CHARACTERISTICS'=>$input_char,
	    'MODULE'=>((isset($_REQUEST['module'])?$_REQUEST['module']:''))
	));
	header('Content-Type: text/html; charset='.CHARSET);
	$smarty->display('yes_export_modules_helper.html');
	exit;
	break;
    case 'quickadd':
	$array = array();
	$lang_id = $_SESSION['languages_id'];
	$slaves_include = false;
	$parent_sku = '';
	foreach($_REQUEST['products_id'] as $pID){
	    $query = xtc_db_query(sprintf(
		    "SELECT products_id,amazon_flatfile,amazon_browse_node_id,allow_amazon FROM products p LEFT JOIN products_description pd USING(products_id) WHERE p.products_id='%s' AND language_id='%s'",
		    (int)xtc_db_input($pID),$lang_id
	    ));
	    if(xtc_db_num_rows($query)){
		$master_copy = true;
		$record = xtc_db_fetch_array($query);
		if(!isset($array[ $record['amazon_flatfile'] ])) $array[ $record['amazon_flatfile'] ] = array();
		$array[ $record['amazon_flatfile'] ][] = $record;
		$query = xtc_db_query(sprintf(
			"SELECT p.products_id,amazon_flatfile,amazon_browse_node_id,allow_amazon FROM products p LEFT JOIN amazon_products ap USING(products_id) LEFT JOIN products_description pd USING(products_id) WHERE ap.amazon_products_id IS NULL AND p.products_master='%s' AND p.products_status=1 AND p.allow_amazon!=2 AND pd.amazon_flatfile='%s' AND pd.amazon_browse_node_id != '' AND pd.language_id='%s'",
			$record['products_id'],$record['amazon_flatfile'],$lang_id
		));
		while($record2 = xtc_db_fetch_array($query)){
		    if($master_copy){
			// COPY VOM MASTER ANLEGEN, DA BEI MASTER/SLAVE DER MASTER 2x VERWENDET WIRD
			$array[ $record['amazon_flatfile'] ][] = $record; 
			$master_copy = false;
			$parent_sku = $record['products_id'].'-PARENT';
		    }
		    $slaves_include = true;
		    $array[ $record['amazon_flatfile'] ][] = $record2;
		}
	    }
	    
	}
	if(!sizeOf($array)){
	    header('Content-Type: text/html; charset='.CHARSET);
	    die(ERROR_NO_VALID_PRODUCTS_FOR_AMAZON_EXPORT);
	}
	$error_message = '';
	foreach($array as $flatfile_template => $items){
	    $fft_parts = explode(':',$flatfile_template);
	    $flatfile = $fft_parts[0];
	    $template = $fft_parts[1];
	    if(!is_file(\main::get_importdata_path().''.$tpl_config_dir . $flatfile.'/'.$template)){
		$error_message .= sprintf(ERROR_MISSING_AMAZON_FLATFILE_CONFIGURATION,$template).'<br />';
	    }
	    foreach($items as $item){
		if( empty($item['amazon_flatfile']) or empty($item['amazon_browse_node_id']) ){
		    $error_message .= sprintf(ERROR_MISSING_AMAZON_CONFIGURATION_FOR_PRODUCT,$item['products_id']).'<br />';
		}
		if( $item['allow_amazon'] == 2){
		    $error_message .= sprintf(ERROR_PRODUCT_NOT_ALLOWED_FOR_AMAZON_EXPORT,$item['products_id']).'<br />';
		}
	    }
	}
	if($error_message != ''){
	    die($error_message);
	}
	foreach($array as $flatfile_template=>$_items){
	    $fft_parts = explode(':',$flatfile_template);
	    $flatfile = $fft_parts[0];
	    $template = $fft_parts[1];
	    $products_id_array = array();
	    foreach($_items as $_item){
		$products_id_array[] = $_item['products_id'];
	    }
	    $yep->import_modules();
	    $path = $ae->get_amazon_template_location($flatfile);
	    $content = $basics->read_file_content($path.'/'.$flatfile, 'r');
	    $lines = explode(PHP_EOL,$content);
	    $cols_german = explode(",",$lines[1]);

	    $items = array();
	    $query_raw = "SELECT p.products_id,p.products_model,p.products_price,pd.products_name,p.products_ean,p.products_quantity FROM products_description pd LEFT JOIN products_collies pcol USING(products_id) ";
	    $query_raw .= ", products p ";
	    $query_raw .= " WHERE pd.products_id=p.products_id AND pd.language_id='".$_SESSION['languages_id']."' and pcol.products_id IS NULL AND p.products_id IN(".implode(',',$products_id_array).")";

	    $query = xtc_db_query( $query_raw );
	    $records_num = xtc_db_num_rows($query);
	    $ae_module_config = parse_ini_file(
			\main::get_importdata_path().$tpl_config_dir . $flatfile.'/'.$template,
			true
		);
	    foreach($ae_module_config as $space_name => $space){
		    foreach($space as $k=>$v){
			    $ae_module_config[$space_name][$k] = str_replace("'",'',$v);
		    }
	    }
	    $yep_modules = $yep->get_modules();
	    $field_names = array();
	    $field_config = array();
	    $field_mandatory_array = array();
	    $counter = 0;
	    foreach($ae_module_config['module_mandatory'] as $field => $type){
		$field_mandatory_array[$field] = $type; // immer 1
	    }
	    if($slaves_include){
		$field_mandatory_array['relationship_type'] = 1;
		$field_mandatory_array['parent_child'] = 1;
		$field_mandatory_array['parent_sku'] = 1;
		$field_mandatory_array['variation_theme'] = 1;
		$field_mandatory_array['color_name'] = 1;
		$field_mandatory_array['size_name'] = 1;
	    }
	    
	    foreach($ae_module_config['module_type'] as $field => $type){

		$field_names[ $field ] = $cols_german[$counter];
		$src = $ae_module_config['module_src'][$field];
		if(isset($ae_module_config['module_src'][$field])){
		    switch($ae_module_config['module_src'][$field]){
			case 'amazon':
			    break;
			default:
			    $yep_modules_name = 'yes_export_module_'.$ae_module_config['module_src'][$field];
			    $src = $yep->get_module_by_name($yep_modules_name);
			    break;
		    }
		}
		$value = '';
		if(isset($ae_module_config['module_default_value'][$field])){
		    $value = $ae_module_config['module_default_value'][$field];
		}
		$values = array();
		$predefined_array = $ae->get_flatfile_config($flatfile, $field);
		if(sizeOf($predefined_array)){
		    foreach($predefined_array as $val){
			$values[] = array(
			    'id'=>$val,
			    'text'=>$val
			);
		    }
		}
		$field_config[$field] = array(
		    'type'=>$ae_module_config['module_type'][$field],
		    'src'=>$src,
		    'value'=>$value,
		    'select_values'=>$values,
		    'mandatory'=>(isset($ae_module_config['module_mandatory'][$field]))?1:0
		);
		$counter++;
	    }
	    if($records_num > 0){
		$counter = 0;
		$slave_include_allow = true; // wird bei master/slaves verwendet fuer init master
		while($record = xtc_db_fetch_array($query)){
		    $img_counter = 0;
		    $YEP_PRODUCT_INSTANCE = new product($record['products_id']);
		    $YEP_PRODUCTS_QUANTITY_INSTANCE = new products_quantity($YEP_PRODUCT_INSTANCE->info['products_id']);
		    $YES_XTPRICE_INSTANCE_GUEST = new xtcPrice(DEFAULT_CURRENCY,1); // 1 ist Gast
		    $YEP_PRODUCT_INSTANCE->xtPrice = $YES_XTPRICE_INSTANCE_GUEST;
		    $item = array();
		    foreach($field_config as $field => $config){
			$pg_info_str = ''; // bei produktgruppen setzen wir die Merkmaltitel hinter das Input Feld
			$values_array = array();
			$value = $config['value'];
			if($slaves_include){
			    switch($field){
				case 'relationship_type':
				    $value = 'Variation';
				    break;
				case 'parent_child':
				    $value = 'child';
				    break;
				case 'parent_sku':
				    $value = $parent_sku;
				    break;
			    }
			}
			switch($config['src']){
			    case 'amazon':
				$values_array = $config['select_values'];
				$item[] = array(
				    'input'=>xtc_draw_pull_down_menu($field.'[]',$values_array,$value),
				    'id'=>$field,
				    'value'=>$value
				);
				break;
			    default:
				if($config['type'] == 'image'){
				    $values_array = $config['src']->get_values_from_product_instance($YEP_PRODUCT_INSTANCE);
				}
				switch($config['src']->id){
				    case 'own_value':
					break;
				    case 'product_group_characteristic':
					$pg_info_str = $config['src']->get_pgc_string($value);
					$value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$value);
					break;
				    case 'products_name_amazon':
					$value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$slaves_include);
					break;
				    default:
					if($config['type'] == 'image' and sizeOf($values_array)){
					    $value = $values_array[$img_counter+1]['id'];
					    if( $img_counter < sizeOf($values_array)){
						$img_counter++;
					    }
					}else{
					    $value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$YEP_PRODUCTS_QUANTITY_INSTANCE);
					}
					break;
				}
				$item[] = array(
				    'input'=>$config['src']->get_input_field($config['type'],$field.'[]',$value,$values_array).$pg_info_str,
				    'id'=>$field,
				    'value'=>$value
				);
				break;
			}
		    }
		    $items[] = $item;
		    $counter++;
		}
	    }
	    if($slaves_include){
		$img_counter = 0;
		$record['products_id'] = (int)xtc_db_input(current($_REQUEST['products_id']));
		
		$YEP_PRODUCT_INSTANCE = new product($record['products_id']);
		$YEP_PRODUCTS_QUANTITY_INSTANCE = new products_quantity($YEP_PRODUCT_INSTANCE->info['products_id']);
		$YES_XTPRICE_INSTANCE_GUEST = new xtcPrice(DEFAULT_CURRENCY,1); // 1 ist Gast
		$YEP_PRODUCT_INSTANCE->xtPrice = $YES_XTPRICE_INSTANCE_GUEST;
		$item = array();
		foreach($field_config as $field => $config){
		    $values_array = array();
		    if(in_array($field, array('external_product_id','external_product_id_type','quantity','standard_price','currency','condition_type','relationship_type'))){
			$value = '';
			$item[] = array(
			    'input'=>xtc_draw_hidden_field($field.'[]',$value).'-',
			    'id'=>$field,
			    'value'=>$value,
			    'master'=>true
			);
		    }else{
			$params = '';
			$value = $config['value'];
			switch($field){
			    case 'relationship_type':
				$value = 'Variation';
				break;
			    case 'parent_child':
				$value = 'parent';
				break;
			    case 'parent_sku':
				$value = '';
				break;
			}
			switch($config['src']){
			    case 'amazon':
				$values_array = $config['select_values'];
				if(in_array($field,array('color_name','size_name') ) ){
				    $values_array = array(array('id'=>'','text'=>'-'));
				    $value = '';
				}
				$item[] = array(
				    'input'=>xtc_draw_pull_down_menu($field.'[]',$values_array,$value,$params),
				    'id'=>$field,
				    'value'=>$value,
				    'master'=>true
				);
				break;
			    default:
				if($config['type'] == 'image'){
				    $values_array = $config['src']->get_values_from_product_instance($YEP_PRODUCT_INSTANCE);
				}
				switch($config['src']->id){
				    case 'own_value':
					break;
				    case 'product_group_characteristic':
					$value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$value);
					break;
				    case 'products_name_amazon':
					$value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE);
					break;
				    case 'products_id':
					$config['type'] = ''; // VON INT AUF STRING SETZEN
					$value = $parent_sku;
					break;
				    default:
					if($config['type'] == 'image' and sizeOf($values_array)){
					    $img_counter++;
					    $value = $values_array[$img_counter+1]['id'];
					}else{
					    $value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$YEP_PRODUCTS_QUANTITY_INSTANCE);
					}
					break;
				}
				if(in_array($field,array('parent_sku') ) ){
				    // INAKTIVE FELDER
				    $item[] = array(
					'input'=>xtc_draw_hidden_field($field.'[]','').'-',
					'id'=>$field,
					'value'=>$value,
					'master'=>true
				    );
				}else{
				    $item[] = array(
					'input'=>$config['src']->get_input_field($config['type'],$field.'[]',$value,$values_array),
					'id'=>$field,
					'value'=>$value,
					'master'=>true
				    );
				}
				break;
			}
		    } // EOF if master field
		}
		array_unshift($items, $item);
	    }
	    $smarty->assign(array(
		'MODE'=>'quickadd',
		'FIELD_NAMES'=>$field_names,
		'FIELD_MANDATORY_ARRAY'=>$field_mandatory_array,
		'ITEMS_NUM'=>$records_num,
		'ITEMS'=>$items,
		'FORM'=>xtc_draw_form('export_form','amazon_export.php',xtc_get_all_get_params(array('action')).'action=export_process','POST'),
		'IMAGE_EXPORT'=>IMAGE_EXPORT
	    ));
	    $smarty->display('amazon_export_quickadd.html');
	}
	exit;
	break;
    case 'export_process':
	$pID_array = array();
	$error = '';
	if(!isset($_REQUEST['merchant_id']) or empty($_REQUEST['merchant_id'])){
	    $error = 'No merchant selected';
	    if(isset($_REQUEST['products_id'])){
		die(json_encode(array(
		    'ERROR'=>$error
		)));
	    }else{
		$messageStack->add_session($error,'error');
		xtc_redirect(xtc_href_link(FILENAME_CATEGORIES));
	    }
	}
	$merchant_id = xtc_db_input($_REQUEST['merchant_id']);
	if(isset($_REQUEST['products_id'])){
	    foreach($_REQUEST['products_id'] as $pID){
		$flatfile_template = yes_get_products_amazon_flatfile($pID, $_SESSION['languages_id']);
		$ff_parts = explode(':',$flatfile_template);
		$flatfile = $ff_parts[0];
		$template = $ff_parts[1];
	    }
	}else{
		$flatfile = xtc_db_input($_REQUEST['flatfile']);
		$template = xtc_db_input($_REQUEST['template']);
	}
	$content = file_get_contents( $ae->get_amazon_template_location($flatfile).'/'.$flatfile );
	$lines = explode("\r\n",$content);
	$csv = array();
	foreach($lines as $line){
	    if(trim($line) != '')
		$csv[] = explode(',',$line);
	}
	$csv_data = array();
	$items_num = sizeOf($_POST['item_sku']);
	for($i=0;$i<$items_num;$i++){
	    foreach($csv[2] as $key){
		$csv_data[$i][] = (isset($_POST[$key][$i])) ? $_POST[$key][$i] : '';
	    }
	}
	foreach($csv_data as $line){
	    $csv[] = $line;
	}
	$csv_str = '';
	foreach($csv as $line){
	    $csv_str .= implode("\t",$line)."\r\n";
	}
	if($items_num == 1 and isset($_REQUEST['products_id'])){
	    $filename = 'AE_'.$merchant_id.'_PID'.current($_REQUEST['products_id']).'.amzn';
	}else{
	    $filename = 'AE_'.$merchant_id.'_PID-'.date('Y-m-d_H_i_s').'-'.sizeOf($_REQUEST['item_sku']).'.amzn';
	}
	if(!is_file($amazon_export_data_dir.$filename)){
	    $basics->create_file($amazon_export_data_dir.$filename,$csv_str);
	    $pID_array[] = $pID;
	}else{
	    $error .= $pID." exists and is not processed\r\n";
	}
	if(isset($_REQUEST['products_id'])){
	    die(json_encode(array(
		'PRODUCTS_ID_ARRAY'=>$pID_array,
		'ERROR'=>$error
	    )));
	}else{
	    $messageStack->add_session(sprintf('Es wurden %s Artikeldaten f&uuml;r Amazon exportiert.',sizeOf($_REQUEST['item_sku'])),'success');
	    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES));
	}
	exit;
	break;
    case 'select_browse_node_id':
	
	$languages = xtc_get_languages();
	foreach($languages as $lang){
	    if($lang['id'] == $_REQUEST['lang']){
		$lang_dir = $lang['directory'];
	    }
	}
	$btgfile = '';
	$ae = new amazon_export($lang_dir);
	$amazon_flatfiles = $ae->get_amazon_flatfiles();
	foreach($amazon_flatfiles as $ff){
	    if($ff['id'] == $_REQUEST['template']){
		$flatfile_path = $ff['text'];
		$btgfile = $ff['btgfile'];
	    }
	}
	$file_content = $basics->read_file_content(DIR_FS_ADMIN.'includes/amazon_flatfiles/'.$lang_dir.'/'.$flatfile_path.'/'.$btgfile,'r');
	$lines = explode(PHP_EOL,$file_content);
	$data = array();
	foreach($lines as $nr => $line){
	    if($nr == 0) continue;
	    if(!empty($line)){
		$parts = explode(',',$line);
		$data[] = array('id'=>$parts[0],'text'=>$parts[1]);
	    }
	}
	$smarty->assign(array(
	    'MODE'=>'select_browse_node_id',
	    'ITEMS'=>$data,
	    'DEFAULT' => (isset($_REQUEST['default'])) ? $_REQUEST['default'] : ''
	));
	header('Content-Type: text/html; charset='.CHARSET);
	$smarty->display('amazon_select_browse_node_id.html');
	exit;
	break;
    case 'export':
	$path = $ae->get_amazon_template_location($flatfile);
	$content = $basics->read_file_content($path.'/'.$flatfile, 'r');
	$lines = explode(PHP_EOL,$content);
	$cols_german = explode(",",$lines[1]);
	
	$items = array();
	$query_raw = "SELECT p.products_id,p.products_model,p.products_price,pd.products_name,p.products_ean,p.products_quantity FROM products_description pd LEFT JOIN products_collies pcol USING(products_id) ";
	if(isset($_REQUEST['cat']) and sizeOf($_REQUEST['cat'])){
		$query_raw .= ", products_to_categories p2c ";
	}
	$query_raw .= ", products p LEFT JOIN amazon_products ap USING(products_id)";
	$query_raw .= " WHERE pd.products_id=p.products_id AND pd.language_id='".$_SESSION['languages_id']."' and pcol.products_id IS NULL and p.products_master=0 ";
	if(isset($_REQUEST['cat']) and sizeOf($_REQUEST['cat'])){
		$query_raw .= " AND p.products_id=p2c.products_id ".$pe->getP2CWhereSQLString(@$_REQUEST['allCat'],@$_REQUEST['cat']);
	}
	if(isset($_REQUEST['pID']) and is_array($_REQUEST['pID']) and sizeOf($_REQUEST['pID'])){
	    $in_sql = array();
	    foreach($_REQUEST['pID'] as $pID){
		$in_sql[] = (int)xtc_db_input($pID);
	    }
	    $query_raw .= sprintf(' AND p.products_id IN(%s)',implode(',',$in_sql));
	}
	$query_raw .= " AND ap.amazon_products_id IS NULL AND p.products_ean != '' AND pd.amazon_flatfile = '".$flatfile.':'.$template."' AND amazon_browse_node_id != '' LIMIT 500";
	$query = xtc_db_query( $query_raw );
	$records_num = xtc_db_num_rows($query);
	$ae_module_config = parse_ini_file(
		\main::get_importdata_path().$tpl_config_dir .$flatfile.'/'.$template,
		true
	);
	foreach($ae_module_config as $space_name => $space){
		foreach($space as $k=>$v){
			$ae_module_config[$space_name][$k] = str_replace("'",'',$v);
		}
	}
	$yep_modules = $yep->get_modules();
	$field_names = array();
	$field_config = array();
	$field_mandatory_array = array();
	$counter = 0;
	foreach($ae_module_config['module_mandatory'] as $field => $type){
	    $field_mandatory_array[$field] = $type; // immer 1
	}
	foreach($ae_module_config['module_type'] as $field => $type){
	    $field_names[ $field ] = $cols_german[$counter];
	    $src = $ae_module_config['module_src'][$field];
	    if(isset($ae_module_config['module_src'][$field])){
		switch($ae_module_config['module_src'][$field]){
		    case 'amazon':
			break;
		    default:
			$yep_modules_name = 'yes_export_module_'.$ae_module_config['module_src'][$field];
			$src = $yep->get_module_by_name($yep_modules_name);
			break;
		}
	    }
	    $value = '';
	    if(isset($ae_module_config['module_default_value'][$field])){
		$value = $ae_module_config['module_default_value'][$field];
	    }
	    $values = array();
	    $predefined_array = $ae->get_flatfile_config($flatfile, $field);
	    if(sizeOf($predefined_array)){
		foreach($predefined_array as $val){
		    $values[] = array(
			'id'=>$val,
			'text'=>$val
		    );
		}
	    }
	    $field_config[$field] = array(
		'type'=>$ae_module_config['module_type'][$field],
		'src'=>$src,
		'value'=>$value,
		'select_values'=>$values,
		'mandatory'=>(isset($ae_module_config['module_mandatory'][$field]))?1:0
	    );
	    $counter++;
	}
	if($records_num > 0){
	    $counter = 0;
	    while($record = xtc_db_fetch_array($query)){
		$YEP_PRODUCT_INSTANCE = new product($record['products_id']);
		$YEP_PRODUCTS_QUANTITY_INSTANCE = new products_quantity($YEP_PRODUCT_INSTANCE->info['products_id']);
		$YES_XTPRICE_INSTANCE_GUEST = new xtcPrice(DEFAULT_CURRENCY,1); // 1 ist Gast
		$YEP_PRODUCT_INSTANCE->xtPrice = $YES_XTPRICE_INSTANCE_GUEST;
		$item = array();
		foreach($field_config as $field => $config){
		    $values_array = array();
		    $value = $config['value'];
		    switch($config['src']){
			case 'amazon':
			    $values_array = $config['select_values'];
			    $item[] = array(
				'input'=>xtc_draw_pull_down_menu($field.'[]',$values_array,$value),
				'id'=>$field
			    );
			    break;
			default:
			    switch($config['src']->id){
				case 'own_value':
				    break;
				case 'product_group_characteristic':
				    $value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$value);
				    break;
				default:
				    $value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$YEP_PRODUCTS_QUANTITY_INSTANCE);
				    break;
			    }
			    if($config['type'] == 'image'){
				$values_array = $config['src']->get_values_from_product_instance($YEP_PRODUCT_INSTANCE);
			    }
			    $item[] = array(
				'input'=>$config['src']->get_input_field($config['type'],$field.'[]',$value,$values_array),
				'id'=>$field
			    );
			    break;
		    }
		}
		$items[] = $item;
		$counter++;
	    }
	}
	$smarty->assign(array(
	    'MODE'=>'export',
	    'FIELD_NAMES'=>$field_names,
	    'FIELD_MANDATORY_ARRAY'=>$field_mandatory_array,
	    'ITEMS_NUM'=>$records_num,
	    'ITEMS'=>$items,
	    'FORM'=>xtc_draw_form('export_form','amazon_export.php',xtc_get_all_get_params(array('action')).'action=export_process','POST'),
	    'IMAGE_EXPORT'=>IMAGE_EXPORT
	));
	break;
    case 'save_template_source_config':
		$yep->write_ini_file(
			\main::get_importdata_path().$tpl_config_dir.$flatfile.'/'.$template
		);
		xtc_redirect(xtc_href_link('amazon_export.php',xtc_get_all_get_params(array('action'))));
		break;
    case 'install_template':
		$path = $ae->get_amazon_template_location($flatfile);
		$content = $basics->read_file_content($path.'/'.$flatfile, 'r');
		$lines = explode(PHP_EOL,$content);
		$cols_german = explode(",",$lines[1]);
		$cols = explode(",",$lines[2]);
		$input_fields = array();
		$yep->read_ini_data(\main::get_importdata_path().$tpl_config_dir . $flatfile.'/'.$template);
		foreach($cols as $nr=>$col){
	    $col = trim($col);
	    $predefined_array = $ae->get_flatfile_config($flatfile, $col);
	    $mandatory = (isset($yep->config['module_mandatory'][$col])) ? $yep->config['module_mandatory'][$col] : false;
	    $default_value = (isset($yep->config['module_default_value'][$col])) ? $yep->config['module_default_value'][$col] : '';
	    if(sizeOf($predefined_array)){
		$values = array();
		foreach($predefined_array as $val){
		    $values[] = array(
			'id'=>$val,
			'text'=>$val
		    );
		}
		$input_fields[] = array(
		    'src'=>'Amazon Werte'.xtc_draw_hidden_field('module_src['.$col.']','amazon'),
		    'amazon_predefine'=>1,
		    'id'=>$col,
		    'text'=>$cols_german[$nr],
		    'input'=>xtc_draw_pull_down_menu('module_default_value['.$col.']',$values,$default_value),
		    'mandatory'=>$mandatory,
		    'type'=>TEXT_YES_EXPORT_MODULES_TYPE_SELECT.  xtc_draw_hidden_field('module_type['.$col.']', 'select')
		);
	    }else{
		$src = (isset($yep->config['module_src'][$col])) ? $yep->config['module_src'][$col] : 'own_value';
		$src_class_name = 'yes_export_module_'.$src;
		$src_class = new $src_class_name($col);
		$src_title = $src_class->text;
		$type_title = constant('TEXT_YES_EXPORT_MODULES_TYPE_'.strtoupper($src_class->type));
		$type = $src_class->type;
		if(isset($yep->config['module_type'][$col]) and $type != $yep->config['module_type'][$col]){
			$type = $yep->config['module_type'][$col];
			$type_title = constant('TEXT_YES_EXPORT_MODULES_TYPE_'.strtoupper($type));
		}
		$input_fields[] = array(
		    'id'=>$col,
		    'text'=>$cols_german[$nr],
		    'input'=>xtc_draw_input_field('module_default_value['.$col.']',$default_value),
		    'mandatory'=>$mandatory,
		    'src'=>$src_title.xtc_draw_hidden_field('module_src['.$col.']',$src),
		    'type'=>$type_title.xtc_draw_hidden_field('module_type['.$col.']', $type),
		    'input_special_edit'=>$src_class->get_input_special_edit(),
		    'input_subtitle'=>$src_class->get_input_subtitle($default_value)
		);
	    }
	}
	
	$smarty->assign(array(
	    'TEMPLATE'=>$template,
	    'INPUT_VALUES'=>$input_fields,
	    'MODE'=>'install_template',
    	    'FORM'=>xtc_draw_form('template_source_config','amazon_export.php',xtc_get_all_get_params(array('action')).'action=save_template_source_config')
	));
	break;
    default:
	$flatfiles = $ae->get_amazon_flatfiles();
	array_unshift($flatfiles,array('id'=>'','text'=>TEXT_SELECT,'btgfile'=>''));
	if($flatfile != ''){
	    $yep->read_ini_data(\main::get_importdata_path().$tpl_config_dir . $flatfile.'/'.$template);
	    if(!sizeOf($yep->config)){
			xtc_redirect(xtc_href_link('amazon_export.php',xtc_get_all_get_params(array('action')).'action=install_template'));
	    }
	    $path = $ae->get_amazon_template_location($flatfile);
	    $content = $basics->read_file_content($path.'/'.$flatfile, 'r');
	    $lines = explode("\r\n",$content);
	    $cols_german = explode(",",$lines[1]);
	    
	    $items = array();
	    $query_raw = sprintf(
		    "SELECT p.products_id,p.products_model,p.products_price,pd.products_name,p.products_ean,p.products_quantity FROM products p LEFT JOIN products_description pd USING(products_id) LEFT JOIN amazon_products ap USING(products_id) WHERE pd.language_id=2 AND pd.amazon_flatfile='%s' AND p.products_status=1 AND p.allow_amazon != 2 AND ap.amazon_products_id IS NULL AND p.products_ean != '' AND amazon_browse_node_id != '' AND products_master_status=0",
		    $flatfile.':'.$template
	    );
	    $qnr_parts = explode('from',strtolower($query_raw));
	    $qnr_select = str_replace('select','',strtolower(current($qnr_parts)));
	    $query_num_raw = str_replace($qnr_select,' COUNT(p.products_id) AS anz ',$query_raw);
	    $total_num_query = xtc_db_query($query_num_raw);
	    $total_num_record = xtc_db_fetch_array($total_num_query);
	    $total_num = $total_num_record['anz'];
	    
	    $query_raw .= " LIMIT 100";
	    $query = xtc_db_query($query_raw);
/*	    
	$query_raw .= " AND ap.amazon_products_id IS NULL AND p.products_ean != '' AND pd.amazon_flatfile = '".$template."' AND amazon_browse_node_id != '' LIMIT 500";
	$query = xtc_db_query( $query_raw );
 * 
 */
	    $records_num = xtc_db_num_rows($query);
	    $ae_module_config = parse_ini_file(
			\main::get_importdata_path().$tpl_config_dir . $flatfile.'/'.$template,
			true
		);
	    foreach($ae_module_config as $space_name => $space){
		    foreach($space as $k=>$v){
			    $ae_module_config[$space_name][$k] = str_replace("'",'',$v);
		    }
	    }
	    $yep_modules = $yep->get_modules();
	    $field_names = array();
	    $field_config = array();
	    $field_mandatory_array = array();
	    $counter = 0;
	    foreach($ae_module_config['module_mandatory'] as $field => $type){
		$field_mandatory_array[$field] = $type; // immer 1
	    }
	    foreach($ae_module_config['module_type'] as $field => $type){
		$field_names[ $field ] = $cols_german[$counter];
		$src = $ae_module_config['module_src'][$field];
		if(isset($ae_module_config['module_src'][$field])){
		    switch($ae_module_config['module_src'][$field]){
			case 'amazon':
			    break;
			default:
			    $yep_modules_name = 'yes_export_module_'.$ae_module_config['module_src'][$field];
			    $src = $yep->get_module_by_name($yep_modules_name);
			    break;
		    }
		}
		$value = '';
		if(isset($ae_module_config['module_default_value'][$field])){
		    $value = $ae_module_config['module_default_value'][$field];
		}
		$values = array();
		$predefined_array = $ae->get_flatfile_config($flatfile, $field);
		if(sizeOf($predefined_array)){
		    foreach($predefined_array as $val){
			$values[] = array(
			    'id'=>$val,
			    'text'=>$val
			);
		    }
		}
		$field_config[$field] = array(
		    'type'=>$ae_module_config['module_type'][$field],
		    'src'=>$src,
		    'value'=>$value,
		    'select_values'=>$values,
		    'mandatory'=>(isset($ae_module_config['module_mandatory'][$field]))?1:0
		);
		$counter++;
	    }
	    if($records_num > 0){
		$counter = 0;
		while($record = xtc_db_fetch_array($query)){
		    $YEP_PRODUCT_INSTANCE = new product($record['products_id']);
		    $YEP_PRODUCTS_QUANTITY_INSTANCE = new products_quantity($YEP_PRODUCT_INSTANCE->info['products_id']);
		    $YES_XTPRICE_INSTANCE_GUEST = new xtcPrice(DEFAULT_CURRENCY,1); // 1 ist Gast
		    $YEP_PRODUCT_INSTANCE->xtPrice = $YES_XTPRICE_INSTANCE_GUEST;
		    $item = array();
		    foreach($field_config as $field => $config){
			$values_array = array();
			$value = $config['value'];
			switch($config['src']){
			    case 'amazon':
				$values_array = $config['select_values'];
				$item[] = array(
				    'input'=>xtc_draw_pull_down_menu($field.'[]',$values_array,$value),
				    'id'=>$field
				);
				break;
			    default:
				switch($config['src']->id){
				    case 'own_value':
					break;
				    case 'product_group_characteristic':
					$value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$value);
					break;
				    default:
					$value = $config['src']->get_value_from_product_instance($YEP_PRODUCT_INSTANCE,$YEP_PRODUCTS_QUANTITY_INSTANCE);
					break;
				}
				if($config['type'] == 'image'){
				    $values_array = $config['src']->get_values_from_product_instance($YEP_PRODUCT_INSTANCE);
				}
				$item[] = array(
				    'input'=>$config['src']->get_input_field($config['type'],$field.'[]',$value,$values_array),
				    'id'=>$field
				);
				break;
			}
		    }
		    $items[] = $item;
		    $counter++;
		}
	    }
	    $smarty->assign(array(
		'MODE'=>'export',
		'FIELD_NAMES'=>$field_names,
		'FIELD_MANDATORY_ARRAY'=>$field_mandatory_array,
		'ITEMS_NUM'=>$records_num,
		'TOTAL_NUM'=>$total_num,
		'ITEMS'=>$items,
		'FORM'=>xtc_draw_form('export_form','amazon_export.php',xtc_get_all_get_params(array('action')).'action=export_process','POST'),
		'IMAGE_EXPORT'=>IMAGE_EXPORT
	    ));
	    $templates = array();
	    $tpl_path = \main::get_importdata_path().'amazon_export_templates/'.$flatfile.'/';
	    if(!is_dir($tpl_path)) mkdir($tpl_path);
	    if ($handle = opendir($tpl_path)) {
		while (false !== ($file = readdir($handle))) {
		    if(strcmp( substr($file,strlen($file)-strlen($ae_template_extension),strlen($ae_template_extension)),$ae_template_extension ) == 0){
				$templates[] = $file;
		    }
		}
	    }
	    sort($templates);

	    $values = array(array('id'=>'','text'=>TEXT_SELECT));
	    foreach($templates as $tpl){
			$values[] = array('id'=>$tpl,'text'=>$tpl);
	    }
	    $values[] = array('id'=>'add','text'=>TEXT_NEW_AMAZON_EXPORT_TEMPLATE);
	    $templates = $values;
	}else{ // EOF isset flatfile
	    $templates = array();
	}
	    
	$smarty->assign(array(
	    'INPUT_FLATFILE'=>xtc_draw_pull_down_menu('flatfile',$flatfiles,$flatfile,'id="flatfile_select"'),
	    'FLATFILE'=>$flatfile,
	    'INPUT_TEMPLATE'=>xtc_draw_pull_down_menu('template',$templates,$template,'id="template_select"'),
	    'TEMPLATE'=>$template,
	    /*'CATEGORIES'=>$pe->getCategoriesString(),
	    'CATEGORIES_JS'=>'',*/
	    'CONFIG_FILE'=>1,
	    'TEXT_IMPORT_PRODUCTS_FROM_ALL_CATEGORIES'=>TEXT_IMPORT_PRODUCTS_FROM_ALL_CATEGORIES
	));
	
	break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
    $buttons = array();
    if(isset($_REQUEST['template']) and $_REQUEST['template'] != ''){
	if($action != 'install_template'){
	    $buttons[] = array('text'=>TEXT_LINK_INSTALL_TEMPLATE,
		'link'=>xtc_href_link('amazon_export.php',xtc_get_all_get_params(array('action')).'action=install_template'),
		'auth'=>true,
		'lbOn'=>false
	    );
	    $buttons[] = array('text'=>TEXT_LINK_DELETE_TEMPLATE,
		'link'=>xtc_href_link('amazon_export.php',xtc_get_all_get_params(array('action')).'action=delete_template_confirm'),
		'auth'=>true,
		'lbOn'=>true
	    );
	}else{
	    $buttons[] = array('text'=>IMAGE_BACK,
		'link'=>xtc_href_link('amazon_export.php'),
		'auth'=>true,
		'lbOn'=>false
	    );
	}
	$smarty->assign(array(
	    'ADDITIONAL_HEADING_TITLE'=>$_REQUEST['flatfile'].' / '.$_REQUEST['template'],
	    'TEXT_PRODUCT_SELECTOR'=>sprintf(TEXT_PRODUCT_SELECTOR,$template)
	));
    }

    $smarty->assign(array(
	'HEADING_TITLE'=>HEADING_TITLE,
	'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	'AE_NEW_TEMPLATE_NAME'=>AE_NEW_TEMPLATE_NAME,
	'JS_CONFIRM_REALLY_DELETE_TEMPLATE'=>JS_CONFIRM_REALLY_DELETE_TEMPLATE
    ));
    $smarty->display('amazon_export.html');
?>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
