<?php
// + includes/classes/amz_fba.php
function amz_encode($str){
	if(strtolower(CHARSET) != 'utf-8'){
		if(mb_detect_encoding($str) == 'UTF-8'){
			$str = utf8_decode($str);
		}
	}
	return $str;
}

function invokeGetMatchingProduct(MarketplaceWebServiceProducts_Interface $service, $request, $smarty)
{
	try {
		$response = $service->GetMatchingProduct($request);
		$dom = new DOMDocument();
		$dom->loadXML($response->toXML());
		$dom->preserveWhiteSpace = false;
		$dom->formatOutput = true;
		$xml = simplexml_load_string($dom->saveXML());
		$ns = $xml->getNamespaces(true);
		$attr_array = array();
		$attributes = $xml->GetMatchingProductResult->Product->AttributeSets->children($ns['ns2']);
		$img = '';
		$title = '';
		foreach($attributes->ItemAttributes as $katt=>$att){
			foreach(get_object_vars($attributes->$katt) as $k=>$v){
				$k = amz_encode($k);
				if(is_object($v)){
					if($k == 'SmallImage'){
						$img = $att->SmallImage->URL;
					}else{
						$varr = array();
						foreach(get_object_vars($v) as $vkatt=>$vv){
							$vkatt = amz_encode($vkatt);
							$vv = amz_encode($vv);
							$varr[] = $vkatt.'='.$vv;
						}
						$attr_array[] = $k.': '.implode(', ',$varr);
					}
				}else{
					$v = amz_encode($v);
					if($k == 'Title'){
						$title = $v;
					}else{
						$attr_array[] = $k.': '.$v;
					}
				}
			}
		}
		$product = $xml->GetMatchingProductResult->Product;
		$img_tag = ($img != '') ? '<img src="'.$img.'" border="0" />' : '<img src="images/icons/cross.gif" border="0" alt="no image available" title="no image available" />';
		$smarty->assign(array(
			'MODE'=>'amazon_product_info',
			'IMG'=>$img_tag,
			'TITLE'=>$title,
			'MARKETPLACE_ID'=>$product->Identifiers->MarketplaceASIN->MarketplaceId,
			'ATTRIBUTES'=>implode('<br />',$attr_array)
		));
		return $smarty->fetch('amazon_fba.html');
	} catch (MarketplaceWebServiceProducts_Exception $ex) {
		echo("Caught Exception: " . $ex->getMessage() . "\n");
		echo("Response Status Code: " . $ex->getStatusCode() . "\n");
		echo("Error Code: " . $ex->getErrorCode() . "\n");
		echo("Error Type: " . $ex->getErrorType() . "\n");
		echo("Request ID: " . $ex->getRequestId() . "\n");
		echo("XML: " . $ex->getXML() . "\n");
		echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
	}
}


include('includes/application_top.php');
include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_Helper.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_SubmitFeed.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/product.php');
include('includes/classes/class.basics.php');
include(DIR_WS_CLASSES.'amz_fba.php');
ini_set('memory_limit','1200M');
define('AMAZON_SAVE_PATH','exportdata/amazon/');
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}

$basics = new basics;
define('AMAZON_SAVE_PATH','exportdata/amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',5);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);
$ReportType = '_GET_AFN_INVENTORY_DATA_';
$A = new amazon_helper;
$AS = new amazon_service();
$service = $AS->get_service();
$smarty = new Smarty;
$smarty->compile_dir = DIR_FS_CATALOG.'templates_c';
$smarty->plugins_dir[] = DIR_FS_CATALOG.'includes/smarty_plugins/';
$smarty->caching = 0;
$smarty->assign(array(
	'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'HEADING_TITLE'=>HEADING_TITLE,
	'BASELINK'=>xtc_href_link(basename(__FILE__),'user='.$mercID),
	'AMAZON_FBA_ALLOCATED'=>AMAZON_FBA_ALLOCATED,
	'ALLOCATED_AS_AMAZON_PRODUCT'=>ALLOCATED_AS_AMAZON_PRODUCT,
));


// BOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER
$auth_user_array = $A->get_auth_user_array();
$user = array();
foreach($auth_user_array as $aa){
	$user[] = array('id'=>$aa, 'text'=>$aa);
}
if(isset($_GET['user']) and in_array($_GET['user'],$auth_user_array)){
	$mercID = $_GET['user'];
}else{
	$mercID = current($auth_user_array);
}

// EOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER

$auth_params = $A->get_auth_data_array($mercID);
$parameters = array (
    'Marketplace' => $auth_params['marketplace_id'],
    'Merchant' => $auth_params['merchant_id'],
    'AvailableToDate' => new DateTime('now'),
    'AvailableFromDate' => new DateTime('-1 Days'),
    'ReportTypeList'=>array ('Type' => array ($ReportType)),
    'MaxCount' => AMAZON_REPORTLIST_MAX_COUNT,
    'Acknowledged' => false
);
if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
}
$service = $AS->get_service();
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch($action){
	case 'allocate':
		$error = '';
		$pID = (int)xtc_db_input($_GET['pID']);
		$asin = xtc_db_input($_GET['asin']);
		$sku = xtc_db_input($_GET['sku']);
		$condition = xtc_db_input($_GET['condition']);
		$condition_code = xtc_db_input($_GET['condition_code']);
		$available = (int)xtc_db_input($_GET['available']);

		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM %s WHERE products_id='%s'",
			TABLE_PRODUCTS, $pID
		));
		if(empty($pID) or $pID < 1 or !xtc_db_num_rows($query)){
			$error = MSG_ERROR_UNKNOWN_PRODDUCTS_ID;
			die(json_encode(array(
				'MESSAGE'=>$error
			)));
		}
		$query = xtc_db_query(sprintf(
			"SELECT amazon_products_fba_id FROM amazon_products_fba WHERE (products_id='%s' or asin='%s') AND merchant_id='%s'",
			$pID,$asin,$mercID
		));
		if(xtc_db_num_rows($query)){
			$error = MSG_ERROR_PID_FBA_ALLOCATION_EXISTS;
			die(json_encode(array(
				'MESSAGE'=>$error
			)));
		}
		$insert_sql_array = array(
			'products_id'=>$pID,
			'seller_sku'=>$sku,
			'asin'=>$asin,
			'amazon_condition'=>$condition,
			'condition_code'=>$condition_code,
			'available'=>$available,
			'merchant_id'=>$mercID
		);
		xtc_db_perform('amazon_products_fba',$insert_sql_array);
		$comments = sprintf(TEXT_HISTORY_PRODUCT_FBA_ALLOCATION,
				$mercID, $asin, $sku, $available
		);
		$product = new product($pID);
		$product->add_history($comments);
		die(json_encode(array(
			'MESSAGE'=>''
		)));
		break;
	case 'allocate_stepwise':
		set_include_path(DIR_WS_CLASSES . PATH_SEPARATOR . 'MarketplaceWebServiceProducts');
		function __autoload($className){
			$filePath = str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php';
			$includePaths = explode(PATH_SEPARATOR, get_include_path());
			foreach($includePaths as $includePath){
			    if(file_exists($includePath . DIRECTORY_SEPARATOR . $filePath)){
				require_once $filePath;
				return;
			    }
			}
		}
		$serviceUrl = "https://mws-eu.amazonservices.com/Products/2011-10-01";
		$config = array (
			'ServiceURL' => $serviceUrl,
			'ProxyHost' => null,
			'ProxyPort' => -1,
			'ProxyUsername' => null,
			'ProxyPassword' => null,
			'MaxErrorRetry' => 3,
		);

		$service = new MarketplaceWebServiceProducts_Client(
			AWS_ACCESS_KEY_ID,
			AWS_SECRET_ACCESS_KEY,
			APPLICATION_NAME,
			APPLICATION_VERSION,
			$config
		);
		$request = new MarketplaceWebServiceProducts_Model_GetMatchingProductRequest();
		$request->setSellerId($mercID);
		$request->setMWSAuthToken($auth_params['mwsauthtoken']);
		$request->setMarketplaceId($auth_params['marketplace_id']);
		$ASINList = new MarketplaceWebServiceProducts_Model_ASINListType;
		$ASINList->setASIN($_GET['asin']);
		$request->setASINList($ASINList);
		// object or array of parameters
		$amazon_product_info = invokeGetMatchingProduct($service, $request,$smarty);


		$proposals = array();
		if(!empty(trim($_GET['sku']))){
			$query = xtc_db_query(sprintf(
				"SELECT products_id,products_model,products_ean,products_image FROM %s WHERE products_ean='%s' OR products_model='%s' OR mpn='%s'",
				TABLE_PRODUCTS, xtc_db_input($_GET['sku']),
				xtc_db_input($_GET['sku']),xtc_db_input($_GET['sku'])
			));
			while($record = xtc_db_fetch_array($query)){
				$img = '';
				if($record['products_image'] != ''){
					$_img = '../images/product_images/thumbnail_images/'.$record['products_image'];
					if(is_file($_img)){
						$img = $_img;
					}
				}
				$img_tag_src = ($img == '') ? 'images/icons/cross.gif' : $img;
				
				$proposals[] = array(
					'image'=>xtc_image($img_tag_src,'pID '.$record['products_id'],'70'),
					'products_id'=>$record['products_id'],
					'products_model'=>$record['products_model'],
					'products_ean'=>$record['products_ean'],
					'products_name'=>xtc_get_products_name($record['products_id']),
				);
			}
		}
		$smarty->assign(array(
			'MODE'=>$action,
			'ASIN'=>$_GET['asin'],
			'SKU'=>$_GET['sku'],
			'PROPOSALS'=>$proposals,
			'COUNTER'=>$_GET['counter'],
			'AMAZON_PRODUCT_INFO'=>$amazon_product_info,
			'TEXT_ALLOCATION_AUTO_MATCHING'=>TEXT_ALLOCATION_AUTO_MATCHING,
			'TEXT_ALLOCATION_NO_AUTO_MATCHING'=>TEXT_ALLOCATION_NO_AUTO_MATCHING,
			'TEXT_AMAZON_PRODUCTS_SEARCH'=>TEXT_AMAZON_PRODUCTS_SEARCH,
			'TEXT_AMAZON_PRODUCTS_SEARCH_INPUT'=>TEXT_AMAZON_PRODUCTS_SEARCH_INPUT,
			'TEXT_AMAZON_PRODUCTS_SEARCH_INTRO'=>TEXT_AMAZON_PRODUCTS_SEARCH_INTRO,
			'TEXT_ALLOCATE_AMAZON_PRODUCT_TO_PRODUCTS_ID'=>TEXT_ALLOCATE_AMAZON_PRODUCT_TO_PRODUCTS_ID,
			'TEXT_PAGING_NEXT'=>TEXT_PAGING_NEXT,
			'TEXT_PAGING_LAST'=>TEXT_PAGING_LAST,
		));
		$smarty->display('amazon_fba.html');
		exit;
		break;
	case 'request_report':
		$request = new MarketplaceWebService_Model_RequestReportRequest();
		$request->setMarketplace($auth_params['marketplace_id']);
		$request->setMerchant($auth_params['merchant_id']);
		$request->setReportType($ReportType);
		if(!empty($auth_params['mwsauthtoken'])){
		    $request->setMWSAuthToken($auth_params['mwsauthtoken']);
		}
		//$request->setEndDate(new DateTime('now'));
//		$request->setStartDate(new DateTime('-3 hours'));
		$res = $service->requestReport($request);
		$messageStack->add_session('FBA Report angefordert','success');
		xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
		break;
	case 'report':
		if(!isset($_GET['report']) or empty($_GET['report'])){
			die('Missing parameter.');
		}
		$reportId = $_GET['report'];
		$parameters = array (
		    'Marketplace' => $auth_params['marketplace_id'],
		    'Merchant' => $auth_params['merchant_id'],
		    'Report' => @fopen('php://memory', 'rw+'),
		    'ReportId' => $reportId
		);
		if(!empty($auth_params['mwsauthtoken'])){
		    $parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
		}

		$service = $AS->get_service();
		$R = new Report;
		$R->setReportType($ReportType);
		$request = new MarketplaceWebService_Model_GetReportRequest($parameters);
		$items = $R->invokeGetReport($service, $request);
		foreach($items as $k=>$item){
			$items[$k]['amazon_products_fba_id'] = -1;
			$items[$k]['products_id'] = -1;
			$query = xtc_db_query(sprintf(
				"SELECT amazon_products_fba_id,products_id FROM amazon_products_fba WHERE asin='%s' AND merchant_id='%s'",
				$item['asin'], $mercID
			));
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				$items[$k]['amazon_products_fba_id'] = $record['amazon_products_fba_id'];
				$items[$k]['products_id'] = $record['products_id'];
			}else{
				$query = xtc_db_query(sprintf(
					"SELECT products_id FROM amazon_products WHERE asin='%s' AND merchant_id='%s'",
					$item['asin'], $mercID
				));
				if(xtc_db_num_rows($query)){
					$record = xtc_db_fetch_array($query);
					$items[$k]['products_id'] = $record['products_id'];
					$insert_sql_array = array(
						'products_id'=>$record['products_id'],
						'seller_sku'=>$item['seller_sku'],
						'asin'=>$item['asin'],
						'amazon_condition'=>$item['condition_type'],
						'condition_code'=>$item['warehouse_condition_code'],
						'available'=>$item['quantity_available'],
						'merchant_id'=>$mercID
					);
					xtc_db_perform('amazon_products_fba',$insert_sql_array);
					$items[$k]['amazon_products_fba_id'] = xtc_db_insert_id();
					$comments = sprintf(TEXT_HISTORY_PRODUCT_FBA_ALLOCATION,
							$mercID, $item['asin'], $item['seller_sku'], $item['quantity_available']
					);
					$product = new product($record['products_id']);
					$product->add_history($comments);
				}
			}
		}
		$smarty->assign(array(
			'REPORT_ITEMS'=>$items,
			'NUM_REPORT_ITEMS'=>sizeOf($items),
			'START_FBA_ALLOCATION'=>START_FBA_ALLOCATION,
			'START_UNKNOWN_ALLOCATION'=>START_UNKNOWN_ALLOCATION,
			'TEXT_UNKNOWN_AMAZON_PRODUCT'=>TEXT_UNKNOWN_AMAZON_PRODUCT,
		));
		break;
	default:
		$RL = new ReportList;
		$request = new MarketplaceWebService_Model_GetReportListRequest($parameters);
		$report_list = $RL->invokeGetReportList($service, $request);
		$report_selects = array(array('id'=>'','text'=>TEXT_SELECT));
		foreach($report_list as $r){
			$report_selects[] = array(
				'id'=>$r['ID'],
				'text'=>$r['DATE_AVAILABLE']
			);
		}
		break;
}


//yes_debug($items);exit;






yes_draw_pre_header();
yes_draw_header(TITLE);



//$FBA = new amz_fba($mercID,$auth_params['mwsauthtoken']);

$buttons = array(
    array('text'=>'Noch nix',
	'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))),
	'lbOn'=>false,
	'auth'=>true
    ),
);
$smarty->assign(array(
	'FILTER_FORM'=>xtc_draw_form('filter',basename(__FILE__),'','GET'),
	'INPUT_USER'=>xtc_draw_pull_down_menu('user',$user,$mercID),
	'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	'INPUT_REPORTLIST'=>xtc_draw_pull_down_menu('report',$report_selects),
	'LINK_REPORT_REQUEST'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','report')).'action=request_report'),
	'REPORT_SELECT_LINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','report')).'action=report'),
	'FBA_REQUESTREPORT_INTRO'=>FBA_REQUESTREPORT_INTRO,
	'REQUEST_FBA_REPORT'=>REQUEST_FBA_REPORT,
	'TEXT_FBA_PRODUCTS'=>TEXT_FBA_PRODUCTS
));

$smarty->display('amazon_fba.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');


