<?php
require('includes/application_top.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/cashier.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
$basics = new basics;
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch($action){
	case 'stats_results':
		$date_start = false;
		if(isset($_REQUEST["date_start"])) $date_start = $_REQUEST["date_start"];
		$date_end = false;
		if(isset($_REQUEST["date_end"])) $date_end = $_REQUEST["date_end"];
		$date_start = ($date_start) ? $date_start : date('Y-m-d');
		$date_end = ($date_end) ? $date_end : date('Y-m-d');
		$cashiers_array = array(0=>array('id'=>'','text'=>TXT_ALL));
		$filter_sql = '';
		if(isset($_REQUEST['filter_cashiers_id']) and $_REQUEST['filter_cashiers_id']>0){
			$value = (int)xtc_db_input($_REQUEST['filter_cashiers_id']);
			$filter_sql .= " AND module_cashier_cashiers_id='".$value."'";
		}
		if(isset($_REQUEST['filter_seller_id']) and $_REQUEST['filter_seller_id']>0){
			$value = (int)xtc_db_input($_REQUEST['filter_seller_id']);
			$filter_sql .= " AND module_cashier_seller_id='".$value."'";
		}
		$query_raw = sprintf(
			"SELECT mgo.*,value as total FROM module_cashier_orders mgo
				LEFT JOIN orders_total ot USING(orders_id) WHERE
				 ot.class='ot_total' AND
				 date_created > '%s 00:00:00' and date_created < '%s 23:59:59'
				 %s
				 ORDER BY date_created DESC",
			$date_start,$date_end,$filter_sql);
		$orders = array();
		$query = xtc_db_query($query_raw);
		$totals = 0;
		while($row = xtc_db_fetch_array($query)){
			$seller_alias_query_raw = sprintf(
				"SELECT seller_alias FROM module_cashier_sellers WHERE
					module_cashier_sellers_id='%s'",
				$row['module_cashier_seller_id']);
			$seller_alias_query = xtc_db_query($seller_alias_query_raw);
			$seller_alias = xtc_db_fetch_array($seller_alias_query);
			$row['seller'] = $seller_alias['seller_alias'];
			$row['cashier'] = xtc_get_editor_name($row['module_cashier_cashiers_id']);
			$row['orders_link'] = xtc_href_link('orders.php','action=edit&oID='.$row['orders_id']);
			$orders[] = $row;
			$totals += $row['total'];
		}
		$smarty->assign('orders',$orders);
		$smarty->assign('totals',$totals);
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('cashier_stats.html');
		exit;
		break;
	case 'delete_cashier':
		if($_GET['customers_id']){
			$cID = (int)xtc_db_input($_GET['customers_id']);
			xtc_db_query(sprintf(
				"DELETE FROM module_cashier_cashiers WHERE customers_id='%s'",
				$cID
			));
			yes_add_history(sprintf(SYSTEM_HISTORY_CASHIER_DELETED,xtc_get_editor_name($cID),$cID));
		}
		break;
	case 'delete_seller':
		if($_GET['seller_id']){
			$tID = (int)xtc_db_input($_GET['seller_id']);
			$seller_alias_query = xtc_db_query(sprintf(
					"SELECT seller_alias FROM module_cashier_sellers WHERE module_cashier_sellers_id='%s'",
					$tID
			));
			$row = xtc_db_fetch_array($seller_alias_query);
			$seller_alias = $row['seller_alias'];
			xtc_db_query(sprintf(
				"DELETE FROM module_cashier_sellers WHERE module_cashier_sellers_id='%s'",
				$tID
			));
			yes_add_history(sprintf(SYSTEM_HISTORY_SELLER_DELETED,$seller_alias,$tID));
		}
		break;
	case 'add':
		if($_POST['customers_id']){
			$cID = (int)xtc_db_input($_POST['customers_id']);
			xtc_db_query(sprintf(
				"DELETE FROM module_cashier_cashiers WHERE customers_id='%s'",
				$cID
			));
			$insert_sql_array = array(
				'customers_id'=>$cID,
				'date_created'=>'now()'
			);
			xtc_db_perform('module_cashier_cashiers',$insert_sql_array);
			yes_add_history(sprintf(SYSTEM_HISTORY_CASHIER_ADDED,xtc_get_editor_name($cID),$cID));
		}
		break;
	case 'add_seller':
		if(isset($_POST['seller_alias']) and strlen($_POST['seller_alias'])){
			$seller_alias = substr(xtc_db_input($_POST['seller_alias']),0,32);
			$insert_sql_array = array(
				'seller_alias'=>yes_decode_string($seller_alias),
				'date_created'=>'now()'
			);
			xtc_db_perform('module_cashier_sellers',$insert_sql_array);
			yes_add_history(sprintf(SYSTEM_HISTORY_SELLER_ADDED,$seller_alias));
		}
		break;
	case 'insert':
		xtc_redirect(xtc_href_link('cashier.php'));
		break;
}
if(isset($_GET['tab'])){
	require_once('cashier_tab.php');
	exit;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript"><!--

var ONLOADFUNC = "";
function really_delete_cashier(cID){
	if(parseInt(cID) < 1)
		return false;
	yes = confirm('<?php echo JS_CONFIRM_REALLY_DELETE_CASHIER; ?>');
	if(yes){
		$.ajax({
			url: "cashier.php?action=delete_cashier&tab=cashiers&customers_id="+cID,
			success: function(){
				var tabid = $('#cashier_tabs').tabs('option', 'active');
				$('#cashier_tabs').tabs('load',tabid);
			}
		});
	}
}

function really_delete_seller(tID){
	if(parseInt(tID) < 1)
		return false;
	yes = confirm('<?php echo JS_CONFIRM_REALLY_DELETE_SELLER; ?>');
	if(yes){
		$.ajax({
			url: "cashier.php?tab=seller&action=delete_seller&seller_id="+tID,
			success: function(){
				var tabid = $('#cashier_tabs').tabs('option', 'active');
				$('#cashier_tabs').tabs('load',tabid);
			}
		});
	}
}

//-->
</script>
<?php
$smarty->assign('tab_link_base','cashier.php?'.xtc_get_all_get_params(array('tab')));
echo $smarty->fetch(DIR_FS_ADMIN.'templates/cashier.html');
?>
</body>
</html>
<?php
include('includes/application_bottom.php');
