<?php
/* --------------------------------------------------------------
   $Id: categories_view.php,v 1.172 2020/04/30 10:37:02 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(categories.php,v 1.140 2003/03/24); www.oscommerce.com
   (c) 2003  nextcommerce (categories.php,v 1.37 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:
   Enable_Disable_Categories 1.3               Autor: Mikel Williams | mikel@ladykatcostumes.com
   New Attribute Manager v4b                   Autor: Mike G | mp3man@internetwork.net | http://downloads.ephing.com
   Category Descriptions (Version: 1.5 MS2)    Original Author:   Brian Lowe <blowe@wpcusrgrp.org> | Editor: Lord Illicious <shaolin-venoms@illicious.net>
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/


  
// HEL FUNCTIONS
require(DIR_FS_ADMIN.'includes/classes/class.categories_sql.php');
require(DIR_FS_ADMIN.'includes/classes/class.products_sql.php');
require(DIR_FS_ADMIN.'includes/classes/class.ebay.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
if(is_file(DIR_WS_CLASSES.'context_menu.php')) require_once(DIR_WS_CLASSES.'context_menu.php');
$xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
$EBAYAPI = new ebayAPI;
// END HELP FUNCTIONS
if(!isset($_REQUEST['export_csv'])){
?>

<script type="text/javascript">
<!--
function setCFlag(cpath,cid,cflag){
<?php if(defined('NO_ASK_FOR_SET_FLAG_PRODUCTS') and NO_ASK_FOR_SET_FLAG_PRODUCTS == 'True') { ?>
	var link_src = '<?php echo xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag','cID','cPath','update_products')).'action=setcflag'); ?>&cPath='+cpath+'&cID='+cid+'&flag='+cflag;
	window.location.href=link_src+'&update_products=0';
<?php }else{ ?>
	var link_src = '<?php echo xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag','cID','cPath','update_products')).'action=setcflag'); ?>&cPath='+cpath+'&cID='+cid+'&flag='+cflag;
	yes = confirm('<?php echo JS_CONFIRM_SET_CFLAG_FOR_PRODUCTS; ?>');
	if(yes){
		window.location.href=link_src+'&update_products=1';
	}else{
		window.location.href=link_src+'&update_products=0';
	}
<?php } ?>
}
//-->
</script>



<?php
} // eof if ! csv
$smarty = new yesSmarty;
$smarty->assign('lang_img_path',DIR_WS_LANGUAGES.$_SESSION['language'].'/admin/images/buttons/');
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$CSQL = new categories_sql( $_SESSION['customer_id'] );
$categories_count = 0;
$categories_query_raw = $CSQL->create_categories_sql();

if(strlen($categories_query_raw)>0 and !isset($_REQUEST['cart_id']) and !isset($_REQUEST['av_filter']) and !isset($_GET['default_storage']) and !isset($_GET['days']) and !isset($_GET['un_classifications_id'])){
    $categories_query = xtc_db_query($categories_query_raw);
    $categorys = array();
    $rows = 0;
    $_cats = [];
    while ($categories = xtc_db_fetch_array($categories_query)) {
        $_cats[] = $categories;
    }
    foreach($_cats as $categories){
	$categories_count++;
	$rows++;
	$category = array();
	$category['id'] = $categories['categories_id'];
	if($categories['categories_image'] != '' and is_file(DIR_FS_CATALOG_IMAGES.'categories/'.$categories['categories_image'])){
	    $category['categories_image'] = HTTP_SERVER.'images/categories/'.$categories['categories_image'];
	}
	// Get parent_id for subcategories if search
	if (isset($_GET['search']) and $_GET['search']) {
	    $cPath= $categories['parent_id'];
	}

	if ( ((!isset($_GET['cID'])) && (!isset($_GET['pID'])) || (@$_GET['cID'] == $categories['categories_id'])) && (!isset($active_id)) && (!isset($_GET['action']) or substr($_GET['action'], 0, 4) != 'new_') ) {
	    $active_id = $categories['categories_id'];
	    $active_id_type = 'category';
	}
	// AJAX PARAMETER
	$category['ajax_key'] = 'cat'.$categories['categories_id'];

	if( isset($active_id) and $categories['categories_id'] == $active_id) {
		$category['selected'] = 1;
		$category['selected_mouseoverlink'] = xtc_href_link(FILENAME_CATEGORIES, xtc_get_path($categories['categories_id']));
		$category['infolink'] = xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&cID=' . $categories['categories_id']);
	}
	$category['ajax_get_params'] = 'cPath=' . $cPath . '&cID=' . $categories['categories_id'];

	if($categories['link_id']==0)
		$category['folderlink'] = xtc_href_link(FILENAME_CATEGORIES, xtc_get_path($categories['categories_id']));
	else
		$category['folderlink'] = xtc_href_link(FILENAME_CATEGORIES, xtc_get_path($categories['link_id']));
	
	$category['link'] = xtc_href_link('ajax_categories_details.php', xtc_get_all_get_params(array('cPath','cID')).'cPath=' . $cPath . '&cID=' . $categories['categories_id']);

	$category['name'] = $categories['categories_name'];
	if($categories['link_id']>0){
            $category['name'] .= '&nbsp;<i>[Link: '.$categories['link_id'].']</i>';
        }
        $category['ebayapi_cart'] = $categories['ebayapi_cart'];
        $category['sort_order'] = (int)$categories['sort_order'];
        $category['categories_status'] = $categories['categories_status'];
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
            if($category['categories_status'] == 1)
                $category['link_setcflag'] = xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag','cID','cPath','update_products')).'action=setCFlag_confirm&cPath='.$cPath.'&cID='.$categories['categories_id'].'&flag=0');
            else
                $category['link_setcflag'] = xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag','cID','cPath','update_products')).'action=setCFlag_confirm&cPath='.$cPath.'&cID='.$categories['categories_id'].'&flag=1');
        }
        $categorys[] = $category;
    } // end while categories
    $smarty->assign(array(
        'categories'=>$categorys,
        'categories_count'=>sizeOf($categorys),
        'TEXT_ACTIVATE_CATEGORY'=>TEXT_ACTIVATE_CATEGORY,
        'TEXT_DEACTIVATE_CATEGORY'=>TEXT_DEACTIVATE_CATEGORY,
        'BASELINK_CATEGORY_EBAYAPI_CART'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('cID','action')).'action=update_category_ebayapi_cart')
    ));
} // end if strlen categories_query
$products_count = 0;
$PSQL = new products_sql( $_SESSION['customer_id'] );
$products_array = array(); // smarty var
if(!$PSQL->length_error){
	    $products_query_raw = $PSQL->create_categories_sql();
	    if(isset($_REQUEST['export_csv']) and $_REQUEST['export_csv'] == 1){
		$query = xtc_db_query($products_query_raw);
		$csv_header = array(
		    'pID',
		    TEXT_QTY_AV1,
		    TEXT_PRODUCTS_MODEL,
		    'EAN',
		    TEXT_MANUFACTURER,
		    TEXT_MPN_LONG, 
		    TEXT_CONDITION,
		    TXT_NAME,
		    TXT_PRICES.' ('.DEFAULT_CURRENCY.')',
		    TEXT_YES_EXPORT_MODULES_TYPE_IMAGE
		);
		$additional_cols = array();
		if(isset($_REQUEST['export_gcs']) and sizeOf($_REQUEST['export_gcs'])){
		    foreach($_REQUEST['export_gcs'] as $pcID=>$egal){
			$pcID = (int) xtc_db_input($pcID);
			$pp_query = xtc_db_query(sprintf(
				"SELECT title FROM products_characteristic_description WHERE products_characteristic_id='%s' AND language_id='%s'",
				$pcID,$_SESSION['languages_id']
			));
			$pp_record = xtc_db_fetch_array($pp_query);
			$additional_cols[] = array('id'=>$pcID,'title'=>$pp_record['title']);
		    }
		}
		foreach($additional_cols as $addcol){
		    $csv_header[] = $addcol['title'];
		}
		$nosetID_array = array();
		if(isset($_REQUEST['export_noset']) and sizeOf($_REQUEST['export_noset'])){
		    foreach($_REQUEST['export_noset'] as $nsid=>$ns_active){
			if($ns_active != 1){
			    continue;
			}
			$nosetID = (int)xtc_db_input($nsid);
			$noset_query = xtc_db_query(sprintf(
				"SELECT title FROM products_characteristic_description pcsd WHERE products_characteristic_id='%s' AND language_id='%s'",
				$nosetID,$_SESSION['languages_id']
			));
			if(xtc_db_num_rows($noset_query)){
			    $noset_record = xtc_db_fetch_array($noset_query);
			    $csv_header[] = xtc_db_prepare_input($noset_record['title']);
			    $nosetID_array[] = $nosetID;
			}
		    }
		}
		$csv_header = implode("\t",$csv_header);
		/*
		$csv_header = implode("\t",array(
		    'products_id',
		    'products_model',
		    'products_ean',
		    'products_name',
		    'price_netto',
		    'Bild 1',
		    'Bild 2',
		    'Bild 3'
		));*/
		
		$csv_data = array();
		$csv_data[] = $csv_header;
		$products_raw = array();
		while($record = xtc_db_fetch_array($query)){
		    $products_raw[] = $record;
		}
		$calc = 1;
		if(isset($_REQUEST['netto_price_recalc']) and $_REQUEST['netto_price_recalc'] != ''){
		    $calc = (float)str_replace(',','.',xtc_db_input($_REQUEST['netto_price_recalc']));
		    if($calc != 0){
			$calc = (100+$calc)/100;
		    }else{
			$calc = 1;
		    }
		}
		foreach($products_raw as $record){
		    $img1 = (!empty($record['products_image'])) ? HTTP_SERVER.'images/product_images/popup_images/'.$record['products_image'] : ''; 
		    /*
		    $img_c = 1;
		    $mo_img = array();
		    $mo_img_query = xtc_db_query(sprintf(
			    "SELECT image_name FROM products_images WHERE products_id='%s' ORDER BY image_nr ASC LIMIT 2",
			    $record['products_id']
		    ));
		    while($mo = xtc_db_fetch_array($mo_img_query)){
			$mo_img[ $img_c ] = $mo['image_name'];
			$img_c++;
		    }
		    $csv = array(
			$record['products_id'],
			$record['products_model'],
			$record['products_ean'],
			$record['products_name'],
			$record['products_price'],
			$img1,
			$mo_img[1],
			$mo_img[2],
		    );
		    */
		    $manufacturer = '';
		    if($record['manufacturers_id'] > 0){
			$mquery = xtc_db_query(sprintf(
				"SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
				$record['manufacturers_id']
			));
			if(xtc_db_num_rows($mquery)){
			    $mrecord = xtc_db_fetch_array($mquery);
			    $manufacturer = xtc_db_prepare_input($mrecord['manufacturers_name']);
			}
		    }
		    $condition = '';
                    if($record['products_conditions_id'] > 0){
                        $condition = \YES4Trade\Model\products_conditions::get_condition_title(
                            $record['products_conditions_id'],
                            $_SESSION['languages_id']
                        );
		    }
		    $SQ = new products_quantity($record['products_id']);
		    $price = number_format($record['products_price']*$calc,2,',','');
		    $csv = array(
			$record['products_id'],
			$SQ->get_available1_qty(),
			$record['products_model'],
			$record['products_ean'],
			$manufacturer,
			$record['mpn'], 
			$condition,
			$record['products_name'],
			$price,
			$img1
		    );
		    foreach($additional_cols as $addcol){
			$pc_query = xtc_db_query(sprintf(
				"SELECT pcsd.title FROM products_to_characteristics pc LEFT JOIN products_characteristic_set pcs USING(products_characteristic_set_id) LEFT JOIN products_characteristic_set_description pcsd USING(products_characteristic_set_id) WHERE pc.products_id='%s' AND pcs.products_characteristic_id='%s' AND pcsd.language_id='%s'",
				$record['products_id'],$addcol['id'],$_SESSION['languages_id']
			));
			if(xtc_db_num_rows($pc_query)){
			    $pc = xtc_db_fetch_array($pc_query);
			    $val = xtc_db_prepare_input($pc['title']);
			}else{
			    $val = '';
			}
			$csv[] = $val;
		    }
		    if(sizeOf($nosetID_array)){
			foreach($nosetID_array as $nsID){
			    $pc_query = xtc_db_query(sprintf(
				    "SELECT pctv.content FROM products_characteristic_text_values pctv WHERE products_id='%s' AND products_characteristic_id='%s' AND pctv.language_id='%s'",
				    $record['products_id'],$nsID,$_SESSION['languages_id']
			    ));
			    if(xtc_db_num_rows($pc_query)){
				$pc = xtc_db_fetch_array($pc_query);
				$val = xtc_db_prepare_input($pc['content']);
			    }else{
				$val = '';
			    }
			    $csv[] = $val;
			}
		    }
		    $csv_data[] = implode("\t",$csv);
		}
		$basics = new basics;
		$file = \main::get_exportdata_path().'search_results_'.date('ymd-his').'.csv';
		$basics->create_file($file,implode("\n",$csv_data));
		$basics->download_file($file);
		unlink($file);
		exit;
	    }
	    
	    /*
	    $num_products_query = xtc_db_query($products_query_raw);
	    $num = xtc_db_num_rows($num_products_query);
	    */
	    //$products_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $products_query_raw, $products_query_numrows);	    $products_query = xtc_db_query($products_query_raw);
            // 05/2018 mario
            // WEGEN GROUP BY KLAUSELN - NUR NOCH DUMMY INITIALISIEREN FUER
            // SEITENNAVIGATION
            $empty_sql_query = '';
            $empty_sql_num_rows = 0;
            
            $page = (isset($_GET['page']) and (int)$_GET['page'] > 1) ? max(1,yes_getIntFromRequest('page')) : 1;
            $start = ($page-1)*MAX_DISPLAY_SEARCH_RESULTS;
            // page wird beim Aufruf von splitPageResults ueberschrieben
            // darum muss start vor dem aufruf von splitpageresults gesetzt
            // werden (11/2018)
            $products_split = new splitPageResults($page, MAX_DISPLAY_SEARCH_RESULTS, $empty_sql_query, $empty_sql_num_rows);
            //$products_query = xtc_db_query($products_query_raw);
            $products_query_numrows_query = xtc_db_query($products_query_raw);
            $products_query_numrows = xtc_db_num_rows($products_query_numrows_query);
            $products_query_raw .= sprintf(" LIMIT %s, %s",$start,MAX_DISPLAY_SEARCH_RESULTS);
            $products_query = xtc_db_query($products_query_raw);
	    while($products = xtc_db_fetch_array($products_query)) {
		    $_product = array(); // smarty var
		    $products_count++;
		    $rows++;
		    $_product = xtc_get_my_product_values($products,$expand = 1);
		    $products_array[] = $_product;
	    }
	    $smarty->assign(['products'=>$products_array,'products_count'=>sizeOf($products_array)]);

	    if ($cPath_array) {
		    $cPath_back = '';
		    for($i = 0, $n = sizeof($cPath_array) - 1; $i < $n; $i++) {
			    if ($cPath_back == '') {
			      $cPath_back .= $cPath_array[$i];
			    } else {
			      $cPath_back .= '_' . $cPath_array[$i];
			    }
		    }
	    }

	    $cPath_back = (isset($cPath_back)) ? 'cPath=' . $cPath_back : '';
        $page = (isset($_GET['page']) and (int)$_GET['page'] > 1) ? max(1,yes_getIntFromRequest('page')) : 1;
	    $split_result =  $products_split->display_count($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $page, TEXT_DISPLAY_NUMBER_OF_PRODUCTS,xtc_get_all_get_params(array('page')));
	    $split_navi = $products_split->display_links($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $page, xtc_get_all_get_params(array('page')));
	    $smarty->assign('SPLIT_PAGE_RESULT',$split_result);
	    $smarty->assign('SPLIT_PAGE_NAVI',$split_navi);
}else{
	    $smarty->assign('length_error',true);
	    $smarty->assign('length_error_value',SEARCHWORD_MIN_LENGTH);
}

$buttons = array(
    array('text'=>TEXT_EXTENDED_SEARCH,
	'link'=>xtc_href_link('advanced_search.php',xtc_get_all_get_params(array('action','pID'))),
	'lbOn'=>false,
	'auth'=>true
    ),
    array('text'=>TEXT_INFO_HEADING_NEW_PRODUCT,
	'link'=>xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','cID','action','pID')).'cPath=' . $cPath . '&action=new_product'),
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) ? true : false,
	'lbOn'=>false
    ),
    array('text'=>BUTTON_QUICK_PRODUCT_ADD,
	'link'=>"javascript:window.open('quick_product_add.php','qpa','scrollbars=yes,resizable=yes,menubar=no,locationbar=no,toolbar=no,personalbar=no,statusbar=no,width=".EXT_POPUP_WIDTH."px,height=".EXT_POPUP_HEIGHT."px');",
	'lbOn'=>false,
	'auth'=>(isset($admin_access['quick_product_add']) and $admin_access['quick_product_add'] == 1) ? true : false

    ),
    array('text'=>LINK_SEARCHABLE_CATEGORIES,
	'link' => "javascript:void(window.open('start.php?action=user_profile'));",
	'lbOn'=>false,
	'auth'=>true
    ),
    array('text'=>TEXT_FILTER_NEW_PRODUCTS,
	'link'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=filter_new_products'),
	'lbOn'=>true,
	'auth'=>true
    )
);

if(isset($_REQUEST['null_qty_filter']) and $_REQUEST['null_qty_filter'] == 1){
    $buttons[] = array('text'=>BUTTON_SHOW_PRODUCTS_WITH_BESTAND,
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params( array('null_qty_filter') ).'null_qty_filter=0' ),
	'auth'=>true,
	'lbOn'=>false
    );
}else{
    $buttons[] = array('text'=>BUTTON_SHOW_PRODUCTS_WITHOUT_BESTAND,
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params( array('null_qty_filter') ).'null_qty_filter=1' ),
	'auth'=>true,
	'lbOn'=>false
    );
}
if(isset($_REQUEST['null_qty_filter'])){
    $buttons[] = array('text'=>'Bestandfilter aus',
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params( array('null_qty_filter') ) ),
	'auth'=>true,
	'lbOn'=>false
    );
}

if(!isset($_REQUEST['av_filter'])){
    $buttons[] = array('text'=>BUTTON_SHOW_PRODUCTS_WITH_DATE_AVAILABLE,
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params( array('av_filter') ).'av_filter=1' ),
	'auth'=>true,
	'lbOn'=>false
    );
}else{
    $buttons[] = array('text'=>BUTTON_HIDE_PRODUCTS_WITH_DATE_AVAILABLE,
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params( array('av_filter') ) ),
	'auth'=>true,
	'lbOn'=>false
    );
}

if(defined('YES_SHOP_MENU_FROM_XML') and YES_SHOP_MENU_FROM_XML == 'True'){
	$buttons[] = array('text'=>BUTTON_GENERATE_CATEGORIES_XML,
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params( array('action') ).'action=cat2xml' ),
	'auth'=>($admin_access['f_categories_edit'] == '1') ? true : false,
	'lbOn'=>false
    );
}

if(!isset($_GET['search'])){
    $buttons[] = array('text'=>TEXT_INFO_HEADING_NEW_CATEGORY,
	'link'=>xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','cID','action','pID')).'cPath=' . $cPath . '&action=new_category'),
	'auth'=>(($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) ? true : false,
	'lbOn'=>false
    );
}
$buttons[] = array('text'=>TEXT_IMPORT_PRODUCT_IMAGES,
	'link'=>xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action')).'action=import_product_images'),
	'auth'=>true,
	'lbOn'=>true
);

// in categories.php wird das ausgefuehrt
if($admin_access['f_categories_clearcache'] == '1'){
    if(isset($_SESSION['f_categories_clearcache_lastaction'])){
        if(time() > ($_SESSION['f_categories_clearcache_lastaction']+(60*10)) ){
            unset($_SESSION['f_categories_clearcache_lastaction']);
            $allow = true;
        }else{
            $rest_wartezeit = -(time() - ($_SESSION['f_categories_clearcache_lastaction']+(60*10))) / 60;
            $allow = false;
        }
    }else{
        $allow = true;
    }
    if($allow){
        $link = xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action')).'action=clearcache');
    }else{
        $link = sprintf("javascript: alert('Template Cache leeren nur alle 10 Minuten. Noch etwa %d Minuten warten.');",
            (int)$rest_wartezeit
        );
    }
    $buttons[] = array('text'=>'Template Cache leeren',
            'link'=>$link,
            'auth'=>true,
            'lbOn'=>false
    );
}
$smarty->assign(array(
    'JS_CONFIRM_REMOVE_PRODUCTS_LINK'=>JS_CONFIRM_REMOVE_PRODUCTS_LINK,
    'HEADING_TITLE'=>HEADING_TITLE,
    'ADDITIONAL_TITLE'=>sprintf(TEXT_ADDITIONAL_TITLE,$categories_count,$products_query_numrows),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
if(isset($_GET['groups_id']) and $_GET['groups_id'] > 0){
    $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
    $group_filter_remove_link = '';
    foreach($gh->groups as $g){
        if((int)$g['groups_id']==(int)$_GET['groups_id']){
                $group_filter_remove_link = sprintf(' - %s &raquo;%s&laquo; <a href="%s" title="%s" style="text-decoration: none; font-size: 0.8em; color: red; font-weight: bold;">&#10060;</a>', 
                        TEXT_PRODUCT_GROUP,
                        $g['groups_title'],
                        xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['groups_id'])),
                        'Filter '.TEXT_PRODUCT_GROUP.' '.IMAGE_DELETE
                );
        }
    }
    $smarty->assign('HEADING_TITLE',HEADING_TITLE.$group_filter_remove_link);
}else{
    $smarty->assign('HEADING_TITLE',HEADING_TITLE);
}
if(isset($_GET['days'])){
    // wird definiert in der categories.php oben
    // weitere Verwendung: action=filter_new_products
    $days_display_text = $_GET['days'].' Tage';
    foreach(FILTER_PRODUCTS_DATE_ADDED_DURATIONS as $da){
        if($da['id']==$_GET['days']){
            $days_display_text = $da['text'];
        }
    }
    $unset_link = sprintf('&nbsp;&nbsp;&nbsp;<a href="%s"><img src="images/icons/cross.gif" title="%s" /></a>',
            xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('days'))),
            IMAGE_DELETE
    );
    $smarty->assign('ADDITIONAL_TITLE',TEXT_FILTER_NEW_PRODUCTS.': '.$days_display_text.$unset_link);
} // end if isset get days
$smarty->assign('SHOW_HEADER',1);
$smarty->display('categories_view.html');
$smarty->assign('SHOW_HEADER',0);
$smarty->assign('CAT_FORM',xtc_draw_form('mcopy',FILENAME_CATEGORIES,'action=multicopy'));
$smarty->assign('cPath',((isset($_GET['cPath']))?$_GET['cPath']:''));
$smarty->assign('STOCK_CHECK',STOCK_CHECK);
$smarty->assign('CATEGORY_LISTING_IMAGES',CATEGORY_LISTING_IMAGES);
$smarty->assign('POPUP_WIDTH',EXT_POPUP_WIDTH);
$smarty->assign('POPUP_HEIGHT',EXT_POPUP_HEIGHT);
$smarty->assign(array(
    'show_search_results_filter'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=search_results_filter'),
));
?>
      <tr>
        <td><br /><table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td>
		<?php echo xtc_draw_form('search', FILENAME_CATEGORIES, '', 'get','class="yesForm"'); ?>
		<fieldset>
		    <legend><?php echo TEXT_SEARCH_FILTER; ?></legend>
		    <?php echo HEADING_TITLE_SEARCH . ' ' . xtc_draw_input_field('search', ((isset($_GET['search']))?$_GET['search']:'')).
		    xtc_draw_hidden_field(xtc_session_name(), xtc_session_id()); ?>
		    <input type="image" src="images/icon_arrow_right.gif" title="<?php echo IMAGE_SEARCH; ?>" alt="<?php echo IMAGE_SEARCH; ?>" />
		    </fieldset>
		    </form>
	    </td>
            <td>
		<div id="search_results_filter"></div>
                
	    </td>
            <td><a title="<?php echo TEXT_OVERVIEW; ?>" href="javascript:;" id="categories.php?action=navigation" class="lbOn"><button style="display:inline-block;" class="ui-button ui-corner-all ui-state-default"><?php echo TEXT_OVERVIEW; ?></button></a></td>
         </tr>
		<tr>
			<td class="main" colspan="3">
				<?php
				if(isset($_REQUEST['cPath']))
					$parts = explode('_',$_REQUEST['cPath']);
				else
					$parts = array();
				$curr = current(array_reverse($parts));
				$add = ' &raquo; ';
                                if(sizeOf($parts) and !in_array('0',$parts)){
                                    $str = sprintf('<a href="%s">TOP</a> %s',
                                            xtc_href_link(FILENAME_CATEGORIES),
                                            $add
                                    );
                                }else{
                                    $str = '';
                                }
				for($i=0;$i<sizeOf($parts);$i++){
					if($parts[$i] != $curr){
						$str .= sprintf(
							'<a href="%s">%s</a>%s',
							xtc_href_link('categories.php','cPath='.xtc_get_category_path($parts[$i])),
							xtc_get_categories_name($parts[$i]),
							$add
						);
					}else{
						$str .= xtc_get_categories_name($parts[$i]).$add;
					}
				}
				$str = substr($str,0,strlen($str)-strlen($add));
				echo $str;
				?>
			</td>
		</tr>
        </table></td>
      </tr>
      <tr>
        <td>
	
<?php    
if ($cPath){
	$smarty->assign('BUTTON_BACK',yes_draw_href_button(
			IMAGE_BACK,
			xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','cID','action','pID')).$cPath_back . '&cID=' . $current_category_id),
			'width:150px'
	));
}
$smarty->assign('catID',$current_category_id);

// AJAX PARAMETER
if(!isset($active_id)){ $active_id = 0; }
if(!isset($active_id_type)){ $active_id_type = 'category'; }

if(isset($active_id_type) and $active_id_type == 'category'){
	$smarty->assign('start_row_id',xtc_draw_hidden_field('start_id','cat'.$active_id));
}else{
	$smarty->assign('start_row_id',xtc_draw_hidden_field('start_id','prod'.$active_id));
}
$smarty->assign('start_row_type',xtc_draw_hidden_field('start_type',$active_id_type));

function _getSort($field){
	$sortmode = 'ASC';
	if(isset($_GET['order_by']) and $_GET['order_by'] == $field.' ASC'){
		$sortmode = 'DESC';
	}else if(isset($_GET['order_by']) and $_GET['order_by'] == $field.' DESC'){
		$sortmode = 'ASC';
	}
	return xtc_href_link('categories.php',xtc_get_all_get_params(array('order_by')).'order_by='.$field.'%20'.$sortmode);
}


$smarty->caching = 0;
$smarty->assign('TABLE_HEADING_ID',array('href'=>_getSort('products_id'),'title'=>TABLE_HEADING_ID));
//	$smarty->assign('TABLE_HEADING_ID',TABLE_HEADING_ID);
$smarty->assign('TABLE_HEADING_CATEGORIES_PRODUCTS',TABLE_HEADING_CATEGORIES_PRODUCTS);
$smarty->assign('TABLE_HEADING_IMAGE',TABLE_HEADING_IMAGE);
$smarty->assign('TABLE_HEADING_SORT',TABLE_HEADING_SORT);
$smarty->assign('TABLE_HEADING_STOCK',TABLE_HEADING_STOCK);
$smarty->assign('TABLE_HEADING_STATUS',array('href'=>_getSort('products_status'),'title'=>TABLE_HEADING_STATUS));
$smarty->assign('TABLE_HEADING_PRICE',array('href'=>_getSort('products_price'),'title'=>TABLE_HEADING_PRICE));
$smarty->assign('TABLE_HEADING_ACTION',TABLE_HEADING_ACTION);
$smarty->assign('TABLE_HEADING_CAPTION',HEADING_TITLE);

$smarty->assign('TEXT_GROUPS_ALLOCATION',BUTTON_GROUPS_ALLOCATION);
$smarty->assign('TEXT_GROUPS_ALLOCATION_GROUPED',BUTTON_GROUPS_ALLOCATION_GROUPED);
$smarty->assign('TEXT_ADD_CART',TEXT_ADD_CART);
$smarty->assign('TEXT_SPECIALS',TEXT_SPECIALS);
$smarty->assign('TEXT_AMAZON_EXPORT',TEXT_INFO_HEADING_AMAZON_EXPORT);
$smarty->assign('MC_TEXT',TEXT_INFO_HEADING_MULTICOPY);

$smarty->assign('BUTTON_GROUPS_ALLOCATION',yes_draw_href_button(
				BUTTON_GROUPS_ALLOCATION,
				'javascript:group_allocation_submit(this,\''.xtc_href_link('categories.php',xtc_get_all_get_params(array('pID','action','catID')).'action=products_group_allocation').'\')',
				'width:350px'
));
$smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
$smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);

// ausgew. artikel an Export senden
if(defined('MODULE_YES2_STATUS') and MODULE_YES2_STATUS == 'True'){
    require_once(DIR_WS_CLASSES.'class.products_export.php');
    require_once(DIR_WS_INCLUDES.'modules/export/yes2.php');
    $smarty->assign('TEXT_EXPORT_YES2',MODULE_YES2_TEXT_TITLE);
}
if(isset($_GET['groups_id']) and (int)$_GET['groups_id'] > 0){
    $gh = new \YES4Trade\Model\group_handler( $_SESSION['languages_id']);
    $gname = 'Unknown';
    foreach($gh->groups as $g){
        if($g['groups_id'] == $_GET['groups_id']){
            $gname = $g['groups_title'];
        }
    }
    $smarty->assign([
        'GROUPS_ID'=>$_GET['groups_id'],
        'TEXT_GROUPS_ALLOCATION_DELETE'=>sprintf(TEXT_GROUPS_ALLOCATION_DELETE,$gname)
    ]);
}
$smarty->assign(array(
    'AJAX_LINK_MENU_PRODUCT'=> xtc_href_link('ajax_categories_details.php', xtc_get_all_get_params(array('pID','action')).'pID='),
    'TEXT_EDIT_PRODUCTS_PHYSICAL_QUANTITY'=>TEXT_EDIT_PRODUCTS_PHYSICAL_QUANTITY,
    'TEXT_EDIT_PRODUCTS_PHYSICAL_QUANTITY_INTRO'=>TEXT_EDIT_PRODUCTS_PHYSICAL_QUANTITY_INTRO,
    'MSG_SUCCESS_EDIT_PRODUCTS_PHYSICAL_QUANTITY'=>MSG_SUCCESS_EDIT_PRODUCTS_PHYSICAL_QUANTITY,
    'ALLOW_EDIT_PRODUCTS_PHYSICAL_QUANTITY'=>$admin_access['f_products_quantity'],
    'TEXT_AMAZON_QUICKADD'=>TEXT_AMAZON_QUICKADD,
    'TEXT_DEACTIVATE_PRODUCT'=>TEXT_DEACTIVATE_PRODUCT,
    'TEXT_ACTIVATE_PRODUCT'=>TEXT_ACTIVATE_PRODUCT,
    'TEXT_ACTIVATE_PRODUCTS_LISTING_STATUS'=>TEXT_ACTIVATE_PRODUCTS_LISTING_STATUS,
    'TEXT_DEACTIVATE_PRODUCTS_LISTING_STATUS'=>TEXT_DEACTIVATE_PRODUCTS_LISTING_STATUS,
    'IMAGE_CANCEL'=>IMAGE_CANCEL,
    'TEXT_PRODUCTS_STATUS_CANCEL_AMAZON'=>TEXT_PRODUCTS_STATUS_CANCEL_AMAZON,
    'TEXT_PRODUCTS_STATUS_CANCEL_AUCTIONS'=>TEXT_PRODUCTS_STATUS_CANCEL_AUCTIONS,
    'allow_change_products_price'=>$admin_access['f_change_products_price'],
    'TEXT_MULTI_PRODUCTS_STORAGE_ALLOCATION'=>TEXT_MULTI_PRODUCTS_STORAGE_ALLOCATION,
    'TEXT_CREATE_MASTER_SLAVE_ALLOCATION'=>TEXT_CREATE_MASTER_SLAVE_ALLOCATION,
    'JS_CONFIRM_REMOVE_PRODUCTS_OTHER_LINKS'=>JS_CONFIRM_REMOVE_PRODUCTS_OTHER_LINKS,
    'JS_CONFIRM_GROUPS_ALLOCATION_DELETE'=>JS_CONFIRM_GROUPS_ALLOCATION_DELETE,
    'GROUPS_ALLOCATION_DELETE_LINK'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['pID','action']).'action=delete_groups_allocation'),
));
    $main_content= $smarty->fetch('categories_view.html');
    echo $main_content;
