<?php
/*
  $Id: coupon_admin.php,v 1.49 2019/11/27 13:41:01 ssh-511548-cvs Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();

require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'xtcPrice.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');

// initiate template engine for mail
$smarty = new yesSmarty;

if (isset($_GET['selected_box'])) {
	$_GET['action']='';
	$_GET['old_action']='';
}
$action = $_GET['action']??'';
$heading = array();
$contents = array();
switch($action){
    case 'check_coupon_code':
	$cID = (int)xtc_db_input($_REQUEST['customers_id']);
	if($cID < 1){
	    die(json_encode(array(
		'MSG'=>'Missing customer Parameter for check_coupon_code'
	    )));
	}
	$xtPrice = new xtcPrice(DEFAULT_CURRENCY,xtc_get_customer_status($cID));
	$gv_redeem_code = trim(xtc_db_input($_REQUEST['code']));
	if(empty($gv_redeem_code)){
	    die(json_encode(array(
		'MSG'=>TEXT_ERROR_MISSING_CODE
	    )));
	}
	$REMOTE_ADDR = ''; // keine remote addr da kasse
        $coupon = \YES4Trade\Model\coupons::get_by_coupon_code($gv_redeem_code);
	if ($coupon === null or $coupon->active !== 'Y') {
	    die(json_encode(array(
		'MSG'=>  html_entity_decode(sprintf(ERROR_NO_INVALID_REDEEM_GV,$gv_redeem_code))
	    )));
        }
        
        
        $gv_result = $coupon->toArray();
        $redeems = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(
            intval($coupon_result['coupon_id']),[
                'coupon_id'
            ]
        );
        if ( sizeOf($redeems) > 0 and $gv_result['coupon_type'] == 'G' ) {
            die(json_encode(array(
                'MSG'=>html_entity_decode(sprintf(ERROR_NO_INVALID_REDEEM_GV,$gv_redeem_code))
            )));
	}
	if ($gv_result['coupon_type'] == 'G') {
            $gv_amount = $gv_result['coupon_amount'];
            $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($cID));
            $total_gv_amount = (float)$gv_amount;
            if ($gvc !== null) {
                $total_gv_amount = (float)$gvc->amount + $gv_amount;
            }
            $cc_id = $gv_result['coupon_id']; //Fred ADDED, set the global and session variable
            die(json_encode(array(
                'MSG'=>'',
                'CC_ID'=>$cc_id
            )));
	}
	// GIFT CODE G END

        if(DateTime::createFromFormat('Y-m-d H:i:s', $coupon->coupon_start_date) > new DateTime()){
	    die(json_encode(array(
		'MSG'=>ERROR_INVALID_STARTDATE_COUPON
	    )));
        }
        
        if(DateTime::createFromFormat('Y-m-d H:i:s', $coupon->coupon_expire_date) < new DateTime()){
	    die(json_encode(array(
		'MSG'=>ERROR_INVALID_FINISDATE_COUPON
	    )));
        }
        
        $customer_redeems = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id_and_customers_id(
            intval($coupon_result['coupon_id']), $cID,
            ['coupon_id']
        );

        $coupon_count = sizeOf($redeems);
	$coupon_count_customer = sizeOf($customer_redeems);

	if($coupon_count >= $gv_result['uses_per_coupon'] and $gv_result['uses_per_coupon'] > 0) {
	    die(json_encode(array(
		'MSG'=>sprintf(ERROR_INVALID_USES_COUPON,$gv_result['uses_per_coupon'])
	    )));
	}

	if ($coupon_count_customer >= $gv_result['uses_per_user'] and $gv_result['uses_per_user'] > 0) {
	    die(json_encode(array(
		'MSG'=>sprintf(ERROR_INVALID_USES_USER_COUPON,$gv_result['uses_per_user'])
	    )));
	}
	if ($gv_result['coupon_type']=='S') {
	    die(json_encode(array(
		'MSG'=>ERROR_COUPON_TYPE_S_NOT_IN_ADMIN
	    )));
	}
	// DEPRECATED (mario)
	//if (!xtc_session_is_registered('cc_id')) xtc_session_register('cc_id'); //Fred - this was commented out before
	die(json_encode(array(
	    'MSG'=>'',
	    'CC_ID'=>$gv_result['coupon_id'],
	    'AMOUNT'=>$coupon_amount
	)));
	break;
    case 'import':
	    $target_path = \main::get_importdata_path();
	    $target_file = 'COUPON.csv';
	    if(is_file($target_path.'/'.$target_file)) {
            unlink($target_path.'/'.$target_file);
        }
	    if( strtolower(substr($_FILES['coupon_file']['name'],strlen($_FILES['coupon_file']['name'])-4,strlen($_FILES['coupon_file']['name']))) != '.csv'){
	        $messageStack->add_session('Filetype not allowed','error');
	        xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	    }
	$upload_max_filesize = yes_return_bytes(ini_get('upload_max_filesize'));
	if( $_FILES['coupon_file']['size'] > $upload_max_filesize){
	    $messageStack->add_session('File to large','error');
	    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	}
	$mime_type = yes_get_mime_type($_FILES['coupon_file']['tmp_name']);
	if(!in_array($mime_type,array('text/plain','text/csv'))){
	    $messageStack->add_session($mime_type.' not allowed','error');
	    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	}
	$file_upload = xtc_try_upload('coupon_file', $target_path, '755', array('CSV','csv'));
	rename($target_path.'/'.$file_upload->file['name'], $target_path.'/'.$target_file);
	if(!is_object($file_upload) or !isset($file_upload->file['name'])){
	    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	    $messageStack->add_session(sprintf(MSG_ERROR_IMPORT_NO_FILE,$file),'error');
	}
	$languages = xtc_get_languages();
	$file = $target_path.'/'.$target_file;
	if(!file_exists($file)){
	    $messageStack->add_session(sprintf(MSG_ERROR_IMPORT_NO_FILE,$file),'error');
	    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	}
	$contents = file_get_contents($file);
	$lines = explode("\n",$contents);
	if(sizeOf($lines) < 2){
	    $messageStack->add_session(sprintf(MSG_ERROR_IMPORT_NO_DATA,$file),'error');
	    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	}
	
	$coupon_insert_sql_array = array(
	    'coupon_type',
	    'coupon_code',
	    'coupon_amount',
	    'coupon_minimum_order',
	    'coupon_start_date',
	    'coupon_expire_date',
	    'uses_per_coupon',
	    'uses_per_user',
	    'restrict_to_products',
	    'restrict_to_categories',
	    'restrict_to_customers',
	    'coupon_active',
	    'date_created',
	    'date_modified',
	    'free_shipping_countries'
	);
	$imported = 0;
	$updated = 0;
	foreach($lines as $nr => $line){
	    if($nr > 0){
		$values = explode(';',$line);
		if(sizeOf($values) < 5){
		    continue;
		}
		$insert_sql_array = array();
		foreach($coupon_insert_sql_array as $key){
		    $insert_sql_array[ $key ] = $values[ $sql_key_array[$key] ];
		}
                $check_coupon = \YES4Trade\Model\coupons::get_by_coupon_code($insert_sql_array['coupon_code'],[
                    'coupon_id'
                ]);
		if($check_coupon === null){
                    $new = new \YES4Trade\Model\coupons($insert_sql_array);
		    $coupon_id = $new->create();
		    foreach($languages as $lang){
			$new = new \YES4Trade\Model\coupons_description([
			    'coupon_id'=>intval($coupon_id),
			    'language_id'=>intval($lang['id']),
			    'coupon_name'=>$values[ $sql_key_array['coupon_name_'.$lang['code']] ],
			    'coupon_description'=>$values[ $sql_key_array['coupon_description_'.$lang['code']] ],
			]);
                        $new->create();
		    }
		    $imported++;
		}else{
                    $insert_sql_array['coupon_id'] = intval($check_coupon->coupon_id);
                    $upd = new \YES4Trade\Model\coupons($insert_sql_array);
		    $upd->update();
		    foreach($languages as $lang){
			$upd = new \YES4Trade\Model\coupons_description([
			    'coupon_name'=>$values[ $sql_key_array['coupon_name_'.$lang['code']] ],
			    'coupon_description'=>$values[ $sql_key_array['coupon_description_'.$lang['code']] ],
                            'coupon_id'=>intval($check_coupon->coupon_id),
                            'language_id'=>intval($lang['id'])
                        ]);
                        $upd->update();
		    }
		    $updated++;
		}
	    }else{
		$sql_key_array = array();
		$sql_keys = explode(';',str_replace('"','',$line));
		if(sizeOf($sql_keys)<5){
		    $messageStack->add_session(MSG_ERROR_IMPORT_INVALID_CSV,'error');
		    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
		}
		foreach($sql_keys as $k=>$sql_key){
		    $sql_key_array[ $sql_key ] = $k;
		}
	    }
	}
	$messageStack->add_session(sprintf(MSG_SUCCESS_IMPORT,$updated,$imported),'success');
	xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	break;
    case 'deactivate':
	if(sizeOf($_REQUEST['id'])){
	    foreach($_REQUEST['id'] as $id){
		$id = (int)xtc_db_input($id);
                $upd = new \YES4Trade\Model\coupons([
                    'coupon_active'=>'N',
                    'coupon_id'=>$id
                ]);
                $upd->update();
                yes_add_history('Coupon ID '.$id. 'deaktiviert.');
	    }
            
	}
	$messageStack->add_session(sprintf(MSG_SUCCESS_COUPONS_DEACTIVATED,sizeOf($_REQUEST['id'])));
	xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN));
	exit;
	break;
	case 'process_copy':
		$languages = xtc_get_languages();
		$copies = (int)xtc_db_input($_REQUEST['copies']);
		if($copies < 1){
                    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN,xtc_get_all_get_params(array('action'))));
                }
		$desc_insert_sql_array = array();

		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                    $language_id = $languages[$i]['id'];
                    $coupon_desc = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                        intval($_GET['cid']),$language_id,[
                            'coupon_name','coupon_description'
                        ]
                    );
                    $desc_insert_sql_array[] = array(
                        'coupon_name'=>$coupon_desc->coupon_name,
                        'coupon_description'=>$coupon_desc->coupon_description,
                        'language_id'=>$language_id
                    );
                    if(!isset($coupon_name)){
                        $coupon_name = $coupon_desc->coupon_name;
                    }
		}
                $coupon_obj = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_GET['cid']));
                if($coupon_obj === null){
                    throw new Exception('Invalid Coupon ID for process_copy');
                }
		$coupon = $coupon_obj->toArray();
		unset($coupon['coupon_id']);
		for($i=0;$i<$copies;$i++){
			$coupon['coupon_code'] = create_coupon_code($coupon['code'], 12);
                        $new = new \YES4Trade\Model\coupons($coupon);
			$new_coupon_id = $new->create();
			foreach($desc_insert_sql_array as $ck=>$disa){
                            $disa['coupon_id'] = $new_coupon_id;
                            $disa['coupon_name'] = $disa['coupon_name'].' ('.($i+1).')';
                            $new = new \YES4Trade\Model\coupons_description($disa);
                            $new->create();
			}
		}
		$messageStack->add_session(sprintf(MSG_SUCCESS_COUPON_COPIED,$copies,$coupon_name),'success');
		xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN,xtc_get_all_get_params(array('action'))));
		exit;
		break;
	case 'copy':
            $lang_items = array();
            $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                intval($_GET['cid']),intval($_SESSION['languages_id']),[
                    'coupon_name','coupon_description'
                ]
            );
            echo '<div class="main">';
            printf('<b>%s:</b> %s<br /><b>%s:</b> %s',
                COUPON_NAME,$coupon_description->coupon_name,
                COUPON_DESC,$coupon_description->coupon_description
            );
            echo xtc_draw_form('copy_coupon',FILENAME_COUPON_ADMIN,xtc_get_all_get_params(array('action')).'action=process_copy');
            printf('<br /><br /><fieldset><legend>%s</legend><label for="copies">%s</label>%s<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" /></fieldset>',
                INTRO_COPY_COUPON,
                NUMBER_OF_COPIES,
                xtc_draw_input_field('copies', '1', 'id="copies" size="5" maxlength="6"'),
                IMAGE_COPY
            );
            echo '</form>';
            echo '</div>';
            exit;
            break;
	case 'listproducts':
            $smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
            if(!isset($_GET['cid'])){
                throw new Exception('Missing parameter for coupon listproducts');
            }
            $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_GET['cid']),[
                'restrict_to_products','restrict_to_categories'
            ]);
            if($coupon === null){
                throw new Exception('Unknown coupon_id in listproducts');
            }
            $pr_ids = explode(",", $coupon->restrict_to_products);
            $products = array();
            for ($i = 0; $i < count($pr_ids); $i++) {
                $result = xtc_db_query(sprintf(
                    "SELECT products.products_id,products_name,products_model FROM products, products_description WHERE products.products_id = products_description.products_id and products_description.language_id = %d and products.products_id = %d",
                    intval($_SESSION['languages_id']),intval($pr_ids[$i])
                ));
                $products[] = xtc_db_fetch_array($result);
            }
            $smarty->assign(array(
                'action' => $_REQUEST['action'],
                'products'=>$products
            ));
            $smarty->display('coupon_admin.html');
            exit;
            break;
	case 'listcategories':
            $smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
            $categories = array();
            if(!isset($_GET['cid'])){
                throw new Exception('Missing parameter for coupon listproducts');
            }
            $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_GET['cid']),[
                'restrict_to_categories'
            ]);
            if($coupon === null){
                throw new Exception('Unknown coupon_id in listproducts');
            }
            
            $cat_ids = explode(",", $coupon->restrict_to_categories);
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
            $contents = [[
                ['text'=>'ID','th'=>true],
                ['text'=>'Name','th'=>true],
            ]];
            for ($i = 0; $i < count($cat_ids); $i++) {
                $cat_desc = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                    intval($cat_ids[$i]), intval($_SESSION['languages_id']),
                    ['categories_name']
                );
                if($cat_desc !== null){
                    $contents[] = [
                        ['text'=>$cat_ids[$i]],
                        ['text'=>$cat_desc->categories_name]
                    ];
                }
            }
            printf('<div class="main"><h3>%s</h3>%s</div>',
                COUPON_CATEGORIES,
                $table->tableBlock_draw($contents)
            );

            exit;
            break;
}

if ((isset($_GET['action']) and $_GET['action'] == 'send_email_to_user') && isset($_POST['customers_email_address']) && (!$_POST['back_x'])) {
    if(!isset($_GET['cid']) or $_GET['cid'] < 1){
          die('Fehlende Referenz zur coupon_id');
    }
    if(!isset($_POST['from']) or !xtc_validate_email($_POST['from'])){
        die('Email Adresse Absender '.$_POST['from'].' fehlerhaft.');
    }
    switch ($_POST['customers_email_address']) {
        case '***':
            $mail_query = xtc_db_query("select customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS);
            $mail_sent_to = TEXT_ALL_CUSTOMERS;
            break;
        case '**D':
            $mail_query = xtc_db_query("select customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS . " where customers_newsletter = '1'");
            $mail_sent_to = TEXT_NEWSLETTER_CUSTOMERS;
            break;
        default:
            $customers_email_address = xtc_db_prepare_input($_POST['customers_email_address']);
            if(!xtc_validate_email($customers_email_address)){
                die('Email Adresse Empfänger '.$customers_email_address.' fehlerhaft.');
            }
            $mail_query = xtc_db_query("select customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS . " where customers_email_address='".$customers_email_address."'");
            $mail_sent_to = $customers_email_address;
            break;
    }
    $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_GET['cid']),[
        'coupon_code'
    ]);
    if($coupon === null){
        throw new Exception('Unknown Coupon in send_email_to_user');
    }

    $from = $_POST['from'];
    $subject = xtc_db_prepare_input($_POST['subject']);
    // assign language to template for caching
    $smarty->assign('language', $_SESSION['language']);

    $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
    $smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

    $smarty->assign('MESSAGE', $_POST['message']??'');
    $smarty->assign('COUPON_ID', $coupon->coupon_code);
    $smarty->assign('WEBSITE', HTTP_SERVER  . DIR_WS_CATALOG);

    $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);


    $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/send_coupon.html');
    $txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/send_coupon.txt');

    while ($mail = xtc_db_fetch_array($mail_query)) {
        xtc_php_mail(
            EMAIL_BILLING_ADDRESS,EMAIL_BILLING_NAME, 
            $mail['customers_email_address'], 
            $mail['customers_firstname'] . ' ' . $mail['customers_lastname'], 
            '', 
            EMAIL_BILLING_REPLY_ADDRESS, 
            EMAIL_BILLING_REPLY_ADDRESS_NAME, 
            '', 
            '', 
            $subject, 
            $html_mail,
            $txt_mail
        );
    }
    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN, 'mail_sent_to=' . urlencode($mail_sent_to)));
}

if ( (isset($_GET['action']) and $_GET['action'] == 'preview_email') && (!$_POST['customers_email_address']) ) {
    $_GET['action'] = 'email';
    $messageStack->add(ERROR_NO_CUSTOMER_SELECTED, 'error');
}

if (isset($_GET['mail_sent_to'])) {
    $messageStack->add(sprintf(NOTICE_EMAIL_SENT_TO, $_GET['mail_sent_to']), 'notice');
}
switch ($action) {
	case 'confirmdelete':
            $upd = new \YES4Trade\Model\coupons([
                'coupon_active' => 'N',
                'coupon_id'=>intval($_GET['cid'])
            ]);
            $upd->update();
            break;
	case 'update':
		// get all _POST and validate
		$_POST['coupon_code'] = trim($_POST['coupon_code']);
		$languages = xtc_get_languages();
		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
			$language_id = $languages[$i]['id'];
			$_POST['coupon_name'][$language_id] = trim($_POST['coupon_name'][$language_id]);
			$_POST['coupon_desc'][$language_id] = trim($_POST['coupon_desc'][$language_id]);
		}
		$_POST['coupon_amount'] = trim($_POST['coupon_amount']);
		$update_errors = 0;
		if (!isset($_POST['coupon_name'])) {
			$update_errors = 1;
			$messageStack->add(ERROR_NO_COUPON_NAME, 'error');
		}
		if ((!isset($_POST['coupon_amount'])) && (!isset($_POST['coupon_free_ship']))) {
			$update_errors = 1;
			$messageStack->add(ERROR_NO_COUPON_AMOUNT, 'error');
		}
		if (!isset($_POST['coupon_code'])) {
			$coupon_code = create_coupon_code(); 
		}
		if (isset($_POST['coupon_code'])) {
                    $coupon_code = $_POST['coupon_code'];
                }
                
                $coupon = \YES4Trade\Model\coupons::get_by_coupon_code($coupon_code,[
                    'coupon_code'
                ]);
                
		if ($coupon !== null and isset($_POST['coupon_code']) and $_GET['oldaction'] != 'voucheredit')  {
                    $update_errors = 1;
                    $messageStack->add(ERROR_COUPON_EXISTS, 'error');
		}
		if ($update_errors != 0) {
                    $_GET['action'] = 'new';
		} else {  
                    $_GET['action'] = 'update_preview';
		}
		break;
	case 'update_confirm':
		if ( ($_POST['back_x']) || ($_POST['back_y']) ) {
			if(isset($_REQUEST['oldaction']) and $_REQUEST['oldaction'] == 'voucheredit'){
				$_GET['action'] = $_REQUEST['oldaction'];
			}else{
				$_GET['action'] = 'new';
			}
		} else {
                    $coupon_type = "F";
                    if (substr($_POST['coupon_amount'], -1) == '%') {
                        $coupon_type='P';
                    }
                    if (isset($_POST['coupon_free_ship']) and intval($_POST['coupon_free_ship']) == 1) {
                        $coupon_type = 'S';
                    }
                    $sql_data_array = [
                        'coupon_code' => $_POST['coupon_code'],
                        'coupon_amount' => (float)$_POST['coupon_amount'],
                        'coupon_type' => $coupon_type,
                        'uses_per_coupon' => intval($_POST['coupon_uses_coupon']),
                        'uses_per_user' => intval($_POST['coupon_uses_user']),
                        'coupon_minimum_order' => (float)$_POST['coupon_min_order'],
                        'restrict_to_products' => $_POST['coupon_products'],
                        'restrict_to_categories' => $_POST['coupon_categories'],
                        'coupon_start_date' => $_POST['coupon_startdate'],
                        'coupon_expire_date' => $_POST['coupon_finishdate'],
                        'date_created' => date('Y-m-d H:i:s'),
                        'free_shipping_countries'=>$_POST['free_shipping_countries'],
                        'date_modified' => date('Y-m-d H:i:s')
                    ];
                    $languages = xtc_get_languages();
                    $sql_data_marray = [];
                    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                        $language_id = $languages[$i]['id'];
                        $sql_data_marray[$i] = array(
                            'coupon_name' => xtc_db_prepare_input($_POST['coupon_name'][$language_id]),
                            'coupon_description' => xtc_db_prepare_input($_POST['coupon_desc'][$language_id])
                        );
                    }
                    if ($_GET['oldaction']=='voucheredit') {
                        $sql_data_array['coupon_id'] = intval($_GET['cid']);
                        $upd = new \YES4Trade\Model\coupons($sql_data_array);
                        $upd->update();
                        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                            $language_id = $languages[$i]['id'];
                            $upd = new \YES4Trade\Model\coupons_description([
                                'coupon_name' => $_POST['coupon_name'][$language_id], 
                                'coupon_description' => $_POST['coupon_desc'][$language_id],
                                'coupon_id' => intval($_GET['cid']),
                                'language_id' => intval($language_id)
                            ]);
                            $upd->update();
                        }
                    } else {
                        $new = new \YES4Trade\Model\coupons($sql_data_array);
                        $insert_id = $new->create();
                        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                            $language_id = $languages[$i]['id'];
                            $sql_data_marray[$i]['coupon_id'] = intval($insert_id);
                            $sql_data_marray[$i]['language_id'] = intval($language_id);
                            $new = new \YES4Trade\Model\coupons_description($sql_data_marray[$i]);
                            $new->create();
                        }
                    }
                    $messageStack->add_session(sprintf(MSG_SUCCESS_COUPON_UPDATED,current($_POST['coupon_name'])),'success');
                    xtc_redirect(xtc_href_link(FILENAME_COUPON_ADMIN,xtc_get_all_get_params(array('action'))));
		}
		break;
} // end switch action
$smarty->assign('language', $_SESSION['language']);

$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$smarty->assign(array(
    'logo_path'=>HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/',
    'mode'=>'items',
    'action'=>$action,
    'HEADING_TITLE'=>HEADING_TITLE,
    'FORM_END'=>'</form>',
    'TEXT_CSV_IMPORT_INTRO'=>TEXT_CSV_IMPORT_INTRO,
    'TEXT_CSV_IMPORT_FILE'=>TEXT_CSV_IMPORT_FILE,
    'FORM_IMPORT_ACTION'=>xtc_href_link(FILENAME_COUPON_ADMIN,'action=import'),
    'BUTTON_IMPORT'=>BUTTON_IMPORT,
    'TEXT_MESSAGE_FREE_SHIPPING_NO_VALUE'=>TEXT_MESSAGE_FREE_SHIPPING_NO_VALUE
));
$action = $_GET['action']??'';
switch ($action) {
    case 'voucherreport':
        if(!isset($_GET['cid']) or intval($_GET['cid'])<1){
            throw new Exception('Missing coupon_id parameter for voucherreport');
        }
        $items = array();
        $redeems = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($_GET['cid']));
        foreach($redeems as $redeem) {
            $cc_list = $redeem->toArray();
            $rows++;
            if (strlen($rows) < 2) {
                    $rows = '0' . $rows;
            }
            if (((!$_GET['uid']) || (@$_GET['uid'] == $cc_list['unique_id'])) && (!$cInfo)) {
                $cInfo = new objectInfo($cc_list);
            }
            if ( (is_object($cInfo)) && ($cc_list['unique_id'] == $cInfo->unique_id) ) {
                    $tr_click = 'document.location.href=\'' . xtc_href_link('coupon_admin.php', xtc_get_all_get_params(array('cid', 'action', 'uid')) . 'cid=' . $cInfo->coupon_id . '&action=voucherreport&uid=' . $cinfo->unique_id) . '\'';
            } else {
                    $tr_click = 'document.location.href=\'' . xtc_href_link('coupon_admin.php', xtc_get_all_get_params(array('cid', 'action', 'uid')) . 'cid=' . $cc_list['coupon_id'] . '&action=voucherreport&uid=' . $cc_list['unique_id']) . '\'';
            }
            $customer = \YES4Trade\Model\customers::get_by_customers_id(
                intval($cc_list['customer_id']),
                ['customers_firstname','customers_lastname']
            );
            
            $redeems_customers = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id_and_customers_id(
                intval($_GET['cid']),intval($cc_list['customer_id']),[
                    'coupon_id'
                ]
            );
            $items[] = array(
                'tr_click'=>$tr_click,
                'customers_id'=>$cc_list['customer_id'],
                'name'=>$customer->customers_firstname . ' ' . $customer->customers_lastname,
                'ip'=>$cc_list['redeem_ip'],
                'date'=>xtc_date_short($cc_list['redeem_date']),
                'action'=>( is_object($cInfo) && ($cc_list['unique_id'] == $cInfo->unique_id)  ? 
                    xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif') : 
                    '<a href="' . xtc_href_link(FILENAME_COUPON_ADMIN, 'page=' . $_GET['page'] . '&cid=' . $cc_list['coupon_id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'
                ),
                'redemptions_customer'=>sizeOf($redeems_customers)
            );
        } // end foreach redeems
                
        if(isset($_GET['export_csv']) and $_GET['export_csv'] == 1){
            require(DIR_WS_CLASSES.'class.csv.php');
            $filename = sprintf('coupon_report_'.date('Y-m-d_His').'.csv');
            $fh = fopen(\main::get_exportdata_path().$filename,'a+') or die("Kann ".$filename." nicht anlegen.");
            fclose($fh);
            $CSV = new CSVfile(\main::get_exportdata_path().$filename);
            $CSV->delimiter = "\t";
            $CSV->open('w');
            $csv_header = array(
                CUSTOMER_ID,
                CUSTOMER_NAME,
                IP_ADDRESS,
                html_entity_decode(REDEEM_DATE),
                html_entity_decode(TEXT_REDEMPTIONS_CUSTOMER)
            );
            $CSV->addRow($csv_header);
            foreach($items as $product){
                $line = array(
                    $product['customers_id'],
                    $product['name'],
                    $product['ip'],
                    $product['date'],
                    $product['redemptions_customer']
                );
                $CSV->addRow($line);
            }
            $CSV->close();
            $content = file_get_contents(\main::get_exportdata_path().$filename);
            unlink(\main::get_exportdata_path().$filename);
            $len = strlen($content);
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename=".$filename);
            header("Content-Length: ".$len);
            echo $content;
            exit;

        }
        $count_customers = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id_and_customers_id(
            intval($_GET['cid']), intval($cInfo->customer_id),[
                'coupon_id'
            ]
        );
        $smarty->assign(array(
            'CUSTOMER_ID'=>CUSTOMER_ID,
            'CUSTOMER_NAME'=>CUSTOMER_NAME,
            'IP_ADDRESS'=>IP_ADDRESS,
            'REDEEM_DATE'=>REDEEM_DATE,
            'TABLE_HEADING_ACTION'=>TABLE_HEADING_ACTION,
            'items'=>$items,
            'TEXT_NO_REPORT_AVAILABLE'=>TEXT_NO_REPORT_AVAILABLE,
            'TEXT_HEADING_COUPON_REPORT'=>TEXT_HEADING_COUPON_REPORT
        ));
        $heading = array();
        $contents = array();
        $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
            intval($_GET['cid']), intval($_SESSION['languages_id']),[
                'coupon_name'
            ]
        );
        $heading[] = array('text' => '<b>[' . $_GET['cid'] . ']' . COUPON_NAME . ' ' . $coupon_description->coupon_name . '</b>');
        $contents[] = array('text' => '<b>' . TEXT_REDEMPTIONS . '</b>');
        $contents[] = array('text' => TEXT_REDEMPTIONS_TOTAL . '=' . sizeOf($items));
        $contents[] = array('text' => TEXT_REDEMPTIONS_CUSTOMER . '=' . sizeOf($count_customers));
        break;
    case 'preview_email': 
        $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                intval($_GET['cid']), intval($_SESSION['languages_id']),[
                    'coupon_name'
                ]
        );
        if($coupon_description === null){
            throw new Exception('Invalid coupon for preview email');
        }
        
        switch ($_POST['customers_email_address']) {
            case '***':
                $mail_sent_to = TEXT_ALL_CUSTOMERS;
                break;
            case '**D':
                $mail_sent_to = TEXT_NEWSLETTER_CUSTOMERS;
                break;
            default:
                $mail_sent_to = $_POST['customers_email_address'];
                break;
        }
        /* Re-Post all POST'ed variables */
        reset($_POST);
        $hidden = '';
        foreach($_POST as $key => $value) {
            if (!is_array($_POST[$key])) {
                    $hidden .= xtc_draw_hidden_field($key, htmlspecialchars(stripslashes($value)));
            }
        }
        $smarty->assign(array(
                'FORM'=>xtc_draw_form('mail', FILENAME_COUPON_ADMIN, 'action=send_email_to_user&cid=' . $_GET['cid']),
                'TEXT_CUSTOMER'=>TEXT_CUSTOMER,
                'mail_sent_to'=>$mail_sent_to,
                'TEXT_COUPON'=>TEXT_COUPON,
                'coupon_name'=>$coupon_description->coupon_name,
                'TEXT_FROM'=>TEXT_FROM,
                'from'=>htmlspecialchars(stripslashes($_POST['from'])),
                'TEXT_SUBJECT'=>TEXT_SUBJECT,
                'subject'=>htmlspecialchars(stripslashes($_POST['subject'])),
                'TEXT_MESSAGE'=>TEXT_MESSAGE,
                'message'=>nl2br(htmlspecialchars(stripslashes($_POST['message']))),
                'hidden'=>$hidden,
                'BUTTON_CANCEL'=>'<a href="' . xtc_href_link(FILENAME_COUPON_ADMIN) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>', 
                'BUTTON_SUBMIT'=>xtc_image_submit('button_send_mail.gif', IMAGE_SEND_EMAIL)
        ));
        break;       
    case 'email':
        $smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        $box = new box;
        $smarty->assign('BOX',$box->infoBox($heading, $contents));
        $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
            intval($_GET['cid']),intval($_SESSION['languages_id']),[
                'coupon_name'
            ]
        );
        if($coupon_description === null){
            throw new Exception('Invalid coupon for email');
        }
        $customers = array();
        $customers[] = array('id' => '', 'text' => TEXT_SELECT_CUSTOMER);
	$smarty->assign(array(
            'FORM'=>xtc_draw_form('mail', FILENAME_COUPON_ADMIN, 'action=preview_email&cid='. $_GET['cid']),
            'TEXT_COUPON'=>TEXT_COUPON,
            'coupon_name'=>$coupon_description->coupon_name,
            'TEXT_CUSTOMER'=>TEXT_CUSTOMER,
            'TEXT_FROM'=>TEXT_FROM,
            'from'=>xtc_draw_input_field('from', EMAIL_FROM),
            'TEXT_SUBJECT'=>TEXT_SUBJECT,
            'subject'=>xtc_draw_input_field('subject'),
            'TEXT_MESSAGE'=>TEXT_MESSAGE,
            'message'=>xtc_draw_textarea_field('message', 'soft', '60', '15'),
            'BUTTON_SUBMIT'=>xtc_image_submit('button_send_mail.gif', IMAGE_SEND_EMAIL)
        ));
        $html = $smarty->fetch(DIR_FS_ADMIN.'templates/coupon_admin.html');
        die($html);
        break;
    case 'update_preview':
        $start_date = date(DATE_FORMAT, mktime(0, 0, 0, $_POST['coupon_startdate_month'],$_POST['coupon_startdate_day'] ,$_POST['coupon_startdate_year'] ));
        $finish_date = date(DATE_FORMAT, mktime(0, 0, 0, $_POST['coupon_finishdate_month'],$_POST['coupon_finishdate_day'] ,$_POST['coupon_finishdate_year'] ));
        $languages = xtc_get_languages();
        $lang_items = array();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                $language_id = $languages[$i]['id'];
                $hidden = xtc_draw_hidden_field('coupon_name[' . $languages[$i]['id'] . ']', $_POST['coupon_name'][$language_id]);
                $hidden .= xtc_draw_hidden_field('coupon_desc[' . $languages[$i]['id'] . ']', $_POST['coupon_desc'][$language_id]);
                $lang_items[$language_id] = array(
                        'coupon_name'=>$_POST['coupon_name'][$language_id],
                        'coupon_desc'=>$_POST['coupon_desc'][$language_id],
                        'hidden'=>$hidden,
                        'lang'=>$languages[$i]['name']
                );
        }
        if ($_POST['coupon_code']) {
                $c_code = $_POST['coupon_code'];
        } else {
                $c_code = $coupon_code;
        }
        $hidden = xtc_draw_hidden_field('coupon_amount', $_POST['coupon_amount']);
        $hidden .= xtc_draw_hidden_field('coupon_min_order', $_POST['coupon_min_order']);
        $hidden .=  xtc_draw_hidden_field('coupon_free_ship', ((isset($_POST['coupon_free_ship'])) ? $_POST['coupon_free_ship'] : '') );
        $hidden .=  xtc_draw_hidden_field('coupon_code', $c_code);
        $hidden .=  xtc_draw_hidden_field('coupon_uses_coupon', $_POST['coupon_uses_coupon']);
        $hidden .=  xtc_draw_hidden_field('coupon_uses_user', $_POST['coupon_uses_user']);
        $hidden .=  xtc_draw_hidden_field('coupon_products', $_POST['coupon_products']);
        $hidden .=  xtc_draw_hidden_field('coupon_categories', $_POST['coupon_categories']);
        $hidden .=  xtc_draw_hidden_field('free_shipping_countries', ((isset($_POST['free_shipping_countries'])) ? $_POST['free_shipping_countries'] : ''));
        $hidden .=  xtc_draw_hidden_field('coupon_startdate', date('Y-m-d', mktime(0, 0, 0, $_POST['coupon_startdate_month'],$_POST['coupon_startdate_day'] ,$_POST['coupon_startdate_year'] )));
        $hidden .=  xtc_draw_hidden_field('coupon_finishdate', date('Y-m-d', mktime(0, 0, 0, $_POST['coupon_finishdate_month'],$_POST['coupon_finishdate_day'] ,$_POST['coupon_finishdate_year'] )));
        $smarty->assign(array(
                'TEXT_COUPON_KEY'=>TEXT_COUPON_KEY,
                'TEXT_COUPON_VALUE'=>TEXT_COUPON_VALUE,
                'FORM'=>xtc_draw_form('coupon', 'coupon_admin.php', 'action=update_confirm&oldaction=' . $_GET['oldaction'] . '&cid=' . $_GET['cid']), 
                'COUPON_NAME'=>COUPON_NAME,
                'COUPON_DESC'=>COUPON_DESC,
                'COUPON_AMOUNT'=>COUPON_AMOUNT,
                'coupon_amount'=>$_POST['coupon_amount'],
                'COUPON_MIN_ORDER'=>COUPON_MIN_ORDER,
                'coupon_min_order'=>$_POST['coupon_min_order'],
                'COUPON_FREE_SHIP'=>COUPON_FREE_SHIP,
                'coupon_free_ship'=>((isset($_POST['coupon_free_ship']))?TEXT_FREE_SHIPPING.((($_POST['free_shipping_countries'] != ''))?'&nbsp;<i>(in '.$_POST['free_shipping_countries'].')</i>':''):TEXT_NO_FREE_SHIPPING),
                'COUPON_CODE'=>COUPON_CODE,
                'coupon_code'=>$coupon_code,
                'COUPON_USES_COUPON'=>COUPON_USES_COUPON,
                'coupon_uses_coupon'=>$_POST['coupon_uses_coupon'],
                'COUPON_USES_USER'=>COUPON_USES_USER,
                'coupon_uses_user'=>$_POST['coupon_uses_user'],
                'COUPON_PRODUCTS'=>COUPON_PRODUCTS,
                'coupon_products'=>$_POST['coupon_products'],
                'COUPON_CATEGORIES'=>COUPON_CATEGORIES,
                'coupon_categories'=>$_POST['coupon_categories'],
                'COUPON_STARTDATE'=>COUPON_STARTDATE,
                'coupon_startdate'=>$start_date,
                'COUPON_FINISHDATE'=>COUPON_FINISHDATE,
                'coupon_finishdate'=>$finish_date,
                'hidden'=>$hidden,
                'BUTTON_CONFIRM'=>xtc_image_submit('button_confirm.gif',COUPON_BUTTON_CONFIRM),
                'BUTTON_BACK'=>xtc_image_submit('button_back.gif',COUPON_BUTTON_BACK, 'name=back'),
                'lang_items'=>$lang_items,
                'hidden'=>$hidden,
                'NOBOX'=>1
        ));
        break;
    case 'voucheredit':
        $lang_items = array();
        $languages = xtc_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $language_id = $languages[$i]['id'];
            $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                intval($_GET['cid']), intval($language_id),[
                    'coupon_name','coupon_description'
                ]
            );
            $coupon_name[$language_id] = $coupon_description->coupon_name;
            $coupon_desc[$language_id] = $coupon_description->coupon_description;
            $lang_items[] = array(
                'coupon_name'=>xtc_draw_input_field('coupon_name[' . $languages[$i]['id'] . ']', $coupon_description->coupon_name) 
                    . '&nbsp;' . xtc_image(DIR_WS_LANGUAGES.$languages[$i]['directory'].'/admin/images/'.$languages[$i]['image']),
                'coupon_desc'=>xtc_draw_textarea_field('coupon_desc[' . $languages[$i]['id'] . ']','physical','24','3', $coupon_description->coupon_description)
                    . '&nbsp;' . xtc_image(DIR_WS_LANGUAGES.$languages[$i]['directory'].'/admin/images/'.$languages[$i]['image'])
            );
        }
        $coupon_obj = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_GET['cid']));
        $coupon = $coupon_obj->toArray();
        
        $coupon_amount = $coupon['coupon_amount'];
        if ($coupon['coupon_type']=='P') {
                $coupon_amount .= '%';
        }
        $coupon_free_ship = false;
        if ($coupon['coupon_type']=='S') {
                $coupon_free_ship = true;
        }     
        $coupon_min_order = $coupon['coupon_minimum_order'];
        $coupon_code = $coupon['coupon_code'];
        $coupon_uses_coupon = $coupon['uses_per_coupon'];
        $coupon_uses_user = $coupon['uses_per_user'];
        $coupon_products = $coupon['restrict_to_products'];
        $coupon_categories = $coupon['restrict_to_categories'];

        $coupon_startdate = explode('-',$coupon['coupon_start_date']);
        $coupon_startdate[2] = current(explode(' ',$coupon_startdate[2]));
        $coupon_finishdate = explode('-',$coupon['coupon_expire_date']);
        $coupon_finishdate[2] = current(explode(' ',$coupon_finishdate[2]));

        $coupon_products_value = (!$coupon_free_ship) ? $coupon_products : '';
        $coupon_categories_value = (!$coupon_free_ship) ? $coupon_categories : '';
        $p_c_disabled = (!$coupon_free_ship) ? 'enabled' : 'disabled';
        $smarty->assign(array(
                'FORM'=>xtc_draw_form('coupon', 'coupon_admin.php', 'action=update&oldaction='.$_GET['action'] . '&cid=' . $_GET['cid']), 
                'COUPON_NAME'=>COUPON_NAME,
                'COUPON_NAME_HELP'=>COUPON_NAME_HELP,
                'COUPON_DESC'=>COUPON_DESC,
                'COUPON_DESC_HELP'=>COUPON_DESC_HELP,
                'COUPON_AMOUNT'=>COUPON_AMOUNT,
                'COUPON_AMOUNT_HELP'=>COUPON_AMOUNT_HELP,
                'coupon_amount'=>xtc_draw_input_field('coupon_amount', $coupon_amount),
                'COUPON_MIN_ORDER'=>COUPON_MIN_ORDER,
                'COUPON_MIN_ORDER_HELP'=>COUPON_MIN_ORDER_HELP,
                'coupon_min_order'=>xtc_draw_input_field('coupon_min_order', $coupon_min_order),
                'COUPON_FREE_SHIP'=>COUPON_FREE_SHIP,
                'COUPON_FREE_COUNTRIES'=>'L&auml;nder',
                'COUPON_FREE_SHIP_HELP'=>COUPON_FREE_SHIP_HELP,
                'coupon_free_ship'=>xtc_draw_checkbox_field('coupon_free_ship', $coupon_free_ship,false,false,'id="coupon_free_ship"'),
                'coupon_free_ship_countries'=>xtc_draw_input_field('free_shipping_countries',$coupon['free_shipping_countries']),
                'COUPON_CODE'=>COUPON_CODE,
                'COUPON_CODE_HELP'=>COUPON_CODE_HELP,
                'coupon_code'=>xtc_draw_input_field('coupon_code', $coupon_code),
                'COUPON_USES_COUPON'=>COUPON_USES_COUPON,
                'COUPON_USES_COUPON_HELP'=>COUPON_USES_COUPON_HELP,
                'coupon_uses_coupon'=>xtc_draw_input_field('coupon_uses_coupon', $coupon_uses_coupon),
                'COUPON_USES_USER'=>COUPON_USES_USER,
                'COUPON_USES_USER_HELP'=>COUPON_USES_USER_HELP,
                'coupon_uses_user'=>xtc_draw_input_field('coupon_uses_user', $coupon_uses_user),
                'COUPON_PRODUCTS'=>COUPON_PRODUCTS,
                'COUPON_PRODUCTS_HELP'=>COUPON_PRODUCTS_HELP,
                'coupon_products'=>xtc_draw_input_field('coupon_products', '','disabled="disabled"',false,'text',false),
                'COUPON_CATEGORIES'=>COUPON_CATEGORIES,
                'COUPON_CATEGORIES_HELP'=>COUPON_CATEGORIES_HELP,
                'coupon_categories'=>xtc_draw_input_field('coupon_categories', '','disabled="disabled"',false,'text',false),
                'COUPON_STARTDATE'=>COUPON_STARTDATE,
                'COUPON_STARTDATE_HELP'=>COUPON_STARTDATE_HELP,
                'coupon_startdate'=>xtc_draw_date_selector('coupon_startdate', $coupon['coupon_start_date']),
                'COUPON_FINISHDATE'=>COUPON_FINISHDATE,
                'COUPON_FINISHDATE_HELP'=>COUPON_FINISHDATE_HELP,
                'coupon_finishdate'=>xtc_draw_date_selector('coupon_finishdate', $coupon['coupon_expire_date']),
                'BUTTON_CONFIRM'=>xtc_image_submit('button_preview.gif',IMAGE_PREVIEW),
                'BUTTON_BACK'=>'<a href="' . xtc_href_link('coupon_admin.php', '').'">'.xtc_image_button('button_cancel.gif', IMAGE_CANCEL).'</a>',
                'lang_items'=>$lang_items,
                'NOBOX'=>1
        ));
        break;
    case 'new':
        // set some defaults
        if (!isset($coupon_uses_user)) $coupon_uses_user=1;
        if (!isset($_POST['coupon_startdate'])) {
                $coupon_startdate = explode("-", date('Y-m-d'));
        } else {
                $coupon_startdate = explode("-", $_POST['coupon_startdate']);
        }
        if (!isset($_POST['coupon_finishdate'])) {
                $coupon_finishdate = explode("-", date('Y-m-d'));
                $coupon_finishdate[0] = (int)$coupon_finishdate[0] + 3;
        } else {
                $coupon_finishdate = explode("-", $_POST['coupon_finishdate']);
        }
        $lang_items = array();
        $languages = xtc_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                $language_id = $languages[$i]['id'];
                $lang_items[] = array(
                        'coupon_name'=>xtc_draw_input_field('coupon_name[' . $languages[$i]['id'] . ']', ((isset($_REQUEST['coupon_name']))?$_REQUEST['coupon_name'][$language_id]:'')) . '&nbsp;' . xtc_image(DIR_WS_LANGUAGES.$languages[$i]['directory'].'/admin/images/'.$languages[$i]['image']),
                        'coupon_desc'=>xtc_draw_textarea_field('coupon_desc[' . $languages[$i]['id'] . ']','physical','24','3', ((isset($_REQUEST['coupon_desc']))?$_REQUEST['coupon_desc'][$language_id]:'')) . '&nbsp;' . xtc_image(DIR_WS_LANGUAGES.$languages[$i]['directory'].'/admin/images/'.$languages[$i]['image'])
                );
        }
        $smarty->assign(array(
                'FORM'=>xtc_draw_form('coupon', 'coupon_admin.php', 'action=update&oldaction='.((isset($_GET['action']))?$_GET['action']:'') . '&cid=' . ((isset($_GET['cid']))?$_GET['cid']:'')), 
                'COUPON_NAME'=>COUPON_NAME,
                'COUPON_NAME_HELP'=>COUPON_NAME_HELP,
                'COUPON_DESC'=>COUPON_DESC,
                'COUPON_DESC_HELP'=>COUPON_DESC_HELP,
                'COUPON_AMOUNT'=>COUPON_AMOUNT,
                'COUPON_AMOUNT_HELP'=>COUPON_AMOUNT_HELP,
                'coupon_amount'=>xtc_draw_input_field('coupon_amount', ((isset($_REQUEST['coupon_amount']))?$_REQUEST['coupon_amount']:'') ),
                'COUPON_MIN_ORDER'=>COUPON_MIN_ORDER,
                'COUPON_MIN_ORDER_HELP'=>COUPON_MIN_ORDER_HELP,
                'coupon_min_order'=>xtc_draw_input_field('coupon_min_order', ((isset($_REQUEST['coupon_min_order']))?$_REQUEST['coupon_min_order']:'') ),
                'COUPON_FREE_SHIP'=>COUPON_FREE_SHIP,
                'COUPON_FREE_COUNTRIES'=>'L&auml;nder',
                'COUPON_FREE_SHIP_HELP'=>COUPON_FREE_SHIP_HELP,
                'coupon_free_ship'=>xtc_draw_checkbox_field('coupon_free_ship', 1, ((isset($_REQUEST['coupon_free_ship']) and $_REQUEST['coupon_free_ship']==1)?true:false),false,'id="coupon_free_ship"'),
                'coupon_free_ship_countries'=>xtc_draw_input_field('free_shipping_countries', ((isset($_REQUEST['free_shipping_countries']))?$_REQUEST['free_shipping_countries']:'') ),
                'COUPON_CODE'=>COUPON_CODE,
                'COUPON_CODE_HELP'=>COUPON_CODE_HELP,
                'coupon_code'=>xtc_draw_input_field('coupon_code', ((isset($_REQUEST['coupon_code']))?$_REQUEST['coupon_code']:'') ),
                'COUPON_USES_COUPON'=>COUPON_USES_COUPON,
                'COUPON_USES_COUPON_HELP'=>COUPON_USES_COUPON_HELP,
                'coupon_uses_coupon'=>xtc_draw_input_field('coupon_uses_coupon', ((isset($_REQUEST['coupon_uses_coupon']))?$_REQUEST['coupon_uses_coupon']:'') ),
                'COUPON_USES_USER'=>COUPON_USES_USER,
                'COUPON_USES_USER_HELP'=>COUPON_USES_USER_HELP,
                'coupon_uses_user'=>xtc_draw_input_field('coupon_uses_user', ((isset($_REQUEST['coupon_uses_user'])) ? $_REQUEST['coupon_uses_user']:'') ),
                'COUPON_PRODUCTS'=>COUPON_PRODUCTS,
                'COUPON_PRODUCTS_HELP'=>COUPON_PRODUCTS_HELP,
/*			'coupon_products'=>xtc_draw_input_field('coupon_products', ((isset($_REQUEST['coupon_products']))?$_REQUEST['coupon_products']:'') ,'id="coupon_products"').'<A HREF="validproducts.php" TARGET="_blank" ONCLICK="window.open(\'validproducts.php\', \'Valid_Products\', \'scrollbars=yes,resizable=yes,menubar=yes,width=600,height=600\'); return false">View</A>', */
                'coupon_products'=>xtc_draw_input_field('coupon_products', '' ,'disabled="disabled"'),
                'COUPON_CATEGORIES'=>COUPON_CATEGORIES,
                'COUPON_CATEGORIES_HELP'=>COUPON_CATEGORIES_HELP,
/*			'coupon_categories'=>xtc_draw_input_field('coupon_categories', ((isset($_REQUEST['coupon_categories']))?$_REQUEST['coupon_categories']:'') ,'id="coupon_categories"').'<A HREF="validcategories.php" TARGET="_blank" ONCLICK="window.open(\'validcategories.php\', \'Valid_Categories\', \'scrollbars=yes,resizable=yes,menubar=yes,width=600,height=600\'); return false">View</A>',*/
                'coupon_categories'=>xtc_draw_input_field('coupon_categories', '','disabled="disabled"'),
                'COUPON_STARTDATE'=>COUPON_STARTDATE,
                'COUPON_STARTDATE_HELP'=>COUPON_STARTDATE_HELP,
                'coupon_startdate'=>xtc_draw_date_selector('coupon_startdate', sprintf('%s-%s-%s',$coupon_startdate[0],$coupon_startdate[1], $coupon_startdate[2])),
                'COUPON_FINISHDATE'=>COUPON_FINISHDATE,
                'COUPON_FINISHDATE_HELP'=>COUPON_FINISHDATE_HELP,
                'coupon_finishdate'=>xtc_draw_date_selector('coupon_finishdate', sprintf('%s-%s-%s',$coupon_finishdate[0], $coupon_finishdate[1], $coupon_finishdate[2])),
                'BUTTON_CONFIRM'=>xtc_image_submit('button_preview.gif',IMAGE_PREVIEW),
                'BUTTON_BACK'=>'<a href="' . xtc_href_link('coupon_admin.php', '').'">'.xtc_image_button('button_cancel.gif', IMAGE_CANCEL).'</a>',
                'lang_items'=>$lang_items,
                'NOBOX'=>1
        ));
        break;
    case 'export':
    default:
        $status_array[] = array('id' => 'Y', 'text' => TEXT_COUPON_ACTIVE);
        $status_array[] = array('id' => 'N', 'text' => TEXT_COUPON_INACTIVE);
        $status_array[] = array('id' => '*', 'text' => TEXT_COUPON_ALL);

        if (isset($_GET['status'])) {
                $status = xtc_db_prepare_input($_GET['status']);
        } else { 
                $status = 'Y';
        } 
        if (isset($_GET['page']) and $_GET['page'] > 1) {
            $rows = $_GET['page'] * MAX_DISPLAY_SEARCH_RESULTS_ADMIN - MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
        }

        $from = TABLE_COUPONS;
        $where = "coupon_type != 'G'";

        if(isset($_REQUEST['search_string']) and $_REQUEST['search_string'] != ''){
            $from .= " left join coupons_description cd using(coupon_id) ";
            $where .= " and (cd.coupon_name like '".xtc_db_input($_REQUEST['search_string'])."%' or coupon_code LIKE '".xtc_db_input($_REQUEST['search_string'])."%') and cd.language_id='".$_SESSION['languages_id']."'";
        }

        if ($status != '*') {
            $where .= " and coupon_active='" . xtc_db_input($status) . "'";
            $cc_query_raw = "select coupon_id, coupon_code, coupon_amount, coupon_type, coupon_start_date,coupon_expire_date,uses_per_user,uses_per_coupon,restrict_to_products, restrict_to_categories, date_created,date_modified,coupon_minimum_order, restrict_to_customers, coupon_active,free_shipping_countries from " . $from ." where ".$where;
        } else {
            $cc_query_raw = "select coupon_id, coupon_code, coupon_amount, coupon_type, coupon_start_date,coupon_expire_date,uses_per_user,uses_per_coupon,restrict_to_products, restrict_to_categories, date_created,date_modified,coupon_minimum_order, restrict_to_customers, coupon_active,free_shipping_countries from " . $from . " where ".$where;
        }
        if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'export'){
            require_once(DIR_WS_CLASSES.'class.csv.php');
            require_once(DIR_WS_CLASSES.'class.basics.php');
            $file = \main::get_exportdata_path().'kupon.csv';
            $basics = new basics;
            $basics->create_file($file, 'test');
            //chmod($file,0777);
            $CSV = new CSVfile($file);
            $query = xtc_db_query($cc_query_raw);
            $CSV->open('w');
            $languages = xtc_get_languages();
            $header = array();
            foreach($languages as $lang){
                $header[] = 'coupon_description_'.$lang['code'];
                $header[] = 'coupon_name_'.$lang['code'];
            }

            $header = array_merge($header,array(
                    'coupon_code',
                    'coupon_amount',
                    'coupon_type',
                    'coupon_start_date',
                    'coupon_expire_date',
                    'uses_per_user',
                    'uses_per_coupon',
                    'restrict_to_products',
                    'restrict_to_categories',
                    'date_created',
                    'date_modified',
                    'coupon_minimum_order',
                    'restrict_to_customers', 
                    'coupon_active',
                    'free_shipping_countries'
            ));
            $CSV->addRow($header);
            $_tmp = [];
            while($row = xtc_db_fetch_array($query)){
                $_tmp[] = $row;
            }
            foreach($_tmp as $row){
                $data = array();
                $coupon_descriptions = \YES4Trade\Model\coupons_description::get_by_coupon_id(
                    intval($row['coupon_id']),[
                        'coupon_name', 'coupon_description'
                    ]
                );
                foreach($coupon_descriptions as $cd){
                    $data[] = str_replace(array("\r\n",';'),array(' ',','),$cd->coupon_description);
                    $data[] = $cd->coupon_name;
                }


                foreach($row as $key=>$value){
                    switch($key){
                        case 'coupon_id':
                                break;
                        default:
                                $data[] = $value;
                                break;
                    }
                }
                $CSV->addRow($data);
            }
            $CSV->close();
            $c = file_get_contents($file);
            unlink($file);
            $len = strlen($c);
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename=kupons.csv");
            header("Content-Length: ".$len);
            echo $c;
            exit;
        }
        $cc_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $cc_query_raw, $cc_query_numrows);
        $cc_query = xtc_db_query($cc_query_raw);
        $items = array();
        $rows = 0;
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal coupons_table"';
        $contents = [[
            ['text'=>'&nbsp;','th'=>true,'params'=>'width="20"'],
            ['text'=>COUPON_NAME,'th'=>true],
            ['text'=>COUPON_AMOUNT,'th'=>true],
            ['text'=>COUPON_CODE,'th'=>true],
        ]];
        $_tmp = [];
        while ($cc_list = xtc_db_fetch_array($cc_query)) {
            $_tmp[] = $cc_list;
        }
        foreach($_tmp as $cc_list){
            $rows++;
            if (strlen($rows) < 2) {
                    $rows = '0' . $rows;
            }
            $selected = '';
            if (( !isset($_GET['cid']) || (@$_GET['cid'] == $cc_list['coupon_id'])) && !isset($cInfo)) {
                $cInfo = new objectInfo($cc_list);
                $selected = ' class="ui-state-active" data-activerow="1"';
            }
            $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                intval($cc_list['coupon_id']),intval($_SESSION['languages_id']),[
                    'coupon_name'
                ]
            );
            if ($cc_list['coupon_type'] == 'P') {
                $type = $cc_list['coupon_amount'] . '%';
            } elseif ($cc_list['coupon_type'] == 'S') {
                $type = TEXT_FREE_SHIPPING;
            } else {
                $type = $currencies->format($cc_list['coupon_amount']);
            }
            $contents[] = [
                'params'=>'data-couponid="'.$cc_list['coupon_id'].'"'.$selected,
                ['text'=> xtc_draw_checkbox_field('id[]', $cc_list['coupon_id'])],
                ['text'=>$coupon_description->coupon_name??'unknown'],
                ['text'=>$type],
                ['text'=>$cc_list['coupon_code']]
            ];
        }
        $contents[] = [
            ['text'=>$cc_split->display_count($cc_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_COUPONS)
                .'<br />'.$cc_split->display_links($cc_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, MAX_DISPLAY_PAGE_LINKS, $_GET['page']),
                'params'=>'colspan="4"',
                'align'=>'center',
            ]
        ];
        $action_array = array(
            array('id'=>'','text'=>TEXT_SELECT),
            array('id'=>'deactivate','text'=>TEXT_MENU_DEACTIVATE_COUPON)
        );
        $smarty->assign(array(
            'LIST_FORM_ACTION'=>xtc_href_link(FILENAME_COUPON_ADMIN),
            'LIST_ACTION_INPUT'=>xtc_draw_pull_down_menu('action',$action_array,'','id="action"'),
            'TEXT_SELECTED_COUPONS'=>TEXT_SELECTED_COUPONS,
            'TEXT_DEACTIVATE_COUPONS'=>TEXT_DEACTIVATE_COUPONS,
            'FORM'=>xtc_draw_form('status', FILENAME_COUPON_ADMIN, '', 'get'),
            'HEADING_TITLE_STATUS'=>HEADING_TITLE_STATUS,
            'status'=>xtc_draw_pull_down_menu('status', $status_array, $status, 'onChange="this.form.submit();" id="status"'),
            'IMAGE_SEARCH'=>IMAGE_SEARCH,
            'search'=>xtc_draw_input_field('search_string', $_REQUEST['search_string']??'', 'id="search_string"'),
            'TABLE'=>$table->tableBlock_draw($contents),
            'BUTTON_SUBMIT'=>'<a href="' . xtc_href_link('coupon_admin.php', 'page=' . $_GET['page'] . ((isset($cInfo->coupon_id)) ? '&cID=' . $cInfo->coupon_id:'') . '&action=new') . '">' . xtc_image_button('button_insert.gif', IMAGE_INSERT) . '</a>',
            'BUTTON_EXPORT'=>'<input onclick="window.location.href=\'' . xtc_href_link('coupon_admin.php', xtc_get_all_get_params(array('action')) .'action=export') . '\'" type="button" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_EXPORT.'"/>',
            'VIEW_COUPON_BOX_INFO_BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['cid']).'cid=')
        ));
        $contents = []; // VARIABLE WIRD UNTEN VERWENDET
        break;
}

switch ($action) {
	case 'release':
		break;
	case 'voucherreport':
		break;
	case 'neww':
		$heading[] = array('text' => '<b>' . TEXT_HEADING_NEW_COUPON . '</b>');
		$contents[] = array('text' => TEXT_NEW_INTRO);
		$contents[] = array('text' => '<br />' . COUPON_NAME . '<br />' . xtc_draw_input_field('name'));
		$contents[] = array('text' => '<br />' . COUPON_AMOUNT . '<br />' . xtc_draw_input_field('voucher_amount'));
		$contents[] = array('text' => '<br />' . COUPON_CODE . '<br />' . xtc_draw_input_field('voucher_code'));
		$contents[] = array('text' => '<br />' . COUPON_USES_COUPON . '<br />' . xtc_draw_input_field('voucher_number_of'));
		break;
	default:
            if(isset($cInfo->coupon_id)){
                    $heading[] = array('text'=>'['.$cInfo->coupon_id.']  '.$cInfo->coupon_code);
                    $amount = $cInfo->coupon_amount;
                    if ($cInfo->coupon_type == 'P') {
                            $amount .= '%';
                    }elseif ($cInfo->coupon_type == 'S') {
                            $amount = 'Versandkostenfrei';
                    } else {
                            $amount = $currencies->format($amount);
                    }
                    if (isset($_GET['action']) and $_GET['action'] == 'voucherdelete') {
                            $contents[] = array('text'=> TEXT_CONFIRM_DELETE . '</br></br>' . 
                                    '<a href="'.xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action')).'action=confirmdelete').'">'.xtc_image_button('button_confirm.gif','Confirm Delete Voucher').'</a>' .
                                    '<a href="'.xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action'))).'">'.xtc_image_button('button_cancel.gif','Cancel').'</a>'
                            );
                    } else { 
                            @$prod_details = 'NONE';
                            if ($cInfo->restrict_to_products) {
                                    $prod_details = sprintf('<a href="javascript:;" class="lbOn" id="%s" title="%s">%s</a>',
                                            xtc_href_link(FILENAME_COUPON_ADMIN,'action=listproducts&cid=' . $cInfo->coupon_id),IMAGE_DETAILS,IMAGE_DETAILS
                                    );
                            }     
                            @$cat_details = 'NONE';
                            if ($cInfo->restrict_to_categories) {
                                    $cat_details = sprintf('<a href="javascript:;" class="lbOn" id="%s" title="%s">%s</a>',
                                            xtc_href_link(FILENAME_COUPON_ADMIN,'action=listcategories&cid=' . $cInfo->coupon_id),IMAGE_DETAILS,IMAGE_DETAILS
                                    );
                            }
                            $coupon_description = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                                intval($cInfo->coupon_id),intval($_SESSION['languages_id']),[
                                    'coupon_name'
                                ]
                            );
                            $contents[] = array(
                                    'text'=>COUPON_NAME . '&nbsp;:&nbsp; ' . $coupon_description->coupon_name . '<br />' .
                                        COUPON_AMOUNT . '&nbsp;:&nbsp; ' . $amount . '<br />' .
                                        COUPON_STARTDATE . '&nbsp;:&nbsp; ' . xtc_date_short($cInfo->coupon_start_date) . '<br />' .
                                        COUPON_FINISHDATE . '&nbsp;:&nbsp; ' . xtc_date_short($cInfo->coupon_expire_date) . '<br />' .
                                        COUPON_USES_COUPON . '&nbsp;:&nbsp; ' . $cInfo->uses_per_coupon . '<br />' .
                                        COUPON_USES_USER . '&nbsp;:&nbsp; ' . $cInfo->uses_per_user . '<br />' .
                                        COUPON_PRODUCTS . '&nbsp;:&nbsp; ' . $prod_details . '<br />' .
                                        COUPON_CATEGORIES . '&nbsp;:&nbsp; ' . $cat_details . '<br />' .
                                        DATE_CREATED . '&nbsp;:&nbsp; ' . xtc_date_short($cInfo->date_created) . '<br />' .
                                        DATE_MODIFIED . '&nbsp;:&nbsp; ' . xtc_date_short($cInfo->date_modified));
                            $contents[] = array(
                                    'align'=>'center','text'=>  yes_draw_href_button('Email', xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action','cid')).'&action=email&cid='.$cInfo->coupon_id), 'width:180px;', 'button', 'lbOn ui-button ui-corner-all ui-state-default')
                            );
                            $contents[] = array(
                                    'align'=>'center','text'=> yes_draw_href_button(IMAGE_EDIT, xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action','cid')).'action=voucheredit&cid='.$cInfo->coupon_id), 'width:180px;', 'button')
                            );
                            $contents[] = array(
                                    'align'=>'center','text'=> yes_draw_href_button(IMAGE_DELETE, xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action','cid')).'action=voucherdelete&cid='.$cInfo->coupon_id), 'width:180px;', 'button')
                            );
                            $contents[] = array(
                                    'align'=>'center','text'=> yes_draw_href_button('Report', xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action','cid')).'action=voucherreport&cid='.$cInfo->coupon_id), 'width:180px;', 'button')
                            );
                            $contents[] = array(
                                    'align'=>'center','text'=> yes_draw_href_button(IMAGE_COPY, xtc_href_link('coupon_admin.php',xtc_get_all_get_params(array('action','cid')).'action=copy&cid='.$cInfo->coupon_id), 'width:180px;', 'button', 'lbOn ui-button ui-corner-all ui-state-default')
                            );
                    }
            }else{
                $heading[] = array('text'=>'Kein Kupon gefunden');
            }
            break;
}
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$box = new box;
$buttons = array();
if($action == 'voucherreport'){
    $buttons[] = array('text'=>IMAGE_BACK, 
	'link'=>xtc_href_link(FILENAME_COUPON_ADMIN,xtc_get_all_get_params(array('action'))),
	'lbOn'=>false,
	'auth'=>true
    );
    if(sizeOf($items)){
        $buttons[] = array('text'=>IMAGE_EXPORT, 
            'link'=>xtc_href_link(FILENAME_COUPON_ADMIN,xtc_get_all_get_params(array('export_csv')).'export_csv=1'),
            'lbOn'=>false,
            'auth'=>true
        );
    }
}
if($action == ''){
    $buttons[] = array('text'=>TEXT_HEADING_NEW_COUPON,
	'link'=>xtc_href_link(FILENAME_COUPON_ADMIN,'action=new'),
	'auth'=>true,
	'lbOn'=>false
    );
    $buttons[] = array('text'=>BUTTON_COUPON_ORDERS,
	'link'=>xtc_href_link('coupon_orders.php'),
	'auth'=>true,
	'lbOn'=>false
    );
}

$smarty->assign(array(
    'BOX'=>$box->infoBox($heading, $contents),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));

$html = $smarty->fetch(DIR_FS_ADMIN.'templates/coupon_admin.html');
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<link rel="stylesheet" type="text/css" href="includes/javascript/spiffyCal/spiffyCal_v2_1.css">
<script type="text/javascript" src="includes/javascript/spiffyCal/spiffyCal_v2_1.js"></script>
<div class="main">
<?php echo $html; ?>
</div>
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>