<?php
/**
 * diese defines sind bei jedem System gleich - keine extra konfiguration
 */

die('Wird nicht mehr verwendet.');

include(__DIR__.'/includes/classes/amazon-sp/autoload.php');

include('includes/cron_application_top.php');
use SellingPartnerApi\Api\SellersV1Api as SellersApi;
use SellingPartnerApi\Configuration;
use SellingPartnerApi\Endpoint;
use SellingPartnerApi\FeedType;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Client;

require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'amazon_sp.php');
if(!defined('MODULE_OTHER_AMAZON_STATUS')){
    die('Amazon Modul not installed.');
}
$basics = new basics;

$ASP = new amazon_sp(null, false);

$collected_feeds = \YES4Trade\Model\amazon_feed_collector::get_list();
$max_feeds = 2;
$max_items = 10000;
$processed_feeds = 0;
if(sizeOf($collected_feeds)){
    $user_feeds = [];
    foreach($collected_feeds as $item){
        if($processed_feeds >= $max_feeds){
        	break;
        }
        
        if(!isset($user_feeds[ $item['selling_partner_id'] ])){
            $user_feeds[ $item['selling_partner_id'] ] = [];
        }
        
        if(!isset($user_feeds[ $item['selling_partner_id'] ][ $item['feed_type'] ] )){
            $user_feeds[ $item['selling_partner_id'] ][ $item['feed_type'] ] = [];
        }
        // max 10000 items
        if( sizeOf($user_feeds[ $item['selling_partner_id'] ][ $item['feed_type'] ]) >= $max_items ){
            break;
        }
        switch($item['feed_type']){
            case 'JSON_LISTINGS_FEED.quantity':
            case 'POST_INVENTORY_AVAILABILITY_DATA': // veraltet
                $user_feeds[ $item['selling_partner_id'] ][ $item['feed_type'] ][] = [
                    'sku'=>$item['sku'],
                    'qty'=>(int)$item['feed_value'],
                    'fulfillment_latency'=>$item['fulfillment_latency'],
                    'amazon_feed_collector_id'=>$item['amazon_feed_collector_id']
                ];
                break;
            case 'JSON_LISTINGS_FEED.price':
            case 'POST_PRODUCT_PRICING_DATA': // veraltet
                $user_feeds[ $item['selling_partner_id'] ][ $item['feed_type'] ][] = [
                    'sku'=>$item['sku'],
                    'price'=>(float)$item['feed_value'],
                    'amazon_feed_collector_id'=>$item['amazon_feed_collector_id']
                ];
                break;
        }
    }
}
foreach($user_feeds as $user => $data){
    $ASP = new amazon_sp($user);
    $content_type = "text/xml; charset=UTF-8";
    $markets = $ASP->get_active_marketplaces();
    
    foreach($data as $feedType=>$items){
        $apiInstance = new SellingPartnerApi\Api\FeedsV20210630Api($ASP->configObj);
        $body = new \SellingPartnerApi\Model\FeedsV20210630\CreateFeedDocumentSpecification;
        $body->setContentType($content_type);
        $result = $apiInstance->createFeedDocument($body);
        $feed_document_id = $result->getFeedDocumentId();
        $url = $result->getURL();
        switch($feedType){
            case 'JSON_LISTINGS_FEED.quantity':
            case 'POST_INVENTORY_AVAILABILITY_DATA': // veraltet
                $feed = $ASP->get_update_qty_feed($user, $items);
                break;
            case 'JSON_LISTINGS_FEED.price':
            case 'POST_PRODUCT_PRICING_DATA': // veraltet
                $feed = $ASP->get_update_price_feed($user, $items);
                break;
        }
        $options = [
            'headers' => ['Content-Type' => $content_type],
            'body' => $feed->asXML()
        ];

        $client = new Client();
        $upload_result = $client->request('PUT', $result->getURL(), $options);
        $processed_feeds++;
        if($upload_result->getStatusCode() == 200){
                $body = new SellingPartnerApi\Model\FeedsV20210630\CreateFeedSpecification($data);
                $body->setFeedType($feedType);
                $body->setInputFeedDocumentId($feed_document_id);
                $body->setMarketplaceIds($markets);
                try{
                    $create_feed_res = $apiInstance->createFeed($body);
                    $ASP->insert_feed_info_to_db($user, $items, $create_feed_res->getFeedId(), $feedType);
                    foreach($items as $itm){
                        \YES4Trade\Model\amazon_feed_collector::delete( $itm['amazon_feed_collector_id'] );
                    }
                    echo "Upload ".$upload_result->getReasonPhrase()." [Status ".$upload_result->getStatusCode()."] - Feed Datei(en) geloescht.\n";
                } catch (Exception $ex) {
                    yes_mail_debug($ex->getMessage()."\n\n".print_r($markets,true),true);
                }
        }else{
                $msg = sprintf("Cronjob %s: Upload failed.\nFeed:\n%s",
                        basename(__FILE__),
                        print_r($feed,true)
                );
                if(main::isDev(true)){
                        echo $msg;
                }else{
                        yes_mail_debug($msg);
                }
        }
    }
}
$ASP_blank = new amazon_sp(null, false);
$toggle_file = main::get_secure_path().'TOGGLE_SPID_'.basename(__FILE__).'.toggle';
if(is_file($toggle_file)){
    $toggle_last = (int)file_get_contents( $toggle_file );
    if(sizeOf($ASP_blank->auth_params->users) > 1){
        $toggle = (sizeOf($ASP_blank->auth_params->users) == ($toggle_last+1) ) ? "0" : "".$toggle_last+1;
    }
}else{
    $toggle = "0";
    file_put_contents($toggle_file, $toggle);
}
$user_counter = 0;
foreach($ASP_blank->auth_params->users as $username=>$data){
	if($user_counter == (int) $toggle){
		$current_seller = $username;
	}
}
$ASP = new amazon_sp( $current_seller );

$apiInstance = new SellingPartnerApi\Api\FeedsV20210630Api( $ASP->getSPAPI_config($current_seller));
$types = ['JSON_LISTINGS_FEED'/*,'POST_PRODUCT_PRICING_DATA','POST_ORDER_FULFILLMENT_DATA'*/]; // file ist eh inaktiv
$result = $apiInstance->getFeeds($types,null, 100);
$max = 2;
$count_calls = 0;
foreach($result->getFeeds() as $feed){
    $af = \YES4Trade\Model\amazon_feeds::get_by_feed_submission_id($feed->getFeedId());
    if($af == null){
        //printf("Unbekannter oder bereits verarbeiteter Feed %s\n",$feed->getFeedId());
        continue;
    }
    $upd = new \YES4Trade\Model\amazon_feeds([
        'amazon_feeds_id'=>intval($af->amazon_feeds_id),
        'feed_processing_status'=>$feed->getProcessingStatus(),
    ]);
    $upd->update();
    
    printf("Verarbeite Feed %s im ProcessingStatus %s\n",
            $feed->getFeedId(),
            $feed->getProcessingStatus()
    );
    sleep(2);
    if( $feed->getProcessingStatus() == 'DONE'){
	$count_calls++;
	if($count_calls > $max){
		echo "Maximum ($max) an Feeds erreicht.\n";
		break;
	}
        try{
            $docres = $apiInstance->getFeedDocument($feed->getResultFeedDocumentId());
            $xml = simplexml_load_string(file_get_contents( $docres->getUrl()));
            $Rep = $xml->Message->ProcessingReport;
            printf("\tResponse StatusCode %s, %d von %d successful)\n",
                    $Rep->StatusCode,
                    $Rep->ProcessingSummary->MessagesSuccessful,
                    $Rep->ProcessingSummary->MessagesProcessed
            );
        }catch( Exception $ex){
            $msg = print_r($ex,true);
            if(main::isDev(true)){
                die($msg);
            }
            yes_mail_debug($msg);
            exit;
        }
        switch($af['feed_type']){
            case 'POST_PRODUCT_PRICING_DATA':
                $amazon_feeds_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_amazon_feeds_id(intval($af['amazon_feeds_id']));
                break;
            case 'POST_INVENTORY_AVAILABILITY_DATA':
                $amazon_feeds_items = \YES4Trade\Model\amazon_feeds_quantity_items::get_by_amazon_feeds_id(intval($af['amazon_feeds_id']));
                break;
        }
        
        
        $p_array = [];
        foreach($amazon_feeds_items as $afi){
            $p = $afi->toArray();
            $p['products_id'] = yes_get_products_id_from_amazon_sku($p['sku'], $current_seller);
            $p_array[] = $p;
        }
        if($Rep->StatusCode == 'Complete' and $Rep->ProcessingSummary->MessagesProcessed == $Rep->ProcessingSummary->MessagesSuccessful){
            switch($af['feed_type']){
                case 'POST_INVENTORY_AVAILABILITY_DATA':
                    foreach($p_array as $p){
                        xtc_db_query(sprintf(
                                "UPDATE amazon_products SET quantity=%d WHERE products_id='%d' AND selling_partner_id='%s'",
                                $p['qty'], $p['products_id'], $current_seller
                        ));
                        xtc_db_perform('products_history',[
                            'products_id' =>$p['products_id'],
                            'editor_id'=>0,
                            'date_saved'=>'now()',
                            'comments'=>'Amazon Feed '.$feed->getFeedId().' @amazon qty fuer Seller '.$current_seller.' auf '.$p['qty'].' gesetzt'
                        ]);
                    }
                    break;
                case 'POST_PRODUCT_PRICING_DATA':
                    foreach($p_array as $p){
                        xtc_db_query(sprintf(
                                "UPDATE amazon_products SET price=%s WHERE products_id='%d' AND selling_partner_id='%s'",
                                $p['price'], $p['products_id'], $current_seller
                        ));
                        xtc_db_perform('products_history',[
                            'products_id' =>$p['products_id'],
                            'editor_id'=>0,
                            'date_saved'=>'now()',
                            'comments'=>'Amazon Feed '.$feed->getFeedId().' @amazon Preis fuer Seller '.$current_seller.' auf '.$p['price'].' gesetzt'
                        ]);
                    }
                    break;
            }
            \YES4Trade\Model\amazon_feeds::delete(intval($af['amazon_feeds_id']));
        }else{
            print_r($Rep);
            die('ABC');
        }
    }elseif($feed->getProcessingStatus() == 'FATAL' or $feed->getProcessingStatus() == 'CANCELLED'){
// @todo: NACHRICHT AN ADMIN DASS FEED NICHT AUSGEFUEHRT WURDE
        switch($af['feed_type']){
            case 'POST_INVENTORY_AVAILABILITY_DATA':
                $messages = [sprintf("Amazon POST_INVENTORY_AVAILABILITY_DATA Fehler (feedID %s)",
                        $feed->getFeedId()
                )];
                foreach($p_array as $p){
                    $messages[] = sprintf("\tpID %d (SKU %s / Seller %s) sollte auf Amazon Menge %d aktualisiert werden.",
                            yes_get_products_id_from_amazon_sku($p['sku'], $current_seller),
                            $p['sku'],
                            $current_seller,
                            $p['qty']
                    );
                }
                $recipients_array = main::get_notice_recipients('amazon');
                yes_write_notice('Amazon Feed fehlgeschlagen', implode("\n",$messages), 0, $recipients_array);
                if(main::isDev(true)){
                    yes_write_notice('Amazon Feed fehlgeschlagen', implode("\n",$messages), 0, [1]);
                }
                
                break;
            case 'POST_PRODUCT_PRICING_DATA':
                $messages = [sprintf("Amazon POST_PRODUCT_PRICING_DATA Fehler (feedID %s)",
                        $feed->getFeedId()
                )];
                foreach($p_array as $p){
                    $messages[] = sprintf("\tpID %d (SKU %s / Seller %s) sollte auf Amazon Preis %s aktualisiert werden.",
                            yes_get_products_id_from_amazon_sku($p['sku'], $current_seller),
                            $p['price'],
                            $current_seller,
                            $p['qty']
                    );
                }
                $recipients_array = main::get_notice_recipients('amazon');
                yes_write_notice('Amazon Feed fehlgeschlagen', implode("\n",$messages), 0, $recipients_array);
                if(main::isDev(true)){
                    yes_write_notice('Amazon Feed fehlgeschlagen', implode("\n",$messages), 0, [1]);
                }
                
                break;
        } // end switch feed type
        \YES4Trade\Model\amazon_feeds::delete(intval($af['amazon_feeds_id']));
    } // end if feedstatus FATAL | CANCELLED
} // eof foreach feeds
die("\nFertig\n");
