<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
define('TABLE_EBAY_AUCTIONS','ebay_auctions');
require('includes/cron_application_top.php');
require(DIR_FS_ADMIN.'includes/config.ebayapi.inc.php');
require(DIR_FS_ADMIN.'includes/classes/class.storagequantity.php');
require(DIR_FS_INC.'xtc_get_serial_number.inc.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.ebay.php');
// WENN NICHT VERKAUFT - UND AUTOM. WIEDEREINSTELLEN
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.ebay_item.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.ebay_auction.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
$EBAYAPI = new ebayAPI;

$language_id = '2';

$recipients_array = main::get_notice_recipients('ebayapi_cart');
$cron_start = yes_strftime('%Y-%m-%d %H:%M:%S',time()+(60*5)); // 5 min versatz um zu verhindern dass unvollstaendige Datensaetze ins Timing kommen

// nun noch ebay_auctions updaten, hat nichts mit transaktionen zu tun
// NUR WENN DURATION > 0 (wenn duration = 0 dann ist auktion bis auf Widerruf)
$rows = array();
$query = xtc_db_query("SELECT ea.ebay_id, ea.id, ea.end_time, ea.quantity,ea.revise_counter, ea.products_id,ep.locked FROM ebay_auctions ea LEFT JOIN ebay_products ep ON ep.id=ea.ebay_products_id WHERE ea.STATUS = '0' AND ea.duration>0 AND ( UNIX_TIMESTAMP( ea.end_time ) + (60*60*2) ) < UNIX_TIMESTAMP( now() )");
while($record = xtc_db_fetch_array($query)){
	$rows[] = $record;
}
if(!sizeOf($rows)){
	die('Nothing to do');
}
foreach($rows as $row){
	$ta_query = xtc_db_query("SELECT count(*) as transactions FROM ebay_transactions WHERE ebayid='".$row['ebay_id']."'");
	$transactions = xtc_db_fetch_array($ta_query);
    $ebay_auctions_variations = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id(intval($row['id']),[
        'products_id','sku','quantity'
    ]);
    $variations = [];
    if(sizeOf($ebay_auctions_variations)){
        foreach($ebay_auctions_variations as $ebay_auctions_variation){
            $variations[] = $ebay_auctions_variation->toArray();
        }
        foreach($variations as $record){
            $variation_update_qty = $record['quantity'];
            $staffel_comment = '';
            if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                $ea = new ebay_auction($row['id']);
                if($ea->has_staffelpreise()){
                    $variation_update_qty = $variation_update_qty*$ea->get_staffelpreis_quantity_from_sku($record['sku']);
                    $staffel_comment = ' Staffelpreis Menge '.$ea->get_staffelpreis_quantity_from_sku($record['sku']);
                }
            }
            
            yes_update_products_in_auction_quantity($record['products_id'],
                -$variation_update_qty,
                sprintf('Varianten Auktion %s beendet per cron beendet, %d (%d) Stk.%s',
                    $row['ebay_id'],
                    $record['quantity'],
                    $variation_update_qty,
                    $staffel_comment
                )
            );
        }
    }else{
        yes_update_products_in_auction_quantity($row['products_id'],
            -$row['quantity'],
            sprintf('Auktion %s beendet per cron beendet (%d Stk.)',$row['ebay_id'],$row['quantity'])
        );
    }
        
        
	if( $transactions['transactions'] < 1 ){
            $EBAYAPI->set_end_auction($row['id']);
            if(sizeOf($variations)){
                foreach($variations as $var){
                    yes_add_products_history($var['products_id'],'Varianten Auktion '.$row['ebay_id'].' Ende ohne Verkaeufe.');
                }
            }else{
                yes_add_products_history($row['products_id'],'Auktion '.$row['ebay_id'].' Ende ohne Verkaeufe.');
            }


	}else{
        $trans_arr = [];
        $trans_qty_query = xtc_db_query("SELECT SUM(quantitypurchased) as qty FROM ebay_transactions WHERE ebayid='".$row['ebay_id']."'");
        while( $trans_qty = xtc_db_fetch_array($trans_qty_query) ){
            $trans_arr[] = $trans_qty;
        }
        foreach($trans_arr as $trans_qty){
            \YES4Trade\Model\ebay_auctions::update_ebay_auction(['status'=>2,'id'=>intval($row['id'])]);
            if(sizeOf($variations)){
                foreach($variations as $var){
                    $comm = 'Varianten Auktion '.$row['ebay_id'].' Ende mit '.$trans_qty['qty'].'/'.($row['quantity']).' Verkaeufen.';
                    yes_add_products_history($var['products_id'],$comm);
                    yes_update_products_in_auction_quantity(intval($var['products_id']), 
                        yes_products_calc_in_auction_quantity(intval($var['products_id'])), 
                        $comm,
                        true // overwrite!
                    );
                }
            }else{
                $comm = 'Auktion '.$row['ebay_id'].' Ende mit '.$trans_qty['qty'].'/'.($row['quantity']).' Verkaeufen.';
                yes_add_products_history($row['products_id'],$comm);
                yes_update_products_in_auction_quantity(intval($row['products_id']), 
                    yes_products_calc_in_auction_quantity(intval($row['products_id'])), 
                    $comm,
                    true // overwrite!
                );
            }
        }
	}
}
