<?php
include('includes/cron_application_top.php');
$MAX_READ_MSG = 200; // max. inputvalues
ini_set('memory_limit','1200M');
set_time_limit(0);
include('includes/classes/class.ebay.php');
$EBAYAPI = new ebayApi();
include('includes/classes/class.ebaymessage.php');
$ebay_user_array = xtc_get_ebay_users();
if(!sizeOf($ebay_user_array)){
    die('Nothing to do.');
}

$EM = new EbayMessage;
foreach($ebay_user_array as $ebay_user){
	$ebay_user_id = $ebay_user['id'];
	if(ebayApi::oauth2_refreshtoken_exists($ebay_user_id)){
		if(!ebayApi::oauth2_usertoken_exists($ebay_user_id) or ebayApi::get_oauth2_usertoken_lifetime($ebay_user_id) < 1){
			try{
				ebayApi::refresh_oauth2_usertoken($ebay_user_id);
			}catch(Exception $e){
				$api_error = 'refresh_oauth2_usertoken() for seller '.$ebay_user_id.'  '.$e->getMessage();
			}
		}
	}
	printf("Getting eBay Messages for %s\n",$ebay_user_id);
	$ebaycalls = new \YES4Trade\Model\ebaycalls();
	try{
		$res = $ebaycalls->tradingQuery($ebay_user_id,
			'GetMyMessages',
			$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
			['DetailLevel'=>'ReturnSummary']
		);
	}catch(Exception $e){
		die($e->getMessage());
	}
    if(!$EBAYAPI->isGood($res)){
		print_r($EBAYAPI->getResponseErrors($res));
		echo "\r\nFEHLER\r\n";
		exit;
    }
    $summary = $res->Summary;
    if($summary->NewMessageCount == 0){
		die("Keine neuen eBay Meldungen.");
    }
    foreach($summary->FolderSummary as $folder){
		if($folder->NewMessageCount == 0){
			printf("Folder %s: No new messages\r\n",$folder->FolderID);
			continue;
		}
		echo 'HOLE HEADER FUER FOLDER NR '.$folder->FolderID."\r\n";

		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		try{
			$res = $ebaycalls->tradingQuery($ebay_user_id,
				'GetMyMessages',
				$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
				[
					'DetailLevel'	=>'ReturnHeaders',
					'FolderID'  	=> $folder->FolderID,
					'StartTime' 	=> (new DateTime('-1 Day'))->format(DATE_ATOM),
					'EndTime'   	=> (new DateTime())->format(DATE_ATOM)
				]
			);
		}catch(Exception $e){
			die($e->getMessage());
		}
		if(!$EBAYAPI->isGood($res)){
			print_r($EBAYAPI->getResponseErrors($res));
			echo "\r\nFEHLER\r\n";
			exit;
		}

		$msg = new \stdClass();
		$header_array = $res->Messages->Message;
		$msgIDLimit = 5;
		$msgTotal = (is_countable($header_array))?sizeOf($header_array):0;
		$rest = $msgTotal % $msgIDLimit;
		$counter = ($msgTotal - $rest) / $msgIDLimit;
		if($rest > 0){
			$counter++;
		}
		$saved_messages = 0;
		for($c=0;$c<$counter;$c++){
			$id_array = array();
			for($i=($c*$msgIDLimit);$i<(($c*$msgIDLimit)+$msgIDLimit);$i++){
				if(isset($header_array[$i])){
					$id_array[] = ['MessageID'=>$header_array[$i]->MessageID];
				}
			}
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$res = $ebaycalls->tradingQuery($ebay_user_id,
				'GetMyMessages',
				$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
				[
					'MessageIDs'=>$id_array,
					'DetailLevel' => 'ReturnMessages',
					'FolderID' => $folder->FolderID
				]
			);
			if(!$EBAYAPI->isGood($res)){
				print_r($EBAYAPI->getResponseErrors($res));
				echo "\r\nFEHLER\r\n";
				exit;
			}
			$messages = $res->Messages;
			foreach($messages as $k=>$message){
				$ebayId = (isset($message->ItemID)) ? $message->ItemID : '';
				$externalMessageId = (isset($message->ExternalMessageID)) ? $message->ExternalMessageID : '';
				if(!$EM->is_saved('1', $folder->FolderID, $ebayId, $message->MessageID, $externalMessageId)){
					$EM->save_message(1,$folder->FolderID,$message,$ebay_user_id);
					$saved_messages++;
				}
			}
		}
		if($saved_messages > 0){
			$parts = parse_url(HTTPS_CATALOG_SERVER);
			yes_push(sprintf("eBay Seller %s hat %s neue eBay Nachrichten erhalten.\r\n\r\nZeitpunkt: %s",
					$ebay_user['id'],$saved_messages,date('Y-m-d H:i:s')
				),
				$parts['path'].'admin/ebayapi_membermessages.php',
				'ebay_message'
			);
		}
		echo "$saved_messages MESSAGES SAVED FOR THIS FOLDER\r\n\r\n";
    }
    
    
}
exit;
