<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
include('includes/cron_application_top.php');
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_WS_CLASSES.'class.basics.php');

/*
 * ES SOLL IN EINEM PFAD UNTERHALB DES WEBROOTS GESPEICHERT WERDEN
 * $secure_path ist dann der Pfad vor /yes/
 */
$secure_path = main::get_secure_path();

function _get_summary_type_string($type){
	switch($type){
		case 'ALL_OPEN':
			$string = 'Gesamt offene Selleranfragen';
			$order = 0;
			break;
		case 'ALL_OPEN_REPLACEMENT':
			$string = 'Gesamt offene Umtausch-Anfragen';
			$order = 2;
			break;
		case 'ALL_OPEN_RETURN':
			$string = 'Gesamt offene R&uuml;ckerstattungen';
			$order = 3;
			break;
		case 'CLOSED':
			$string = 'Geschlossen';
			$order = 7;
			break;
		case 'ITEM_DELIVERED':
			$string = 'R&uuml;cksendung abgeschlossen';
			$order = 6;
			break;
		case 'ITEM_SHIPPED':
			$string = 'R&uuml;cksendung versendet';
			$order = 5;
			break;
		case 'RETURN_STARTED':
			$string = 'R&uuml;ckerstattung gestartet';
			$order = 4;
			break;
		case 'EBAY_PLUS':
			$string = 'eBay Plus';
			$order = 1;
			break;
		case 'UNKNOWN':
			$string = 'Unbekannt';
			break;
		default:
			$string = $type;
			break;
	}
	return array(
	    'string'=>sprintf('<![CDATA[%s]]>',$string),
	    'order'=>$order
	);
}
$ebay_user_array = xtc_get_ebay_users();
if(!sizeOf($ebay_user_array)){
    die('Nothing to do.');
}
$EBAYAPI = new ebayApi;
$xmlstr = "<?xml version='1.0' standalone='yes'?><summaries>";
$valid_call = false;
foreach($ebay_user_array as $ebay_user){
	$token = $EBAYAPI->getToken($ebay_user['id']);
	$userAuthToken= 'Authorization:TOKEN '.$token;

	//Endpoint URL to Use
	$from_date = date('Y-m-d\TH:i:s',time()-(60*60*24*2));
	$url = "https://api.ebay.com/post-order/v2/return/search";//?creation_date_range_from=".$from_date;

	//Initializle cURL
	$connection = curl_init();

	//Set Endpoint URL
	curl_setopt($connection,CURLOPT_URL,$url);
//	curl_setopt($connection, CURLOPT_HEADER, 1);
	//Set HTTP Method
	curl_setopt($connection, CURLOPT_HTTPGET, true);

	//Create Array of  Required Headers
	$headers = array();
	$headers[] = $userAuthToken;
	$headers[] = 'Content-Type:application/json';
	$headers[] = 'X-EBAY-C-MARKETPLACE-ID:EBAY-DE';
	//var_dump($headers);
	//set the headers using the array of headers
	curl_setopt($connection,CURLOPT_HTTPHEADER,$headers);

	//set it to return the transfer as a string from curl_exec
	curl_setopt($connection,CURLOPT_RETURNTRANSFER,1);

	//stop CURL from verifying the peer's certificate
	curl_setopt($connection, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($connection, CURLOPT_SSL_VERIFYHOST, 0);

	//Execute the Request
	$response = curl_exec($connection);

	//close the connection
	curl_close($connection);
	$response_array = json_decode($response,true);
	if(isset($response_array['countSummary'])){
		$valid_call = true;
		$xmlstr .= sprintf('<summary><seller>%s</seller>',$ebay_user['id']);
		$xmlstr .= '<items>';
		foreach($response_array['countSummary'] as $sum){
		    $type = _get_summary_type_string($sum['type']);
			$xmlstr .= sprintf('<item><count>%s</count><type>%s</type><order>%s</order></item>',$sum['count'],$type['string'],$type['order']);
		}
		$xmlstr .= '</items></summary>';
	}
}
$xmlstr .= "</summaries>";
if($valid_call){
	if(!is_dir($secure_path.basename(__FILE__)))
		mkdir($secure_path.basename(__FILE__));
	$xml_save_path = $secure_path.basename(__FILE__).'/summary.xml';
	$basics = new basics;
	@unlink($xml_save_path);
	$basics->create_file($xml_save_path,$xmlstr);	
	die(basename($xml_save_path)." written\r\n");
}
