<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
set_time_limit(0);
ini_set('memory_limit','512M');

require('includes/cron_application_top.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'class.products_export.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'yes_cron_export.php');
require_once(DIR_WS_FUNCTIONS . 'export_functions.php');
require_once(DIR_FS_INC .'xtc_get_product_path.inc.php');
require_once(DIR_WS_CLASSES."class.products_characteristic.php");
require_once(DIR_FS_INC .'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_CATALOG.'lang/german/admin/module_export.php');
require_once(DIR_WS_CLASSES.'simple_lock.php');

$lock = new simple_lock(\main::get_exportdata_path().basename(__FILE__).'.LOCK');
$lock->lock();
$BASICS = new basics;
$query = xtc_db_query(sprintf(
        "SELECT * FROM %s",
        yes_cron_export::TABLE_NAME
));
printf("\r\nZEITGESTEUERTE EXPORTE\r\n\r\nGESAMT: %s\r\n\r\n",
        xtc_db_num_rows($query)
);
while($record = xtc_db_fetch_array($query)){
    printf("[ID %s] %s (File: %s) Last Export: %s %s\r\n",
            $record[yes_cron_export::TABLE_INDEX_FIELD],
            substr($record['name'],0,5).'...',
            substr($record['export_filename'],0,5).'...',
            $record['last_export'],
            (($record['current_export']==1) ? '*' : '')
    );
}

$yceID = yes_cron_export::get_current_cron_export();
if(!$yceID){
    $lock->destroy();
    die("\r\nKeine Cronjob Exporte zum generieren.\r\n");
}
$yce = new yes_cron_export($yceID);
$page = $yce->getCurrent_export_page();
$class = 'yes2';
include(realpath(__DIR__) . DIRECTORY_SEPARATOR. 'includes'. DIRECTORY_SEPARATOR. 'modules'. DIRECTORY_SEPARATOR. 'export/'.$class . '.php');

$fn = $yce->getExport_filename();
if(!in_array(strtolower(substr($fn,-4)),array('.zip','.csv'))){
    $text = 'Exportdatei Name fuer Zeitsteuerung "'.$yce->getName().'" hat unerlaubte Endung: '.$fn;
    yes_mail_debug($text);
    $yce->update_current_export(0);
    $yce->update_last_export('now()');
    $lock->destroy();
    die("\r\n$text\r\n");
}

$fn_pre = substr($fn,0,strlen($fn)-4);
$file = $BASICS->get_valid_filename_from_string($fn_pre).strtolower(substr($fn,-4));
$module = new $class;
$error = $module::check_ini_sort(sprintf('yes2_%s.ini',$yce->getIni_file()));
if($error){
    $text = 'Konfigurationsdatei '.$yce->getIni_file().' fuer Zeitsteuerung "'.$yce->getName().'" enthaelt eine defekte Sortierung und kann nicht verarbeitet werden';
    yes_mail_debug($text);
    $yce->update_current_export(0);
    $yce->update_last_export('now()');
    $lock->destroy();
    die("\r\n$text\r\n");
}

$module->save_path = DIR_FS_CATALOG.'files';
$cron_parameter = array(
    'ini'=>$yce->getIni_file(),
    'use_heading_row'=>(bool)$yce->getUse_heading_row(),
    'header_rows'=>$yce->get_heading_rows(),
    'export_linked_products'=>$yce->getExport_linked_products(),
    'cat'=>$yce->getCat(),
    'allCat'=>(bool)$yce->getAllCat(),
    'distributors_id'=>$yce->getDistributors_id(),
    'yce'=>$yce
);
$module->process($file, $cron_parameter);
echo $module->ACK->output();
$lock->destroy();