<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');


require_once(DIR_WS_CLASSES.'class.help.php');
require_once(DIR_WS_CLASSES.'class.csv.php');
require_once(DIR_WS_CLASSES.'distributor.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_FS_CATALOG.'inc/xtc_get_product_path.inc.php');
require_once(DIR_FS_CATALOG.'inc/xtc_get_parent_categories.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');

require_once(DIR_FS_INC.'yes_get_products_distributors_stock.inc.php');

$admin_access = main::get_admin_access();

$csv_file = \main::get_exportdata_path()."00000ekproducts.csv";
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

  if (isset($_GET['action'])) {
    switch ($_GET['action']) {
	case 'delete_distributor_products':
	    $dID = (int)xtc_db_input($_REQUEST['dID']);
	    $forbidden_products = array();
	    $lb_query = xtc_db_query(sprintf(
		    "SELECT products_id FROM distributor_orders do LEFT JOIN distributor_orders_products dop USING(distributor_orders_id) WHERE do.orders_status IN(1,2) AND distributor_id='%s'",
		    $dID
	    ));
	    while($lb = xtc_db_fetch_array($lb_query)){
		$forbidden_products[] = $lb['products_id'];
	    }
	    
	    $delete_dpp = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT distributor_product_prices_id,products_id FROM distributor_product_prices WHERE distributor_id='%s'",
		    $dID
	    ));
	    while($record = xtc_db_fetch_array($query)){
		if(!in_array($record['products_id'], $forbidden_products)){
		    $delete_dpp[] = $record['distributor_product_prices_id'];
		}
	    }
	    foreach($delete_dpp as $dppID){
		xtc_db_query(sprintf(
			"DELETE FROM distributor_product_prices WHERE distributor_product_prices_id='%s'",
			$dppID
		));
	    }
	    
	    $delete_pd = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT id,products_id FROM products_distributors WHERE distributor_id='%s'",
		    $dID
	    ));
	    while($record = xtc_db_fetch_array($query)){
		if(!in_array($record['products_id'], $forbidden_products)){
		    $delete_pd[] = $record['id'];
		}
	    }
	    foreach($delete_pd as $pdID){
		xtc_db_query(sprintf(
			"DELETE FROM products_distributors WHERE id='%s'",
			$pdID
		));
	    }
	    $messageStack->add_session(sprintf(
		MSG_SUCCESS_DISTRIBUTOR_ALLOCATIONS_DELETED,
		    sizeOf($delete_dpp),sizeOf($delete_pd)
		),'success'
	    );
	    xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF'])));
	    break;
		case 'all_storage_stats':
			$data = array();
			$query = xtc_db_query("SELECT DISTINCT(dpp.products_id),p.products_quantity FROM distributor_product_prices dpp LEFT JOIN products p USING(products_id) WHERE p.products_quantity > 0");
			while($record = xtc_db_fetch_array($query)){
				$data[$record['products_id']] = $record['products_quantity'];
			}
			if(!sizeOf($data)){
				die(ERROR_NO_PRODUCTS_FOR_STATS);
			}
			$total = 0;
			//echo '<hr><span class="smallText">---Debug---<br /><i>';
			foreach($data as $pID=>$qty){
				$query = xtc_db_query(sprintf(
					"SELECT price FROM distributor_product_prices WHERE products_id='%s' ORDER BY date_saved DESC LIMIT 1",
					$pID
				));
				$record = xtc_db_fetch_array($query);
				//printf('<li>pID %s: %s Stk. a %s EUR',$pID,$qty,$record['price']);
				$total += $qty*$record['price'];
			}
			//echo '</i><br />---Debug ENDE---</span><br /><span class="main">';
			printf(TEXT_ALL_STORAGE_STATS_TOTAL,sizeOf($data),number_format($total,2,',','.'));
			echo '</span>';
			exit;
			break;
		case 'storage_stats':
			$distributor = new distributor((int)xtc_db_input($_REQUEST['dID']));
			$products = $distributor->get_products();
			$countable_products = 0;
			$total = 0;
			$no_price = 0;
			//echo '<hr><span class="smallText">---Debug---<br /><i>';
			for($i=0;$i<sizeOf($products);$i++){
				if($products[$i]['products_quantity'] <= 0)
					continue;
				$newest_ek_date = '';
				$use_default = false;
				if(!isset($products[$i]['ek']) or !sizeOf($products[$i]['ek'])){
					$no_price++;
					continue;
				}
				for($j=0;$j<sizeOf($products[$i]['ek']);$j++){
					switch($products[$i]['ek'][$j]['is_default']){
						case 1:
							$min_ek = $products[$i]['ek'][$j]['price'];
							$use_default = true;
							break;
						default:
							if(!isset($newest_ek))
								$newest_ek = $products[$i]['ek'][$j]['date_saved'];
							if(!$use_default and strtotime($products[$i]['ek'][$j]['date_saved']) > strtotime($newest_ek)){
								$min_ek = $products[$i]['ek'][$j]['price'];
								$newest_ek = $products[$i]['ek'][$j]['date_saved'];
							}
					}
				}
				if(isset($min_ek) and $min_ek > 0){
					$countable_products++;
					$total += $min_ek * $products[$i]['products_quantity'];
//					printf('<li>pID %s / qty: %s / minEK: %s</li>',$products[$i]['products_id'],$products[$i]['products_quantity'],$min_ek);
				}
			}
			//echo '</i>---Debug ENDE---</span><br />';
			printf(TEXT_STORAGE_STATS_TOTAL,$countable_products,number_format($total,2,',','.'),$no_price);
			exit;
			break;
		case 'export_select_group':
			$cgroups = xtc_get_customers_statuses();
			printf('<div class="main">%s<b>%s</b><br />%s<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default"></form></div>',
					xtc_draw_form('export','distributor.php','action=export'.((isset($_REQUEST['dID']))?'&dID='.$_REQUEST['dID']:'')),
					TEXT_EXPORT_CS_INTRO,
					xtc_draw_pull_down_menu('customers_status_id',$cgroups,1),
					IMAGE_SAVE
			);
			exit;
			break;
		case 'save_distributor':
			if(!isset($_REQUEST['distributor_id']) or !isset($_REQUEST['distributor_products_number']) or !isset($_REQUEST['pID'])){
				die(json_encode(array(
					'error'=>'Missing Parameter'
				)));
			}
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$dID = (int)xtc_db_input($_REQUEST['distributor_id']);
			$is_default = (isset($_REQUEST['is_default'])) ? (int)$_REQUEST['is_default'] : 0;
			/**
			 * FALLS is_default GESETZT WURDE, DANN ERST BEI ALLEN ANDEREN
			 * LIEFERANTEN-ZUWEISUNGEN VON DIESEM ARTIKEL is_default NULLEN
			 *
			 */
			if($is_default == '1'){
				xtc_db_query(sprintf(
					"UPDATE products_distributors SET is_default=0 WHERE products_id='%s'",
					$pID
				));
			}

			$update_sql_array = array(
				'distributor_products_number'=>yes_decode_string($_REQUEST['distributor_products_number']),
				'mindestbestellmenge'=>(int)$_REQUEST['mindestbestellmenge'],
				'distributor_products_link'=>yes_decode_string($_REQUEST['distributor_products_link']),
				'is_default'=>$is_default,
				'comments'=>yes_decode_string($_REQUEST['comments']),
			    'payment_terms'=>yes_decode_string($_REQUEST['payment_terms']),
			);
			xtc_db_perform('products_distributors',$update_sql_array,'update',sprintf(
				"products_id='%s' and distributor_id='%s'",$pID,$dID
			));


			$product = new product($pID);
			$comments = sprintf(
				HISTORY_DISTRIBUTOR_UPDATED,
				xtc_get_distributor_name($dID)
			);
			$product->add_history($comments);
			die(json_encode(array(
				/**
				 * JSON MIT SONDERZEICHEN - IMMER ENCODEN
				 */
			    'error'=>'',
				'html'=>yes_encode_string($comments)
			)));
			break;
		case 'delete_distributor_price':
			if(!isset($_REQUEST['distributor_id']) or !isset($_REQUEST['distributor_product_prices_id']) or !isset($_REQUEST['pID'])){
				die(json_encode(array(
					'error'=>'Missing Parameter'
				)));
			}
			$dID = (int)xtc_db_input($_REQUEST['distributor_id']);
			$dpID = (int)xtc_db_input($_REQUEST['distributor_product_prices_id']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			xtc_db_query(sprintf(
				"DELETE FROM distributor_product_prices WHERE distributor_id='%s' and products_id='%s' and distributor_product_prices_id='%s'",
				$dID,$pID,$dpID
			));
			$comments = sprintf(HISTORY_DISTRIBUTOR_PRODUCT_PRICE_DELETED,
					xtc_get_distributor_name($dID)
			);
			$product = new product($pID);
			$product->add_history($comments);
			die(json_encode(array(
				/**
				 * JSON MIT SONDERZEICHEN - IMMER ENCODEN
				 */
				'html'=>yes_encode_string($comments)
			)));
			exit;
			break;
		case 'save_distributor_price':
			if(!isset($_REQUEST['pID']) or !isset($_REQUEST['distributor_id'])){
				die(json_encode(array(
					'error'=>JS_ERROR_MISSING_PARAMS
				)));
			}
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$dID = (int)xtc_db_input($_REQUEST['distributor_id']);
                        $is_default = (isset($_REQUEST['is_default']) and $_REQUEST['is_default'] > 0) ? (int)xtc_db_input($_REQUEST['is_default']) : 0;
                        xtc_db_query(sprintf(
                                "UPDATE distributor_product_prices SET is_default=0 WHERE distributor_id='%s' AND products_id='%s'",
                                $dID,$pID
                        ));
                        
			$insert_sql_array = array(
				'products_id'=>$pID,
				'distributor_id'=>$dID,
				'price'=>(float)$_REQUEST['price'],
				'vpe'=>(int)$_REQUEST['vpe'],
				'vpe_width'=>(float)$_REQUEST['vpe_width'],
				'vpe_height'=>(float)$_REQUEST['vpe_height'],
				'vpe_depth'=>(float)$_REQUEST['vpe_depth'],
				'vse'=>(int)$_REQUEST['vse'],
				'conditions'=>yes_decode_string($_REQUEST['conditions']),
				'shippings'=>yes_decode_string($_REQUEST['shippings'])
			);
                        $insert_sql_array['shipping_status_id'] = (int)$_REQUEST['shipping_status_id'];
			$name = xtc_get_distributor_name($dID);
			if($_REQUEST['distributor_products_prices_id'] > 0){
				$dp_id = (int)xtc_db_input($_REQUEST['distributor_products_prices_id']);
				xtc_db_perform('distributor_product_prices',$insert_sql_array,'update',"distributor_product_prices_id='".$dp_id."'");
				$comments = sprintf(TEXT_EK_PRICE_EDITED,
					$name
				);
			}else{
				$insert_sql_array['date_saved'] = 'now()';
				xtc_db_perform('distributor_product_prices',$insert_sql_array);
				$dp_id = xtc_db_insert_id();
				$comments = sprintf(TEXT_EK_PRICE_ADDED,
					$name
				);
			}
                        if(isset($_REQUEST['is_default']) and $_REQUEST['is_default'] == 'new'){
                           $is_default = $dp_id; 
                        }
                        if($is_default > 0){
                            xtc_db_query(sprintf(
                                    "UPDATE distributor_product_prices SET is_default=1 WHERE distributor_product_prices_id='%s'",
                                    $is_default
                            ));
                        }
			$product = new product($pID);
			$product->add_history($comments);
			die(json_encode(array(
				'id'=>$dp_id
			)));
			break;
		case 'add_distributor_price_fieldset':
			if(!isset($_REQUEST['pID']) or !isset($_REQUEST['distributor_id'])){
				die(json_encode(array(
					'error'=>JS_ERROR_MISSING_PARAMS
				)));
			}
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$dID = (int)xtc_db_input($_REQUEST['distributor_id']);

                        $st_input = xtc_draw_pull_down_menu('shipping_status_id',xtc_get_shipping_status(),'','id="shippingtime"');
			$smarty->assign(array(
				'distributor_id'=>$dID,
				'products_id'=>$pID,
				'action'=>'get_distributor_price_fieldset',
				'SHIPPINGTIME_INPUT'=>$st_input,
			));
			$html = $smarty->fetch('distributor_admin.html');
			die(json_encode(array(
				'html'=>yes_encode_string($html)
			)));
			break;
			break;
		case 'delete_distributor':
			if(!isset($_REQUEST['pID']) or !isset($_REQUEST['distributor_id'])){
				die(json_encode(array(
					'error'=>JS_ERROR_MISSING_PARAMS
				)));
			}
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$dID = (int)xtc_db_input($_REQUEST['distributor_id']);

			/**
			 *  WENN DAS DER DEFAULT LIEFERANT WAR, DANN SETZEN WIR IRGENDEINEN
			 * ANDEREN LIEFERANTEN DIESES ARTIKELS ALS is_default
			 * PASSIERT NUR WAR, WENN ES EINEN ANDEREN GIBT
			 */
			$is_default_query = yes_db_query(sprintf(
				"SELECT id FROM products_distributors WHERE products_id='%s' and distributor_id='%s' and is_default='1'",
				$pID,$dID
			));
			if(yes_db_num_rows($is_default_query)){
				xtc_db_query(sprintf(
					"UPDATE products_distributors SET is_default='1' WHERE products_id='%s' and distributor_id != '%s' LIMIT 1",
					$pID,$dID
				));
			}
			xtc_db_query(sprintf(
				"DELETE FROM distributor_product_prices WHERE distributor_id='%s' and products_id='%s'",
				$dID,$pID
			));
			xtc_db_query(sprintf(
				"DELETE FROM products_distributors WHERE distributor_id='%s' and products_id='%s'",
				$dID,$pID
			));
			$name = xtc_get_distributor_name($dID);
			$comments = sprintf(TEXT_EK_PRICE_DELETED,$name);
			$product = new product($pID);
			$product->add_history($comments);
			exit;
			break;
		case 'get_distributor_fieldset':
			if(!isset($_REQUEST['pID']) or !isset($_REQUEST['new_distributor_id'])){
				die(json_encode(array(
					'error'=>JS_ERROR_MISSING_PARAMS
				)));
			}
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$dID = (int)xtc_db_input($_REQUEST['new_distributor_id']);
			/**
			 * VERHINDERN DASS EIN ARTIKEL MEHRMALS ZUM LIEFERANTEN HINZUGEFUEGT
			 * WIRD
			 */
			$count_query = yes_db_query(sprintf(
				"SELECT count(id) as anz FROM products_distributors WHERE products_id='%s' and distributor_id='%s'",
				$pID,$dID
			));
			if(yes_db_num_rows($count_query)){
				$count = current($count_query);
				if($count['anz'] > 0){
					die(json_encode(array(
						'error'=>JS_ERROR_ALLOCATION_EXISTS
					)));
				}
			}
			/**
			 * FALLS is_default GESETZT WURDE, DANN ERST BEI ALLEN ANDEREN
			 * LIEFERANTEN-ZUWEISUNGEN VON DIESEM ARTIKEL is_default NULLEN
			 *
			 */
			if(isset($_REQUEST['is_default'])){
				$is_default = $_REQUEST['is_default'];
			}else{
				$is_default = 0;
			}
			if($is_default == 1){
				xtc_db_query(sprintf(
					"UPDATE products_distributors SET is_default=0 WHERE products_id='%s'",
					$pID
				));
			}
			/**
			 * WENN NOCH KEIN WEITERER LIEFERANTENEINTRAG ZUM ARTIKEL VORLIEGT
			 * SETZEN WIR IS_DEFAULT AUTOMATISCH
			 */
			$count_query = yes_db_query(sprintf(
				"SELECT count(id) as anz FROM products_distributors WHERE products_id='%s'",
				$pID
			));
			if(yes_db_num_rows($count_query)){
				$count = current($count_query);
				if($count['anz'] == 0)
					$is_default = true;
			}

			$insert_sql_array = array(
				'products_id'=>$pID,
				'distributor_id'=>$dID,
				'distributor_products_number'=>yes_decode_string($_REQUEST['distributor_products_number']),
				'mindestbestellmenge'=>(int)$_REQUEST['mindestbestellmenge'],
				'distributor_products_link'=>yes_decode_string($_REQUEST['distributor_products_link']),
				'is_default'=>$is_default,
				'comments'=>yes_decode_string($_REQUEST['comments'])
			);
			xtc_db_perform('products_distributors',$insert_sql_array);
			$distributor_array = $insert_sql_array;

			$product = new product($pID);
			$product->add_history(sprintf(
				HISTORY_DISTRIBUTOR_ALLOCATED,
				xtc_get_distributor_name($dID)
			));
			$distributor_array['name'] = xtc_get_distributor_name($dID);
			$distributor_array['id'] = $dID;
			$smarty->assign(array(
				'distributor'=>$distributor_array,
				'action'=>'get_fieldset'
			));
			$html = $smarty->fetch('distributor_admin.html');
			die(json_encode(array(
				'html'=>yes_encode_string($html)
			)));
			break;
	case 'import_data':
		$CSV = new CSVfile($csv_file);
		$CSV->setDelimiter("\t");
                $CSV->check_first_col_empty = false;
		$CSV->open('r');
		$row_count = 0;
		$max_ek_entries = 0;
                $errors = [];
		while($row = $CSV->readRow()){
			if($row_count > 0){
                            // NUR NEUANLAGE - WENN IN SPALTE 0 EIN WERT IST
                            // DANN HANDELT ES SICH UM EINEN BESTEHENDEN EINTRAG
                            // TICKET 3033 - 12/2019
                            if($row[0] != ''){
                                continue;
                            }
                            $dID = (int)xtc_db_input($row[1]);
                            if($dID < 1){
                                $errors[] = sprintf('Import %s: Fehlender Lieferant');
                                $row_count++;
                                continue;
                            }
                            $pID = (int)xtc_db_input($row[3]);
                            if($pID < 1){
                                $errors[] = sprintf('Import %s: Fehlende pID');
                                $row_count++;
                                continue;
                            }
                            
                            $check_pid_query = xtc_db_query("SELECT products_id FROM products WHERE products_id='".$pID."'");
                            if(!xtc_db_num_rows($check_pid_query)){
                                $errors[] = sprintf(MSG_ERROR_IMPORT_UNKNOWN_PID,$pID);
                                $row_count++;
                                continue;
                            }
                            $check_dist_query = xtc_db_query("SELECT id FROM distributors WHERE id='".$dID."'");
                            if(!xtc_db_num_rows($check_dist_query)){
                                $errors[] = sprintf(MSG_ERROR_IMPORT_UNKNOWN_DISTRIBUTOR,$dID);
                                $row_count++;
                                continue;
                            }

                            // BOF - PRUEFUNG AUF ALLOCATION - TICKET 3277
                            $check_dist_allocation_query = xtc_db_query(sprintf(
                                    "SELECT id FROM products_distributors WHERE products_id='%d' AND distributor_id='%d'",
                                    $pID, $dID
                            ));
                            if(xtc_db_num_rows($check_dist_allocation_query)){
                                $check_dist_allocation = xtc_db_fetch_array($check_dist_allocation_query);
                                $pdID = $check_dist_allocation['id'];
                                $update_sql_array = array(
                                        'comments'=>$row[6],
                                        'distributor_products_link'=>$row[7],
                                        'mindestbestellmenge'=>$row[8],
                                );
                                xtc_db_perform('products_distributors', 
                                    $update_sql_array,'update',
                                    "id='".$pdID."'"
                                );
                            }else{
                                // BOF dieser Block war VOR ticket 3277
                                // also ohne pruefung ob die allocation existiert
                                // wenn die Pruefung zu Problem fuehrt, kann der
                                // ganze andere Ticket 3277 basierte Code raus
                                $insert_sql_array = array(
                                        'products_id'=>$pID,
                                        'distributor_id'=>$dID,
                                        'distributor_products_number'=>$row[5],
                                        'comments'=>$row[6],
                                        'distributor_products_link'=>$row[7],
                                        'mindestbestellmenge'=>$row[8],
                                );
                                xtc_db_perform('products_distributors', $insert_sql_array);
                                $pdID = xtc_db_insert_id();
                                // EOF dieser Block war VOR ticket 3277
                            }
                            // EOF - PRUEFUNG AUF ALLOCATION - TICKET 3277
                            $pd_saved_ek_num_query = xtc_db_query(sprintf(
                                    "SELECT COUNT(distributor_product_prices_id) AS anz FROM distributor_product_prices WHERE products_id='%d' AND distributor_id='%d'",
                                    $pID, $dID
                            ));
                            $pd_saved_ek_num_res = xtc_db_fetch_array($pd_saved_ek_num_query);
                            $pd_saved_ek_num = $pd_saved_ek_num_res['anz'];
                            
                            $max_ek_size  = (sizeOf($row)-11) / 8;
                            $csv_row_has_default_ek = false;
                            for($i=1;$i<=$max_ek_size;$i++){
                                $ci = (8*$i)+3;
                                $size = explode(',',$row[ $ci+7 ]);
                                // pruefe ob spalte ekpreis 1 gesetzt ist
                                if($row[$ci] <= 0){ // leereintraege verhindern
                                        continue;
                                }
                                $is_default = $row[ ($ci+1) ];
                                if($is_default == 1){
                                    $csv_row_has_default_ek = true;
                                }
                            }
                            
                            $is_default_auto_set = false;
                            for($i=1;$i<=$max_ek_size;$i++){
                                $ci = (8*$i)+3;
                                $size = explode(',',$row[ $ci+7 ]);
                                // pruefe ob spalte ekpreis 1 gesetzt ist
                                if($row[$ci] <= 0){ // leereintraege verhindern
                                        continue;
                                }
                                $is_default = $row[ ($ci+1) ];
                                if(!$csv_row_has_default_ek && $pd_saved_ek_num == 0){
                                    $is_default = 1;
                                    $pd_saved_ek_num++;
                                    $is_default_auto_set = true;
                                }
                                
                                if($is_default == 1 && $pd_saved_ek_num > 0 && !$is_default_auto_set){
                                    xtc_db_query(sprintf(
                                            "UPDATE distributor_product_prices SET is_default='0' WHERE products_id='%d' AND distributor_id='%d'",
                                            $pID, $dID
                                    ));
                                }
                                $insert_sql_array = array(
                                        'products_id'=>$pID,
                                        'distributor_id'=>$dID,
                                        'date_saved'=>'now()',
                                        'price'=>(float)$row[$ci++],
                                        'is_default'=>(int)$is_default,
                                        'conditions'=>$row[ ($ci++) ],
                                        'shippings'=>$row[ ($ci++) ],
                                        'shippingtime'=>$row[ ($ci++) ],
                                        'vse'=>(int)$row[ ($ci++) ],
                                        'vpe'=>(int)$row[ ($ci++) ],
                                        'vpe_width'=>(int)$size[0],
                                        'vpe_height'=>(int)$size[1],
                                        'vpe_depth'=>(int)$size[2]
                                );
                                
                                $insert_sql_array['shipping_status_id'] = $insert_sql_array['shippingtime'];
                                unset($insert_sql_array['shippingtime']);
                                xtc_db_perform('distributor_product_prices',$insert_sql_array);
					
                            }
			}
			$row_count++;
		}
                foreach($errors as $err){
                    $messageStack->add_session($err,'error');
                }
		$messageStack->add_session(MSG_SUCCESS_IMPORT,'success');
		xtc_redirect(xtc_href_link('distributor.php','dID='.$_GET['dID']));
		break;
	case 'export':
		
		$dID = (isset($_GET['dID'])) ? (int)xtc_db_input($_GET['dID']) : 0;
		$export = array();
		if(isset($_GET['dID'])){
			$dID = (int)xtc_db_input($_GET['dID']);
			$d = new distributor($dID);
			$export[] = array(
				'id'=>$dID,
				'name'=>$d->info['name'],
				'products'=>$d->get_products()
			);
		}else{
			$distributors_query = xtc_db_query("SELECT id FROM distributors");
			while($distributors = xtc_db_fetch_array($distributors_query)){
				$d = new distributor($distributors['id']);
				$export[] = array(
					'id'=>$distributors['id'],
					'name'=>$d->info['name'],
					'products'=>$d->get_products()
				);
			}
		}
		$max_ek_entries = 0;
		foreach($export as $k=>$exp){
			for($i=0;$i<sizeOf($exp['products']);$i++){
				$p = $exp['products'][$i];
				if(sizeOf($p['ek']) > $max_ek_entries){
					$max_ek_entries = sizeOf($p['ek']);
				}
			}
		}
		$file = \main::get_exportdata_path().'ekpreise.csv';
		if(!is_file($file)){
			$fp = fopen($file,"w");
			fclose($fp);
		}
		$customers_status_id = (int)xtc_db_input($_REQUEST['customers_status_id']);
		$xtPrice = new xtcPrice('EUR',$customers_status_id);
		// Show price
		$CSV = new CSVfile($file);
		$CSV->setDelimiter("\t");
		$CSV->open("w");
		$CSV->setEncapsulate('"');
		$head_array = array(
                        'ID (Wenn leer dann Neuanlage sonst nur Info)',
			'LieferantID',
			'Lieferantenname (Nur zur Info, kein Import)',
			'pID',
			'Produkttitel (Nur zur Info, kein Import)',
			'Lieferanten-Nr',
                        'Kommentar zum Lieferantenprodukt',
			'URL zum Lieferantenprodukt',
			'Mindestbestellmenge',
			'Phys. Bestand (Nur Info)',
			'VK Preis KdG '.  xtc_get_customers_status_name($customers_status_id).' (nur zur Info, kein Import)'
		);
		for($i=0;$i<$max_ek_entries;$i++){
			$head_array[] = 'EK Preis ('.($i+1).')';
			$head_array[] = 'Default EK ('.($i+1).')';
			$head_array[] = 'Konditionen ('.($i+1).')';
			$head_array[] = 'Versandbedingungen ('.($i+1).')';
                        $head_array[] = 'Lieferzeit ID ('.($i+1).')';
			$head_array[] = 'VSE ('.($i+1).')';
			$head_array[] = 'VPE ('.($i+1).')';
			$head_array[] = 'VSE Masse Laenge,Breite,Hoehe ('.($i+1).')';
		}
		$CSV->addRow( $head_array );
		foreach($export as $k=>$v){
			for($i=0;$i<sizeOf($v['products']);$i++){
				$product_details_query = xtc_db_query(sprintf(
					"SELECT products_price FROM products WHERE products_id='%s'",
					$v['products'][$i]['products_id']
				));
				$product_details = xtc_db_fetch_array($product_details_query);
                                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                                    $v['products'][$i]['products_id'], 
                                    STORE_COUNTRY
                                );
                                
                                
				// BOF PRICE
				$product_price = $xtPrice->xtcGetPrice($v['products'][$i]['products_id'],
                                    $format=false,
                                    0,
                                    $products_tax_class_id,
                                    $product_details['products_price']
				);
				// EOF PRICE
				$ek_array = array();
				for($j=0;$j<sizeOf($v['products'][$i]['ek']);$j++){
					$ek = $v['products'][$i]['ek'][$j];
					$ek['conditions'] = str_replace(";",", ",$ek['conditions']);
					$ek['conditions'] = str_replace("\n"," ",$ek['conditions']);
					$ek['conditions'] = str_replace("\r"," ",$ek['conditions']);
					$ek['shippings'] = str_replace(";",", ",$ek['shippings']);
					$ek['shippings'] = str_replace("\n"," ",$ek['shippings']);
					$ek['shippings'] = str_replace("\r"," ",$ek['shippings']);

					$ek_array[$j] = array(
						'price'=>$ek['price'],
						'is_default'=>$ek['is_default'],
						'conditions'=>$ek['conditions'],
						'shippings'=>$ek['shippings'],
						'vse'=>$ek['vse'],
						'vpe'=>$ek['vpe'],
						'vpe_size'=>$ek['vpe_width'].','.$ek['vpe_height'].','.$ek['vpe_depth']
					);
                                        $ek_array[$j]['shipping_status_id'] = $ek['shipping_status_id'];
				}

				$row = array(
                                        $v['products'][$i]['id'], // ek id
                                        $v['id'], // LIEFERANT ID
					str_replace('"','\"',$v['name']),
					$v['products'][$i]['products_id'],
					str_replace('"',"''",xtc_get_products_name($v['products'][$i]['products_id'])),
					str_replace('"',"''",$v['products'][$i]['number']),
					str_replace('"',"''",$v['products'][$i]['comments']),
					str_replace('"',"''",$v['products'][$i]['link']),
					str_replace('"',"''",$v['products'][$i]['mindestbestellmenge']),
					(int)$v['products'][$i]['products_quantity'],
					number_format($product_price,2,'.','')
				);
				for($max=0;$max<$max_ek_entries;$max++){
					if(isset($ek_array[$max])){
							$row[] = (float)$ek_array[$max]['price'];
							$row[] = ($ek_array[$max]['is_default'] == 1)?'1':'0';
							$row[] = str_replace('"',"''",$ek_array[$max]['conditions']);
							$row[] = str_replace('"',"''",$ek_array[$max]['shippings']);
                                                        $row[] = (int)$ek_array[$max]['shipping_status_id'];
							$row[] = (int)$ek_array[$max]['vse'];
							$row[] = (int)$ek_array[$max]['vpe'];
							$row[] = $ek_array[$max]['vpe_size'];
					}else{
						$row[] = '0';
						$row[] = '0';
						$row[] = '';
						$row[] = '';
						$row[] = '';
						$row[] = '';
						$row[] = '';
					}
				}
				$CSV->addRow( $row );
			}
		}
		$CSV->close();
		$fp = fopen($file,"rb");
		$buffer = fread($fp, filesize($file));
		fclose($fp);
		unlink($file);
		header('Content-type: application/x-octet-stream');
		header('Content-disposition: attachment; filename=ekpreise.csv');
		echo $buffer;
		exit;
		break;
	case 'new_order':
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_new_order'] != '1')) {
		$messageStack->add_session(MSG_ERROR_AUTH_NEW_ORDER,'error');
		xtc_redirect(xtc_href_link('distributor.php',xtc_get_all_get_params(array('action'))));
	}
	$distributor = new distributor($_GET['dID']);
	$orders_id = $distributor->new_order();
	$messageStack->add_session(MSG_SUCCESS_NEW_ORDER,'success');
	xtc_redirect(xtc_href_link('distributor_orders.php', 'doID=' . $orders_id . '&action=edit'));
      case 'new_invoice':
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_new_invoice'] != '1')) {
		$messageStack->add_session(MSG_ERROR_AUTH_NEW_INVOICE,'error');
		xtc_redirect(xtc_href_link('distributor.php',xtc_get_all_get_params(array('action'))));
	}
	$distributor = new distributor($_GET['dID']);
	$invoice_id = $distributor->new_invoice();
	$messageStack->add_session(MSG_SUCCESS_NEW_INVOICE,'success');
	xtc_redirect(xtc_href_link('distributor_invoices.php', 'diID=' . $invoice_id . '&action=edit'));
      case 'new':
	$name = xtc_db_input($_POST['name']);
        $fax = xtc_db_input($_POST['fax']);
        $tel = xtc_db_input($_POST['telefon']);
        $email = xtc_db_input($_POST['email']);
        $homepage = xtc_db_input($_POST['homepage']);
        $strasse = xtc_db_input($_POST['strasse']);
        $plz = xtc_db_input($_POST['plz']);
        $ort = xtc_db_input($_POST['ort']);
        $land = xtc_db_input($_POST['land']);
        $memo = xtc_db_input($_POST['memo']);
        $type = xtc_db_input($_POST['account_type']);
        $kundennummer = xtc_db_input($_POST['kundennummer']);
        $tax_orders = xtc_db_input($_POST['tax_orders']);
	$default_delivery_storage_address_id = (int)xtc_db_input($_REQUEST['default_delivery_storage_address_id']);
	$payment_terms = xtc_db_input($_POST['payment_terms']);

        $q = xtc_db_query("INSERT INTO distributors set account_type='".$type."',land='".$land."',name='".$name."',fax='".$fax."',email='".$email."',homepage='".$homepage."',strasse='".$strasse."',plz='".$plz."',ort='".$ort."',memo='".$memo."',kundennummer='".$kundennummer."',telefon='".$tel."',tax_orders='".$tax_orders."',default_delivery_storage_id='".$default_delivery_storage_address_id."',payment_terms='".$payment_terms."'");
	$insert_id = xtc_db_insert_id($q);
        xtc_redirect(xtc_href_link('distributor.php', xtc_get_all_get_params(array('dID','action')).'dID=' . $insert_id));
        break;
      case 'save':
        $dID = xtc_db_input($_GET['dID']);
	$name = xtc_db_input($_POST['name']);
        $fax = xtc_db_input($_POST['fax']);
        $tel = xtc_db_input($_POST['telefon']);
        $email = xtc_db_input($_POST['email']);
        $homepage = xtc_db_input($_POST['homepage']);
        $strasse = xtc_db_input($_POST['strasse']);
        $plz = xtc_db_input($_POST['plz']);
        $ort = xtc_db_input($_POST['ort']);
        $land = xtc_db_input($_POST['land']);
        $memo = xtc_db_input($_POST['memo']);
        $type = xtc_db_input($_POST['account_type']);
	$kundennummer = xtc_db_input($_POST['kundennummer']);
	$tax_orders = xtc_db_input($_POST['tax_orders']);
	$default_delivery_storage_address_id = (int)xtc_db_input($_REQUEST['default_delivery_storage_address_id']);
	$payment_terms = xtc_db_input($_REQUEST['payment_terms']);
        xtc_db_query("update distributors set land='".$land."',name='".$name."',account_type='".$type."',fax='".$fax."',email='".$email."',homepage='".$homepage."',strasse='".$strasse."',plz='".$plz."',ort='".$ort."',memo='".$memo."',kundennummer='".$kundennummer."',telefon='".$tel."',tax_orders='".$tax_orders."',default_delivery_storage_id='".$default_delivery_storage_address_id."',payment_terms = '".$payment_terms."' where id = '" . $dID . "'");
        xtc_redirect(xtc_href_link('distributor.php', xtc_get_all_get_params(array('action'))));
	
        break;
      case 'delete':
			$dID = intval($_GET['dID']);
			$distributor = new \distributor($dID);
			$num_orders = $distributor->get_orders_count();
			if($num_orders  > 0){
				$messageStack->add_session(sprintf(
					MSG_ERROR_DELETE_DISTRIBUTOR_ORDERS_EXISTS,
					$num_orders
				),'error');
				xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
			}
			$num_invoices = $distributor->get_invoices_count();
			if($num_invoices  > 0){
				$messageStack->add_session(sprintf(
					MSG_ERROR_DELETE_DISTRIBUTOR_INVOICES_EXISTS,
					$num_invoices
				),'error');
				xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
			}

			xtc_db_query("DELETE FROM distributors WHERE id='". $dID . "'");
			xtc_db_query("DELETE FROM products_distributors WHERE distributor_id='".$dID."'");
			xtc_db_query("DELETE FROM distributor_contacts WHERE distributor_id='".$dID."'");
			
			/**
			 *  WENN DAS DER DEFAULT LIEFERANT WAR, DANN SETZEN WIR IRGENDEINEN
			 * ANDEREN LIEFERANTEN DIESES ARTIKELS ALS is_default
			 * PASSIERT NUR WAR, WENN ES EINEN ANDEREN GIBT
			 */
			$is_default_query = yes_db_query(sprintf(
				"SELECT products_id,id FROM products_distributors WHERE distributor_id='%s' and is_default='1'",
				$dID
			));
			if(yes_db_num_rows($is_default_query)){
				foreach($is_default_query as $is_default){
					$pID = $is_defaul['products_id'];
					xtc_db_query(sprintf(
						"UPDATE products_distributors SET is_default='1' WHERE products_id='%s' and distributor_id != '%s' LIMIT 1",
						$pID,$dID
					));
				}
			}
			xtc_db_query(sprintf(
				"DELETE FROM distributor_product_prices WHERE distributor_id='%s'",
				$dID
			));
			xtc_db_query(sprintf(
				"DELETE FROM products_distributors WHERE distributor_id='%s'",
				$dID
			));
			xtc_redirect(xtc_href_link('distributor.php',xtc_get_all_get_params(array('action','dID'))));
			break;
    }
}
$buttons = array(
);
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch($action){
    case 'products':
    case 'scm':
	$buttons[] = array('text'=>IMAGE_BACK,
	    'link'=>xtc_href_link('distributor.php',xtc_get_all_get_params(array('action'))),
	    'lbOn'=>false,
	    'auth'=>true
	);
	break;
    case 'new':
	break;
    default:
	$buttons[] = array('text'=>BUTTON_ALL_STORAGE_STATS,
	    'link'=>xtc_href_link('distributor.php',xtc_get_all_get_params(array('dID','action')).'action=all_storage_stats'),
	    'lbOn'=>true,
	    'auth'=>true
	);
	$buttons[] = array('text'=>TEXT_NEW_TITLE,
	    'link'=>xtc_href_link('distributor.php','action=new_edit'),
	    'lbOn'=>false,
	    'auth'=>true
	);
	break;
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch($action){
	case 'import_preview':
		@unlink($csv_file);
		if (isset($_FILES['importfile']) and ! $_FILES['importfile']['error']) {
			// Alternativ:            and   $_FILES['probe']['size']
			move_uploaded_file($_FILES['importfile']['tmp_name'], $csv_file);
		}
		$CSV = new CSVfile($csv_file);
		$CSV->setDelimiter("\t");
                $CSV->check_first_col_empty = false;
		$CSV->open('r');
		$data_array = array();
		$rowcount = 0;
		$max_ek_entries = 0;
		while($row = $CSV->readRow()){
                    if($rowcount == 0){
                        $rowcount++;
                        continue;
                    }
                    $max_ek_size  = (sizeOf($row)-11) / 8;
                    if($max_ek_size > $max_ek_entries)
                            $max_ek_entries = $max_ek_size;
                    if($row[0] != ''){
                        $rowcount++;
                        continue;
                    }
                    $ek_items = array();
                    // SPALTE 11 = EK(1)
                    // SPALTE 19 = EK(2)
                    for($i=1;$i<=$max_ek_size;$i++){
                            $ci = (8*$i)+3;
                            $ek_items[$i] = array(
                                    'ek'=>(float)$row[($ci++)],
                                    'is_default'=>(int)$row[($ci++)],
                                    'conditions'=>$row[ ($ci++) ],
                                    'shippings'=>$row[ ($ci++) ],
                                    'shippingtime'=>$row[ ($ci++) ],
                                    'vse'=>(int)$row[ ($ci++) ],
                                    'vpe'=>(int)$row[ ($ci++) ],
                                    'vpe_size'=>$row[ ($ci++) ]
                            );
                            $ek_items[$i]['shipping_status_id'] = $ek_items[$i]['shippingtime'];
                    }
                    $row_sliced = array_slice($row,0,10);
                    if($row_sliced[1]>0){
                        $row_sliced[1] = sprintf('%s (%d)',
                                xtc_get_distributor_name($row_sliced[1]),
                                $row_sliced[1]
                        );
                    }
                    if((int)$row_sliced[3] > 0){
                        $row_sliced[4] = xtc_get_products_name($row_sliced[3]);
                    }
                    $row_sliced['ek_array'] = $ek_items;
                    $data_array[] = $row_sliced;
		}
		$CSV->close();
		$smarty->assign('data',$data_array);
		for($i=0;$i<$max_ek_entries;$i++){
			$max_ek_array_size_array[] = $i;
		}
		$smarty->assign('max_ek_array_size_array',$max_ek_array_size_array);
		$smarty->assign('CANCEL_LINK',xtc_href_link('distributor.php','dID='.$_GET['dID']));
		$smarty->assign('IMPORT_LINK',xtc_href_link('distributor.php','dID='.$_GET['dID'].'&action=import_data'));
		$smarty->assign('import',1);
		break;
	case 'find':
		$find_products_query = xtc_db_query("select * from products_distributors where distributor_products_number LIKE '%".xtc_db_input($_POST['pname'])."%'");
		while($product = xtc_db_fetch_array($find_products_query)){
			echo '<li>'.$product['distributor_products_number'];
		}
	case 'products':
		$group_id = 1; // GAST
                $search = (isset($_REQUEST['search'])) ? xtc_db_input($_REQUEST['search']) : '';
		require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
		require_once(DIR_FS_INC.'yes_get_products_ordered_by_distributors.inc.php');
		$xtPrice = new xtcPrice(DEFAULT_CURRENCY,$group_id);
		$distributor_extra_query = xtc_db_query("select d.*,CONCAT(dc.contact_firstname,' ',dc.contact_lastname) as contact_name,dc.distributor_contacts_id,dc.contact_telephone from distributors d left join distributor_contacts dc on dc.distributor_id=d.id and dc.contact_standard=1 where d.id = '" . xtc_db_input($_GET['dID']) . "'");
		$dist = xtc_db_fetch_array($distributor_extra_query);
		$smarty->assign('dist',xtc_db_prepare_input($dist));
		
		
		$products_query_raw = "select p.products_model,p.products_id,pd.distributor_products_number,pd.distributor_products_link,prd.products_name from products p left join products_distributors pd using(products_id) left join products_description prd using(products_id) where pd.distributor_id='".xtc_db_input($_GET['dID'])."' and prd.language_id='".$_SESSION['languages_id']."'";
		if($search != ''){
		    $products_query_raw .= sprintf(" and (prd.products_name LIKE '%%%s%%' or pd.distributor_products_number LIKE '%%%s%%' or p.products_model LIKE '%%%s%%' ",
			    $search,$search,$search
		    );
		    if(is_int($search) and $search > 0){
			$products_query_raw .= " or p.products_id='".$search."' ";
		    }
		    $products_query_raw .= ') ';
		}
		
		$products_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $products_query_raw, $products_query_numrows);
		
		$products = array();
		$products_query = xtc_db_query($products_query_raw);
		$_records = array();
		while( $product = xtc_db_fetch_array($products_query) ){
		    $_records[] = $product;
		}
		if(sizeOf($_records)){
		    foreach($_records as $product){
			$p = new product($product['products_id']);
			$product['newest_ek'] = number_format(xtc_get_price_ek($product['products_id'], 'NEWEST', (int)xtc_db_input($_GET['dID']),false),2,',','.');
			$product['customers_status_price'] = $xtPrice->xtcGetPrice($product['products_id'],
			    $format=true,
			    1,
			    $p->info['products_tax_class_id'], // EU OSS SAFE
			    ''
			);
			$product['not_shipped'] = xtc_get_products_not_shipped($product['products_id']);
			$product['at_ebay'] = xtc_get_products_at_amazon($product['products_id']);
			$product['at_amazon'] = xtc_get_products_at_amazon($product['products_id']);
			$product['ordered'] = yes_get_products_ordered_by_distributors($product['products_id'],(int)xtc_db_input($_GET['dID']));
			$product['ordered_total'] = yes_get_products_ordered_by_distributors($product['products_id']);
			$product['sold_month1'] = yes_get_products_sells($product['products_id'],28,xtc_get_product_in_collies($product['products_id']));
			$product['sold_month3'] = yes_get_products_sells($product['products_id'],28*3,xtc_get_product_in_collies($product['products_id']));
			$product['sold_month6'] = yes_get_products_sells($product['products_id'],28*6,xtc_get_product_in_collies($product['products_id']));;
			$product['sold_month12'] = yes_get_products_sells($product['products_id'],365,xtc_get_product_in_collies($product['products_id']));
			
			$product['is_set'] = sizeOf(xtc_get_product_collies($product['products_id']));
			$product['products_name'] = xtc_get_products_name($product['products_id']);
			$product['link'] = xtc_href_link('categories.php','pID='.$product['products_id'].'&action=new_product&cPath='.xtc_get_product_path($product['products_id']));
			$product['bestand_popup_link'] = xtc_href_link('products.php','action=bestand&pID='.$product['products_id']);
                        $product['stock'] = yes_get_products_distributors_stock(
                            (int)xtc_db_input($_GET['dID']),
                            $product['products_id']
                        );
			$products[] = xtc_db_prepare_input($product);
		    }
		}
		if(sizeOf($products)>0)
			$smarty->assign('products',$products);
			
		$text_anzahl = TEXT_DISPLAY_NUMBER_OF_ITEMS;
		$split = $products_split->display_count($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], $text_anzahl, xtc_get_all_get_params(array('page')));
		$split .= '<br />'.$products_split->display_links($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page')));
		$smarty->assign('POPUP_WIDTH',EXT_POPUP_WIDTH);
    		$smarty->assign('POPUP_HEIGHT',EXT_POPUP_HEIGHT);

		$smarty->assign('split',$split);
		$smarty->assign(array(
		    'PRODUCTS'=>'1',
		    'customers_status_name'=>xtc_get_customers_status_name(DEFAULT_CUSTOMERS_STATUS_ID_GUEST),
		    'TEXT_DISTRIBUTOR_PRODUCTS_LISTING'=>sprintf(TEXT_DISTRIBUTOR_PRODUCTS_LISTING,xtc_db_prepare_input($dist['name'])),
		    'SEARCH_FORM'=>xtc_draw_form('search_form','distributor.php',xtc_get_all_get_params(array('search'))),
		    'input_search'=>  xtc_draw_input_field('search', $search, 'id="input_search"')
		));
		break;
	case 'scm':
		$distributor_extra_query = xtc_db_query("select d.*,CONCAT(dc.contact_firstname, ' ', dc.contact_lastname) as contact_name,dc.distributor_contacts_id,dc.contact_telephone from distributors d left join distributor_contacts dc on dc.distributor_id=d.id and dc.contact_standard=1 where d.id = '" . xtc_db_input($_GET['dID']) . "'");
		$dist = xtc_db_fetch_array($distributor_extra_query);
		$smarty->assign('dist',xtc_db_prepare_input($dist));
		
		$products_query_raw = "select p.products_id,p.products_name,pd.distributor_products_number from products_description p left join products_distributors pd on p.products_id=pd.products_id where pd.distributor_id='".xtc_db_input($_GET['dID'])."'";
		$products_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $products_query_raw, $products_query_numrows);
		
		$products = array();
		$products_query = xtc_db_query($products_query_raw);
		while( $product = xtc_db_fetch_array($products_query) ){
			$product['link'] = xtc_href_link('categories.php','pID='.$product['products_id'].'&action=new_product&cPath='.xtc_get_product_path($product['products_id']));
			$products[] = xtc_db_prepare_input($product);
		}
		if(sizeOf($products)>0)
			$smarty->assign('products',$products);
			
		$text_anzahl = TEXT_DISPLAY_NUMBER_OF_ITEMS;
		$split = $products_split->display_count($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], $text_anzahl, xtc_get_all_get_params(array('page', 'oID', 'action')));
		$split .= '<br />'.$products_split->display_links($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page', 'oID', 'action')));
		$smarty->assign('split',$split);
		$smarty->assign('BACKLINK',xtc_href_link('distributor.php','dID='.$_GET['dID']));
		$smarty->assign('PRODUCTS','1');
		break;
	default:
		$smarty->assign('DISTRIBUTORS','1');
		$distributors_array = array();	
		$distributors_query = xtc_db_query("select d.*,CONCAT(dc.contact_firstname,' ',dc.contact_lastname) as contact_name,dc.distributor_contacts_id,dc.contact_telephone from distributors d left join distributor_contacts dc on dc.distributor_id=d.id and dc.contact_standard=1 order by d.name");
		while ($distributor = xtc_db_fetch_array($distributors_query)) {
			if (((!isset($_GET['dID'])) || ($_GET['dID'] == $distributor['id'])) && (!isset($dInfo)) && (substr($action, 0, 3) != 'new')) {
				$distributor_extra_query = xtc_db_query("select d.*,CONCAT(dc.contact_firstname,' ',dc.contact_lastname) as contact_name,dc.distributor_contacts_id,dc.contact_telephone from distributors d left join distributor_contacts dc on dc.distributor_id=d.id and dc.contact_standard=1 where d.id = '" . $distributor['id'] . "'");
				$distributor_extra = xtc_db_fetch_array($distributor_extra_query);
				if($distributor_extra['contact_name'] == '' or !$distributor_extra['contact_name'] ){
						$distributor_extra['contact_name'] = '<a href="'.xtc_href_link('distributor_contacts.php','dId='.$distributor_extra['id']).'"><i><u>'.TEXT_LINK_ADD_CONTACT.'</u></i></a>';
				}else{
						$distributor_extra['contact_name'] = '<a href="'.xtc_href_link('distributor_contacts.php','dId='.$distributor_extra['id'].'&dcID='.$distributor_extra['distributor_contacts_id']).'"><i><u>'.$distributor_extra['contact_name'].'</u></i></a>';
				}
				$dInfo_array = xtc_array_merge($distributor, $distributor_extra);
				$dInfo = new objectInfo($dInfo_array);
			}
			if($distributor['contact_name'] == '' or !$distributor['contact_name'] ){
				$distributor['contact_name'] = '<a href="'.xtc_href_link('distributor_contacts.php','dId='.$distributor['id']).'"><i><u>'.TEXT_LINK_ADD_CONTACT.'</u></i></a>';
			}else{
				$distributor['contact_name'] = '<a href="'.xtc_href_link('distributor_contacts.php','dId='.$distributor['id'].'&dcID='.$distributor['distributor_contacts_id']).'"><i><u>'.$distributor['contact_name'].'</u></i></a>';
			}
			if ( (isset($dInfo) and is_object($dInfo)) && ($distributor['id'] == $dInfo->id) ) {
				$distributor['trlink'] = xtc_href_link('distributor.php', 'dID=' . $dInfo->id . '&action=edit');
				$distributor['selected'] = '1';
			}else{
				$distributor['trlink'] = xtc_href_link('distributor.php', 'dID=' . $distributor['id']);
			}
			if ( (isset($dInfo) and is_object($dInfo)) && ($distributor['id'] == $dInfo->id) ) { 
				$distributor['action'] = xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', '');
			} else { 
				$distributor['action'] = '<a href="' . xtc_href_link('distributor.php', 'dID=' . $distributor['id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; 
			}
			$distributors_array[] = $distributor;
		}
		if(sizeOf($distributors_array)>0)
			$smarty->assign('distributors',$distributors_array);
		break;
} // end switch action
  
  $html=$smarty->fetch('distributor.html');
  echo $html;
?>

</td>

<?php
$heading = array();
$contents = array();
$type_arr = array( 0=>array('id'=>'Lieferant','text'=>TEXT_DISTRIBUTOR),1=>array('id'=>'Versender','text'=>TEXT_SHIPPER));
$db_ini = yes_get_database_table_ini();
$max_size = 50;
switch ($action) {
      case 'delete_distributor_products_confirm':
		$heading[] = array('text'=>'<b>'.IMAGE_DELETE_DISTRIBUTOR_PRODUCTS_ALLOCATIONS.'</b>');
		$contents = array('form' => xtc_draw_form('del_alloc', 'distributor.php', 'dID='.$_GET['dID'].'&action=delete_distributor_products','post'));
		$contents[] = array('text' => TEXT_DELETE_DISTRIBUTOR_PRODUCTS_ALLOCATIONS_INTRO);
		$contents[] = array('align' => 'center', 'text' =>
		'<br />' . yes_draw_href_button(IMAGE_DELETE,'','width:100px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('distributor.php'),'width:100px;')
		);
		break;
    case 'delete_confirm':
		$heading[] = array('text'=>'<b>'.TEXT_DELETE_TITLE.'</b>');
		$contents = array('form' => xtc_draw_form('del', 'distributor.php', 'dID='.$_GET['dID'].'&action=delete','post'));
		$contents[] = array('text' => TEXT_DELETE_INTRO);
		$contents[] = array('align' => 'center', 'text' =>
		'<br />' . yes_draw_href_button(IMAGE_DELETE,'','width:100px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('distributor.php'),'width:100px;')
		);
		break;
    case 'import':
		$heading[] = array('text'=>'<b>'.TEXT_IMPORT_TITLE.'</b>');
		$contents = array('form' => xtc_draw_form('import', 'distributor.php', 'dID='.$_GET['dID'].'&action=import_preview','post','enctype="multipart/form-data"'));
		$contents[] = array('text' => TEXT_IMPORT_INTRO);
		$contents[] = array('text' => xtc_draw_input_field('importfile','','',false,'file'));
		$contents[] = array('align' => 'center', 'text' =>
		'<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:100px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('distributor.php'),'width:100px;')
		);
		break;
    case 'new_edit':
		$heading[] = array('text' => '<b>'.TEXT_NEW_TITLE.'</b>');
		$countries = xtc_get_countries();
		foreach($countries as $k=>$country){
			$countries[$k] = array(
				'id'=>$country['text'],'text'=>$country['text']
			);
		}

		$contents = array('form' => xtc_draw_form('distributor', 'distributor.php', 'action=new'));
		$contents[] = array('text' => TEXT_NEW_INTRO);
		$contents[] = array('text' => '<br /><b>'.TEXT_FIELD_TYPE.':</b><br />' . xtc_draw_pull_down_menu('account_type',$type_arr,'Lieferant'));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'name');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.TEXT_FIELD_NAME.':</b><br />' . xtc_draw_input_field('name','',$params));
		$contents[] = array('text' => '<br /><b>'.TEXT_FIELD_TAX.':</b><br />' .YES.xtc_draw_radio_field('tax_orders','1',true).'&nbsp;'.NO.xtc_draw_radio_field('tax_orders','0'));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'payment_terms');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.TEXT_DISTRIBUTOR_PAYMENT_TERMS.':</b><br />' .xtc_draw_input_field('payment_terms','',$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'telefon');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_TELEPHONE_NUMBER.'</b><br />' . xtc_draw_input_field('telefon',''));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'fax');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_FAX_NUMBER.'</b><br />' . xtc_draw_input_field('fax','',$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'email');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_EMAIL_ADDRESS.'</b><br />' . xtc_draw_input_field('email','',$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'homepage');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_HOMEPAGE.'</b><br />' . xtc_draw_input_field('homepage','',$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'strasse');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_STREET_ADDRESS.'</b><br />' . xtc_draw_input_field('strasse','',$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'plz');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_POST_CODE.'</b><br />' . xtc_draw_input_field('plz','',$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'ort');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_CITY.'</b><br />' . xtc_draw_input_field('ort','',$params));
		$contents[] = array('text' => '<br /><b>'.ENTRY_COUNTRY.'</b><br />' . xtc_draw_pull_down_menu('land',$countries));
		$contents[] = array('text' => '<br /><b>'.ENTRY_CID.'</b><br />' . xtc_draw_input_field('kundennummer',''));
		$contents[] = array('text' => '<br /><b>'.ENTRY_COMMENT.'</b><br />' . xtc_draw_textarea_field('memo','',45,4,''));
		$contents[] = array('align' => 'center', 'text' =>
		'<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:100px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('distributor.php'),'width:100px;')
		);
      break;
    case 'edit':
		$heading[] = array('text' => sprintf(TEXT_EDIT_TITLE,
			  $dInfo->account_type,
			  $dInfo->name,
			  $dInfo->id));
		$contents = array('form' => xtc_draw_form('distributor', 'distributor.php', 'dID=' . $dInfo->id . '&action=save'));
		$contents[] = array('text' => TEXT_EDIT_INTRO);
		$contents[] = array('text' => '<br /><b>'.TEXT_FIELD_TYPE.':</b><br />' . xtc_draw_pull_down_menu('account_type',$type_arr,$dInfo->account_type));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'name');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.TEXT_FIELD_NAME.'</b>:<br />' . xtc_draw_input_field('name',$dInfo->name,$params));
		$contents[] = array('text' => '<br /><b>'.TEXT_FIELD_TAX.'</b><br />' . YES.xtc_draw_radio_field('tax_orders','1',(($dInfo->tax_orders==1)?true:false) ).'&nbsp;'.NO.xtc_draw_radio_field('tax_orders','0',(($dInfo->tax_orders==0)?true:false) ));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'payment_terms');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.TEXT_DISTRIBUTOR_PAYMENT_TERMS.':</b><br />' .xtc_draw_input_field('payment_terms',$dInfo->payment_terms,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'telefon');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_TELEPHONE_NUMBER.'</b><br />' . xtc_draw_input_field('telefon',$dInfo->telefon,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'fax');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_FAX_NUMBER.'</b><br />' . xtc_draw_input_field('fax',$dInfo->fax,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'email');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_EMAIL_ADDRESS.'</b><br />' . xtc_draw_input_field('email',$dInfo->email,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'homepage');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_HOMEPAGE.'</b><br />' . xtc_draw_input_field('homepage',$dInfo->homepage,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'strasse');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_STREET_ADDRESS.'</b><br />' . xtc_draw_input_field('strasse',$dInfo->strasse,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'plz');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_POST_CODE.'</b><br />' . xtc_draw_input_field('plz',$dInfo->plz,$params));
        $field_len = yes_get_database_table_field_length($db_ini, 'distributors', 'ort');
        $params = ($field_len > 0) ? sprintf('maxlength="%s" size="%s"',$field_len,(($field_len > $max_size)?$max_size:$field_len)) : '';
		$contents[] = array('text' => '<br /><b>'.ENTRY_CITY.'</b><br />' . xtc_draw_input_field('ort',$dInfo->ort,$params));
		$countries = xtc_get_countries();
		foreach($countries as $k=>$country){
			$countries[$k] = array(
				'id'=>$country['text'],'text'=>$country['text']
			);
		}
		
		$contents[] = array('text' => '<br /><b>'.ENTRY_COUNTRY.'</b><br />' . xtc_draw_pull_down_menu('land',$countries,$dInfo->land));
		$contents[] = array('text' => '<br /><b>'.ENTRY_CID.'</b><br />' . xtc_draw_input_field('kundennummer',$dInfo->kundennummer));
		$contents[] = array('text' => '<br /><b>'.ENTRY_COMMENT.'</b><br />' . xtc_draw_textarea_field('memo','',45,4,$dInfo->memo));
		$contents[] = array('text' => DISTRIBUTOR_DEFAULT_STORAGE);
		$default_delivery_storage_addresses = array(array('id'=>'','text'=>TEXT_SELECT));
		$ddsa_query = xtc_db_query(
			"SELECT id,name, storage_street_address,storage_city,default_storage FROM storages ORDER BY default_storage ASC,name ASC"
		);
		while($ddsa = xtc_db_fetch_array($ddsa_query)){
		    $ddsa_text = $ddsa['name'];
		    if($ddsa['default_storage'] == 'y'){
			$ddsa_text .= ' (Default)';
		    }
		    if($ddsa['storage_street_address'] != ''){
			$ddsa_text .= ', '.$ddsa['storage_street_address'];
		    }
		    if($ddsa['storage_city'] != ''){
			$ddsa_text .= ', '.$ddsa['storage_city'];
		    }
		    $default_delivery_storage_addresses[] = array('id'=>$ddsa['id'],'text'=>substr($ddsa_text,0,50));
		}
		$contents[] = array('text' => xtc_draw_pull_down_menu('default_delivery_storage_address_id',$default_delivery_storage_addresses,$dInfo->default_delivery_storage_id));

		$contents[] = array('align' => 'center', 'text' =>
		'<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:100px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('distributor.php',xtc_get_all_get_params(array('action'))),'width:100px;')
		);
		break;
    default:
      if (isset($dInfo) and is_object($dInfo)) {
        $heading[] = array('text' => '<b>'.$dInfo->account_type.' '.$dInfo->name.'</b>');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor.php','dID=' . $dInfo->id . '&action=edit') . '\';" value="'.IMAGE_EDIT.'" style="width:200px;">');
       	if($dInfo->account_type == 'Lieferant')
		$contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\''.xtc_href_link('distributor.php', xtc_get_all_get_params(array('dID', 'action')) . 'dID=' . $dInfo->id . '&action=new_order') . '\';" value="'.BUTTON_NEW_ORDER.'" style="width:200px;">');
		$contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor.php', xtc_get_all_get_params(array('dID', 'action')) . 'dID=' . $dInfo->id . '&action=new_invoice') . '\';" value="'.BUTTON_NEW_INVOICE.'" style="width:200px;">');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default lbOn" id="'.xtc_href_link('distributor.php','dID=' . $dInfo->id . '&action=export_select_group') . '" value="'.BUTTON_EXPORT.'" title="'.BUTTON_EXPORT.'" style="width:200px;">');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor.php','dID=' . $dInfo->id . '&action=import') . '\';" value="'.BUTTON_IMPORT.'" style="width:200px;">');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor.php','dID=' . $dInfo->id . '&action=delete_distributor_products_confirm') . '\';" value="'.IMAGE_DELETE_DISTRIBUTOR_PRODUCTS_ALLOCATIONS.'" style="width:200px;">');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor.php','dID=' . $dInfo->id . '&action=delete_confirm') . '\';" value="'.IMAGE_DELETE.'" style="width:200px;">');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor.php','dID=' . $dInfo->id . '&action=products') . '\';" value="'.BUTTON_PRODUCTS.'" style="width:200px;">');
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\''. xtc_href_link('distributor_orders.php','dID=' . $dInfo->id) . '\';" value="'.BUTTON_ORDERS.'" style="width:200px;">');
		
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="lbOn ui-button ui-corner-all ui-state-default" id="' . xtc_href_link('distributor.php',xtc_get_all_get_params(array('dID','action')).'action=storage_stats&dID=' . $dInfo->id) . '" value="'.BUTTON_STORAGE_STATS.'" title="'.BUTTON_STORAGE_STATS.'" style="width:200px;">');
		
        $contents[] = array('align' => 'center', 'text' => '<input type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('distributor_invoices.php','dID=' . $dInfo->id) . '\';" value="'.BUTTON_INVOICES.'" style="width:200px;">');
		
        $contents[] = array('text' => '<br /><b>Nr:</b> '.$dInfo->id);
        $contents[] = array('text' => '<br /><b>'.TEXT_FIELD_CONTACTNAME.':</b> '.$dInfo->contact_name);
        $contents[] = array('text' => '<b>'.ENTRY_TELEPHONE_NUMBER.'</b> '.$dInfo->telefon);
        $contents[] = array('text' => '<b>'.ENTRY_CITY.'</b> '.$dInfo->ort);
        $contents[] = array('text' => '<b>'.ENTRY_COUNTRY.'</b> '.$dInfo->land);
        $contents[] = array('text' => '<b>'.ENTRY_CID.'</b> '.$dInfo->kundennummer);
        $contents[] = array('text' => '<b>'.TEXT_DISTRIBUTOR_PAYMENT_TERMS.':</b><br /> '.$dInfo->payment_terms);
        $contents[] = array('text' => '<b>'.ENTRY_COMMENT.'</b><br /> '.$dInfo->memo);
      }
      break;
  }

  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table></td>
      </tr>
    </table>
    
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
