<?php
function _get_invoice_type($value){
	return ($value == 'installment') ? TEXT_INVOICE_TYPE_INSTALLMENT : TEXT_INVOICE_TYPE_OTC;
}
function _get_status_name($value){
	global $statuses_array;
	foreach($statuses_array as $status){
		if($status['id'] == $value)
			return $status['text'];
	}
}

$smarty = new yesSmarty;
include(DIR_WS_CLASSES.'class.yes_lister.php');
$smarty->assign('HEADING_TITLE',HEADING_TITLE);
$smarty->assign('FORM_STATUS',xtc_draw_form('status', 'distributor_invoices.php', '', 'get'));
$smarty->assign('HEADING_TITLE_STATUS',HEADING_TITLE_STATUS);
$statuses_array = array();
$statuses_query = xtc_db_query("SELECT * FROM distributor_invoices_status");
while($statuses = xtc_db_fetch_array($statuses_query)){
	$statuses_array[] = array('id'=>$statuses['distributor_invoices_status_id'],'text'=>$statuses['distributor_invoices_status_name']);
}
$smarty->assign('INPUT_STATUS',xtc_draw_pull_down_menu('status',$statuses_array));

$status = (isset($_GET['status'])) ? intval($_GET['status']) : 1;
$reason = (isset($_GET['reason'])) ? xtc_db_input($_GET['reason']) : '';
$reasons_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
$items = \YES4Trade\Model\distributor_invoices_reasons::get_all();
foreach($items as $it){
    $reasons_array[] = array(
        'id'=>$it->distributor_invoices_reasons_id,
        'text'=>$it->title
    );
}

$where = '';
$order_by = (isset($_GET['order_by'])) ? xtc_db_input($_GET['order_by']) : 'di.distributor_id DESC';
if($status > 0){
	$where .=" di.status='". $status . "' ";
}

if(isset($_GET['dID'])){
	if($status > 0){
		$where .= ' and ';
	}
	$where .= " di.distributor_id='".xtc_db_input($_GET['dID'])."' ";
}
if($reason != ''){
	$where .= " and di.reasons_id='".$reason."'";
}
$distributors_invoice_query_raw = "select distributor_invoices_id,date_created,distributor_name,invoice_type,status from distributor_invoices di WHERE ".$where." order by ".$order_by;
$di_split = new splitPageResults($_GET['page'], $view_limit = MAX_DISPLAY_SEARCH_RESULTS, $distributors_invoice_query_raw, $di_query_numrows);

$select_field_array = array(
		0=>array(
			'field'=>'distributor_invoices_id',
			'heading'=>TABLE_HEADING_ID,
			'format'=>'int',
			'get_param'=>'diID',
			'sortable'=>1,
			'index'=>true,
			'column'=>0
		),
		1=>array(
			'field'=>'date_created',
			'heading'=>TABLE_HEADING_DATE_ADDED,
			'format'=>'date',
			'get_param'=>'',
			'sortable'=>1,
			'column'=>1
		),
		2=>array(
			'field'=>'distributor_name',
			'heading'=>TABLE_HEADING_NAME,
			'format'=>'string',
			'get_param'=>'',
			'sortable'=>1,
			'column'=>2
		),
		3=>array(
			'field'=>'invoice_type',
			'heading'=>TABLE_HEADING_TYPE,
			'format'=>'string',
			'get_param'=>'',
			'function'=>'_get_invoice_type',
			'sortable'=>1,
			'column'=>3
		),
		4=>array(
			'field'=>'status',
			'heading'=>TABLE_HEADING_STATUS,
			'format'=>'string',
			'get_param'=>'',
			'function'=>'_get_status_name',
			'sortable'=>1,
			'column'=>4
		)
);
$listing_smarty = $smarty;
$ajax_link = 'ajax_distributor_invoices_details.php';
$YL = new yes_lister($distributors_invoice_query_raw,'distributor_invoices','distributor_invoices.php',$select_field_array,$where_array = array(),$ajax_box = 1,$ajax_get_param_key = 'diID',$ajax_link,'yes_lister_item_table_new.html');
$YL->setSmarty($listing_smarty);
//$YL->setTableCaption(HEADING_TITLE);
$diInfo = $YL->active_row;
$smarty->assign('LISTING',$YL->display($di_split,$di_query_numrows,$view_limit));
$smarty->assign('start_row_input',$YL->start_row_input);
$smarty->assign([
	'SPLIT'=>$YL->split_string,
	'JS_CONFIRM_REALLY_DELETE_ITEMS'=>JS_CONFIRM_REALLY_DELETE_ITEMS
]);

$box_html = '';
$heading = array();
$contents = array();
$action = '';
if(isset($_GET['action'])){
	$action = $_GET['action'];
}
switch($action) {
	case 'delete':
		  $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_ORDER . '</b>');
		  $contents = array('form' => xtc_draw_form('orders', FILENAME_ORDERS, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=deleteconfirm'));
		  $contents[] = array('text' => TEXT_INFO_DELETE_INTRO . '<br><br><b>' . $cInfo->customers_firstname . ' ' . $cInfo->customers_lastname . '</b>');
		  $contents[] = array('text' => '<br>' . xtc_draw_checkbox_field('restock') . ' ' . TEXT_INFO_RESTOCK_PRODUCT_QUANTITY);
		  $contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_delete.gif', IMAGE_DELETE) . ' <a href="' . xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
		  break;
	default:
		$box_html .= '<div id="orderdetails" style="z-index:0;width:100%;margin: 0;padding: 0;" class="ui-widget-content"></div>';
		break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    $box_html .= '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    $box_html .= $box->infoBox($heading, $contents);
    $box_html .= '            </td>' . "\n";
}
$smarty->assign('BOX',$box_html);
echo $smarty->fetch(DIR_FS_ADMIN.'templates/distributor_invoices_listing.html');
