<?php
/* --------------------------------------------------------------
   $Id: orders_edit.php,v 1.1

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.27 2003/02/16); www.oscommerce.com
   (c) 2003	 nextcommerce (orders.php,v 1.7 2003/08/14); www.nextcommerce.org

   Released under the GNU General Public License

   To do: Rabatte ber�cksichtigen
   --------------------------------------------------------------*/

  
require('includes/application_top.php');  
require_once('includes/classes/class.help.php');
require_once('includes/classes/product.php');
require_once('includes/classes/distributor.php');
require_once('includes/classes/distributor_order.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');

require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_options_name.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_options_values_name.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_data_from_name.inc.php');

$allow_tax = 0;
$dID = intval(xtc_db_input($_REQUEST['dID'] ?? 0));
$action = $_REQUEST['action'] ?? '';
if($dID > 0){
    $distributor = new distributor($dID);
    $allow_tax = $distributor->info['tax_orders'];  	// sollte irgendwann mal feststehen dass wir lieferantenbestellungen ohne
    // MwSt brauchen, dann pro lieferant einbauen - mario -
}

$admin_access = main::get_admin_access();

// initiate template engine for mail
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('FORM_END','</form>');

if($action == 'update_search_defaults'){
    $value = xtc_db_input($_GET['value']);
    $update_sql_array = array(
        'distributor_orders_edit_products_search_default'=>substr($value,0,16)
    );
    xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array, "update","customers_id='".$_SESSION['customer_id']."'");
    die(json_encode(array(
        'MSG'=>$value
    )));
}

if($action == 'get_storages_addresses'){
    $items = array();
    $query = xtc_db_query("SELECT * FROM storages ORDER BY default_storage DESC, name");
    while($record = xtc_db_fetch_array($query)){
	$address = array();
	if($record['storage_company'] != '')
	    $address[] = $record['storage_company'];
	if($record['storage_name'] != '')
	    $address[] = $record['storage_name'];
	if($record['storage_suburb'] != '')
	    $address[] = $record['storage_suburb'];
	if($record['storage_street_address'] != '')
	    $address[] = $record['storage_street_address'];
	if($record['storage_city'] != '')
	    $address[] = $record['storage_postcode'].' '.$record['storage_city'];
	$country = ($record['storage_country']>0) ? $record['storage_country'] : STORE_COUNTRY;
	$address[] = xtc_get_country_name($country);
	$record['address'] = implode(', ',$address);
	$items[] = $record;
    }
    if(!sizeOf($items)){
	die(MSG_ERROR_NO_STORAGES_SAVED);
    }
    $smarty->assign(array(
	'items'=>$items,
	'action'=>$action
    ));
    header('Content-Type: text/html; charset='.CHARSET);
    $smarty->display('distributor_orders_edit.html');
    exit;
}

if ($action == "json_get_storage_address_array") {
    $query = xtc_db_query(sprintf(
	    "SELECT storage_company,storage_name,storage_suburb,storage_street_address,storage_city,storage_postcode,storage_country FROM storages WHERE id='%s'",
	    (int)xtc_db_input($_REQUEST['id'])
    ));
    $record = xtc_db_prepare_input(xtc_db_fetch_array($query));
    foreach($record as $k=>$v){
	$record[$k] = yes_encode_string($v);
    }
    header('Content-Type: text/html; charset=UTF-8');
    die(json_encode($record));
}

$doID = (int)xtc_db_input($_REQUEST['doID']??0);
if ($action == "address_edit") {
	  // yes accounting
	  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_address'] == '1')) {
	  }else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_ADDRESS),'error');
		xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
	  }
	  
	  require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
	$distributor_country = xtc_get_country_name(xtc_db_input($_POST['distributor_country']));
	$delivery_country = xtc_get_country_name(xtc_db_input($_POST['delivery_country']));
	  
	$sql_data_array = array('distributor_id' => (int)$_POST['dID'],
		'distributor_name' => $_POST['distributor_name'],
		'distributor_street_address' => $_POST['distributor_street_address'],
		'distributor_city' => $_POST['distributor_city'],
		'distributor_postcode' => $_POST['distributor_postcode'],
		'distributor_country' => $distributor_country,
		'delivery_company' => $_POST['delivery_company'],
		'delivery_name' => $_POST['delivery_name'],
		'delivery_street_address' => $_POST['delivery_street_address'],
		'delivery_suburb' => $_POST['delivery_suburb'],
		'delivery_city' => $_POST['delivery_city'],
		'delivery_postcode' => $_POST['delivery_postcode'],
		'delivery_country' => $delivery_country,
		'last_modified' => 'now()'
	);

	xtc_db_perform('distributor_orders', $sql_data_array, 'update', 'distributor_orders_id = \'' . $doID . '\'');
		
	$order = new distributor_order($doID);
	$comments = MSG_SUCCESS_ADDRESS_UPDATE;
	$order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
	$messageStack->add_session($comments, 'success');
	xtc_redirect(xtc_href_link(basename(__FILE__), 'text=address&dID='.$_POST['dID'].'&doID=' . $doID));
}
// Adressbearbeitung Ende



// ******************* Artikel bearbeiten Anfang
if ($action == "product_edit") {
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_PRODUCTS),'error');
		xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
	}
	require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
	// ************* BESTANDSPRUEFUNG ***************
	$oID  = $doID;
	$dID = (int)xtc_db_input($_POST['dID']);
	$distributor = new distributor($dID);
	$pID  = xtc_db_input($_POST['products_id']);
	$qty  = xtc_db_input($_POST['products_quantity']);
	$opID = xtc_db_input($_POST['opID']);
	$price_netto = (float)xtc_db_input(str_replace(',','.',$_REQUEST['products_price']));
	$price_netto_original = $price_netto;
	$order = new distributor_order($oID);
        
	if($order->distributor['country'] == 'Deutschland') $order->distributor['country'] = 'Germany';
	$country = xtc_get_country_data_from_name($order->distributor['country']);
        
        $country_id = $country['countries_id'];
        $zone_id = 0;
        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $country_id, $zone_id);
        $tax = xtc_get_tax_rate($products_tax_class_id, $country_id, $zone_id );
        
	$allow_tax = $order->distributor['allow_tax'];
	if($allow_tax == 1 and $tax > 0){
		$price_netto = $price_netto * (($tax+100)/100);
	}
	
	$orig_query = xtc_db_query("SELECT stuecklistenartikel,products_quantity,products_price,products_name FROM distributor_orders_products WHERE distributor_orders_products_id='".$opID."'");
	$orig = xtc_db_fetch_array($orig_query);
	$price_orig = $orig['products_price'];
	$name_orig = $orig['products_name'];
	$qty_orig = $orig['products_quantity'];
	
	if($qty_orig != $qty){
		// IST EIN SET, ALSO AUCH QTY DER COLLIS UPDATEN
		if($orig['stuecklistenartikel'] == 1){
			$colli_query = xtc_db_query("SELECT collie_qty,distributor_orders_products_id FROM distributor_orders_products WHERE stuecklisten_id='".$pID."'");
			while($colli = xtc_db_fetch_array($colli_query)){
				xtc_db_query("UPDATE distributor_orders_products SET products_quantity='".($qty*$colli['collie_qty'])."' WHERE distributor_orders_products_id='".$colli['distributor_orders_products_id']."'");
			}
		}
		$comments = sprintf(TEXT_HISTORY_UPDATE,TEXT_QUANTITY.' '.TEXT_PRODUCT.' pID '.$pID,$qty_orig,$qty);
		$order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
	}

	// VORGANG LOGGEN
	if($price_netto <> $price_orig){
		$comments = sprintf(TEXT_HISTORY_UPDATE,'Preis '.TEXT_PRODUCT.' pID '.$pID,$price_orig,$price_netto);
		$order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
	}
	if($_POST['products_name'] != $name_orig){
		$comments = sprintf(TEXT_HISTORY_UPDATE,'Titel '.TEXT_PRODUCT.' pID '.$pID,$name_orig,xtc_db_input($_POST['products_name']));
		$order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
	}
	
	$sql_data_array = array('distributor_orders_id' => $doID,
	    'products_id' => xtc_db_prepare_input($pID),
	    'products_name' => xtc_db_prepare_input($_POST['products_name']),
	    'products_price' => $price_netto,
	    'products_discount_made' => '',
	    'final_price' => $price_netto * $qty,
	    'products_tax' => $tax,
	    'products_quantity' => $qty,
	    'allow_tax' => $order->info['allow_tax'],
	    'products_model' => xtc_db_prepare_input($_POST['products_model'])
	);

	xtc_db_perform('distributor_orders_products', $sql_data_array, 'update', 'distributor_orders_products_id = \'' . $opID . '\'');
	
	// IST EIN EINTRAG IN distributor_product_prices?
	// FALLS NICHT: ERZEUGEN UND ALS DEFAULT SETZEN
	$new_dpp_id = 0;
	if(DISTRIBUTOR_ORDER_PRODUCTS_DISTRIBUTOR_PRICES_AUTOMATIC_INSERT == 'True'){
	    $check_query = xtc_db_query(sprintf("SELECT distributor_product_prices_id FROM distributor_product_prices WHERE products_id='%s' AND distributor_id='%s' AND CAST(price as DECIMAL(12,2))=CAST(%s as DECIMAL(12,2))",
		    $pID,$dID,$price_netto
	    ));
	    if(!xtc_db_num_rows($check_query)){
		xtc_db_query(sprintf(
			"UPDATE distributor_product_prices SET is_default=0 WHERE products_id='%s' AND distributor_id='%s'",
			$pID,$dID
		));
		$insert_sql_array = array(
		    'products_id'=>$pID,
		    'distributor_id'=>$dID,
		    'price'=>$price_netto_original,
		    'date_saved'=>'now()',
		    'is_default'=>1
		);
		xtc_db_perform('distributor_product_prices',$insert_sql_array);
		$new_dpp_id = xtc_db_insert_id();
		$P = new product($pID);
		$P->add_history(sprintf(TEXT_HISTORY_EK_PRICE_ADDED_FROM_DO,number_format($price_netto,2,',','.'),  xtc_get_distributor_name($dID),$oID));
	    }
	}
	
	// BOF TICKET 1507
	$is_default = (isset($_REQUEST['use_price_as_default_ek']) and $_REQUEST['use_price_as_default_ek'] == 1) ? 1 : 0;
	if($new_dpp_id == 0 and isset($_REQUEST['use_price_as_new_ek']) and $_REQUEST['use_price_as_new_ek'] == 1){
	    // ggf anderen default loeschen
	    if($is_default == 1){ 
		xtc_db_query(sprintf(
			"UPDATE distributor_product_prices SET is_default='0' WHERE products_id='%s' AND distributor_id='%s'",
			$pID,$dID
		));
	    }
	    // neuen EK anlegen
	    $insert_sql_array = array(
		'distributor_id'=> $dID,
		'products_id'=>$pID,
		'price'=>(float)$price_netto_original,
		'date_saved'=>'now()',
		'conditions'=>'aus LB '.$doID.' uebernommen',
		'shippings'=>'',
		'is_default'=>$is_default
	    );
	    xtc_db_perform('distributor_product_prices',$insert_sql_array);
	    $product = new product($pID);
	    $product->add_history('Neuer EK Preis '.(($is_default == 1)?' als Default ':'').'- Artikelbearbeitung LB '.$doID);
	}
	// EOF TICKET 1507
	$order = new distributor_order($doID);
	$order->recalc();
	
	$messageStack->add_session(MSG_SUCCESS_PRODUCTS_UPDATE,'success');
	xtc_redirect(xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action','doID','dID','edit_action')).'edit_action=products&dID='.$_POST['dID'].'&doID=' . $doID));
}
// ********************************* Artikel bearbeiten Ende

// Artikel einf�gen Anfang

if ($action == "product_ins") {
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_PRODUCTS),'error');
		xtc_redirect(xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('action'))));
	}
	$distributor = new distributor((int)xtc_db_input($_REQUEST['dID']));
	$properties = array();
	foreach($_REQUEST['products_quantity'] as $pID => $qty){
	    if($qty < 1) continue;
	    $qty = (int)xtc_db_input($qty);
	    $pID = (int)xtc_db_input($pID);
	    if(isset($_REQUEST['prop'][$pID]) and is_array($_REQUEST['prop'][$pID])){
		    $check_query = xtc_db_query(sprintf(
			    "SELECT distributor_orders_products_id FROM distributor_orders_products WHERE products_id='%s' AND distributor_orders_id='%s'",
			    $pID,$doID
		    ));
		    if(xtc_db_num_rows($check_query)){
			$record = xtc_db_fetch_array($check_query);
                        $dopID = $record['distributor_orders_products_id'];
                        foreach($_REQUEST['prop'][$pID] as $properties_id => $properties_values_id){
				    $query = xtc_db_query(sprintf(
					    "SELECT title FROM products_properties_description WHERE products_properties_id='%s' AND language_id='%s'",
					    (int)xtc_db_input($properties_id),$_SESSION['languages_id']
				    ));
				    $record = xtc_db_fetch_array($query);
				    $title = xtc_db_prepare_input($record['title']);

				    $query = xtc_db_query(sprintf(
					    "SELECT title FROM products_properties_values_description WHERE products_properties_values_id='%s' AND language_id='%s'",
					    (int)xtc_db_input($properties_values_id),$_SESSION['languages_id']
				    ));
				    $record = xtc_db_fetch_array($query);
				    $value = xtc_db_prepare_input($record['title']);
				    $query = xtc_db_query(sprintf(
					    "SELECT distributor_orders_products_properties_id FROM distributor_orders_products_properties WHERE distributor_orders_products_id='%s' AND property_title='%s' AND property_value='%s'",
					    $dopID,$title,$value
				    ));
				    if(xtc_db_num_rows($query)){
					    $messageStack->add_session(MSG_ERROR_PROPERTY_EXISTS,'error');
					    xtc_redirect(xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('action','edit_action','doID','dID')).'edit_action=products&doID='.$doID.'&dID='.$_REQUEST['dID']));
				    }
				    $properties[] = array(
					    'title'=>$title,
					    'value'=>$value
				    );
			    }
		    }
	    }else{
		    // verhindern dass produkte die nicht in sets enthalten sind doppelt in der bestellung vorkommen
		    $dbl_check_query = xtc_db_query("SELECT count(1) as anzahl FROM distributor_orders_products WHERE products_id='".$pID."' and stuecklisten_id=0 and distributor_orders_id='".$doID."'");
		    $dbl_check = xtc_db_fetch_array($dbl_check_query);
		    if($dbl_check['anzahl']>0){
			    $messageStack->add_session(MSG_ERROR_PRODUCT_EXISTS,'error');
			    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
		    }
	    }
	
	    $product_query = xtc_db_query("select p.products_model, pd.products_name from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id = '" . $pID . "' and pd.products_id = p.products_id and pd.language_id = '".$_SESSION['languages_id']."'");
	    $product = xtc_db_fetch_array($product_query);

	    $collies = xtc_get_product_collies($pID);

	    $oID = $doID;
	    $dID = (int)xtc_db_input($_REQUEST['dID']);
	    $order = new distributor_order($oID);

	    $qt = $qty;
	    if(isset($_REQUEST['price'][$pID])){
		$ek_netto = (float)str_replace(',','.',xtc_db_input($_REQUEST['price'][$pID]));
	    }else{
		$ek_netto = xtc_get_price_ek($pID,'NEWEST',$dID);
	    }
	    
	    // IST EIN EINTRAG IN products_distributors?
	    // FALLS NICHT: ERZEUGEN
	    $check_query = xtc_db_query(sprintf(
		    "SELECT id FROM products_distributors WHERE products_id='%s' AND distributor_id='%s'",
		    $pID,$dID
	    ));
	    if(!xtc_db_num_rows($check_query)){
		$insert_sql_array = array(
		    'products_id'=>$pID,
		    'distributor_id'=>$dID,
		    'distributor_products_number'=>$pID
		);
		xtc_db_perform('products_distributors',$insert_sql_array);
	    }
	    // IST EIN EINTRAG IN distributor_product_prices?
	    // FALLS NICHT: ERZEUGEN UND ALS DEFAULT SETZEN
	    if(DISTRIBUTOR_ORDER_PRODUCTS_DISTRIBUTOR_PRICES_AUTOMATIC_INSERT == 'True'){
		/*
		$check_query = sprintf("SELECT distributor_product_prices_id FROM distributor_product_prices WHERE products_id='%s' AND distributor_id='%s' AND CAST(price as FLOAT)=CAST(%s as FLOAT)",
			$pID,$dID,$ek_netto
		);*/
		$check_query = xtc_db_query(sprintf("SELECT distributor_product_prices_id FROM distributor_product_prices WHERE products_id='%s' AND distributor_id='%s'",
			$pID,$dID
		));
		if(!xtc_db_num_rows($check_query)){
		    xtc_db_query(sprintf(
			    "UPDATE distributor_product_prices SET is_default=0 WHERE products_id='%s' AND distributor_id='%s'",
			    $pID,$dID
		    ));
		    $insert_sql_array = array(
			'products_id'=>$pID,
			'distributor_id'=>$dID,
			'price'=>$ek_netto,
			'date_saved'=>'now()',
			'is_default'=>1
		    );
		    xtc_db_perform('distributor_product_prices',$insert_sql_array);
		    $P = new product($pID);
		    $P->add_history(sprintf(TEXT_HISTORY_EK_PRICE_ADDED_FROM_DO,number_format($ek_netto,2,',','.'),  xtc_get_distributor_name($dID),$oID));
		}
	    }

	    if($order->distributor['country'] == 'Deutschland') $order->distributor['country'] = 'Germany';
	    $country = xtc_get_country_data_from_name($order->distributor['country']);
            
            $country_id = $country['countries_id'];
            $zone_id = 0;

            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $country_id, $zone_id);
	    $tax = xtc_get_tax_rate($products_tax_class_id, $country_id, $zone_id );
	    $allow_tax = $order->distributor['allow_tax'];
	    $products_price = $ek_netto;
	    // IMMER NETTO - Ticket 1725
	    if($allow_tax == 1 and $tax > 0){
		    $products_price = $ek_netto * (($tax+100)/100);
	    }
	    $final_price=$products_price * $qt;

	    // ************ PRODUCTS QUANTITY ZONE ************************************
	    if(sizeOf($collies)>0){
		    // COLLIPRODUKTE SPEICHERN
		    foreach($collies as $k=>$collie){
			    $cp_query = xtc_db_query("SELECT products_model FROM products WHERE products_id='".$collie['collie_products_id']."'");
			    $cp = xtc_db_fetch_array($cp_query);
			    $sql_data_array = array(
				    'distributor_orders_id' => $oID,
				    'products_id' => $collie['collie_products_id'],
				    'products_name' => xtc_get_products_name($collie['collie_products_id']),
				    'products_model' => xtc_db_prepare_input($cp['products_model']),
				    'products_price' => 0,
				    'products_discount_made' => '',
				    'final_price' => 0,
				    'products_tax' => 0,
				    'products_quantity' =>($collie['quantity']*$qt),
				    'allow_tax' => 0,
				    'stuecklisten_id'=>$pID,
				    'collie_qty'=>$collie['quantity'],
				    'stuecklistenartikel'=>0,
				    'date_added'=>'now()'
			    );
			    xtc_db_perform('distributor_orders_products', $sql_data_array);
			    $comments = sprintf(TEXT_INSERT_COLLI_IN_DISTRIBUTOR_ORDER,
				    $collie['collie_products_id'],$pID,
				    ($qt*$collie['quantity'])
			    );
			    $order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
		    }
		    // und natuerlich das stklisten produkt
                    // EU-OSS 2021/07
		    $tax = xtc_get_product_collies_tax_value($collies, $country_id,$zone_id);
		    $sql_data_array = array(
			    'distributor_orders_id' => $oID,
			    'products_id' => $pID,
			    'products_model' => xtc_db_prepare_input($product['products_model']),
			    'products_name' => xtc_db_prepare_input($product['products_name']),
			    'products_price' => $products_price,
			    'products_discount_made' => '',
			    'final_price' => xtc_db_prepare_input($final_price),
			    'products_tax' => xtc_db_prepare_input($tax),
			    'products_quantity' => $qt,
			    'allow_tax' => $allow_tax,
			    'stuecklistenartikel'=>1,
			    'date_added'=>'now()'
		    );
		    xtc_db_perform('distributor_orders_products', $sql_data_array);
	    }else{
		    $sql_data_array = array(
			    'distributor_orders_id' => $oID,
			    'products_id' => $pID,
			    'products_model' => xtc_db_prepare_input($product['products_model']),
			    'products_name' => xtc_db_prepare_input($product['products_name']),
			    'products_price' => $products_price,
			    'products_discount_made' => '',
			    'final_price' => xtc_db_prepare_input($final_price),
			    'products_tax' => xtc_db_prepare_input($tax),
			    'products_quantity' => $qt,
			    'allow_tax' => $allow_tax,
			    'stuecklistenartikel'=>0,
			    'date_added'=>'now()'
		    );
		    xtc_db_perform('distributor_orders_products', $sql_data_array);
		    $dopID = xtc_db_insert_id();
		    if( isset($properties) and sizeOf($properties)){
			    foreach($properties as $property){
				    $insert_sql_array = array(
					    'distributor_orders_products_id'=>$dopID,
					    'property_title'=>$property['title'],
					    'property_value'=>$property['value']
				    );
				    xtc_db_perform('distributor_orders_products_properties',$insert_sql_array);
			    }
		    }
		    $comments = sprintf(TEXT_HISTORY_LB_PRODUCT_ADDED,$pID,$qt);
		    $order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
	    }
	} // eof foreach request products_quantity
	$order = new distributor_order($doID);
	$order->recalc();
	$messageStack->add_session(MSG_SUCCESS_ADD_PRODUCTS_TO_LB,'success');
	xtc_redirect(xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('edit_action','action','doID','dID')).'edit_action=products&doID='.$_REQUEST['doID'].'&dID='.$_REQUEST['dID']));
}
// Artikel einf�gen Ende

// Versandkosten bearbeiten Anfang

if ($action == "shipping_edit") {
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_SHIPPING),'error');
		xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
	}
	
	require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
	$counter = 0;
	$order = new distributor_order($doID);
	if(is_array($_POST['otID'])){
		foreach( $_POST['otID'] as $k => $otID ) {
			$inp_price = $_POST['value'][$counter];
			xtc_db_query("UPDATE distributor_orders_total SET title = '".xtc_db_prepare_input( $_POST['title'][$counter] )."', value = '".$inp_price."', text = '".number_format($inp_price,2,',','')." ".$order->info['currency']."' WHERE orders_total_id='".xtc_db_prepare_input($otID)."'");
			$counter++;
		}
		$msg = MSG_SUCCESS_SHIPPING_UPDATE;
		$order->insert_history($order->info['orders_status'],$customer_notified='0',$msg,$_SESSION['customer_id']);
		$messageStack->add_session($msg,'success');
	}
	$order = new distributor_order($doID);
	$order->recalc();
	xtc_redirect(xtc_href_link('distributor_orders_edit.php', 'edit_action=shipping&dID='.$_POST['dID'].'&doID=' . $_POST['doID']));
}
// Versandkosten bearbeiten Ende

// voraussichtl. lieferzeit Anfang

if ($action == "shipping_edit_date") {
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_SHIPPING),'error');
		xtc_redirect(xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('action'))));
	}
	require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
	$counter = 0;
	
	$order = new distributor_order((int)$_POST['doID']);
	xtc_db_query("UPDATE distributor_orders SET estimated_date_receipt='".xtc_db_input($_POST['datefrom'])."' WHERE distributor_orders_id='".(int)xtc_db_input($_POST['doID'])."'");
	$msg = sprintf(TEXT_HISTORY_UPDATE,TEXT_ESTIMATED_DATE_RECEIPT,((!empty($order->info['estimated_date_receipt']))?xtc_date_short($order->info['estimated_date_receipt']):'-'),xtc_date_short($_POST['datefrom']));
        $order->insert_history($order->info['orders_status'], false, $msg);
	$messageStack->add_session($msg,'success');
	xtc_redirect(xtc_href_link('distributor_orders_edit.php', 'edit_action=shipping&dID='.$_POST['dID'].'&doID=' . $_POST['doID']));
}
// Versandkosten bearbeiten Ende

// Versandkosten Einf�gen Anfang
if ($action == "shipping_ins") {
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_SHIPPING),'error');
		xtc_redirect(xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('action'))));
	}
	
	require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
	$order = new distributor_order($doID);

	$inp_price = $_POST['value'];

	$text = number_format($inp_price,2,',','.').' '.$order->info['currency'];
	$sort = MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER;
	
	// --------- Gesamtsummer NEU	
	$o_subtotal = 0;
	$o_tax = 0;
	$o_ship = 0;
	$o_total = 0;
	$calc_query = xtc_db_query("SELECT * FROM distributor_orders_total WHERE orders_id='".$_POST['doID']."'");
	while($calc = xtc_db_fetch_array($calc_query)){
		switch($calc['class']){
			case 'ot_subtotal':	$o_subtotal += $calc['value'];	break;
			case 'ot_tax':		$o_tax += $calc['value'];	break;
			case 'ot_shipping':	$o_ship += $calc['value'];	break;
			case 'ot_total':	$o_total = $calc['value'];	break;
		}
	}
	$n_total = $o_total - ($o_ship - $inp_price);
	$n_total_text = number_format($n_total,2,',','.').' '.$order->info['currency'];
	xtc_db_query("UPDATE distributor_orders_total SET value='".$n_total."',text='".$n_total_text."' WHERE orders_id='".$doID."' && class='ot_total'");
	// --------- Gesamtsummer NEU ende
 	
	$sql_data_array = array('orders_id' => $doID,
	    'title' => $_POST['title'],
	    'text' => $text,
	    'value' => $inp_price,
	    'class' => 'ot_shipping'
	);

	$insert_sql_data = array('sort_order' => $sort);
	$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
	xtc_db_perform('distributor_orders_total', $sql_data_array);
	$comments = sprintf(TEXT_HISTORY_INSERT,TEXT_FRACHTKOSTEN,$inp_price);
        $order->insert_history($order->info['orders_status'], false, $comments);
	$order = new distributor_order($doID);
	$order->recalc();
	$messageStack->add_session($comments,'success');
	xtc_redirect(xtc_href_link(basename(__FILE__), 'edit_action=shipping&dID='.$_POST['dID'].'&doID=' . $doID));
}
// Versandkosten Einf�gen Ende
if ($action == "shipping_del") {
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
	}else{
	    $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_SHIPPING),'error');
	    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
	}

	require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
	xtc_db_query("delete from distributor_orders_total where orders_total_id = '" . xtc_db_input($_GET['otID']) . "'");
	$order = new distributor_order($doID);
	$comments = sprintf(TEXT_HISTORY_DELETE,TEXT_FRACHTKOSTEN);
        $order->insert_history($order->info['orders_status'], false, $comments);
	$order->recalc();
	$messageStack->add_session($comments,'success');
	xtc_redirect(xtc_href_link(basename(__FILE__), 'edit_action=shipping&dID='.$_GET['dID'].'&doID=' . $_GET['doID']));
}

// L�schfunktionen Anfang

if ($action == "product_delete") {
    // yes accounting
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) {
    }else{
	$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,TEXT_EDIT_PRODUCTS),'error');
	xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
    }


    require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
    // ************* BESTANDSPRUEFUNG ***************
    $oID  = $doID;
    $pID  = xtc_db_input($_REQUEST['pID']);
    $opID = xtc_db_input($_REQUEST['opID']);

    $order = new distributor_order($oID);

    $orig_query = xtc_db_query("SELECT stuecklistenartikel,products_quantity,products_price,products_name,products_id FROM distributor_orders_products WHERE distributor_orders_products_id='".$opID."'");
    $orig = xtc_db_fetch_array($orig_query);
    $qty_orig = $orig['products_quantity'];


    // IST EIN SET, ALSO AUCH QTY DER COLLIS DELETEN
    if($orig['stuecklistenartikel'] == 1 and $orig['products_id'] > 0){
	xtc_db_query("DELETE FROM distributor_orders_products WHERE stuecklisten_id='".$orig['products_id']."'");
    }
	
    xtc_db_query("delete from distributor_orders_products where distributor_orders_id = '" . $oID . "' and distributor_orders_products_id = '" . $opID . "'");
    $comments = sprintf(TEXT_HISTORY_DELETE,TEXT_PRODUCT.' pID '.$pID);
    $order->insert_history($order->info['orders_status'], false, $comments);
    $order = new distributor_order($doID);
    $order->recalc();
    $messageStack->add_session($comments,'success');
    xtc_redirect(xtc_href_link('distributor_orders_edit.php', 'edit_action=products&dID='.$order->info['distributor_id'].'&doID=' . $oID));
}
$buttons = array(
    array('text'=>IMAGE_BACK,
	'link'=>xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('action')).'action=edit'),
	'lbOn'=>false,
	'auth'=>true
    ),
    array(
	'text'=>TEXT_EDIT_ADDRESS, 
	'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('edit_action')).'edit_action=address'),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_address'] == '1')) ? true : false,
    ),
    array(
	'text'=>TEXT_EDIT_PRODUCTS, 
	'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('edit_action')).'edit_action=products'),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) ? true : false,
    ),
    array(
	'text'=>TEXT_EDIT_SHIPPING, 
	'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('edit_action')).'edit_action=shipping'),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_products'] == '1')) ? true : false,
    )
);
$smarty->assign(array(
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'HEADING_TITLE'=>HEADING_TITLE,
    'ADDITIONAL_TITLE'=>TEXT_DISTRIBUTOR_ORDER.' '.$_REQUEST['doID']
));
yes_draw_pre_header();
yes_draw_header(TITLE);
?>

<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>

<?php
$smarty->display('distributor_orders_edit.html');
if(isset($_REQUEST['doID'])){
    $distributor_order = new distributor_order((int)xtc_db_input($_REQUEST['doID']));
    $format_id = 5;
?>
<br clear="all" />
<div class="oe_addresses">
    <div class="ui-widget oe_address">
	<div class="ui-widget-header"><?php echo TEXT_INVOICE_ADDRESS; ?></div>
 	<div class="ui-widget-content"><?php echo xtc_address_format($format_id, xtc_db_prepare_input($distributor_order->distributor), true, '', '<br />'); ?></div>
    </div>
    <div class="ui-widget oe_address">
	<div class="ui-widget-header"><?php echo TEXT_SHIPPING_ADDRESS; ?></div>
	<div class="ui-widget-content"><?php echo xtc_address_format($format_id, xtc_db_prepare_input($distributor_order->delivery), true, '', '<br />'); ?></div>
    </div>
</div>
<br clear="all" />
<br />
<?php
}
if (isset($_GET['edit_action']) and $_GET['edit_action']=='address'){
  
  // yes accounting
  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_distributor_orders_edit_address'] == '1' )) {
  	include('distributor_orders_edit_address.php');
  }else{
      printf(JS_MISSING_PERMISSION,TEXT_EDIT_ADDRESS);
  }
} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='products'){
  
  // yes accounting
  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_distributor_orders_edit_products'] == '1' )) {
	  include('distributor_orders_edit_products.php');
  }else{
      printf(JS_MISSING_PERMISSION,TEXT_EDIT_PRODUCTS);
  }
} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='shipping'){
  // yes accounting
  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_distributor_orders_edit_products'] == '1' )) {
	  include('distributor_orders_edit_shipping.php');
  }else{
      printf(JS_MISSING_PERMISSION,TEXT_EDIT_SHIPPING);
  }
} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='options'){
  include('distributor_orders_edit_options.php');
}
?>


<!-- body_eof //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
