<?php
//error_reporting(E_ALL);ini_set('display_errors',true);
define('MSG_SUCCESS_CSV_UPLOADED','CSV Datei "%s" wurde erfolgreich gespeichert.');
define('MSG_SUCCESS_CSV_DELETED','CSV Datei "%s" wurde entfernt.');
require_once(DIR_WS_CLASSES.'qqUploadedFileXhr.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'class.csv.php');
if(!function_exists('yes_get_sha1_from_string')){
    require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
}
function human_filesize($bytes, $decimals = 2) {
  $sz = 'BKMGTP';
  $factor = floor((strlen($bytes) - 1) / 3);
  return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
}
//error_reporting(E_ALL);ini_set('display_errors',true);
function human2byte($val) {
    $val = trim($val);
    $last = strtolower($val[strlen($val)-1]);
    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }

    return $val;
}
$max_csv_file_size = human2byte(ini_get('upload_max_filesize'));
$csv_file_save_path = 'importdata/ebay_import_csv/';
if(!is_dir($csv_file_save_path)){
    mkdir($csv_file_save_path);
}
if(isset($_REQUEST['delete_ebay_import_csv_file'])){
    $delfile = basename(xtc_db_input($_REQUEST['delete_ebay_import_csv_file']));
    if(is_file($csv_file_save_path.'/'.$delfile)){
	unlink($csv_file_save_path.'/'.$delfile);
	$messageStack->add_session(sprintf(MSG_SUCCESS_CSV_DELETED,$delfile),'success');
	xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),'action=ebay_import_csv'));
    }
}
if(isset($_REQUEST['qqfile'])){
	$allowedExtensions = array('csv','CSV');
	$sizeLimit = $max_csv_file_size;
	$uploader = new qqFileUploader($allowedExtensions,$sizeLimit);
	// Call handleUpload() with the name of the folder, relative to PHP's getcwd()
	$result = $uploader->handleUpload($csv_file_save_path);
	$messageStack->add_session(sprintf(MSG_SUCCESS_CSV_UPLOADED,basename($result['FN'])),'success');
	exit;
}
$smarty = new Smarty;
$smarty->caching = 0;
$smarty->template_dir=DIR_FS_ADMIN.'templates/';
$smarty->compile_dir=DIR_FS_CATALOG.'templates_c';
$smarty->config_dir=DIR_FS_CATALOG.'lang';
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$basics = new basics;
$files = array();
$_files = $basics->get_directory_content($csv_file_save_path);
foreach($_files as $file){
    $counter = 0;
    if (($handle = fopen($csv_file_save_path.$file, "r")) !== FALSE) {
	while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
	    $counter++;
	}
	fclose($handle);
    }

    $files[] = array(
	'file'=>$file,
	'size'=>human_filesize(filesize($csv_file_save_path.'/'.$file)),
	'date'=> yes_strftime('%d.%m.%Y %T',filectime($csv_file_save_path.'/'.$file)),
	'cols'=>$counter
    );
}

$smarty->assign(array(
    'MAX_FILEUPLOAD_SIZE'=>$max_csv_file_size,
    'FILES'=>$files
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('ebay_import_csv.html');
include('includes/footer.php');
include('includes/application_bottom.php');

