<?php
/* --------------------------------------------------------------
Copyright (c) 2005 Mario Aspeleiter <dazze@gmx.de>
--------------------------------------------------------------*/
function _get_icon($type){
	$part = explode('/',$type);
	if(isset($part[1])){
		switch($part[1]){
			case 'png':
				$part[1] = 'gif';
				break;
		}
		if(is_file('images/icons/icon_'.$part[1].'.gif'))
			return 'images/icons/icon_'.$part[1].'.gif';
	}
	return 'images/icons/file.gif';
}

function get_double_filename($part_name,$diff_names){
	$parts = explode('.',$part_name);
	$new_part_name = '';
	foreach($parts as $k=>$p){
		if($k == sizeOf($parts)-1){
			$new_part_name .= '_'.$diff_names[$part_name].'.'.$p;
		}else{
			$new_part_name .= $p;
			if(sizeOf($parts)>2)
				$new_part_name .= '.';
		}
	}
	return $new_part_name;
}

define('MAIL_LIMIT', 100);
include('includes/application_top.php');
require_once('includes/classes/class.ebaymail.php');
require_once('includes/classes/order.php');
require_once('includes/classes/reclamation.php');
require_once('includes/classes/yes_shipping.php');
require_once('includes/classes/class.basics.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/ebay_email.php');
require_once(DIR_FS_INC.'xtc_php_mail.inc.php');
require_once(DIR_FS_INC.'xtc_parse_input_field_data.inc.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
$smarty = new yesSmarty;
$smarty->assign([
	'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'JS_CONFIRM_REALLY_UNALLOCATION'=>JS_CONFIRM_REALLY_UNALLOCATION,
	'FORM_END'=>'</form>',
	'HIDE_TABLEHEADINGS'=>true,
	'SORT_DATE'=>'Datum',
	'SORT_FROM'=>'Absender',
	'SORT_SUBJECT'=>'Betreff',
	'SORT_EBAYUSER'=>'Ebayuser',
	'TEXT_SYSTEM_ALERTS'=>constant('TEXT_SYSTEM_ALERTS'),
	'REALLY_SPAM_PROCESS'=>constant('REALLY_SPAM_PROCESS'),
]);

$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch($action){
    case 'spam':
		$secure_query = yes_query(sprintf(
			"SELECT customers_id,customers_firstname,customers_lastname FROM %s WHERE customers_email_address=:mail",
			TABLE_CUSTOMERS),
			['mail'=>$_REQUEST['email']??''],
			true
		);
		if(isset($secure_query['customers_id']) and intval($secure_query['customers_id']) > 0){
			die(json_encode([
				'MSG'=>sprintf(MSG_ERROR_SPAM_MAIL_EXISTS_AS_USER,
					$_REQUEST['email'],
					$secure_query['customers_firstname'],
					$secure_query['customers_lastname']
				)
			]));
		}else{
			$id_array = array();
			$ee_items = \YES4Trade\Model\ebay_emails::filter([
				'from_email'=>$_REQUEST['email']
				],['id']
			);
			foreach($ee_items as $ee){
				$id_array[] = intval($ee->id);
			}
			foreach($id_array as $id){
				$email = new DBmail($id,false,true);
				$email->delete();
			}
		}
		die(json_encode([
			'MSG'=>''
		]));
		break;
	case 'unallocation':
		$eId = intval($_REQUEST['eId']??0);
		if($eId < 1){
			die(json_encode([
				'MSG'=>'mail '.$action.': Missing mail id'
			]));
		}
		\YES4Trade\Model\ebay_emails::update_ebay_email([
			'customers_id'=>0,
			'ebay_id'=>'',
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS0,
			'orders_id'=>0,
			'ebay_user'=>'',
			'id'=>$eId
		]);
		die(json_encode([
			'MSG'=>''
		]));
		break;
    case 'save':
    case 'unsave':
		$eId = intval($_REQUEST['eId']??0);
		if($eId < 1){
			die(json_encode([
				'MSG'=>'mail '.$action.': Missing mail id'
			]));
		}
		$saved = ($action=='save')?\YES4Trade\Model\ebay_emails::SAVED1:\YES4Trade\Model\ebay_emails::SAVED0;
		$upd = [
			'saved'=>$saved,
			'id'=>$eId
		];
		if($action == 'save'){
			$upd['allocation_status'] = \YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1;
		}
		\YES4Trade\Model\ebay_emails::update_ebay_email($upd);
		die(json_encode([
			'MSG'=>''
		]));
		break;
	case 'get_textitem_subject':
		if(!isset($_REQUEST['tID']))
			die('Missing Parameter');
		$tID = intval(xtc_db_input($_REQUEST['tID']));
		$textitems_query_raw = sprintf("select ti.subject from %s ti LEFT JOIN ebay_textitems_user tiu ON ti.id=tiu.ebay_textitems_id WHERE tiu.customers_id='%s' and ti.id='%s' and ti.module='mail'",
			TABLE_TEXTITEMS,$_SESSION['customer_id'],$tID
		);
		$textitems_query = xtc_db_query($textitems_query_raw);
		$textitem = xtc_db_fetch_array($textitems_query);
		$text = xtc_db_prepare_input($textitem['subject']);
		$text = str_replace('{STORE}',nl2br(STORE_NAME_ADDRESS),$text);
		if(isset($_REQUEST['cID'])){
			$cID = intVal(xtc_db_input($_REQUEST['cID']));
			$text = str_replace('{NAME}',xtc_get_editor_name($cID),$text);
			$email_query = xtc_db_query(sprintf(
				"SELECT customers_email_address FROM customers WHERE customers_id='%s'",
				$cID
			));
			$email = xtc_db_fetch_array($email_query);
			$text = str_replace('{EMAIL}',$email['customers_email_address'],$text);
		}
		$text = str_replace('{MY_NAME}',xtc_get_editor_name($_SESSION['customer_id']),$text);
		if(!strlen($text)) die('-1');
		echo $text;
		exit;
		break;
	case 'get_textitem_content':
		if(!isset($_REQUEST['tID'])){
			die('Missing Parameter');
		}
		$tID = intval(xtc_db_input($_REQUEST['tID']));
		$textitems_query_raw = sprintf("select ti.text,ti.module,ti.subject from %s ti LEFT JOIN ebay_textitems_user tiu ON ti.id=tiu.ebay_textitems_id WHERE tiu.customers_id='%s' and ti.id='%s' order by class",
			TABLE_TEXTITEMS,$_SESSION['customer_id'],$tID
		);
		$textitems_query = xtc_db_query($textitems_query_raw);
		$textitem = xtc_db_fetch_array($textitems_query);
		$text = nl2br(xtc_db_prepare_input($textitem['text']));
		$text = str_replace('{STORE}',nl2br(STORE_NAME_ADDRESS),$text);
		if(isset($_REQUEST['cID'])){
			$cID = intVal(xtc_db_input($_REQUEST['cID']));
			$email_query = xtc_db_query(sprintf(
				"SELECT customers_email_address FROM customers WHERE customers_id='%s'",
				$cID
			));
			$email = xtc_db_fetch_array($email_query);
			$text = str_replace('{EMAIL}',$email['customers_email_address'],$text);
			$text = str_replace('{NAME}',xtc_get_editor_name($cID),$text);

                        $query = xtc_db_query(sprintf(
                                "SELECT c.customers_status,c.customers_email_address,cb.* FROM customers_basket cb LEFT JOIN customers c USING(customers_id) WHERE customers_id='%d'",
                                $cID
                        ));
                        $num = xtc_db_num_rows($query);
                        $shopping_cart_html = '';
                        while($record = xtc_db_fetch_array($query)){
                            $record['customers_basket_date_added_raw'] = $record['customers_basket_date_added'];
                            $record['customers_basket_date_added'] = substr($record['customers_basket_date_added'],0,4).'-'.
                                substr($record['customers_basket_date_added'],4,2).'-'.
                                substr($record['customers_basket_date_added'],6,2);
                            $record['customers_basket_date_added'] = xtc_date_short($record['customers_basket_date_added']);
                            $properties_valid = true;
                            $properties_array = array();
                            if(strstr($record['products_id'],'{')){
                                $properties_array = yes_get_products_properties_values_from_shopping_cart_id($record['products_id']);
                            }
                            $recpID = xtc_get_prid($record['products_id']);
                            $smarty_properties = array();
                            foreach($properties_array as $ppvID){
                                $pquery = xtc_db_query(sprintf(
                                        "SELECT products_properties_id,title FROM products_properties_values ppv LEFT JOIN products_properties_values_description ppvd USING(products_properties_values_id) WHERE ppv.products_properties_values_id='%s' AND language_id='%s'",
                                        $ppvID,$_SESSION['languages_id']
                                ));
                                $prec = xtc_db_fetch_array($pquery);
                                $ppquery = xtc_db_query(sprintf(
                                        "SELECT title FROM products_properties_description WHERE products_properties_id='%s' AND language_id='%s'",
                                        $prec['products_properties_id'],$_SESSION['languages_id']
                                ));
                                $pprec = xtc_db_fetch_array($ppquery);
                                $smarty_properties[] = sprintf('%s: %s',$pprec['title'],$prec['title']);
                            }
                            $record['properties_valid'] = $properties_valid;
                            $record['products_name'] = xtc_get_products_name($recpID);
                            $name = $record['products_name'];
                            if(sizeOf($smarty_properties)){
                                $name .= sprintf('<br /><i>%s</i>',implode(', ',$smarty_properties));
                            }
                            $shopping_cart_html .= sprintf('%d x %s<br />',$record['customers_basket_quantity'],$name);
                        }
                        if($shopping_cart_html != ''){
                            $text = str_replace('{CART}',$shopping_cart_html,$text);
                        }
		}
		if(isset($_REQUEST['oID'])){
		    $oID = intVal(xtc_db_input($_REQUEST['oID']));
		    $order = new order($oID);
		    $op_array = array();
		    foreach($order->products as $op){
				$op_array[] = sprintf('%sx %s',$op['qty'],xtc_db_prepare_input($op['name']));
		    }
		    $text = str_replace('{ORDER}',$oID,$text);
		    $text = str_replace('{INVOICE}',$order->get_fibunumber(),$text);
		    $text = str_replace('{ORDER_PRODUCTS}',implode('<br />',$op_array),$text);
		    $text = str_replace('{ORDER_SHIPPING_ADDRESS}',  xtc_address_format($order->delivery['format_id'], $order->delivery, true, '', '<br />'),$text);
		    $text = str_replace('{ORDER_SHIPPING_TELEPHONE}',  $order->customer['telephone'],$text);
		    $tracks = array();
		    // get_shipping_tracking_id_array(false) EXCLUDET DIE REKLAMATIONEN TRACKING NUMMERN
		    foreach($order->get_shipping_tracking_id_array(false) as $order_track){
			$tracks[] = sprintf('%s:  %s vom %s',
				(defined('SHIPPING_ACTION_'.strtoupper($order_track['versender']).'_TITLE')) ? constant('SHIPPING_ACTION_'.strtoupper($order_track['versender']).'_TITLE') : $order_track['versender'],
				$order_track['tracking_id'],
				xtc_date_short($order_track['date_finished'])
			);
		    }
		    $text = str_replace('{ORDER_TRACKING_NUMBERS}',  implode('<br />',$tracks),$text);
                    if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
                        $hm_data = $order->get_hitmeister_data( $oID );
                        $text = str_replace('{REAL_ORDER_ID}', $hm_data['hitmeister_id_order'], $text);
                    }
		}
		if(isset($_REQUEST['rID'])){
		    $rID = intVal(xtc_db_input($_REQUEST['rID']));
		    $reclamation = new reclamation($rID);
		    $op_array = array();
		    foreach($reclamation->products as $op){
			$op_array[] = sprintf('%sx %s',$op['qty'],xtc_db_prepare_input($op['name']));
		    }
		    $text = str_replace('{ORDER_PRODUCTS}',implode('<br />',$op_array),$text);
		    $text = str_replace('{ORDER_SHIPPING_ADDRESS}',  xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, true, '', '<br />'),$text);
		    $text = str_replace('{ORDER_SHIPPING_TELEPHONE}',  $reclamation->customer['telephone'],$text);
		    $tracks = array();
		    // get_shipping_tracking_id_array(false) EXCLUDET DIE REKLAMATIONEN TRACKING NUMMERN
		    foreach($reclamation->get_shipping_tracking_id_array(false) as $order_track){
			$tracks[] = sprintf('%s:  %s vom %s',
				$order_track['versender'],
				$order_track['tracking_id'],
				xtc_date_short($order_track['date_finished'])
			);
		    }
		    $text = str_replace('{ORDER_TRACKING_NUMBERS}',  implode('<br />',$tracks),$text);
		    
		}
		$text = str_replace('{MY_NAME}',xtc_get_editor_name($_SESSION['customer_id']),$text);
		echo $text;
		exit;
		break;
}

$showId = (isset($_REQUEST['showId'])) ? $_REQUEST['showId'] : '';
$showEmail = (isset($_REQUEST['showEmail'])) ? xtc_db_input($_REQUEST['showEmail']) : '';

$eId = (isset($_REQUEST['eId'])) ? xtc_db_input($_REQUEST['eId']) : '';
$cId = (isset($_REQUEST['cId'])) ? xtc_db_input($_REQUEST['cId']) : '';
if(isset($_REQUEST['cID']) and $_REQUEST['cID']>0)
	$cId = xtc_db_input($_REQUEST['cID']);

$email = (isset($_REQUEST['email'])) ? xtc_db_input($_REQUEST['email']) : '';
$box = (isset($_GET['box'])) ? xtc_db_input($_REQUEST['box']) : '';

// Beim ersten Aufruf die neuen Parameter speichern
if( ( !isset($_SESSION['OPENER_EMAIL_ADDRESS'])  ) or 
( !isset($_SESSION['OPENER_EMAIL_ID']) && !xtc_not_null($_SESSION['OPENER_EMAIL_ID']) ) or (xtc_not_null($eId) or xtc_not_null($email) ) ) {
	$_SESSION['OPENER_EMAIL_ADDRESS'] = $email;
	$_SESSION['OPENER_EMAIL_ID'] = $eId;
}

// setze die showId auf die uebergebene Email-ID beim ersten Aufruf
if( !xtc_not_null( $showId ) && !is_array($showId) ){
	$showId = $_SESSION['OPENER_EMAIL_ID'];
}

// setze die showEmail auf die uebergebene Emailadresse beim ersten Aufruf
if( !xtc_not_null( $showEmail ) ){
	$showEmail = $_SESSION['OPENER_EMAIL_ADDRESS'];
}

// setze die original eId
if( !xtc_not_null( $eId ) ){
	$eId = $_SESSION['OPENER_EMAIL_ID'];
}
// setze die original email
if( !xtc_not_null( $email ) ){
	$email = $_SESSION['OPENER_EMAIL_ADDRESS'];
}

switch($action){
	// drucken der email
	case 'print':
		$mail = new DBmail($showId);
		$smarty->assign('PIXEL',xtc_image('images/pixel_black.gif','','100%','1'));
		$smarty->assign('FROM_NAME',$mail->getFrom_name(60));
		$smarty->assign('FROM_EMAIL',$mail->getFrom_email(60));
		$smarty->assign('TO_EMAIL',$mail->mailto);
		$smarty->assign('SUBJECT',$mail->getSubject(60));
		$smarty->assign('DATE',$mail->getFormatedDate());
		$smarty->assign('RAWDATE',$mail->getRawDate());
		$smarty->assign('BODY', $mail->getBody( $HTML_MODE ) );
			
		$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/print_email.html');
		echo $main_content;
		exit;
		break;
	case "set_replystatus":
		$mail = new DBmail($showId);
	    	if($mail->id > 0) {
				\YES4Trade\Model\ebay_emails::update_ebay_email([
					'reply_status'=>\YES4Trade\Model\ebay_emails::REPLY_STATUS1,
					'read_status'=>\YES4Trade\Model\ebay_emails::READ_STATUS1,
					'id'=>intval($mail->id)
				]);
    			xtc_redirect( xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action'))));
	    	}
		break;
	case "textitems":
		$ti = new yesTextitems();
		$ti->init();
		echo '<html><head><title></title><link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php"></head><body marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>';
		echo $ti->getItemsSelectable();
		echo "</body></html>";
		exit;
		break;
    case "send":
		if(xtc_db_input($_POST['mailbody']) == ''){
			$alert = urlencode('E-Mail konnte nicht versendet werden, fehlender Inhalt');
			xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action','master_close','eId','showId','alert','opener_refresh')).'alert='.$alert.'&showId='.$showId));
		}
		if(isset($_FILES) and sizeOf($_FILES)){
			$next_id_query = xtc_db_query("SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME =  'ebay_emails'");
			$next_id = xtc_db_fetch_array($next_id_query);
			$att_path = \main::get_importdata_path().'mail_attachments/';
			if(!is_dir($att_path)){
				mkdir($att_path);
			}
			$insert_id = $next_id['AUTO_INCREMENT'];
			$save_path = $att_path.$insert_id;
			$basics = new basics;
			$target_path = "uploads/";
			$diff_names = array();
			// derzeit 5 attachements
			$attachements = array();
			for($i=0;$i<5;$i++){
			    $attachements[] = array(
					'filename'=>'',
					'path'=>'',
					'sha1_name'=>''
			    );
			    if(isset($_FILES['att'.($i+1)]) and $_FILES['att'.($i+1)]['name'] != ''){
				$part = $_FILES['att'.($i+1)];
				$part_name = $part['name'];
				if(isset($diff_names[$part_name])){
					$part_name = get_double_filename($part_name,$diff_names);
				}else{
					$diff_names[$part_name] = 0;
				}
				$diff_names[$part['name']]++;
				$filename_sha1 = yes_get_sha1_from_string($part_name);
				$save_name = $save_path.'/'.$filename_sha1;
				if(!is_dir($save_path)){
					mkdir($save_path);
				}
				// UPLOAD
				if ($att = &xtc_try_upload('att'.($i+1), $save_path)) {
					$attachements[$i] = array(
						'filename'=>$att->filename,
						'path'=>$save_path.'/',
						'sha1_name'=>$filename_sha1
					);
				}
			    }
			}
		}
		$attachements_array = array();
		if(sizeOf($attachements)){
		    foreach($attachements as $att){
			if(!empty($att['path']) and !empty($att['filename'])){
			    $attachements_array[] = $att['path'].$att['filename'];
                        }
		    }
		}
		$email_addresses = $_POST['recipient'];
		if(strstr($email_addresses,',')){
			$email_addresses = split(',',$email_addresses);
		}else{
			$email_addresses = array(0=>$email_addresses);
		}
		$valid_emails = array();
		$invalid_emails = array();
		for($i=0;$i<sizeOf($email_addresses);$i++){
			$mail = trim($email_addresses[$i]);
			// wir filtern den Namen weg, wenn vorhanden
			if(strlen($mail)>0){
				$first_pos = strpos($mail,'<');
				$last_pos = strpos($mail,'>');
				if($first_pos === false and $last_pos === false){
					// ist ok, hat keine klammern
				}else{
					$mail = substr($mail,($first_pos+1),$last_pos-$first_pos-1);
				}
			        if (!xtc_validate_email($mail)) {
					$invalid_emails[] = $email_addresses[$i];
				}else{
					$valid_emails[] = $mail;
				}
			}
		}
		if(sizeOf($invalid_emails) > 0){
			$inv_str = '';
			foreach($invalid_emails as $ek=>$ev){
				$inv_str .= $ev.',';
			}
			$inv_str = substr($inv_str,0,strlen($inv_str)-1);
			$alert = urlencode('E-Mail konnte nicht versendet werden da die E-Mail-Adresse(n) [ '.$inv_str.' ] fehlerhaft war(en).');
			xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action','master_close','eId','showId','alert','opener_refresh')).'alert='.$alert.'&showId='.$showId));
			exit;
		}
		if(!sizeOf($valid_emails)){
			$alert = urlencode('E-Mail konnte nicht versendet werden da die E-Mail Adresse(n) fehlerhaft war(en).');
			xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action','master_close','eId','showId','alert','opener_refresh')).'alert='.$alert.'&showId='.$showId));
		}
		$recipient = $valid_emails[0];
		$bcc = ($valid_emails[1]) ? $valid_emails[1] : '';
		
		if(isset($_SESSION['use_own_mailaddress']) and $_SESSION['use_own_mailaddress'] == 1){
			$query = xtc_db_query(sprintf(
				"SELECT customers_email_address FROM customers WHERE customers_id='%s'",
				$_SESSION['customer_id']
			));
			$record = xtc_db_fetch_array($query);
			$from_email = $record['customers_email_address'];
		}else{
			$from_email = STORE_OWNER_EMAIL_ADDRESS;
		}
		xtc_php_mail($from_email, STORE_OWNER,  $recipient, $recipient, $bcc, $from_email, STORE_OWNER, $attachements_array, '', xtc_db_prepare_input($_POST['subject']), xtc_db_prepare_input($_POST['mailbody']),'');
		
		$ebay_id = ($_POST['ebay_id']!='') ? $_POST['ebay_id'] : $_GET['ebay_id'];
		$customers_id = ($_POST['customers_id']!='') ? $_POST['customers_id'] : $_GET['cID'];
		$reply_id = \YES4Trade\Model\ebay_emails::create_ebay_emails([
			'subject'=>$_POST['subject'],
			'mailto'=>$recipient, 
			'from_name'=>STORE_OWNER,
			'from_email'=>STORE_OWNER_EMAIL_ADDRESS,
			'date'=>date('Y-m-d H:i:s'),
			'ebay_id'=>$ebay_id, 
			'customers_id'=>intval($customers_id),
			'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1,
			'saved'=>\YES4Trade\Model\ebay_emails::SAVED1, 
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
			'reply_status'=>\YES4Trade\Model\ebay_emails::REPLY_STATUS1, 
			'editor'=>intval($_SESSION['customer_id']),
			'format'=>'text/html'
		],$_POST['mailbody']);
		
		foreach($attachements as $att){
			if(empty($att['filename'])){
				continue;
			}
			rename($att['path'].$att['filename'], $att['path'].$att['sha1_name']);
			\YES4Trade\Model\ebay_email_attachments::create_ebay_email_attachments([
				'email_id'=>intval($reply_id),
				'filename'=>$att['filename'],
				'filesize'=>filesize($att['path'].$att['sha1_name']),
				'filetype'=>strtolower(filetype($att['path'].$att['sha1_name']))
			]);
		}
		
		if($showId>0){
			if(isset($_POST['allocation']) and !empty($_POST['allocation'])){
				\YES4Trade\Model\ebay_emails::update_ebay_email([
					'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
					'id'=>intval($showId)
				]);
			}
			if(isset($_POST['save']) and intval($_POST['save']) == 1){
				\YES4Trade\Model\ebay_emails::update_ebay_email([
					'saved'=>\YES4Trade\Model\ebay_emails::SAVED1,
					'id'=>intval($showId)
				]);
			}
			\YES4Trade\Model\ebay_emails::update_ebay_email([
				'reply_status'=>\YES4Trade\Model\ebay_emails::REPLY_STATUS1,
				'reply_id'=>intval($reply_id),
				'id'=>intval($showId)
			]);
			// BOF - staff allocation
			$esa = new email_staff_allocation;
			if($esa->allocation_exists($showId, $_SESSION['customer_id'])){
				$esa->add_history($showId, STAFF_ALLOCATION_MAIL_REPLY);
			}
			// EOF - staff allocation
		}
                
		if($_GET['mode']=='single' || $_POST['save'] == '1' || $_POST['close'] == '1' || $_GET['close'] == '1'){
			xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action','eId','showId')).'opener_refresh=1&master_close=1'));
		}else{
			xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action','master_close','eId','showId')).'opener_refresh=1&showId='.$showId));
		}
   		break;
	case "del":
		$del_close = false;
		if(count($showId)>0){
			foreach($showId as $k=>$delID){
				$email = new DBmail($delID,false,true);
				$email->delete();
			}
       	}
		if($_GET['mode']=='single'){
			// $messageStack->add_session('Email wurde gel&ouml;scht.','success');
			// xtc_redirect( xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('eId','showId','action')).'opener_refresh=1&master_close=1'));
			$del_close = true;
		}else{
			$messageStack->add_session('Email(s) wurden gel&ouml;scht.','success');
			if($_POST['save'] == '1' or $_GET['save'] == '1') {
				xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('eId','showId','action')).'opener_refresh=1&master_close=1') );
			}else{
				xtc_redirect(xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('action')).'opener_refresh=1&showId='.$eId));
			}
		}
    		break;
	case "save":
		if(is_countable($_GET['showId'])){
			$saveId = intval($_GET['showId'][0]);
		}else{
			$saveId = intval($_GET['showId']);
		}
		\YES4Trade\Model\ebay_emails::update_ebay_email([
			'saved'=>\YES4Trade\Model\ebay_emails::SAVED1,
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
			'id'=>intval($saveId)
		]);
		$messageStack->add_session('Die Email wurde gespeichert und als geschlossen markiert.','success');
		xtc_redirect( xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('eId','action')).'opener_refresh=1&master_close=1'));
   		break;
	default:
		if(!isset($_REQUEST['smode']) && $box != 'reply'){
			if($showId > 0){
			    $eId = $showId;
				$ee = \YES4Trade\Model\ebay_emails::get_by_id(intval($eId),[
					'from_email','customers_id','ebay_id','read_status','allocation_status'
				]);
				if($ee === null) {
					printf('<script>parent.window.close();</script>');
					exit;
				}
				$mails_res = $ee->toArray();
				if($mails_res['read_status'] != '1' ){
					\YES4Trade\Model\ebay_emails::update_ebay_email([
						'read_status' => \YES4Trade\Model\ebay_emails::READ_STATUS1,
						'id'=>intval($eId)
					]);
					xtc_redirect(xtc_href_link('ebay_mail_main.php', xtc_get_all_get_params().'opener_refresh=1' ) );
				}
				$mails[] = $eId;
				if($mails_res['customers_id'] > 0){
					$limit = 50;
					$ee_list = \YES4Trade\Model\ebay_emails::get_by_customers_id_excluding_id(intval($mails_res['customers_id']),intval($eId),[
						'id'
					],$limit);
					foreach($ee_list as $ee){
						$mails[] = intval($ee->id);
					}
				}
				if($mails_res['ebay_id'] > 0){
					$ee_list = \YES4Trade\Model\ebay_emails::get_by_ebay_id_excluding_id($mails_res['ebay_id'], intval($eId),[
						'id'
					]);
					foreach($ee_list as $ee){
						$mails[] = intval($ee->id);
					}
				}
				if($mails_res['allocation_status'] == \YES4Trade\Model\ebay_emails::ALLOCATION_STATUS0 and !stristr($mails_res['from_email'],'ebay.de') and !stristr($mails_res['from_email'],'ebay.com')){
					$limit = 50;
					$ee_list = \YES4Trade\Model\ebay_emails::get_by_email_address_excluding_id($mails_res['from_email'], intval($eId),[
						'id'
					], $limit);
					foreach($ee_list as $ee){
						$mails[] = intval($ee->id);
					}
				}
			}else if($email != ''){
				$limit = 50;
				$ee_list = \YES4Trade\Model\ebay_emails::get_by_from_email($email,['id'], $limit);
				foreach($ee_list as $ee){
					$mails[] = intval($ee->id);
				}
				if(intval($mails_res['customers_id']) > 0){
					$ee_list = \YES4Trade\Model\ebay_emails::get_by_customers_id_excluding_id(intval($mails_res['customers_id']),intval($mails_res['id']),
						$limit
					);
					foreach($ee_list as $ee){
						$mails[] = intval($ee->id);
					}
				}
				if(!empty($mails_res['ebay_id'])){
					$ee_list = \YES4Trade\Model\ebay_emails::get_by_ebay_id_excluding_id($mails_res['ebay_id'],intval($mails_res['id']));
					foreach($ee_list as $ee){
						$mails[] = intval($ee->id);
					}
				}
				if($mails_res['from_email'] != '' and $mails_res['allocation_status'] == 0 and !stristr($mails_res['from_email'],'ebay.de') and !stristr($mails_res['from_email'],'ebay.com')){
					$ee_list = \YES4Trade\Model\ebay_emails::get_by_mailto($mails_res['from_email'],['id'],$limit);
					foreach($ee_list as $ee){
						$mails[] = intval($ee->id);
					}
				}
			}
		}else if($box == 'reply'){
		
			if(isset($_GET['eId']) and $_GET['eId'] > 0){
				$ee = \YES4Trade\Model\ebay_emails::get_by_id(intval($_GET['eId']),[
					'customers_id','ebay_id','read_status'
				]);
				if($ee === null){
					throw new Exception('Unknown email id #'.$_GET['eId']);
				}
				if($ee->read_status != \YES4Trade\Model\ebay_emails::READ_STATUS1 ){
					\YES4Trade\Model\ebay_emails::update_ebay_email([
						'read_status' => \YES4Trade\Model\ebay_emails::READ_STATUS1,
						'id'=>intval($_GET['eId'])
					]);
					xtc_redirect(xtc_href_link('ebay_mail_main.php', xtc_get_all_get_params().'opener_refresh=1' ) );
				}
			}
			$ee_list = \YES4Trade\Model\ebay_emails::get_by_from_email_or_customers_id($showEmail,intval($cId),[
				'id'
			],30);
			foreach($ee_list as $ee){
	       			$mails[] = intval($ee->id);
			}
			if(isset($_GET['oID']) and intval($_GET['oID']) > 0){
				$ee_list = \YES4Trade\Model\ebay_emails::get_by_orders_id(intval($_GET['oID']),[
					'id'
				],30);
				foreach($ee_list as $ee){
					if(!is_countable($mails) or !in_array(intval($ee->id),$mails)){
					   $mails[] = intval($ee->id);
					}
				}
			}
			if(isset($mail['customers_id']) and $mail['customers_id'] > 0){
				$ee_list = \YES4Trade\Model\ebay_emails::get_by_customers_id_excluding_id(
					intval($mail['customers_id']),
					intval($mail['id']),
					['id'],
					50,
					['UNIX_TIMESTAMP(date) desc']
				);
				foreach($ee_list as $ee){
				    if(!in_array($ee->id,$mails)){
						$mails[] = intval($ee->id);
					}
			 	}
			}else if(isset($mail['ebay_id']) and $mail['ebay_id'] != ''){
				$ee_list = \YES4Trade\Model\ebay_emails::get_by_ebay_id_excluding_id($mail['ebay_id'],intval($mail['id']),['id'],50,['UNIX_TIMESTAMP(ee.date) DESC']);
				foreach($ee_list as $ee){
				    if(!in_array($ee->id,$mails)){
						$mails[] = intval($ee->id);
					}
			 	}
			}
			if(is_countable($mails) and sizeOf($mails) and $mail['allocation_status'] == \YES4Trade\Model\ebay_emails::ALLOCATION_STATUS0 and !stristr($mail['from_email'],'ebay.de') and !stristr($mail['from_email'],'ebay.com')){
				$ee_list = \YES4Trade\Model\ebay_emails::get_by_mailto($mail['from_email'],['id'],50);
				foreach($ee_list as $ee){
				    if(!in_array($ee->id,$mails)){
						$mails[] = intval($ee->id);
					}
			 	}
			}
		}
		// wir haben mind. eine email gefunden fuer die listenansicht
		$esa = new email_staff_allocation;
		$tr_array = [];
		if(isset($mails) and is_countable($mails) and sizeOf($mails) > 0) {
			// ****************************** listenansicht ***************************************************************
			$smarty->assign('FORM',xtc_draw_form('mails','ebay_mail_main.php',xtc_get_all_get_params(array('eId','action','a','showId')),'post'));
			
			foreach($mails as $k=>$id){
//				$mail = new DBmail($id,false,true);
				if(intval($id) > 0){
					$tr_array[] = smarty_function_mail_list(['id'=>intval($id)], $smarty);
					/*
					if ($showId == $id) {
						$tr = '          <tr class="dataTableRowSelected" onmouseover="this.style.cursor=\'hand\'">' . "\n";
					} else {
						$tr = '          <tr class="dataTableRow" onmouseover="this.className=\'dataTableRowOver\';this.style.cursor=\'hand\'" onmouseout="this.className=\'dataTableRow\'">' . "\n";
					}

					$attachments_array = array();
					$attachments = $mail->get_attachments();
					for($i=0;$i<sizeOf($attachments);$i++){
						$att = $attachments[$i];
						$attachments_array[] = array(
							'id'=>$att->getEbay_email_attachments_id(),
							'filename'=>$att->getFilename(),
							'filetype'=>$att->getFiletype(),
							'filetype_icon'=>_get_icon($att->getFiletype()),
							'filesize'=>$att->getFilesize(),
							'filesize_kb'=>number_format(($att->getFilesize() / 1024),2,',','.')
						);
					}

					$email_data[] = array(
						'TR'=>$tr,
				                'ID'=>$mail->id,
						'NAME'=>'<a href="javascript:viewmail(\''.$id.'\');">'.$mail->getFrom_Name(30).'</a>',
						'EMAIL'=>'<a href="javascript:viewmail(\''.$id.'\');">'.$mail->getFrom_email(30).'</a>',
						'ALLOCATED_USER'=>$mail->customers_id,
						'ALLOCATED_AUCTION'=>$mail->ebay_id,
						'OWNMAIL'=>$mail->ownmail,
						'EDITOR'=>$mail->editor,
						'READ_STATUS'=>$mail->read_status,
						'REPLY_STATUS'=>(($mail->reply_status==1)?xtc_image('images/icon_status_green.gif','Beantwortet'):xtc_image('images/icon_status_red.gif','Nicht beantwortet')),
						'REPLYMAIL_LINK'=> '',
						'SUBJECT'=>'<a href="javascript:viewmail(\''.$id.'\');">'.$mail->getSubject(60).'</a>',
						'DATE'=>$mail->getFormatedDate(),
						'REPLY_LINK'=>'',
						'ALLOCATE_LINK'=>'',
						'DELETE_LINK'=>'<a href="javascript:;" onclick="really_delete_email('.$mail->id.');">'.xtc_image('images/icons/cross.gif',IMAGE_DELETE,16,16).'</a>',
						'REPLYSTATUS_LINK'=>'',
						'INPUT_BOX'=>xtc_draw_hidden_field('box',$box),
						'ATTACHMENTS'=>$attachments_array,
			                        'EMAIL_STAFF_ALLOCATION_TITLE'=>$esa->get_allocation_link_title($mail->id),
					);*/
				}
			}
			$base_get_params = xtc_get_all_get_params(array('action','action2','eId','id')); // ,'scID','sebayID','semail','ssubject','sbody','sboth','startDate'
			// falls keine get parameter vorhanden sind, setze ich einfach
			// einen parameter, damit im Template dynamische parameter mit
			// &var=val hinzugefuegt werden koennen ohne umstaendlich zu pruefen
			if(empty($base_get_params)) {
				$base_get_params = '?menugroup=interfaces';
			}else{
				$base_get_params = '?'.$base_get_params;
			}
			$bl = basename(__FILE__);
			$smarty->assign(array(
				'BASELINK_DELETE'=>xtc_href_link('ebay_email.php',xtc_get_all_get_params(array('action'))),
				'BASELINK'=>xtc_href_link($bl.$base_get_params),
				'JS_CONFIRM_REALLY_DELETE_ITEMS'=>JS_CONFIRM_REALLY_DELETE_ITEMS,
//				'emails'=>$email_data,
				'tr_array'=>$tr_array,
				'SORT_BASE_URL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('order_by')))
			));
			$smarty->assign('EID',''); // soll die "alle markieren"->l�schen auswahl gezeigt werden -> nein
			$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/mail_list.html');
		}else{ // end if mind. 1 email
			if(isset($_REQUEST['eId'])){
				echo "<span class='main'><b>Noch keine E-Mails zum Kunden gespeichert.</b></span>";
			}
		}
 		break;

}
switch($box){
	case "inbox":
		$mail = array();
		$ee_list = \YES4Trade\Model\ebay_emails::filter([
			'read_status' => \YES4Trade\Model\ebay_emails::READ_STATUS0,
			'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL0
			],['id']
		);
		foreach($ee_list as $ee){
			$mail[] = intval($ee->id);
	    }
        $headertext = "Neue Emails";
		break;
	case "ownmail":
		$mail = array();
		$ee_list = \YES4Trade\Model\ebay_emails::filter([
			'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1
			],['id'], MAIL_LIMIT
		);
		foreach($ee_list as $ee){
			$mail[] = intval($ee->id);
	    }
       	$headertext = "Die letzten ".MAIL_LIMIT." eigenen Emails";
		break;
}
yes_draw_pre_header();
?>
<meta charset="<?php echo CHARSET; ?>" />
<meta name="robots" content="noindex" />
<meta name="robots" content="nofollow" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />

<title>MAILMASTER</title>
<script type="text/javascript">
<!-- 
<?php
if( (isset($_GET['opener_refresh']) and $_GET['opener_refresh']!='') or isset($del_close)){
?>
	parent.opener.window.location.reload();
	<?php if(isset($del_close)) { ?>
	parent.window.close();
	<?php }else{ ?>
		<?php
		if($_GET['master_close']=='1'){
		?>
	parent.window.close();
		<?php
		}else{
		?>
	window.location.href="<?php echo xtc_href_link('ebay_mail_main.php',xtc_get_all_get_params(array('opener_refresh')));?>";
	<?php 
		}
	} 
	?>
<?php
}
?>
var alerted = false;	
<?php
if(isset($_GET['alert']) and $_GET['alert'] != ''){
	echo "if(!alerted){";
	echo "alert('".$_GET['alert']."');alerted=true;\r\n";
	echo "}\r\n";
	$_GET['alert'] = '';
}
if(isset($_GET['master_close']) and $_GET['master_close']=='1'){
?>
	parent.window.close();
//-->
</script>
<?php
exit;
}
?>
var TEXT_SYSTEM_ALERTS = '<?php echo constant('TEXT_SYSTEM_ALERTS'); ?>';
function mailupdate(action,val){
	var add_params = (action == 'spam') ? '&email='+val : '&eId='+val;
	var actionurl = 'ebay_mail_main.php?action='+action+add_params;
	$.ajax({
		url: actionurl,
		dataType: 'json',
		success: function(response){
            hidePreloader();
			if(response.MSG != ''){
				alert(response.MSG);
				return false;
			}			
			window.location.reload(true);
		},
		error: function(xhr) {
			alert('Cant '+action+' mail #'+showId);
		}
	});
}
function viewmail(showId) {
	parent.frames['replyframe'].location.href="<?php echo xtc_href_link('ebay_mail_reply.php',xtc_get_all_get_params( array('action','eId','showId') ) ); ?>&showId="+showId;
	tlink = '<?php echo xtc_href_link('ebay_mail_main.php', xtc_get_all_get_params(array('eId','showId'))); ?>&showId='+showId;
	document.location.href=tlink;
}
function unsavemail(showId) {
	mailupdate('unsave',showId);
}
function savemail(showId) {
	mailupdate('save',showId);
}
function unallocatemail(showId) {
	mailupdate('unallocation',showId);
}
function allocatemail(showId){
	// dummy funktion, wird im mailmaster popup nicht angeboten

}
function spammail(email){
	mailupdate('spam',email);
}
//-->
</script>

<link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php?file=css/yes_style.html5.css" />
<link type="text/css" href="<?php echo yes_get_cdn_link('jquery-ui-css','1.10.3','start');?>" rel="stylesheet" />
<script type="text/javascript" src="<?php echo yes_get_cdn_link('jquery','1.9.1'); ?>"></script>
<script type="text/javascript" src="<?php echo yes_get_cdn_link('jquery-ui','1.10.3'); ?>"></script>
<script type="text/javascript" src="minify_js.php?file=js/yes.js"></script>
<script type="text/javascript" src="minify_js.php?file=js/app.js"></script>
<script type="text/javascript" src="minify_js.php?file=js/jquery-cluetip-master/jquery.cluetip.min.js"></script>
<link rel="stylesheet" href="includes/stylesheet.css.php?file=js/jquery-cluetip-master/jquery.cluetip.css" type="text/css" />
<script type="text/javascript" src="minify_js.php?file=js/header.html5.js"></script>

</head>

<body marginwidth="0" marginheight="0" topmargin=0 leftmargin=0>

<table border="0" cellpadding="1" cellspacing="0" width="100%">
<tr>
	<td class="main">
		<?php echo (isset($main_content))?$main_content:'<p align="center"><i>'.TEXT_NO_EMAILS_TO_DISPLAY.'</i></p>'; ?>
	</td>
</tr>
</table>
</body>
