<?php
//@todo globale konstante bereitstellen die auch in cron_ebay_orders greift
$cronjob_days = 3; 

$seller = $_GET['seller']??constant('EBAY_USER');
if(empty($seller)){
    die('No registered eBay seller available');
}
function simpleParseObj($obj, $string){
    foreach(array_keys((array)$obj) as $k){
        if(gettype($obj->$k)=='string'){
            $val = $obj->$k;
            if(strpos($k,'Time') !== false){
                $val = yes_date_short($val,true);
            }
            $string .= sprintf('<div class="simple_obj"><div>%s</div><div>%s</div></div>',
                $k, $val
            );
        }else{
            simpleParseObj($obj->$k, $string);
        }
    }
    return $string;
}
$site_id = $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE'));
if(ebayApi::oauth2_refreshtoken_exists($seller)){
    if(!ebayApi::oauth2_usertoken_exists($seller) or ebayApi::get_oauth2_usertoken_lifetime($seller) < 1){
        try{
            ebayApi::refresh_oauth2_usertoken($seller);
        }catch(Exception $e){
            $api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
            die($api_error);
        }
    }
}else{
    echo $seller." has no refresh token saved\n\n";
    exit;
}
$ebaycaller = new \YES4Trade\Model\ebaycalls();
$ebay_order = $_GET['ebay_order']??'';
if(!empty($ebay_order)){
    $res = $ebaycaller->tradingQuery(
        $seller, 
        'GetOrders',
        $site_id,
        [
            'OrderIDArray'=>['OrderID'=>$ebay_order],
        ]
    );

    $order_array = $res->OrderArray->Order ?? [];
    if(!is_array($order_array)){
        $order_array = [$order_array];
    }

    if(intval($res->ReturnedOrderCountActual)<1){
        echo '<b>No Order found</b>';
        if($res->Errors->LongMessage !== null and !empty($res->Errors->LongMessage)){
            echo '<div>'.$res->Errors->LongMessage.'</div>';
        }
        exit;
    }
    $order = current($order_array);
    $table = new tableBlock();
    $table->table_parameters = 'class="yesListTable_minimal ebay_orders_detail_table"';
    $contents = [];
    foreach($order as $k=>$v){
        $text = gettype($v)=='string'?$v:simpleParseObj($v,'');
        $contents[] = [
            ['text'=>$k,'th'=>true],
            ['text'=>$text],
        ];
    }
    printf('<div class="main">%s</div>',$table->tableBlock_draw($contents));
    exit;
}
$ebay_order_import = $_GET['ebay_order_import']??'';
if(!empty($ebay_order_import)){
    if(isset($_GET['confirmed']) and intval($_GET['confirmed']) == 1){
        try{
            \YES4Trade\Model\ebay_order_add_import::add($ebay_order_import, $seller);
            $messageStack->add_session(MSG_SUCCESS_ADD_TO_ABONDED_EBAY_ORDER_IMPORT,'success');
        }catch( Exception $e){
            $messageStack->add_session(sprintf(MSG_ERROR_ADD_TO_ABONDED_EBAY_ORDER_IMPORT,$e->getMessage()),'error');
        }
        xtc_redirect(xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(['confirmed','ebay_order_import'])));
    }
    $exists = yes_query("SELECT ebay_orders_id FROM ebay_orders WHERE OrderID=:id",[
        'id'=>$ebay_order_import
    ],true);
    if($exists !== false){
        die('Error: eBay Order is imported.');
    }
    $res = $ebaycaller->tradingQuery(
        $seller, 
        'GetOrders',
        $site_id,
        [
            'OrderIDArray'=>['OrderID'=>$ebay_order_import],
        ]
    );

    $order_array = $res->OrderArray->Order ?? [];
    if(!is_array($order_array)){
        $order_array = [$order_array];
    }

    $order = current($order_array);
    $created = new \DateTime($order->CreatedTime);
    $now = new \DateTime();
    $interval = $now->diff($created);
    printf('<div>%s</div>',
        sprintf(ADD_TO_ABONDED_EBAY_ORDER_IMPORT_CREATION_INFO,
            $created->format('d.m.y H:i:s'),
            $interval->days
        )
    );
    // Prüfen, ob das Datum mehr als 3 Tage in der Vergangenheit liegt
    if ($created < $now && $interval->days > 3) {
        printf('<div><a href="%s"><button type="button" class="ui-button ui-corner-all ui-state-default">Import</button></a></div>',
            xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(['confirmed']).'confirmed=1'),
        );

    } else {
        printf('<div style="max-width: 450px; margin-top: 5px; color: #666;font-size: 0.8em;">%s</div>',
            sprintf(ADD_TO_ABONDED_EBAY_ORDER_IMPORT_CREATION_DENIED,
                $interval->days, $cronjob_days
            )
        );
    }
    exit;
}





$page_number = intval($_GET['page_number']??1);
$days = intval($_GET['days']??3);
$days_options = [];
for($i=1;$i<=30;$i++){
    $days_options[] = [
        'id'=>$i,
        'text'=>$i
    ];
}
$res = $ebaycaller->tradingQuery(
    $seller, 
    'GetOrders',
    $site_id,
    [
        'Pagination'=>[
            'EntriesPerPage'=>200,
            'PageNumber'=>$page_number
        ],
        'NumberOfDays'=>$days
    ]
);
$order_array = $res->OrderArray->Order ?? [];
if(!is_array($order_array)){
    $order_array = [$order_array];
}
$contents = [];
$base_keys = [
    'OrderID','OrderStatus','CheckoutStatus','CreatedTime','ShippingAddress','BuyerUserID'
];
foreach($base_keys as $k){
    $contents[0][] = ['text'=>$k,'th'=>true];
}


foreach($order_array as $Order){
    $trans_array = $Order->TransactionArray->Transaction ?? [];
    if(!is_array($trans_array)){
        $trans_array = [$trans_array];
    }
    $td = [];
    foreach($base_keys as $key){
        switch(gettype($Order->$key)){
            case 'string':
                $text = $Order->$key;
                if(strpos($key,'Time') !== false){
                    $text = yes_date_short($text,true);
                }
                if($key == 'OrderID'){
                    $OrderID = $text;
                    $exists_query = yes_query(
                        "SELECT ebay_orders_id,orders_id FROM ebay_orders WHERE OrderID=:id",
                        ['id'=>$OrderID],
                        true
                    );
                    $text = sprintf(
                        '<a class="ebay_order_link" href="javascript:;">%s</a>',
                        $OrderID,
                    );
                    if($exists_query !== false){
                        $text .= '<div style="margin-top: 4px; font-weight: bold;">Importiert</div>';
                        if(intval($exists_query['orders_id']) > 0){
                            $text .= sprintf('<div style="margin-top: 4px;"><a href="%s">%s %s</a></div>',
                                xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$exists_query['orders_id']),
                                TEXT_ORDER, $exists_query['orders_id']
                            );
                        }
                    }else{
                        $eooosID = \YES4Trade\Model\ebay_orders_oos::get_ebay_orders_oos_id_from_OrderID($OrderID,$seller);
                        if($eooosID > 0){
                            $text .= '<div style="margin-top: 5px; padding: 4px;background-color: red; color: white;">Out Of Stock</div>';
                        }else{
                            $in_import = \YES4Trade\Model\ebay_order_add_import::isSaved($OrderID, $seller);
                            if($in_import){
                                $text .= sprintf('<div style="margin-top: 5px;color: #666;">%s</div>',
                                    ADD_TO_ABONDED_EBAY_ORDER_IMPORT_SAVED_ERROR
                                );
                            }else{
                                $text .= '<div style="margin-top: 5px;"><a data-ebayorderid="'.$OrderID.'" class="force_import" href="javascript:;"><button type="button" class="ui-button ui-corner-all ui-state-default">IMPORT</button></a></div>';
                            }
                        }
                    }
                }
                $td[] = ['text'=>$text];
                break;
            default:
                $string = '';
                $html = simpleParseObj($Order->$key, $string);
                $td[] = ['text'=>$html];
                break;
        }
    }
    $contents[] = $td;
}

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal ebay_orders_table"';
$buttons = [];
$buttons[] = array('text'=>IMAGE_BACK,
    'link'=>xtc_href_link(FILENAME_EBAYAPI_CART),
    'lbOn'=>false,
    'auth'=>true
);
$input_pages_options = [];
for($i=0;$i<intval($res->PaginationResult->TotalNumberOfPages);$i++){
    $input_pages_options[] = [
        'id'=>$i+1,
        'text'=>$i+1
    ];
}
if(intval($res->PaginationResult->TotalNumberOfPages) > 0){
    $input_pages = xtc_draw_pull_down_menu('page_number',$input_pages_options, $page_number,'onchange="paging()"');
}else{
    $input_pages = 0;
}
$smarty->assign([
    'HEADING_TITLE'=>'eBay Orders',
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TABLE'=>$table->tableBlock_draw($contents),
    'FORM'=>xtc_draw_form('ebay_orders','ebayapi_cart.php','','GET')
        .xtc_draw_hidden_field('action',$_GET['action']),
    'INPUT_SELLER'=>xtc_draw_pull_down_menu('seller',xtc_get_ebay_users(),$seller),
    'INPUT_DAYS'=>xtc_draw_pull_down_menu('days',$days_options,$days),
    'TEXT_DAYS'=>TEXT_DAYS,
    'SELLER'=>$seller,
    'PAGING'=>sprintf('Page: %s / Total Orders: %d',
        $input_pages,
        $res->PaginationResult->TotalNumberOfEntries,
    )
]);
yes_draw_pre_header();
yes_draw_header('eBay Orders');
$smarty->display('ebay_orders.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
