<?php
include('includes/cron_application_top.php');
include('includes/classes/class.ebay.php');
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_ServiceProxy.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_Logger.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetUserDisputesRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetDisputeRequestType.php';
$EBAYAPI = new ebayAPI;
$smarty = new Smarty;
$smarty->caching = false;
$smarty->template_dir='templates';
$smarty->compile_dir=DIR_FS_CATALOG.'templates_c';
$smarty->config_dir=DIR_FS_CATALOG.'lang';
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$ebay_user = ($_GET['ebay_user']) ? $_GET['ebay_user'] : EBAY_USER;

$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
$session->setRequestToken( $EBAYAPI->getToken($ebay_user) );
$cs = new EbatNs_ServiceProxy($session);

if(isset($_REQUEST['DisputeID'])){
	$req = new GetDisputeRequestType();
	$req->setDisputeID($_REQUEST['DisputeID']);
	$res = $cs->GetDispute($req);
	$Dispute = $res->getDispute();
    $item = array(
		'ItemID'=>$Dispute->Item->getItemID()
	);

	$dispute = array(
			'Item'=>$item,
            'DisputeID'=>$Dispute->getDisputeID(),
            'DisputeRecordType'=>$Dispute->getDisputeRecordType(),
            'DisputeState'=>$Dispute->getDisputeState(),
            'DisputeStatus'=>$Dispute->getDisputeStatus(),
            'BuyerUserID'=>$Dispute->getBuyerUserID(),
            'SellerUserID'=>$Dispute->getSellerUserID(),
            'TransactionID'=>$Dispute->getTransactionID(),
            'DisputeReason'=>$Dispute->getDisputeReason(),
            'DisputeExplanation'=>$Dispute->getDisputeExplanation(),
            'DisputeCreditEligibility'=>$Dispute->getDisputeCreditEligibility(),
            'DisputeCreatedTime'=>$Dispute->getDisputeCreatedTime(),
            'DisputeModifiedTime'=>$Dispute->getDisputeModifiedTime()
	);
	$smarty->assign('Dispute',$dispute);
	$smarty->display('dispute.html');
	exit;
}


$req = new GetUserDisputesRequestType();
$pageNumber = (isset($_REQUEST['page'])) ? $_REQUEST['page'] : 0;

if(isset($_REQUEST['DisputeFilterType'])){
	$req->setDisputeFilterType($_REQUEST['DisputeFilterType']);
}

$pag = new PaginationType();
$pag->setEntriesPerPage(200);
//$pag->setEntriesPerPage(2);
$pag->setPageNumber($pageNumber);
$req->setPagination($pag);

$days = 30; // how many days
$span = 30; // how many days timespan

$ebay_users = xtc_get_ebay_users();
$ebay_now = $EBAYAPI->get_ebay_official_time();

$from = yes_strftime('%Y-%m-%d',strtotime(date('Y-m-d'))-(60*60*24*$days));
// wir ziehen 20 Minuten ab um nicht gleichzeitig mit SOAP ANfragen ins Gehege zu kommen
$now = (strtotime( $ebay_now ) - (60*20) );
$to = yes_strftime('%Y-%m-%d %H:%M', $now - (60*60*24*($days-$span)));

$req->setModTimeFrom($from);
$req->setModTimeTo($to);

$res = $cs->GetUserDisputes($req);

$DisputeFilterCount = $res->getDisputeFilterCount();

foreach($DisputeFilterCount as $DisputeFilterCountType){
	printf('%s: <a href="?DisputeFilterType=%s">%s</a><br />',
			$DisputeFilterCountType->getDisputeFilterType(),
			$DisputeFilterCountType->getDisputeFilterType(),
			(int)$DisputeFilterCountType->getTotalAvailable());
}

if($res->StartingDisputeID){
	printf('<p>Disput %s bis %s</p>',$res->getStartingDisputeID(),$res->getEndingDisputeID());
	$disputes = array();
	foreach($res->getDisputeArray() as $Dispute){
		$Item = $Dispute->getItem();
		$item_array = array(
			'ItemID' => $Item->getItemID(),
			'ConditionID' => $Item->getConditionID(),
            'ConditionDisplayName'=>$Item->getConditionDisplayName()
		);
		$disputes[] = array(
			'Item'=>$item_array,
			'DisputeID'=>$Dispute->getDisputeID(),
			'DisputeRecordType'=>$Dispute->getDisputeRecordType(),
			'DisputeState'=>$Dispute->getDisputeState(),
            'DisputeStatus'=>$Dispute->getDisputeStatus(),
            'OtherPartyRole'=>$Dispute->getOtherPartyRole(),
            'OtherPartyName'=>$Dispute->getOtherPartyName(),
            'UserRole'=>$Dispute->getUserRole(),
            'TransactionID'=>$Dispute->getTransactionID(),
            'DisputeReason'=>$Dispute->getDisputeReason(),
            'DisputeExplanation'=>$Dispute->getDisputeExplanation(),
            'DisputeCreditEligibility'=>$Dispute->getDisputeCreditEligibility(),
            'DisputeCreatedTime'=>$Dispute->getDisputeCreatedTime(),
            'DisputeModifiedTime'=>$Dispute->getDisputeModifiedTime()
		);
	}
	$smarty->assign('disputes',$disputes);
	$smarty->display('disputes_array.html');
}

yes_debug($res);