<?php
include('includes/application_top.php');
include('includes/classes/class.ebay.php');
include('includes/classes/class.textitems.php');
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');

$EBAYAPI = new ebayAPI;
define('FILENAME_EBAY_FEEDBACK','ebayapi_feedback.php');

$CommentType = (isset($_REQUEST['CommentType'])) ? $_REQUEST['CommentType'] : '';

// forget about any script timeouts
set_time_limit(0);
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

$ebay_user = $_GET['ebay_user'] ?? constant('EBAY_USER');
if(ebayApi::oauth2_refreshtoken_exists($ebay_user)){
        if(!ebayApi::oauth2_usertoken_exists($ebay_user) or ebayApi::get_oauth2_usertoken_lifetime($ebay_user) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($ebay_user);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$ebay_user.'  '.$e->getMessage();
            }
        }
}
switch($action) {
	case "del":
		if($_GET['id'] and is_array($_GET['id']) and sizeOf($_GET['id'])>0){
			foreach($_GET['id'] as $k=>$id){
				xtc_db_query("UPDATE ".TABLE_EBAY_FEEDBACK." SET status=1 WHERE id='".xtc_db_input($id)."'");
			}
			$messageStack->add_session('Ausgew&auml;hlte Bewertungen wurden aus Listing entfernt.','success');
		}else{
			$messageStack->add_session('Es wurde keine Bewertung &uuml;bergeben.','error');
		}
		xtc_redirect(xtc_href_link('ebayapi_feedback.php',xtc_get_all_get_params(array('action','id'))));
		break;
	case "send_feedback":
		if(is_array($_POST['feedback_id'])){
			$counter = 0;
			foreach($_POST['feedback_id'] as $k => $fID) {
				$fID = (int)xtc_db_input($fID);
				$query = xtc_db_query("SELECT ef.ItemNumber,ef.TransactionId, ef.CommentingUser FROM ebay_feedback ef WHERE ef.id='".$fID."'");
				if( xtc_db_num_rows($query) > 0 ){
					$res = xtc_db_fetch_array($query);
					$res_data = $res;
					$req = new \stdClass();
					$req->ItemID = $res['ItemNumber'];
					$req->TargetUser = $res['CommentingUser'];
					$req->TransactionID = ((xtc_not_null($res['TransactionId']))?$res['TransactionId']:'0');
						
					$TI = new yesTextItems;
					$TI->init('feedback');
					$TI->getItem($_POST['textitem']);
					
					$type = strtoupper($TI->value[0]).substr($TI->value,1,strlen($TI->value));
                    $req->CommentType = $type;
					$req->CommentText = $TI->text;
				
					$ebaycalls = new \YES4Trade\Model\ebaycalls();
					$res = $ebaycalls->tradingQuery($ebay_user, 
						'LeaveFeedback',
						$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
						(array)$req
					);
			
					if ($EBAYAPI->isGood($res)) {
						$counter++;
					} else {
						$messageStack->add_session(implode('<br />',$EBAYAPI->getResponseErrors($res)),'error');
					}
					xtc_db_query("UPDATE ".TABLE_EBAY_FEEDBACK." SET status=1 WHERE id='".$fID."'");

					// AUS DER FEEDBACK-REMINDER TABLE RAUSNEHMEN
					xtc_db_query(sprintf("DELETE FROM feedback_reminder WHERE ebay_user_id='%s' and ebay_id='%s'",xtc_db_input( $res_data['CommentingUser'] ), xtc_db_input( $res_data['ItemNumber'] )));
				}else{
					xtc_db_query("UPDATE ".TABLE_EBAY_FEEDBACK." SET status=1 WHERE id='".$fID."'");
					$messageStack->add_session('Keine YES Auktion - gilt als Bewertet! (Auf ebay.de direkt bewerten!)','error');
				}
			}
			if($counter > 0)
				$messageStack->add_session($counter.' Bewertungen wurden abgegeben.','success');
			
			xtc_redirect(xtc_href_link('ebayapi_feedback.php',xtc_get_all_get_params(array('action')) ));
		}
		break;
}
if(!isset($CommentType) or $CommentType == '') $CommentType = 'Positive';
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript">
<!--
function delete_feedback(id){
	ok=confirm('Diese Bewertung aus dem Listing l�schen?');
	if(ok)
		window.location.href='<?php echo xtc_href_Link('ebayapi_feedback.php',xtc_get_all_get_params(array('id','action')).'action=del'); ?>&id[]='+id;
}
//-->
</script>
<?php
$smarty = new yesSmarty;
$smarty->assign(array(
    'HEADING_TITLE'=>'Bewertungssystem',
    'PAGE_HEADING_MENU_BUTTONS'=>[],
    'right_content'=>'',
));
echo $smarty->fetch('ebayapi_feedback.html');
?>
<!-- header_eof //-->

<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr>
	<td colspan="2">
	<br />
	<?php
	$TI = new yesTextItems();
	$TI->init('feedback');
	$pos_feedbacks = 0;
	if(sizeOf($TI->data) > 0){
		foreach($TI->data as $k=>$t){
			if($t['value'] == 'positive')
				$pos_feedbacks++;
		}
	}
	if($pos_feedbacks < 6){
?>
		<p class="helpTable">Sie haben derzeit <?php echo $pos_feedbacks; ?> positive Bewertungstexte in Ihren Textbausteinen hinterlegt. Um automatisches Bewerten aktivieren zu k&ouml;nnen, brauchen Sie mindestens 6 verschiedene positive Bewertungstexte.<br /><a href="<?php echo xtc_href_link('ebayapi_textitems.php','menugroup=tools'); ?>" title="Neue Textbausteine anlegen"><u>Klicken Sie hier</u></a> um weitere Bewertungstexte (Modul: Bewertungen, Bewertung: positiv) einzupflegen.</p>
<?php
	}else{
?>
		<p class="helpTable">Sie haben derzeit <?php echo $pos_feedbacks; ?> positive Bewertungstexte in Ihren Textbausteinen hinterlegt. Ihr automatisches Bewertungssystem ist <?php echo (EBAY_AUTOMATIC_FEEDBACK == 'true') ? 'aktiv' : 'deaktiv'; ?>. <a href="<?php echo xtc_href_link('configuration.php','gID=101&menugroup=admin'); ?>" title="Automatisches Bewertungssystem bearbeiten"><u>Klicken Sie hier</u></a> um die Einstellung zu bearbeiten.</p>
<?php
	}
	?>
	<br />
	</td>
</tr>
<tr>
	<td>
		<table border="0" cellpadding="0" cellspacing="0">
		<?php echo xtc_draw_form('ebayuserselect','ebayapi_feedback.php','','get'); ?>
		<tr>
			<td class="main">Ebay User</td>
			<td class="main"><?php echo xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),$ebay_user); ?></td>
			<td class="main"><input border="0" type="image" src="images/icon_save.gif" alt="Ebay User" title="Ebay User"></td>
		</tr>
		</form>
		</table>
	</td><td align="right">
		<form name="typechoose" method="get" action="<?php echo xtc_href_link('ebayapi_feedback.php');?>">
		<input type="hidden" name="ebay_user" value="<?php echo (isset($_GET['ebay_user'])) ? $_GET['ebay_user'] : ''; ?>">
		<table border="0" cellpadding="0" cellspacing="0">
		<tr>
			<td> 
				<select name='CommentType'>
				<option><?php echo TEXT_SELECT; ?></option>
				<option value='Positive'<?php if($CommentType == 'Positive') { echo " selected"; } ?>>Positive Bewertungen</option>
				<option value='Negative'<?php if($CommentType == 'Negative') { echo " selected"; } ?>>Negative Bewertungen</option>
				<option value='Neutral'<?php if($CommentType == 'Neutral') { echo " selected"; } ?>>Neutrale Bewertungen</option>
				<option value='Withdrawn'<?php if($CommentType == 'Withdrawn') { echo " selected"; } ?>>Zurückgezogene Bewertungen</option>
				</select>
			</td><td>
				 <input type="submit" value="Bewertungsstatus auswählen">
			</td>
		</tr>
		</table>
		</form>
	</td>
</tr>
</table>

<table border="0" width="100%" cellspacing="0" cellpadding="2">
<tr>
    <td>
	<br />
	   <table border="0" cellspacing="0">
<?php
$view_limit = ( !isset($_GET['limit']) or $_GET['limit'] < 1 ) ? MAX_DISPLAY_SEARCH_RESULTS : $_GET['limit'];
$view_start = ( !isset($_GET['start']) or $_GET['start'] < 1 ) ? '0'  : $_GET['start'];
$view_end = $view_start + $view_limit;
$order_by = (isset($_GET['order_by']) and $_GET['order_by']!='') ? xtc_db_prepare_input($_GET['order_by']) : 'TimeOfComment DESC';

$search = (isset($_GET['searchword'])) ? xtc_db_prepare_input($_GET['searchword']) : '';
$where = "CommentType='".$CommentType."' ";
if($search != ''){
	$where = " ( CommentText LIKE '%".$search."%' ) && CommentType='".$CommentType."' ";
}

$q = "SELECT * from ebay_feedback where status=0 and ebay_user='".$ebay_user."'";
if($where != '') {
	$q .= ' && ' . $where;
}
if( $order_by !='' ) {
	$q .= " order by ";
	$q .= $order_by;
}

$feedback_split = new splitPageResults( $_GET['page'], 	MAX_DISPLAY_SEARCH_RESULTS, $q, $feedback_query_numrows);
$feedback_query = xtc_db_query($q);
$viewcount = (int)$_GET['page'];
$text = "<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>Bewertungstext</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown1'></td></tr></table><map name='updown1'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=CommentText%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=CommentText%20ASC')."'></map>";
$user = "<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>User</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown2'></td></tr></table><map name='updown2'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=CommentingUser%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=CommentingUser%20ASC')."'></map>";
$userscore = "<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>User-Score</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown3'></td></tr></table><map name='updown3'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=CommentingUserScore%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=CommentingUserScore%20ASC')."'></map>";
$zeit = "<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>Zeitpunkt</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown5'></td></tr></table><map name='updown5'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=TimeOfComment%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('ebayapi_feedback.php','CommentType='.$CommentType.'&start='.($viewcount*$view_limit).'&limit='.$view_limit.'&searchword='.$search.'&order_by=TimeOfComment%20ASC')."'></map>";

echo xtc_draw_form('feedback',FILENAME_EBAY_FEEDBACK,'action=send_feedback&ebay_user='.$ebay_user,'post');
?>
<tr class="dataTableHeadingRow">
	<td class='dataTableHeadingContent'>&nbsp;</td>
	<td class='dataTableHeadingContent' width="350"><b><?php echo $text; ?></b></td>
	<td class='dataTableHeadingContent'><b><?php echo $user; ?></b></td>
	<td class='dataTableHeadingContent'><b><?php echo $userscore; ?></b></td>
	<td class='dataTableHeadingContent' width='100' align='center'><b>Auktion</b></td>
	<td class='dataTableHeadingContent'><b><?php echo $zeit; ?></b></td>
	<td class='dataTableHeadingContent'><b>Bewertung</b></td>
	<td class='dataTableHeadingContent'>&nbsp;</td>
</tr>

<?php
if($feedback_query_numrows>0){
	$color = 0;
	while($res = xtc_db_fetch_array($feedback_query) ) {
		$class = (is_int($color/2)) ? 'dataTableRow' : 'dataTableRowSelected';
		echo "	<tr class='".$class."'>\n";
		echo "		<td class='dataTableContent'>";
		if($res['status'] == '0'){
			echo xtc_draw_checkbox_field('feedback_id[]',$res['id']);
		}else{
			echo '&nbsp;';
		}
		echo "</td>";
		echo "		<td class='dataTableContent'>".$res['CommentText']."</td>";
		echo "		<td class='dataTableContent'>".$res['CommentingUser']."</td>";
		echo "		<td class='dataTableContent' align='center'>".$res['CommentingUserScore']."</td>";
		echo "		<td class='dataTableContent' align='center'><a target=top href='".xtc_get_ebay_link(xtc_get_auction_site($res['ItemNumber'])).$res['ItemNumber']."'><u>".$res['ItemNumber']."</u></a></td>";
		echo "		<td class='dataTableContent'>".yes_strftime('%d.%m.%Y - %H:%M:%S',strtotime($res['TimeOfComment']))."</td>";
        	echo "	        <td class='dataTableContent' align='center'>".$EBAYAPI->get_german_feedbackcomment_type($res['CommentType'])."</td>";
		echo "          <td class='dataTableContent' align='right'><a href='#' onClick='delete_feedback(\"".$res['id']."\");'>".xtc_image('images/icons/cross.gif','Aus dem Listing l�schen')."</a></td>";
		echo "	</tr>\n";
		$color++;
	}
?>
<tr bgcolor="lightblue">
	<td colspan="8" align="right">
		<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tr><td>
			<a href="#" onClick="selectall('feedback','feedback_id[]','true');">Alle markieren</a><br>
			<a href="#" onClick="selectall('feedback','feedback_id[]',false);">Alle demarkieren</a>
		</td><td align="right">
			<select name='textitem'>
			<option><?php echo TEXT_SELECT; ?></option>
			<?php
			$TI = new yesTextItems();
			$TI->init('feedback');
			foreach($TI->data as $t) {
			?>
			<option value='<?php echo $t['id'];?>'><?php echo $t['class']; ?> - (<?php echo $t['value']; ?>) <?php echo substr($t['text'],0,40); ?></option>
			<?php
			}
			?>
			</select>
			<input type="submit" value="Bewerten">
		</td></tr>
		</table>
	</td>
</tr>
<?php
}else{
?>
			<tr class='dataTableRow'>
				<td class='dataTableContent' colspan='8'>Es sind zur Zeit keine Bewertungen mit diesem Status vorhanden.</td>
			</tr>
<?php
}
?>
			</form>
			<tr bgcolor="lightblue">
				<td colspan="8" class="main" align="center">
				<?php
echo "<table border='0' bgcolor='#CADACC'><tr bgcolor='#FFFFFF'><td class=main align=center><font size=1>";
echo $feedback_split->display_count($feedback_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ORDERS);
echo "</font></td></tr><tr><td class=main align=center><font size=1>";
echo $feedback_split->display_links($feedback_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page')));
echo "</font></td></tr></table>";
?>
			</form>
				</td>
			</tr>
			</table>
    </td>
</tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

