<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

include('includes/application_top.php');
include('includes/classes/class.ebay.php');
$error_reporting = yes_getErrorReporting();
error_reporting(E_ERROR);
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_ServiceProxy.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_Logger.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetAllBiddersRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetSellerEventsRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/AddSecondChanceItemRequestType.php';
error_reporting($error_reporting);
require(DIR_FS_INC.'xtc_get_tax_class_id.inc.php');
require(DIR_FS_INC.'xtc_get_product_path.inc.php');
require(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');

$EBAYAPI = new ebayAPI;

$smarty = new Smarty;
$smarty->caching = false;
$smarty->compile_dir=DIR_FS_CATALOG.'templates_c';
$smarty->template_dir=DIR_FS_ADMIN.'templates';
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->plugins_dir[] = DIR_FS_CATALOG.'includes/smarty_plugins/';
$smarty->assign('FORM_END','</form>');

$cstatus_query = xtc_db_query("SELECT customers_status_show_price_tax FROM customers_status WHERE customers_status_id='".EBAY_CUSTOMERS_STATUS."'");
$cstatus = xtc_db_fetch_array($cstatus_query);
$show_price_tax = $cstatus['customers_status_show_price_tax'];


$second_chance_offer_durations = array(
	0=>array('id'=>'','text'=>TEXT_SELECT),
	1=>array('id'=>'Days_1','text'=>'1 Tag'),
	2=>array('id'=>'Days_3','text'=>'3 Tage'),
	3=>array('id'=>'Days_5','text'=>'5 Tage'),
	4=>array('id'=>'Days_7','text'=>'7 Tage')
);

@set_time_limit(0);

if(isset($_GET['from']) and isset($_GET['to'])){
	$from = xtc_db_input($_GET['from']);
	$from_parts = list($d,$m,$j) = explode('.',$from);
	$from = sprintf('%s-%s-%s',$j,$m,$d);
	$to = xtc_db_input($_GET['to']);
	$to_parts = list($d,$m,$j) = explode('.',$to);
	$to = sprintf('%s-%s-%s',$j,$m,$d);
	$to .= ' '.date('H:i:s');
}else{
	$d = new DateTime();
	$d->modify('-1 day');
	$from = $d->format('Y-m-d');
	$to = date('Y-m-d H:i:s');
}

$ebay_user = isset($_GET['ebay_user'])?$_GET['ebay_user']:EBAY_USER;
$action = isset($_GET['action']) ? $_GET['action'] : '';
switch($action) {
   	case 'add':
		$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
		$session->setRequestToken( $EBAYAPI->getToken($ebay_user) );
		$cs = new EbatNs_ServiceProxy($session);
		//$cs->attachLogger(new EbatNs_Logger(false),'stdout');
		if(isset($_POST['duration']) and sizeOf($_POST['duration'])>0){
			foreach($_POST['duration'] as $ebay_id=>$users){
				$ebay_id = xtc_db_input($ebay_id);
				if(!sizeOf($users)){
					continue;
				}
				foreach($users as $user=>$duration){
					$price = (float) xtc_db_input($_REQUEST['price'][$ebay_id][$user]);
					$orig_auction_query = xtc_db_query("SELECT * FROM ebay_auctions WHERE ebay_id='".$ebay_id."'");
					if(xtc_db_num_rows($orig_auction_query) == 1){
						$orig_auction = xtc_db_fetch_array($orig_auction_query);
						$go = false;
						// IMMER NUR 1 STUECK, DAHER KEINE QTY

						if(STOCK_CHECK == 'true'){
							$SQ = new products_quantity($orig_auction["products_id"]);
							$products_stock = $SQ->get_products_total_qty();
							if( $products_stock >= 1 ) {
								$go = true;
							}
						}else{
							$go = true;
						}
						if($go){
							$new_auction_sql = $orig_auction;
							$new_auction_sql['id'] = '';
							$new_auction_sql['auctionprice'] = $price;
							$new_auction_sql['auction_fees'] = 0;
							$new_auction_sql['duration'] = current(array_reverse(split('Days_',$duration)));
							$new_auction_sql['current_auctionprice'] = 0;
							$new_auction_sql['quantity_sold'] = 0;
							$new_auction_sql['relist_id'] = '';
							$new_auction_sql['cronstart'] = '';
							$new_auction_sql['status'] = '0';
							$new_auction_sql['relist'] = '';
							$new_auction_sql['not_valid'] = '';
							$new_auction_sql['is_automatic'] = '';
							
							$req = new AddSecondChanceItemRequestType();
							$req->setRecipientBidderUserID($user);
							$req->setDuration($duration);
							$req->setItemID($ebay_id);
							$res = $cs->AddSecondChanceItem($req);
							if($cs->isGood($res)){
								$new_auction_sql['ebay_id'] = $res->getItemID();
								$new_auction_sql['start_time'] = $res->getStartTime();
								$new_auction_sql['end_time'] = $res->getEndTime();
								$new_auction_sql['is_personal_offer'] = '1';
								
								xtc_db_perform('ebay_auctions',$new_auction_sql);
								$new_ebay_auctions_id = xtc_db_insert_id();

								// SHIPPINGS KOPIEREN!
								$query = yes_db_query(sprintf(
									"SELECT * FROM ebay_auctions_shippings WHERE ebay_auctions_id='%s'",
									$orig_auction['id']
								));
								foreach($query as $record){
									$ebay_auctions_shippings_id = $record['ebay_auctions_shippings_id'];
									$insert_sql_array = $record;
									$insert_sql_array['ebay_auctions_id'] = $new_ebay_auctions_id;
									$insert_sql_array['ebay_auctions_shippings_id'] = '';
									xtc_db_perform('ebay_auctions_shippings',$insert_sql_array);
									$new_ebay_auctions_shippings_id = xtc_db_insert_id();
									// SHIPPING_LOCATIONSS KOPIEREN!
									$locations_query = yes_db_query(sprintf(
										"SELECT * FROM ebay_auctions_shippings_locations WHERE ebay_auctions_shippings_id='%s'",
										$ebay_auctions_shippings_id
									));
									foreach($locations_query as $location_record){
										$insert_sql_array = $location_record;
										$insert_sql_array['ebay_auctions_shippings_locations_id'] = '';
										xtc_db_perform('ebay_auctions_shippings_locations',$insert_sql_array);
									}
								}

								
								$SQ = new products_quantity($orig_auction["products_id"]);
								$new_qty = 1; // immer 1(!?)
								$qty_total = $SQ->get_products_total_qty();
									
								xtc_db_query("INSERT INTO ebay_personal_offers SET ebay_id='".$ebay_id."', userid='".$user."',duration='".$new_auction_sql['duration']."',date_saved=now()");
//								$SQ->update_qty( -$new_qty, $SQ->get_default_storage_id(),$qty_total,'Privates Ebay-Auktionsangebot an Hoechstbietende fuer '.$res->getItemID().' unterbreitet: '.$new_qty.' Stk.');
								yes_update_products_in_auction_quantity($orig_auction["products_id"], 
										$new_qty, 
										'Privates Ebay-Auktionsangebot an Hoechstbietende fuer '.$res->getItemID().' unterbreitet: '.$new_qty.' Stk.'
								);
								$messageStack->add_session('Das Angebot zur Auktion '.$ebay_id.' zum User '.$user.' wurde unterbreitet.','success');
							}else{
								$messageStack->add_session('Das Angebot zur Auktion '.$ebay_id.' zum User '.$user.' konnte nicht unterbreitet werden: '.$cs->getErrorsToString($res),'error');
							}
						}else{
							$messageStack->add_session('Das Angebot zur Auktion '.$ebay_id.' zum User '.$user.' konnte wegen Bestandsperre nicht unterbreitet werden.','error');
						}
					}else{
						$messageStack->add_session('Die Auktion '.$ebay_id.' zum User '.$user.' ist keine YES-Auktion.','error');
					}
				}
			}
		}else{
			$messageStack->add_session('Es wurden keine Angebote ausgew&auml;hlt.','error');
		}
		xtc_redirect(xtc_href_link('ebayapi_highbidder.php',xtc_get_all_get_params(array('action'))));
		exit;
		break;
	case 'confirm':

		$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
		$session->setRequestToken( $EBAYAPI->getToken($ebay_user) );
		$cs = new EbatNs_ServiceProxy($session);
		$auctions = array();
		if(isset($_POST['duration']) and sizeOf($_POST['duration'])>0){
			foreach($_POST['duration'] as $ebay_id=>$buyers){
				unset($bidArray);
				$ebay_id = xtc_db_input($ebay_id);
				$bids = array();
				foreach($buyers as $userid=>$days){
					if(empty($days)){
						continue;
					}
					if(!isset($bidArray)){
						$transactionprice_query = xtc_db_query("SELECT et.transactionprice,ea.title FROM ebay_transactions et,ebay_auctions ea WHERE et.ebayid='".$ebay_id."' and ea.ebay_id=et.ebayid");
						$transactionprice = xtc_db_fetch_array($transactionprice_query);
						$req = new GetAllBiddersRequestType();
						$req->setItemID($ebay_id);
						$res = $cs->GetAllBidders($req);
						$bidArray = $res->getBidArray();
					}
						
					if(sizeOf($bidArray)>0){
						foreach($bidArray as $ba=>$offer){
							$bid = array();
							$bid['currency'] = $offer->getCurrency();
							$max = $offer->getMaxBid();
							$bid['max_value'] = $max->value;
							$user = $offer->getUser();
							$regadd = $user->getRegistrationAddress();
							if(gettype($regadd) != 'NULL'){
								$bid['name'] = $regadd->getName();
								$bid['street'] = $regadd->getStreet();
								$bid['street1'] = $regadd->getStreet1();
								$bid['city'] = $regadd->getCityName();
								$bid['countryname'] = $regadd->getCountryName();
								$bid['postalcode'] = $regadd->getPostalCode();
							}
							$bid['userid'] = $user->getUserID();
							$bid['feedback'] = $user->getFeedbackScore();
							
							$is_saved = xtc_db_query("SELECT ebay_id FROM ebay_personal_offers WHERE ebay_id='".$ebay_id."' and userid='".$bid['userid']."'");
							if(xtc_db_num_rows($is_saved) < 1){
								$bid['active'] = 1;
								$bid['duration'] = xtc_draw_hidden_field('duration['.$ebay_id.']['.$userid.']',$_POST['duration'][$ebay_id][$userid]).substr($_POST['duration'][$ebay_id][$userid],5,strlen($_POST['duration'][$ebay_id][$userid])) . ' Tage';
								$bid['price_input'] = xtc_draw_hidden_field('price['.$ebay_id.']['.$userid.']',$_POST['price'][$ebay_id][$userid]);
							}else{
								$bid['duration'] = '&nbsp;';
							}
							$bid['quote'] = number_format($transactionprice['transactionprice']/$max->value,2,',','.');
							if($userid == $user->getUserID()){
								$bids[] = $bid;
							}
						}
					}
				
					if(sizeOf($bids)>0){
						$auctions[$ebay_id]['bids'] = $bids;
						$auctions[$ebay_id]['ebaylink'] = xtc_get_ebay_link(xtc_get_auction_site($ebay_id)).$ebay_id;
						$auctions[$ebay_id]['transactionprice'] = number_format($transactionprice['transactionprice'],2,',','.');
						$auctions[$ebay_id]['ebay_id'] = $ebay_id;
						$auctions[$ebay_id]['name'] = xtc_db_prepare_input($transactionprice['title']);
						
						$products_query = xtc_db_query("SELECT ebay_products_id,products_id,site FROM ebay_auctions WHERE ebay_id='".$ebay_id."' LIMIT 1");
						$products = xtc_db_fetch_array($products_query);
						$pID = $products["products_id"];
						$site = $products["site"];
						$SQ = new products_quantity( $pID );
						$currency = $EBAYAPI->get_site_currency($EBAYAPI->get_site_id_from_name($site));
						$xtPrice = new xtcPrice($currency,EBAY_CUSTOMERS_STATUS );
						
						$tax_id=xtc_get_tax_class_id($pID);
						$final_price=$xtPrice->xtcGetPrice($pID,
							$format=false,
							1,
							$tax_id,0
						);
						$auctions[$ebay_id]['show_price_tax'] = $show_price_tax;
						$auctions[$ebay_id]['shopprice'] = $final_price;
						$auctions[$ebay_id]['products_id'] = $pID;
						$auctions[$ebay_id]['products_at_ebay'] = $SQ->get_auction_qty();
						$auctions[$ebay_id]['products_bestand'] = "<a href='#' onClick='window.open(\"".xtc_href_link('products.php','action=bestand&pID='.$pID)."\",\"popup\",\"width=350px,height=400px,scrollbars=yes,resizable=yes\");'><u>". $SQ->get_available2_qty().'</u></a>';
					}				
				}
			}
		}
		break;
	default:
	    error_reporting(E_ERROR);
		$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
		$session->setRequestToken( $EBAYAPI->getToken($ebay_user) );
		$cs = new EbatNs_ServiceProxy($session);
		//$cs->attachLogger(new EbatNs_Logger(false),'stdout');

		
		// mit addsecondchanceitem relisten - bis 60tage rueck
		
		$ebays = array();
		$req = new GetSellerEventsRequestType();
		$req->setEndTimeFrom($from);
		$req->setEndTimeTo($to);
		$res = $cs->GetSellerEvents($req);
                if(!$cs->isGood($res)){
                    $ebay_error = $cs->getErrorsToString($res);
                    error_reporting($error_reporting);
                }else{
                    $items = $res->getItemArray();
                    error_reporting($error_reporting);
                }
		if(sizeOf($items)>0){
                    foreach($items as $k=>$item){
                            $sellingStatus = $item->getSellingStatus();
                            $cprice = $sellingStatus->getCurrentPrice();
                            if($sellingStatus->getBidCount() > 1)
                                    $ebays[] = array('ebay_id'=>$item->getItemID(),'name'=>$item->getTitle(),'transactionprice'=>$cprice->value);

                    }
                    $auctions = array();
                    $counter = 0;
                    foreach($ebays as $k=>$v){
                            $req = new GetAllBiddersRequestType();
                            $req->setItemID($v['ebay_id']);
                            $res = $cs->GetAllBidders($req);
                            $bidArray = $res->getBidArray();
                            $bids = array();
                            if(sizeOf($bidArray)>0){
                                    foreach($bidArray as $ba=>$offer){
                                            $bid['currency'] = $offer->getCurrency();
                                            $max = $offer->getMaxBid();
                                            $bid['max_value'] = $max->value;
                                            $user = $offer->getUser();
                                            $regadd = $user->getRegistrationAddress();
                                            if(gettype($regadd) != 'NULL'){
                                                    $bid['name'] = $regadd->getName();
                                                    $bid['street'] = $regadd->getStreet();
                                                    $bid['street1'] = $regadd->getStreet1();
                                                    $bid['city'] = $regadd->getCityName();
                                                    $bid['countryname'] = $regadd->getCountryName();
                                                    $bid['postalcode'] = $regadd->getPostalCode();
                                            }
                                            $bid['userid'] = $user->getUserID();
                                            $bid['feedback'] = $user->getFeedbackScore();

                                            $is_saved = xtc_db_query("SELECT ebay_id FROM ebay_personal_offers WHERE ebay_id='".$v['ebay_id']."' and userid='".$bid['userid']."'");
                                            if(xtc_db_num_rows($is_saved) < 1){
                                                    $bid['active'] = 1;
                                                    $bid['duration'] = xtc_draw_pull_down_menu('duration['.$v['ebay_id'].']['.$bid['userid'].']',$second_chance_offer_durations);
                                                    $bid['price_input'] = xtc_draw_hidden_field('price['.$v['ebay_id'].']['.$bid['userid'].']',$bid['max_value']);
    //						$bid['duration'] = xtc_draw_pull_down_menu('duration['.$v['ebay_id'].'][]',$second_chance_offer_durations,'Days_'.EBAYAPI_HIGHBIDDER_DURATION).xtc_draw_hidden_field('price['.$v['ebay_id'].'][]',$bid['max_value']);
                                            }else{
                                                    $bid['checkbox'] = xtc_image('images/icons/tick.gif','Bereits unterbreitet');
                                                    $bid['duration'] = '&nbsp;';
                                            }

                                            $bids[] = $bid;
                                    }
                                    if(sizeOf($bids)>0){
                                            $auctions[$v['ebay_id']]['bids'] = $bids;
                                    }
                                    $auctions[$v['ebay_id']]['ebaylink'] = xtc_get_ebay_link(xtc_get_auction_site($v['ebay_id'])).$v['ebay_id'];
                                    $auctions[$v['ebay_id']]['transactionprice'] = $v['transactionprice'];
                                    $auctions[$v['ebay_id']]['ebay_id'] = $v['ebay_id'];
                                    $auctions[$v['ebay_id']]['name'] = $v['name'];

                                    $products_query = xtc_db_query("SELECT site,ebay_products_id,products_id FROM ebay_auctions WHERE ebay_id='".$v['ebay_id']."' LIMIT 1");
                                    $products = xtc_db_fetch_array($products_query);
                                    $pID = $products["products_id"];
                                    $site = $products["site"]; 
                                    $SQ = new products_quantity( $pID );
                                    $currency = $EBAYAPI->get_site_currency($EBAYAPI->get_site_id_from_name($site));
                                    $xtPrice = new xtcPrice($currency,EBAY_CUSTOMERS_STATUS );

                                    $tax_id=xtc_get_tax_class_id($pID);
                                    $final_price=$xtPrice->xtcGetPrice($pID,
                                            $format=false,
                                            1,
                                            $tax_id,0
                                    );
                                    $auctions[$v['ebay_id']]['show_price_tax'] = $show_price_tax;
                                    $auctions[$v['ebay_id']]['shopprice'] = $final_price;
                                    $auctions[$v['ebay_id']]['products_id'] = $pID;
                                    $auctions[$v['ebay_id']]['products_id_link'] = "<a href='#' onClick='window.open(\"".xtc_href_link('categories.php','action=new_product&pID='.$pID.'&cPath='.xtc_get_product_path($pID))."\",\"popup\",\"width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_WIDTH.",resizable=yes,scrollbars=yes\");'><u>".$pID."</u></a>";
                                    $auctions[$v['ebay_id']]['sammler_id'] = $products["ebay_products_id"];
                                    $auctions[$v['ebay_id']]['products_at_ebay'] = $SQ->get_auction_qty();
                                    $auctions[$v['ebay_id']]['products_bestand'] = "<a href='#' onClick='window.open(\"".xtc_href_link('products.php','action=bestand&pID='.$pID)."\",\"popup\",\"width=350px,height=400px,scrollbars=yes,resizable=yes\");'><u>". $SQ->get_available2_qty().'</u></a>';
                            }
                    }
                }
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>

<?php
if(!isset($ebay_error)) $ebay_error = '';
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'EBAY_ERROR'=>$ebay_error,
    'EBAY_USER_FORM'=>xtc_draw_form('ebayuser_select','ebayapi_highbidder.php',xtc_get_all_get_params(array('ebay_user')),'get'),
    'EBAY_USER_ID'=>TEXT_EBAY_USERID,
    'INPUT_EBAY_USER'=>xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),$ebay_user)
));
$smarty->assign(array(
	'CONFIRM_INTRO'=>CONFIRM_INTRO,
	'FORM_END'=>'</form>',
	'DATE_FORM_LEGEND'=>DATE_FORM_LEGEND
));
if(isset($_GET['action']) and $_GET['action'] == 'confirm'){
	$smarty->assign('BID_FORM',xtc_draw_form('bidder','ebayapi_highbidder.php',xtc_get_all_get_params(array('action','ebay_user')).'action=add&ebay_user='.$ebay_user,'POST'));
	$smarty->assign('CONFIRM','1');
}else{
	$smarty->assign('BID_FORM',xtc_draw_form('bidder','ebayapi_highbidder.php',xtc_get_all_get_params(array('action','ebay_user')).'action=confirm&ebay_user='.$ebay_user,'POST'));
	$smarty->assign('DATE_FORM',xtc_draw_form('mysel','ebayapi_highbidder.php','','GET','class="yesForm" id="date_form"'));
	$from_date = (isset($_REQUEST['from'])) ? $_REQUEST['from'] : $from;
	$smarty->assign('FROM_DATE',$from_date);
	$to_date = (isset($_REQUEST['to'])) ? $_REQUEST['to'] : $to;
	$smarty->assign('TO_DATE',$to_date);
	$smarty->assign('EBAY_USER',$ebay_user);
}
$smarty->assign('auctions',$auctions);

$html = $smarty->fetch(DIR_FS_ADMIN.'templates/highbidder.html');
echo $html;

require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');


