<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

// ***********************************************************
//    das feld 'no_warn' in den orders entscheidet ob 
//    die rechnung in den warningprocess darf
//    
//    die felder 'warning_span_date' und 'warning_span'
//    werden verwendet um die rechnung fuer eine dauer
//    von x tagen vom mahnwesen auszuschliessen. wenn
//    eine rechnung zeitweise vom mahnwesen ausgeschlossen
//    wird, werden die beiden felder gespeichert sowie das
//    feld 'no_warn' auf 1 gesetzt. der cronjob 
//    ebayapi_crontimer.php setzt diese felder nach
//    ablauf wieder auf 0.
//    
//    das feld 'warning_status' steht fuer die aktuelle mahn-
//    stufe. das feld 'last_warning' speichert das datum der
//    letzten mahnaktion. nachdem eine mahnstufe ausgef�hrt 
//    wurde, wird also warning_status um 1 erh�ht und das feld
//    'last_warning' aktualisiert.
// ***********************************************************
    
include('includes/application_top.php');
require_once('includes/classes/class.ebay.php');
require_once('includes/classes/class.csv.php');
require_once(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require_once(DIR_FS_INC . 'xtc_warning_process.inc.php');

$allowed_warning_statuses = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET);
$EBAYAPI = new ebayAPI;

require_once(DIR_WS_CLASSES . 'order.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_WS_CLASSES . 'currencies.php');

// BEZAHLARTEN VOM MAHNWESEN AUSSCHLIESSEN
$payment_exclude_sql = '';
if(xtc_not_null(WARNING_EXCLUDE_PAYMENTMETHODS)){
	$payment_methods = explode(",", WARNING_EXCLUDE_PAYMENTMETHODS);
	if(is_countable($payment_methods) and sizeOf($payment_methods)>0){
		$payment_exclude_sql .= ' AND ';
		foreach($payment_methods as $k=>$payment_method){
			$payment_exclude_sql .= " o.payment_method != '".$payment_method."' AND ";
		}
		$payment_exclude_sql = substr($payment_exclude_sql,0,(strlen($payment_exclude_sql)-4));
	}
}

$currencies = new currencies();
$smarty = new yesSmarty;

$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
$warningmode = (isset($_REQUEST['warningmode'])) ? $_REQUEST['warningmode'] : 0;
if(!xtc_not_null($warningmode)) $warningmode = 0;

@set_time_limit(0);

// WORKAROUND FUER TAGE BIS NAECHSTE WARNUNG
function _get_dayspan($warningmode){
	switch($warningmode){
		case 0:
			return WARNING_DAYSPAN_LEVEL_1;
			break;
		case 1:
			return WARNING_DAYSPAN_LEVEL_2-WARNING_DAYSPAN_LEVEL_1;
			break;
		case 2:
			return WARNING_DAYSPAN_LEVEL_3-WARNING_DAYSPAN_LEVEL_2;
			break;
		case 3:
			return WARNING_DAYSPAN_LEVEL_4-WARNING_DAYSPAN_LEVEL_3;
			break;
	}
}

function is_orders_total_positive($orders_id){
    $query = xtc_db_query(sprintf(
	    "SELECT value FROM %s WHERE orders_id='%s' AND class='ot_total'",
	    TABLE_ORDERS_TOTAL,$orders_id
    ));
    $record = xtc_db_fetch_array($query);
    if($record['value'] > 0){
	return true;
    }
    return false;
}

if($warningmode<1) $warningmode = '0';
switch($action) {
	case "set_no_warn":
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET no_warning=1,last_modified=now() WHERE orders_id='".$oID."'");
		$messageStack->add_session('Die Rechnung Nr '.$oID.' wurde vom Mahnwesen ausgeschlossen','success');
                $order->add_history($order->info['orders_status'], false, 'Vom Mahnwesen ausgeschlossen');
		xtc_redirect( xtc_href_link('ebayapi_warnings.php',xtc_get_all_get_params(array('oID','action'))));
		break;
	case "set_no_warn_span":
		$oID = xtc_db_input($_GET['oID']);
		$span = xtc_db_input($_GET['span']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET no_warning=1,warning_span_date=now(),warning_span='".$span."',last_modified=now() WHERE orders_id='".$oID."'");
		$messageStack->add_session('Die Rechnung Nr '.$oID.' wurde vom Mahnwesen fuer '.$span.' Tage ausgeschlossen','success');
                $order->add_history($order->info['orders_status'], false, 'Vom Mahnwesen f&uuml;r '.$span.' Tage ausgeschlossen');
		xtc_redirect( xtc_href_link('ebayapi_warnings.php',xtc_get_all_get_params(array('oID','action'))));
		break;
	case "set_warn":
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET no_warning=0,warning_span_date='0000-00-00 00:00:00',warning_span=0,last_modified=now() WHERE orders_id='".$oID."'");
		$messageStack->add_session('Die Rechnung Nr '.$oID.' wurde wieder ins Mahnwesen eingefuegt.','success');
                $order->add_history($order->info['orders_status'], false, 'Wieder ins Mahnwesen integriert.');
		xtc_redirect( xtc_href_link('ebayapi_warnings.php',xtc_get_all_get_params(array('oID','action'))));
		break;
	case "adddispute":
		if($_POST['sendnow'] > 0 && isset($_POST['id']) ) {
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$res = $ebaycalls->tradingQuery(EBAY_USER,
				'AddDispute',
				$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
				[
					'DisputeId' => (int)$_POST['id'],
					'Reason' => $_POST['reason'],
					'Message' => $_POST['msg'],
				]
			);
			if($EBAYAPI->isGood($res)){
				$messageStack->add_session("eBay Dispute Message sent");
				xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_WARNING,'action=warnings','NONSSL'));
			}
			die(implode('<br />',$EBAYAPI->getResponseErrors($res)));
		}
		break;
	case "deldispute":
		if($_POST['sendnow'] > 0 && isset($_POST['id']) ) {

			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$res = $ebaycalls->tradingQuery(EBAY_USER,
				'AddDispute',
				$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
				[
					'DisputeId' => (int)$_POST['id'],
					'SellerReverse' => $_POST['reason']
				]
			);
			if (!$EBAYAPI->isGood($res)){
				echo implode('<br />',$EBAYAPI->getResponseErrors($res));
				die();
			}else{
				$messageStack->add_session("Sie haben den Streit zur�ckgezogen.");
				xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_WARNING,'action=warnings','NONSSL'));
			}

		}
		break;
	case "warn":
		if(is_countable($_POST['orders_id']) and sizeOf($_POST['orders_id']) > 0) {
			$orders_array = array();
			for($i=0;$i<count($_POST['orders_id']);$i++){
				$orders_array[] = $_POST['orders_id'][$i];
			}
			xtc_warning_process($orders_array,$warningmode);
			xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_WARNING, xtc_get_all_get_params(array('oID', 'action'))));
		}
	  	break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript">
<!--
function really_nowarn(wid) {
	yes = confirm('Die ausgewaehlte Bestellung wirklich vom Mahnwesen ausschliessen?');
	if(yes)
		window.location.href="<?php echo xtc_href_link('ebayapi_warnings.php',xtc_get_all_get_params(array('action','oID')).'action=set_no_warn'); ?>&oID="+wid;
}

function really_nowarn_span(wid) {
	yes = confirm('Die ausgewaehlte Bestellung wirklich vom Mahnwesen ausschliessen?');
	if(yes){
		span = prompt('Fuer wieviel Tage ausschliessen?');
		window.location.href="<?php echo xtc_href_link('ebayapi_warnings.php',xtc_get_all_get_params(array('action','oID')).'action=set_no_warn_span'); ?>&oID="+wid+"&span="+span;
	}
}
function really_warn(wid) {
	yes = confirm('Die ausgewaehlte Bestellung wirklich vom wieder ins Mahnwesen integrieren?');
	if(yes)
		window.location.href="<?php echo xtc_href_link('ebayapi_warnings.php',xtc_get_all_get_params(array('action','oID')).'action=set_warn'); ?>&oID="+wid;
}
//-->
</script>


<div class="yesPage">

<?php
	$warningmode_array = array(
		0=>array('id'=>'0','text'=>'Anzumahnende Bestellungen'),
		1=>array('id'=>'1','text'=>'Zahlungserinnerung geschickt'),
		2=>array('id'=>'2','text'=>'1. Mahnung verschickt'),
		3=>array('id'=>'3','text'=>'2. Mahnung verschickt')
	);
	$smarty->assign('STATUS_SELECT',xtc_draw_pull_down_menu('warningmode',$warningmode_array,$warningmode,'onChange="document.forms[\'warnings\'].submit();"'));
	$smarty->assign('NO_WARNINGS_LINK',xtc_href_link(FILENAME_EBAYAPI_WARNING,'action=no_warning','NONSSL'));
	switch($warningmode) {
		case '1': $string = "Diese Bestellungen haben bereits eine Zahlungsaufforderung erhalten.";break;
		case '2': $string = "Diese Bestellungen haben bereits eine 1. Mahnung erhalten.";break;
		case '3': $string = "Diese Bestellungen haben bereits die 2. Mahnung mit Rechtsanwalt-Androhung erhalten.";break;
		case '4': $string = "Diese Bestellungen wurden dem Rechtsanwalt zugesendet.";break;
		default:  $string = "Diese Bestellungen sind bereits nach ".WARNING_DAYSPAN_LEVEL_1." Tagen noch nicht bezahlt worden.";break;
	}
	$smarty->assign('WARNINGMODE_STRING',$string);
	
	// wir durchlaufen die kundengruppen -> zahlungsziel-routine
	$groups = array();
	$customers_status_query = xtc_db_query("SELECT cs.customers_status_payment_target,cs.customers_status_name,cs.customers_status_id FROM customers_status cs WHERE cs.language_id='".$_SESSION['languages_id']."'");
	while($customers_status = xtc_db_fetch_array($customers_status_query)){
		if($warningmode == 0)
			$groups[] = array('id' => $customers_status['customers_status_id'],'name'=>$customers_status['customers_status_name'],'dayspan'=>(($customers_status['customers_status_payment_target']>0)?$customers_status['customers_status_payment_target']:WARNING_DAYSPAN_LEVEL_1));
		else
			$groups[] = array('id' => $customers_status['customers_status_id'],'name'=>$customers_status['customers_status_name'],'dayspan'=>_get_dayspan($warningmode));
	}
	$action = (isset($_GET['action'])) ? $_GET['action'] : '';
	switch($action) {
		default:
			$smarty->assign('FORM',xtc_draw_form('warningsform',FILENAME_EBAYAPI_WARNING,'action=warn','POST'));
			$smarty->assign('WARNINGMODE',$warningmode);

			// DAS DATEFIELD ENTSCHEIDET ANHAND WELCHES DATUMS BERECHNET WIRD			
			if($warningmode > 0){
				$no_warn_sql = " && o.no_warning='0'";
				$date_field = 'last_warning';
			}else{
				$no_warn_sql = "";
				$date_field = 'date_purchased';
			}
		
			$warnings = array();
			foreach($groups as $gk=>$group){
				$orders_query = xtc_db_query("SELECT c.block_warnings,o.*,ot.text FROM ".TABLE_ORDERS." o, ".TABLE_ORDERS_TOTAL." ot,customers c WHERE c.customers_id=o.customers_id and o.orders_status IN(".implode(',',$allowed_warning_statuses).") && ( UNIX_TIMESTAMP(o.".$date_field.")+".($group['dayspan']*60*60*24)." ) < UNIX_TIMESTAMP( NOW() ) && ot.orders_id=o.orders_id && ot.class='ot_total' && o.warning_status=".$warningmode." and o.customers_status='".$group['id']."' ".$no_warn_sql.$payment_exclude_sql);
				$zaehler = 1;
				if(xtc_db_num_rows($orders_query) > 0) {
					while($orders = xtc_db_fetch_array($orders_query)){
					    if(!is_orders_total_positive($orders['orders_id'])){
						continue;
					    }
						$entry = $orders;
						$entry['name'] = $group['name'];
						$entry['dayspan'] = $group['dayspan'];
						
						
						$noprice = 0;
						$link = '';
						
						if($orders['no_warning'] == '0'){
							$oproducts_query = xtc_db_query("SELECT products_id FROM orders_products WHERE orders_id='".$orders['orders_id']."'");
							while( $oproducts = xtc_db_fetch_array($oproducts_query) ){
								$pID = $oproducts['products_id'];
								$ek = xtc_get_price_ek($pID);
								if($ek == 0){
									$noprice = 1;
									$link .= '<a target="_blank" href="'.xtc_href_link('distributor_products.php','pID='.$pID).'">'.xtc_image('images/icons/warning.gif','Das Produkt '.$pID.' hat keinen EK Preis. Dieser wird ben�tigt um den entgangenen Gewinn zu berechnen.').'</a>&nbsp;';
								}
							}
							if($noprice == 0 or WARNING_ENTGANGENER_GEWINN_ACTIVE == 0){
								if($orders['block_warnings'] == 0){
									$entry['icon'] = xtc_draw_checkbox_field('orders_id[]',$orders['orders_id']).'&nbsp;<font color=darkblue>'.$zaehler."</font>";
								}else{
									$entry['icon'] = xtc_image('images/icon_status_red.gif','Der Kunde ist vom Mahnwesen ausgeschlossen.');	
								}
							}else{
								$entry['icon'] = $link;
							}
							$entry['orderlink'] = xtc_href_link('orders.php','action=edit&oID='.$orders['orders_id']);
							$entry['orders_id'] = $orders['orders_id'];
							$ebayuser_query = xtc_db_query("SELECT customers_ebay_userid FROM customers WHERE customers_id='".$orders['customers_id']."'");
							$ebayuser_res = xtc_db_fetch_array($ebayuser_query);
							$entry['ebayuser'] = ($ebayuser_res['customers_ebay_userid']!='') ? '&nbsp;<font color=blue>'.$ebayuser_res['customers_ebay_userid'].'</font>' : '';
							$entry['customerlink'] = xtc_href_link('customers.php','action=crm&cID='.$orders['customers_id']);
							$history = array();
							if($warningmode > 0){
								$hist_query = xtc_db_query("SELECT action,warning_date FROM ebay_warning_history WHERE orders_id='".$orders['orders_id']."'");
								while($hist = xtc_db_fetch_array($hist_query) ){
									$history[] = $hist;
								}
								$entry['history'] = $history;
							}
							$entry['ebaylink'] = xtc_get_ebay_link(xtc_get_auction_site($orders['ebay_id'])).$orders['ebay_id'];
							$entry['printlink'] = xtc_href_link('print_order_warnings.php','oID='.$orders['orders_id']);
							$warnings[] = $entry;
							$zaehler++;
						} // end if no_warning == 0
					} // end while sql array
				} // end if numrows>0
			} // end foreach groups
			
			$smarty->assign('warnings',$warnings);
			switch($warningmode) {
						case '1':	$save = xtc_draw_input_field('save','1. Mahnung schicken','','','submit'); break;
						case '2':	$save = xtc_draw_input_field('save','2. Mahnung schicken','','','submit'); break;
						case '3':	$save = xtc_draw_input_field('save','Rechtsanwalt �bergeben','','','submit'); break;
						default:	$save = xtc_draw_input_field('save','Zahlungserinnerung senden','','','submit'); break;
			}
			$smarty->assign('SAVE',$save);
			$smarty->assign('HIDDEN_MODE',xtc_draw_hidden_field('warningmode',$warningmode));
			switch($warningmode) {
						case '1': $MODE_COMMENT = "<p class='smallText'> * Mit abschicken der ausgew�hlten Bestellungen erh�lt der K�ufer eine Mahnung mit einer sch�rferen Zahlungsaufforderung, gleichzeitig wird an Ebay eine Meldung gesendet, dass der K&#228;ufer in Verzug ist (sofern es sich um eine Bestellung aus Ebay handelt), dadurch wird der Ebay-User auch direkt von Ebay angemahnt. Vorg�nge die dann zwischen Ebay/K�ufer/Verk�ufer stattfinden, sind im Men�punkt 'Ebay-Direkt-Mahnungen' zu finden (Allerdings kann der komplette Ablauf eines Ebay-Disputes nicht abgebildet werden, so dass ab dem 1. Abmahnen auf ebay.de 'weitergestritten' werden sollte)</p>"; break;
						case '2': $MODE_COMMENT = "<p class='smallText'> * Mit abschicken der ausgew�hlten Bestellungen erh�lt der K�ufer eine Ank�ndigung den Vorgang dem Anwalt zu �bergeben.</p>"; break;
						case '3': $MODE_COMMENT = "<p class='smallText'> * Mit abschicken der ausgew�hlten Bestellungen erh�lt der Rechtsanwalt die Bestelldaten, der K�ufer erh�lt keine Email.</p>"; break;
						case '4': $MODE_COMMENT = "<p class='smallText'> * Noch keine Funktion.</p>"; break;
						default: $MODE_COMMENT = "<p class='smallText'> * Mit ausw&#228;hlen der Bestellungen und dem Abschicken wird eine Email an die jeweiligen Kunden gesendet.</p>"; break;
			}
			$smarty->assign('MODE_COMMENT',$MODE_COMMENT);
			if(is_countable($warnings) and sizeOf($warnings) == 0){
				switch($warningmode) {
						default: $comment = "<p>Es sind zur Zeit keine Bestellungen vorhanden, an die eine Zahlungserinnerung verschickt werden m�sste.</p>"; break;
						case '1': $comment = "<p>Es sind zur Zeit keine Bestellungen vorhanden, die in Mahnstufe 1 angemahnt werden m�ssen.</p>"; break;
						case '2': $comment = "<p>Es sind zur Zeit keine Bestellungen vorhanden, die in Mahnstufe 2 angemahnt werden m�ssen.</p>"; break;
						case '3': $comment = "<p>Es sind zur Zeit keine Bestellungen vorhanden, die dem Rechtsanwalt �bergeben werden m�ssen.</p>"; break;
						case '4': $comment = "<p>Es sind zur Zeit keine Bestellungen vorhanden, die dem Rechtsanwalt �bergeben wurden.</p>"; break;
				}
				$smarty->assign('COMMENTS',$comment);
			}
			break;
		case 'no_warning':
			$smarty->assign('FORM',xtc_draw_form('warningsform',FILENAME_EBAYAPI_WARNING,'action=warn','POST'));
			$smarty->assign('WARNINGMODE',$warningmode);
			
			$no_warn_sql = " && o.no_warning='1'";
			
			foreach($groups as $gk=>$group){
			
				$orders_query = xtc_db_query("SELECT o.*,ot.text FROM ".TABLE_ORDERS." o, ".TABLE_ORDERS_TOTAL." ot WHERE o.orders_status IN(".implode(',',$allowed_warning_statuses).") && ot.orders_id=o.orders_id && ot.class='ot_total' ".$no_warn_sql);
				
				if(xtc_db_num_rows($orders_query) > 0) {
					while($orders = xtc_db_fetch_array($orders_query)){
					    if(!is_orders_total_positive($orders['orders_id'])){
						continue;
					    }
						$entry = $orders;
						$entry['icon'] = xtc_draw_checkbox_field('orders_id[]',$orders['orders_id']);
						$entry['dayspan'] = $group['dayspan'];
						$entry['orderlink'] = "javascript:window.open('".xtc_href_link('incoming_payments.php','action=showorder&oID='.$orders['orders_id'])."','popup','width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_HEIGHT."');";
						$entry['customerlink'] = xtc_href_link('customers.php','action=crm&cID='.$orders['customers_id']);
						$entry['warnlink'] = "<a href=\"javascript:really_warn(\"".$orders['orders_id']."\");\">".xtc_image('images/icons/unlocked.gif','Wieder ins Mahnwesen einf&uuml;gen.')."</a>&nbsp;";
						if( $orders['warning_span'] > 0){
							$_date = strtotime( $orders['warning_span_date'] );
							$_span = $orders['warning_span'];
							$_now  = strtotime( date("Y-m-d H:i:s") );
							$_diff = yes_strftime('%d.%m.%Y',($_date + ( $_span*(60*60*24) ) ) );
							$entry['dayspan'] = xtc_image('images/uhr-button.gif','Noch bis '.$_diff.' ausgeschlossen.');
						}
					}
				}else{
					$smarty->assign('COMMENTS',"<p>Es sind zur Zeit keine offenen Bestellungen vorhanden, die vom Mahnwesen ausgeschlossen worden sind.</p>");
				}
			}
			break;
		case "adddispute":
			if (isset($_GET['id']) || isset($_POST['id'])) {
				$smarty->assign('FORM',xtc_draw_form('dispute',FILENAME_EBAYAPI_WARNING,'action=adddispute','post'));
				$reason_array = array(
					0=>array('id'=>'11','text'=>'Sie m�chten zur Antwort des K�ufers schreiben oder Bemerkungen zum Streit abgeben'),
					1=>array('id'=>'13','text'=>'Sie m�chten den Streit abschliessen'),
					2=>array('id'=>'14','text'=>'Sie m�chten den Streit und weitere Kommunikation dazu beenden'),
					3=>array('id'=>'15','text'=>'Seller wants to withdraw the UPI')
				);
				$smarty->assign('REASON_SELECT',xtc_draw_pull_down_menu('reason',$reason_array));
				$smarty->assign('ID',$_GET['id']);
			}
			$smarty->assign('BACKLINK',xtc_href_link(FILENAME_EBAYAPI_WARNING,'action=warnings'));
			break;
}
$html=$smarty->fetch(DIR_FS_ADMIN.'templates/warnings.html');
echo $html;
?>
</div>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

