<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

// ***********************************************************
//    das feld 'no_warn' in den orders entscheidet ob 
//    die rechnung in den warningprocess darf
//    
//    die felder 'warning_span_date' und 'warning_span'
//    werden verwendet um die rechnung fuer eine dauer
//    von x tagen vom mahnwesen auszuschliessen. wenn
//    eine rechnung zeitweise vom mahnwesen ausgeschlossen
//    wird, werden die beiden felder gespeichert sowie das
//    feld 'no_warn' auf 1 gesetzt. der cronjob 
//    ebayapi_crontimer.php setzt diese felder nach
//    ablauf wieder auf 0.
//    
//    das feld 'warning_status' steht fuer die aktuelle mahn-
//    stufe. das feld 'last_warning' speichert das datum der
//    letzten mahnaktion. nachdem eine mahnstufe ausgef�hrt 
//    wurde, wird also warning_status um 1 erh�ht und das feld
//    'last_warning' aktualisiert.
// ***********************************************************
   
include('includes/cron_application_top.php');

$allowed_warning_statuses = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET);

if(!defined('WARNING_AUTOMATIC') or intval(WARNING_AUTOMATIC) == 0){
	die('Das automatische Mahnwesen ist nicht aktiv.');
}

require_once('includes/classes/class.ebay.php');
require_once('includes/classes/class.storagequantity.php');
require_once('includes/classes/class.csv.php');

$EBAYAPI = new ebayAPI;

require_once(DIR_WS_CLASSES . 'order.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_FS_INC . 'xtc_warning_process.inc.php');
$currencies = new currencies();

@set_time_limit(0);
$smarty = new yesSmarty;
$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

function is_orders_total_positive($orders_id){
    $query = xtc_db_query(sprintf(
	    "SELECT value FROM %s WHERE orders_id='%s' AND class='ot_total'",
	    TABLE_ORDERS_TOTAL,$orders_id
    ));
    $record = xtc_db_fetch_array($query);
    if($record['value'] > 0){
	return true;
    }
    return false;
}


// WORKAROUND FUER TAGE BIS NAECHSTE WARNUNG
function _get_dayspan($warningmode){
	switch($warningmode){
		case 0:
			return WARNING_DAYSPAN_LEVEL_1;
			break;
		case 1:
			return WARNING_DAYSPAN_LEVEL_2-WARNING_DAYSPAN_LEVEL_1;
			break;
		case 2:
			return WARNING_DAYSPAN_LEVEL_3-WARNING_DAYSPAN_LEVEL_2;
			break;
		case 3:
			return WARNING_DAYSPAN_LEVEL_4-WARNING_DAYSPAN_LEVEL_3;
			break;
	}
}

// -------------------------------------------------------------------------------------------
// alle zahlungserinnerungen
$orders_array = array();
$warningmode = 0;

// BEZAHLARTEN VOM MAHNWESEN AUSSCHLIESSEN
$payment_exclude_sql = '';
if(defined('WARNING_EXCLUDE_PAYMENTMETHODS') and xtc_not_null(WARNING_EXCLUDE_PAYMENTMETHODS)){
	$payment_methods = explode(",", WARNING_EXCLUDE_PAYMENTMETHODS);
	if(sizeOf($payment_methods)>0){
		$payment_exclude_sql .= ' AND ';
		foreach($payment_methods as $k=>$payment_method){
			$payment_exclude_sql .= " o.payment_method != '".$payment_method."' AND ";
		}
		$payment_exclude_sql = substr($payment_exclude_sql,0,(strlen($payment_exclude_sql)-4));
	}
}
$customers_statuses = xtc_get_customers_statuses();
$groups = array();
$customers_status_query = xtc_db_query("SELECT cs.customers_status_id,cs.customers_status_payment_target,cs.customers_status_name FROM customers_status cs WHERE language_id='2'");
foreach($customers_statuses as $customers_status){
    $groups[] = array('id' => $customers_status['customers_status_id'],
        'name'=>$customers_status['customers_status_name'],
        'dayspan'=>((isset($customers_status['customers_status_payment_target']) and $customers_status['customers_status_payment_target']>0)?$customers_status['customers_status_payment_target']:WARNING_DAYSPAN_LEVEL_1)
    );
}
foreach($groups as $gk=>$group){
	// HIER NEHMEN WIR date_purchased ALS BASIS FUER DIE DATUMSBERECHNUNG

	$orders_query_raw = sprintf("SELECT o.orders_id FROM %s o,customers c WHERE
		c.customers_id=o.customers_id and c.block_warnings=0 and
		o.orders_status IN (%s) && ( UNIX_TIMESTAMP(o.date_purchased)+%s ) < UNIX_TIMESTAMP( NOW() )
		&& o.warning_status='%s' && o.no_warning='0' and o.customers_status='%s' %s order by o.customers_id",
		TABLE_ORDERS,
		implode(',',$allowed_warning_statuses),
		($group['dayspan'] * 60*60*24),
		$warningmode,
		$group['id'],
		$payment_exclude_sql
	);
	$orders_query = xtc_db_query($orders_query_raw);
	while( $orders = xtc_db_fetch_array($orders_query) ){
	    if(is_orders_total_positive($orders['orders_id'])){
			$orders_array[] = $orders['orders_id'];
	    }
	}
}
if( sizeOf($orders_array)>0 ){
	xtc_warning_process($orders_array,$warningmode,$automatic_flag = '1');
}




// -------------------------------------------------------------------------------------------
// alle 1. Mahnungen
$orders_array = array();
$warningmode = 1;

// HIER NEHMEN WIR last_warning ALS BASIS FUER DIE DATUMSBERECHNUNG
$raw = "SELECT o.orders_id FROM ".TABLE_ORDERS." o,customers c WHERE c.customers_id=o.customers_id and c.block_warnings=0 and o.orders_status IN(".implode(',',$allowed_warning_statuses).") && ( UNIX_TIMESTAMP(o.last_warning)+".( _get_dayspan($warningmode) * 60*60*24)." ) < UNIX_TIMESTAMP( NOW() ) && o.warning_status='".$warningmode."' && o.no_warning='0' ".$payment_exclude_sql." order by o.customers_id";
$orders_query = xtc_db_query($raw);
while( $orders = xtc_db_fetch_array($orders_query) ){
	if(is_orders_total_positive($orders['orders_id'])){
	    $orders_array[] = $orders['orders_id'];
	}
}
if( sizeOf($orders_array)>0 ){
	xtc_warning_process($orders_array,$warningmode,$automatic_flag = '1');
}


// -------------------------------------------------------------------------------------------
// alle 2. Mahnungen
$orders_array = array();
$warningmode = 2;

// HIER NEHMEN WIR last_warning ALS BASIS FUER DIE DATUMSBERECHNUNG
$orders_query = xtc_db_query("SELECT o.orders_id FROM ".TABLE_ORDERS." o,customers c WHERE c.customers_id=o.customers_id and c.block_warnings=0 and o.orders_status IN(".implode(',',$allowed_warning_statuses).") && ( UNIX_TIMESTAMP(o.last_warning)+".( _get_dayspan($warningmode) * 60*60*24)." ) < UNIX_TIMESTAMP( NOW() ) && o.warning_status='".$warningmode."' && o.no_warning='0' ".$payment_exclude_sql." order by o.customers_id");
while( $orders = xtc_db_fetch_array($orders_query) ){
	if(is_orders_total_positive($orders['orders_id'])){
	    $orders_array[] = $orders['orders_id'];
	}
}
if( sizeOf($orders_array)>0 ){
	xtc_warning_process($orders_array,$warningmode,$automatic_flag = '1');
}

// -------------------------------------------------------------------------------------------
// alle RA-Exporte
$orders_array = array();
$warningmode = 3;

// HIER NEHMEN WIR last_warning ALS BASIS FUER DIE DATUMSBERECHNUNG
$orders_query = xtc_db_query("SELECT o.orders_id FROM ".TABLE_ORDERS." o, customers c WHERE c.customers_id=o.customers_id and c.block_warnings=0 and (o.orders_status='1' || o.orders_status='2' || o.orders_status='".ORDERS_STATUS_UPSELLING."') && ( UNIX_TIMESTAMP(o.last_warning)+".( _get_dayspan($warningmode) * 60*60*24)." ) < UNIX_TIMESTAMP( NOW() ) && o.warning_status='".$warningmode."' && o.no_warning='0' ".$payment_exclude_sql." order by o.customers_id");
while( $orders = xtc_db_fetch_array($orders_query) ){
	if(is_orders_total_positive($orders['orders_id'])){
	    $orders_array[] = $orders['orders_id'];
	}
}
if( sizeOf($orders_array)>0 ){
	xtc_warning_process($orders_array,$warningmode,$automatic_flag = '1');
}
