<?php
namespace YES4Trade\Enums;

enum ADR_Class: string
{

    case ADR_Class_1 = '1';
    case ADR_Class_2 = '2';
    case ADR_Class_3 = '3';
    case ADR_Class_4_1 = '4.1';
    case ADR_Class_4_2 = '4.2';
    case ADR_Class_4_3 = '4.3';
    case ADR_Class_5_1 = '5.1';
    case ADR_Class_5_2 = '5.2';
    case ADR_Class_6_1 = '6.1';
    case ADR_Class_6_2 = '6.2';
    case ADR_Class_7 = '7';
    case ADR_Class_8 = '8';
    case ADR_Class_9 = '9';

    public function label(): string
    {
        return match($this) {
            self::ADR_Class_1 => constant('ADR_Class_1'),
            self::ADR_Class_2 => constant('ADR_Class_2'),
            self::ADR_Class_3 => constant('ADR_Class_3'),
            self::ADR_Class_4_1 => constant('ADR_Class_4_1'),
            self::ADR_Class_4_2 => constant('ADR_Class_4_2'),
            self::ADR_Class_4_3 => constant('ADR_Class_4_3'),
            self::ADR_Class_5_1 => constant('ADR_Class_5_1'),
            self::ADR_Class_5_2 => constant('ADR_Class_5_2'),
            self::ADR_Class_6_1 => constant('ADR_Class_6_1'),
            self::ADR_Class_6_2 => constant('ADR_Class_6_2'),
            self::ADR_Class_7 => constant('ADR_Class_7'),
            self::ADR_Class_8 => constant('ADR_Class_8'),
            self::ADR_Class_9 => constant('ADR_Class_9'),
        };
    }
    
    public static function fromName(string $name): ?self
    {
        foreach (self::cases() as $case) {
            if ($case->name === $name) {
                return $case;
            }
        }
        return null;
    }


}
