<?php

namespace YES4Trade\Model;

class content_manager extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'content_manager';
    const TABLE_INDEX = 'content_id';
    public static $integerProperties = [
        'content_id',
        'categories_id',
        'parent_id',
        'languages_id',
        'sort_order',
        'file_flag',
        'content_status',
        'content_group',
        'content_delete'
    ];
    private static $propertyTypes = [
        'content_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_id'
        ],
        'categories_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_id'
        ],
        'parent_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'parent_id'
        ],
        'group_ids' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'group_ids'
        ],
        'languages_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'languages_id'
        ],
        'content_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_title'
        ],
        'content_heading' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_heading'
        ],
        'content_text' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_text'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'file_flag' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'file_flag'
        ],
        'content_file' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_file'
        ],
        'content_status' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_status'
        ],
        'content_group' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_group'
        ],
        'content_delete' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_delete'
        ],
        'content_meta_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_meta_title'
        ],
        'content_meta_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_meta_description'
        ],
        'content_meta_keywords' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_meta_keywords'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        foreach($data as $rk=>$rv){
            if(in_array($rk, self::$integerProperties)){
                $data[$rk] = (int)$rv;
            }
        }
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        foreach($data as $rk=>$rv){
            if(in_array($rk, self::$integerProperties)){
                $data[$rk] = (int)$rv;
            }
        }
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:index_val",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['index_val'=>$index]
        );
    }


    public static function get_by_content_id(int $content_id ) {
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:index_val",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['index_val'=>$content_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach($record as $rk=>$rv){
            if(in_array($rk, self::$integerProperties)){
                $record[$rk] = (int)$rv;
            }
        }
        return new self($record);
    }


    public static function get_by_languages_id( int $languages_id ) {
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE languages_id=:language_id ORDER BY sort_order",
                self::TABLE_NAME
            ),['language_id'=>$languages_id]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get_by_parent_id_and_languages_id(int $parent_id, int $languages_id ) {
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE parent_id=:parent_id AND languages_id=:language_id ORDER BY sort_order",
                self::TABLE_NAME
            ),['parent_id'=>$parent_id, 'language_id'=>$languages_id]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }
    
    public static function get_musthaves_by_languages_id(int $languages_id){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_delete=0 AND languages_id=:language_id ORDER BY sort_order",
                self::TABLE_NAME
            ),['language_id'=>$languages_id]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }
    
    public static function clear_musthaves_by_languages_id( int $languages_id ){
        $items = self::get_musthaves_by_languages_id($languages_id);
        foreach($items as $i){
            self::delete($i->content_id);
        }
    }
    
    public static function get_by_content_group_and_content_id_and_languages_id(int $content_group, int $content_id, int $languages_id){
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_group=:content_group and content_id=:content_id and languages_id=:language_id",
                self::TABLE_NAME
            ),[
                'content_group'=>$content_group,
                'content_id'=>$content_id,
                'language_id'=>$languages_id
            ]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach($record as $rk=>$rv){
            if(in_array($rk, self::$integerProperties)){
                $record[$rk] = (int)$rv;
            }
        }
        return new self($record);
    }
    
    public static function get_by_content_group(int $content_group ) {
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_group=:content_group ORDER BY sort_order",
                self::TABLE_NAME
            ),['content_group'=>$content_group]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }
    
    public static function get_by_content_group_and_languages_id(int $content_group, int $languages_id ) {
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_group=:content_group AND languages_id=:language_id ORDER BY sort_order",
                self::TABLE_NAME
            ),
            ['content_group'=>$content_group, 'language_id'=>$languages_id]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get_by_content_status_and_languages_id(int $content_status, int $languages_id){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_status=:content_status AND languages_id=:language_id ORDER BY sort_order",
                self::TABLE_NAME
            ),['content_status'=>$content_status, 'language_id'=>$languages_id]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }
    
    public static function get_by_content_status_and_file_flag_and_languages_id(int $content_status, int $file_flag, int $languages_id){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_status=:content_status AND file_flag=:file_flag and languages_id=:language_id ORDER BY sort_order",
                self::TABLE_NAME
            ),[
                'content_status'=>$content_status, 
                'file_flag'=>$file_flag, 
                'language_id'=>$languages_id
            ]
        );
        foreach($query as $record){
            foreach($record as $rk=>$rv){
                if(in_array($rk, self::$integerProperties)){
                    $record[$rk] = (int)$rv;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }
}
