<?php

namespace YES4Trade\Model;

/**
 * Eingeloeste Kupons / wann wurde welcher kupon eingeloest
 */
class coupon_redeem_track extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'coupon_redeem_track';
    const TABLE_INDEX = 'unique_id';

    private static $propertyTypes = [
        'unique_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'unique_id'
        ],
        'coupon_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_id'
        ],
        'customer_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customer_id'
        ],
        'redeem_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'redeem_date'
        ],
        'redeem_ip' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'redeem_ip'
        ],
        'order_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'order_id'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_unique_id(int $unique_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$unique_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}
        
        public static function get_by_coupon_id( int $coupon_id, array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE coupon_id=:id",
                    $select_field_string,self::TABLE_NAME
                ),['id'=>$coupon_id]
            );
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }

        public static function get_by_coupon_id_and_customers_id(int $coupon_id, int $customers_id, array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE coupon_id=:coupon_id AND customer_id=:customers_id",
                    $select_field_string,self::TABLE_NAME
                ),['coupon_id'=>$coupon_id,'customers_id'=>$customers_id]
            );
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
}
