<?php

namespace YES4Trade\Model;

class customers_info extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'customers_info';
    const TABLE_INDEX = 'customers_info_id';

    private static $propertyTypes = [
        'customers_info_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_info_id'
        ],
        'customers_info_date_of_last_logon' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_info_date_of_last_logon'
        ],
        'customers_info_number_of_logons' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_info_number_of_logons'
        ],
        'customers_info_date_account_created' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_info_date_account_created'
        ],
        'customers_info_date_account_last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_info_date_account_last_modified'
        ],
        'global_product_notifications' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'global_product_notifications'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_customers_info_id(int $customers_info_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$customers_info_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

        /**
         * Aktualisiert customers_info zur customers_info_id
         * Dabei werden customers_info_number_of_logons = customers_info_number_of_logons+1
         * sowie customers_info_date_of_last_logon auf aktuelles Datum gesetzt
         * 
         * @param int $customers_id
         */
        public static function update_number_of_logins(int $customers_id){
            yes_query(sprintf(
                "UPDATE %s SET customers_info_number_of_logons = customers_info_number_of_logons+1,customers_info_date_of_last_logon=:date WHERE customers_info_id=:customers_id",
                self::TABLE_NAME
            ),[
                'date'=>date('Y-m-d H:i:s'),
                'customers_id'=>$customers_id
            ]);
        }
        
        /**
         * Wird zb fuer newsletter product_notification verwendet um alle
         * Subscriber zu holen
         * 
         * @param int $global_product_notifications
         * @return array Instanzen
         */
        public static function get_by_global_product_notifications(int $global_product_notifications):array{
            $items = [];
            $query = yes_query(sprintf(
                "select customers_info_id from %s where global_product_notifications =:global_product_notifications",
                    self::TABLE_NAME,
                ),['global_product_notifications'=>$global_product_notifications]
            );
            foreach($query as $record) {
                $items[] = self::get_by_customers_info_id(intval($record['customers_info_id']));
            }
            return $items;
        }
        
        /**
         * Ermittelt ob der customer in Tabelle customers_info das flag 
         * global_product_notifications=1 hat
         * 
         * @param int $customers_id
         * @return bool
         */
        public static function customer_has_global_product_notifications(int $customers_id):bool{
            $query = yes_query(sprintf(
                "select customers_info_id from %s where global_product_notifications=1 AND customers_info_id=:customers_id",
                    self::TABLE_NAME,
                ),[
                    'customers_id'=>$customers_id
                ]
            );
            return (!sizeOf($query))?false:true;
        }
}
