<?php
namespace YES4Trade\Model;

class distributor_orders_status extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'distributor_orders_status';
    const TABLE_INDEX = 'orders_status_id';

    private static $propertyTypes = [
        'orders_status_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'orders_status_id'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
        'orders_status_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'orders_status_name'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        unset($data['language_id']);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            $index => $this->$index,
            'language_id'=>$this->language_id
        ]);
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['id'=>$index]
        );
    }


    public static function get_by_orders_status_id_and_language_id(int $orders_status_id, int $language_id) {
        $query = yes_query(sprintf(
                "SELECT * FROM %s WHERE %s=:status_id AND language_id=:language_id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),[
                'status_id'=>$orders_status_id,
                'language_id'=>$language_id
            ]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self($record);
    }


    public static function get_by_language_id(int $language_id) {
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE language_id=:language_id ORDER BY orders_status_id",
                self::TABLE_NAME, 
            ),['language_id'=>$language_id]
        );
        foreach($query as $record){
            $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            $record['language_id'] = (int)$record['language_id'];
            $items[] = new self($record);
        }
        return $items;
    }
}
