<?php
namespace YES4Trade\Model;
class ebay_auctions_manufacturer extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_auctions_manufacturers';
    const TABLE_INDEX = 'ebay_auctions_manufacturers_id';
    private static $propertyTypes = [
        'ebay_auctions_manufacturers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_id'
        ],
        'ebay_auctions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_id'
        ],
        'manufacturer_cityname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_cityname'
        ],
        'manufacturer_companyname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_companyname'
        ],
        'manufacturer_country' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_country'
        ],
        'manufacturer_email' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_email'
        ],
        'manufacturer_phone' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_phone'
        ],
        'manufacturer_postalcode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_postalcode'
        ],
        'manufacturer_stateorprovince' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_stateorprovince'
        ],
        'manufacturer_street1' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_street1'
        ],
        'manufacturer_street2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_street2'
        ],
        
        
        
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public function create(){
        $data = $this->toArray();
        foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $data[$pk] = (int)$data[$pk];
           }
        }
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $data[$pk] = (int)$data[$pk];
           }
        }
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_ebay_auctions_manufacturers_id( int $ebay_auctions_manufacturers_id ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE %s='%d'",
            self::TABLE_NAME, self::TABLE_INDEX, $ebay_auctions_manufacturers_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            foreach(get_class_vars(__CLASS__) as $pk=>$pv){
               if($pv['type'] == 'integer'){
                   $record[$pk] = (int)$record[$pk];
               }
            }
            return new self($record);
        }
        return null;
    }
    
    public static function get_by_ebay_auctions_id( int $ebay_auctions_id ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE ebay_auctions_id='%d'",
            self::TABLE_NAME, $ebay_auctions_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            foreach(get_class_vars(__CLASS__) as $pk=>$pv){
               if($pv['type'] == 'integer'){
                   $record[$pk] = (int)$record[$pk];
               }
            }
            return new self($record);
        }
        return null;
    }
    
    
}