<?php

namespace YES4Trade\Model;

class ebay_auctions_variations extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_auctions_variations';
    const TABLE_INDEX = 'ebay_auctions_variations_id';

    private static $propertyTypes = [
        'ebay_auctions_variations_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_variations_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'quantity' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity'
        ],
        'sku' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sku'
        ],
        'ebay_auctions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_id'
        ],
        'quantity_sold' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity_sold'
        ],
        'revise_counter' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'revise_counter'
        ],
        'price' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'price'
        ],
        'ean' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ean'
        ],
        'isbn' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'isbn'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'ProductReferenceID' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ProductReferenceID'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}

    public function update_by_ebay_auctions_id_and_sku(){
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
        $sku = $data['sku'];
        $ebay_auctions_id = intval($data['ebay_auctions_id']);
        unset($data['sku']);
        unset($data['ebay_auctions_id']);
		yes_db_perform(self::TABLE_NAME, $data,'update',[
            'sku'=>$sku,
            'ebay_auctions_id'=>$ebay_auctions_id
        ]);
    }

    public function update_by_ebay_auctions_id_and_sku_and_products_id(){
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
        $sku = $data['sku'];
        $products_id = intval($data['products_id']);
        $ebay_auctions_id = intval($data['ebay_auctions_id']);
        unset($data['sku']);
        unset($data['ebay_auctions_id']);
        unset($data['products_id']);
		yes_db_perform(self::TABLE_NAME, $data,'update',[
            'sku'=>$sku,
            'ebay_auctions_id'=>$ebay_auctions_id,
            'products_id'=>$products_id
        ]);
    }

	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_ebay_auctions_variations_id(int $ebay_auctions_variations_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$ebay_auctions_variations_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

	/**
     * get items array by ebay_auctions_id
     * 
	 * @param int $ebay_auctions_id
	 * @param array $select_fields
	 * 
	 * @return array
	 */
	public static function get_by_ebay_auctions_id(int $ebay_auctions_id, array $select_fields = []) {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE ebay_auctions_id=:id ORDER BY sort_order",
				$select_field_string,self::TABLE_NAME
			),['id'=>$ebay_auctions_id]
		);
        foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
	}

	/**
     * get items array by products_id
     * 
	 * @param int $products_id
	 * @param array $select_fields
	 * 
	 * @return [type]
	 */
	public static function get_by_products_id(int $products_id, array $select_fields = [], bool $only_active_auctions = false) {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}

        if($only_active_auctions === false){
            $query_raw = sprintf(
			    "SELECT %s FROM %s WHERE products_id=:id",
				$select_field_string,self::TABLE_NAME
			);
        }else{
            $query_raw = sprintf(
			    "SELECT %s FROM %s eav INNER JOIN ebay_auctions ea ON ea.id = eav.ebay_auctions_id WHERE eav.products_id=:id AND ea.status=0",
				$select_field_string,self::TABLE_NAME
			);
        }

		$query = yes_query($query_raw,['id'=>$products_id]);
        foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
	}


    /**
     * wrapper function for inserts
     * returns insert_id
     * 
     * @param array $data
     * 
     * @return int
     */
    public static function create_ebay_auctions_variations(array $data){
        $new = new self($data);
        return $new->create();
    }

    /**
     * wrapper function for updates
     * 
     * @param array $data
     * 
     * @return none
     */
    public static function update_ebay_auctions_variations(array $data){
        $upd = new self($data);
        $upd->update();

    }

    public static function update_ebay_auctions_variations_by_ebay_auctions_id_and_sku(array $data){
        $upd = new self($data);
        $upd->update_by_ebay_auctions_id_and_sku();

    }

    public static function update_ebay_auctions_variations_by_ebay_auctions_id_and_sku_and_products_id(array $data){
        $upd = new self($data);
        $upd->update_by_ebay_auctions_id_and_sku_and_products_id();

    }

    /**
     * returns object based on ebay_auctions_id and sku
     * 
     * @param int $ebay_auctions_id
     * @param string $sku
     * @param array $select_fields
     * 
     * @return mixed null or self
     */
    public static function get_by_ebay_auctions_id_and_sku(int $ebay_auctions_id, string $sku, array $select_fields = []){
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE ebay_auctions_id=:id AND sku=:sku",
				$select_field_string,self::TABLE_NAME
			),['id'=>$ebay_auctions_id,'sku'=>$sku]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
    }


    /**
     * gibt ein array zurueck denn es kann glaube durchaus sein, dass es gleiche pID gibt
     * zb bei Staffelmengen (gleiche pID / Unterschiedliche SKU)
     * @param int $ebay_auctions_id
     * @param int $products_id
     * @param array $select_fields
     * 
     * @return array
     */
    public static function get_by_ebay_auctions_id_and_products_id(int $ebay_auctions_id, int $products_id, array $select_fields = []){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE ebay_auctions_id=:id AND products_id=:products_id",
				$select_field_string,self::TABLE_NAME
			),['id'=>$ebay_auctions_id,'products_id'=>$products_id]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    
    /**
     * zaehlt bei einer variantenauktion wieviel Artikel AUSSER die der angebenen SKU sonst
     * noch enthalten sind. Gibt einen INT Wert zurueck
     * 
     * @param int $ebay_auctions_id
     * @param string $sku
     * 
     * @return integer
     */
    public static function calc_quantity_by_ebay_auctions_id_excluding_sku( int $ebay_auctions_id, string $sku ){
        $query = yes_query(sprintf(
            "SELECT SUM(quantity) AS anzahl FROM %s WHERE ebay_auctions_id=:id and sku!=:sku",
                self::TABLE_NAME
            ),['id'=>$ebay_auctions_id, 'sku'=>$sku],
            true
        );
        return intval($query['anzahl']);
    }
}
