<?php
namespace YES4Trade\Model;
class ebay_products_manufacturer extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_products_manufacturers';
    const TABLE_INDEX = 'ebay_products_manufacturers_id';
    private static $propertyTypes = [
        'ebay_products_manufacturers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_id'
        ],
        'ebay_products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_id'
        ],
        'manufacturer_cityname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_cityname'
        ],
        'manufacturer_companyname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_companyname'
        ],
        'manufacturer_country' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_country'
        ],
        'manufacturer_email' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_email'
        ],
        'manufacturer_phone' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_phone'
        ],
        'manufacturer_postalcode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_postalcode'
        ],
        'manufacturer_stateorprovince' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_stateorprovince'
        ],
        'manufacturer_street1' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_street1'
        ],
        'manufacturer_street2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_street2'
        ],
        
        
        
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public function create(){
        $data = $this->toArray();
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        $id = $data[self::TABLE_INDEX];
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_ebay_products_manufacturers_id( int $ebay_products_manufacturers_id ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE %s='%d'",
            self::TABLE_NAME, self::TABLE_INDEX, $ebay_products_manufacturers_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            $record['ebay_products_id'] = (int)$record['ebay_products_id'];
            return new \YES4Trade\Model\ebay_products_manufacturer($record);
        }
        return null;
    }
    
    public static function get_by_ebay_products_id( int $ebay_products_id ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE ebay_products_id='%d'",
            self::TABLE_NAME, $ebay_products_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            $record['ebay_products_id'] = (int)$record['ebay_products_id'];
            return new \YES4Trade\Model\ebay_products_manufacturer($record);
        }
        return null;
    }
    
    public static function get_array_keys(){
        return get_class_vars(__CLASS__);
    }
    
}
