<?php

namespace YES4Trade\Model;

class ebay_variations extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_variations';
    const TABLE_INDEX = 'ebay_variations_id';
    var $ebay_variations_variationspecifics;
    var $ebay_variations_pictures;
    
    private static $propertyTypes = [
        'ebay_variations_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_variations_id'
        ],
        'ebay_variations_sets_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_variations_sets_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'quantity' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity'
        ],
        'sku' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sku'
        ],
        'startprice' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'startprice'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'ean' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ean'
        ],
        'isbn' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'isbn'
        ],
        'ProductReferenceID' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ProductReferenceID'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        unset($data['ebay_variations_variationspecifics']);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        $data['ebay_variations_id'] = (int)$data['ebay_variations_id'];
        unset($data[self::TABLE_INDEX]);
        unset($data['ebay_variations_variationspecifics']);
        
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        $ebay_variations_variationspecifics = \YES4Trade\Model\ebay_variations_variationspecifics::get_by_ebay_variations_id(
            $index
        );
        foreach($ebay_variations_variationspecifics as $evvs){
            \YES4Trade\Model\ebay_variations_variationspecifics::delete( $evvs->ebay_variations_variationspecifics_id );
        }
        xtc_db_query(sprintf(
            "DELETE FROM %s WHERE %s='%d'",
            self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_ebay_variations_id(int $ebay_variations_id) {
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE %s='%d'",
                self::TABLE_NAME, self::TABLE_INDEX, $ebay_variations_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $record[$pk] = (int)$record[$pk];
           }
        }
        $item = new self($record);
        $item->ebay_variations_variationspecifics = \YES4Trade\Model\ebay_variations_variationspecifics::get_by_ebay_variations_id(
                $record[ self::TABLE_INDEX ]
        );
        return $item;
    }

    public static function get_by_ebay_variations_sets_id(int $ebay_variations_sets_id) {
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE ebay_variations_sets_id='%d'",
                self::TABLE_NAME, $ebay_variations_sets_id
        ));
        while($record = xtc_db_fetch_array($query)){
            foreach(get_class_vars(__CLASS__) as $pk=>$pv){
               if($pv['type'] == 'integer'){
                   $record[$pk] = (int)$record[$pk];
               }
            }
            $item = new self($record);
            $item->ebay_variations_variationspecifics = \YES4Trade\Model\ebay_variations_variationspecifics::get_by_ebay_variations_id(
                    $record[ self::TABLE_INDEX ]
            );
            $items[] = $item;
        }
        return $items;
    }

}
